use strict;
use warnings;
use Guacamole::Test;

parses('$foo');
parses('@foo');
parses('%foo');
parses('*foo');
parses('$0');
parses('$1');
parses('$2');
parses('$3');
parses('$4');
parses('$5');
parses('$6');
parses('$7');
parses('$8');
parses('$9');

#$ perldoc perlvar | grep '^    [$@%]' | awk '{print $1}' | sort | uniq | grep -v '[$@%][A-Za-z]'

parses('$!');
parses('$"');
parses('$#');
parses('$#_');
parsent('$# _');
parses('$%');
parses('$&');
parses('$\'');
parses('$(');
parses('$)');
parses('$*');
parses('$+');
parses('$,');
parses('$-');
parses('$.');
parses('$/');
parses('$:');
parses('$;');
parses('$<');
parses('$=');
parses('$>');
parses('$?');
parses('$@');
parses('$[');
parses('$\\');
parses('$]');
parses('$^');
parses('$_');
parses('$`');
parses('$|');
parses('$~');
parses('$$');
parses('$^A');
parses('$^C');
parses('${^CHILD_ERROR_NATIVE}');
parses('$^D');
parses('$0');
parses('$100');
parses('$^E');
parses('${^ENCODING}');
parses('$^F');
parses('${^GLOBAL_PHASE}');
parses('$^H');
parses('$^I');
parses('$^L');
parses('${^LAST_FH}');
parses('$^M');
parses('${^MATCH}');
parses('$^N');
parses('$^O');
parses('${^OPEN}');
parses('$^P');
parses('${^POSTMATCH}');
parses('${^PREMATCH}');
parses('$^R');
parses('${^RE_COMPILE_RECURSION_LIMIT}');
parses('${^RE_DEBUG_FLAGS}');
parses('${^RE_TRIE_MAXBUF}');
parses('$^S');
parses('${^SAFE_LOCALES}');
parses('$^T');
parses('${^TAINT}');
parses('${^UNICODE}');
parses('${^UTF8CACHE}');
parses('${^UTF8LOCALE}');
parses('$^V');
parses('$^W');
parses('${^WARNING_BITS}');
parses('${^WIN32_SLOPPY_STAT}');
parses('$^X');

parses('@+');
parses('@-');
parses('@_');
parses('@{^CAPTURE}');

parses('%!');
parses('%+');
parses('%-');
parses('%{^CAPTURE}');
parses('%{^CAPTURE_ALL}');
parses('%^H');

parses('$ \'');

done_testing();
