######################################################################
#
# KEIS83_by_CP932.pl
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# HITAC Character code table (KEIS83)
# Document number 8080-2-100-10

use strict;

my %KEIS83_by_CP932 = ();

my @KEIS83_by_CP932_a = map { (split(/ /,$_))[3,4] } split(/\n/,<<'END');
 81BE  81BE A2C0
 81BF  81BF A2C1
 81CA  81CA A2CC
 81DA  81DA A2DC
 81DB  81DB A2DD
 81DF  81DF A2E1
 81E0  81E0 A2E2
 81E3  81E3 A2E5
 81E6  81E6 A2E8
 EA9F  EA9F F4A1
 EAA0  EAA0 F4A2
 EAA1  EAA1 F4A3
 EAA2  EAA2 F4A4
 EAA3  EAA3 D1DB
 EAA4  EAA4 64B8
 FA9C  FA9C 5CC7
 FAD0  FAD0 60B6
@ 8740 @ 8740 76B1
A 8741 A 8741 76B2
B 8742 B 8742 76B3
C 8743 C 8743 76B4
D 8744 D 8744 76B5
E 8745 E 8745 76B6
F 8746 F 8746 76B7
G 8747 G 8747 76B8
H 8748 H 8748 76B9
I 8749 I 8749 76BA
J 874A J 874A 77A1
K 874B K 874B 77A2
L 874C L 874C 77A3
M 874D M 874D 77A4
N 874E N 874E 77A5
O 874F O 874F 77A6
P 8750 P 8750 77A7
Q 8751 Q 8751 77A8
R 8752 R 8752 77A9
S 8753 S 8753 77AA
T 8754 T 8754 74B1
U 8755 U 8755 74B2
V 8756 V 8756 74B3
W 8757 W 8757 74B4
X 8758 X 8758 74B5
Y 8759 Y 8759 74B6
Z 875A Z 875A 74B7
[ 875B [ 875B 74B8
\ 875C \ 875C 74B9
] 875D ] 875D 74BA
_ 875F _ 875F 70CF
` 8760 ` 8760 70D1
a 8761 a 8761 70D0
b 8762 b 8762 70D3
c 8763 c 8763 70D5
d 8764 d 8764 70D7
e 8765 e 8765 70D8
f 8766 f 8766 70D9
h 8768 h 8768 70DB
i 8769 i 8769 70DC
j 876A j 876A 70E2
k 876B k 876B 70E1
l 876C l 876C 70E0
m 876D m 876D 70DA
n 876E n 876E 70DF
o 876F o 876F 6FCC
p 8770 p 8770 6FCB
q 8771 q 8771 6FCA
r 8772 r 8772 6FDA
s 8773 s 8773 6FD9
t 8774 t 8774 6FFA
u 8775 u 8775 6FD0
 8782  8782 72BE
 8783  8783 72B6
 8784  8784 72B8
 878A  878A 73D0
 878B  878B 73B1
 878C  878C 73BD
@ FA40 @ FA40 74C1
A FA41 A FA41 74C2
B FA42 B FA42 74C3
C FA43 C FA43 74C4
D FA44 D FA44 74C5
E FA45 E FA45 74C6
F FA46 F FA46 74C7
G FA47 G FA47 74C8
H FA48 H FA48 74C9
I FA49 I FA49 74CA
\ FA5C \ FA5C 67FE
] FA5D ] FA5D 69E8
^ FA5E ^ FA5E 6CC7
_ FA5F _ FA5F 6CA3
` FA60 ` FA60 69AE
a FA61 a FA61 59E4
b FA62 b FA62 63FE
c FA63 c FA63 60F8
d FA64 d FA64 61DC
e FA65 e FA65 6CBB
f FA66 f FA66 60D3
g FA67 g FA67 5ED8
h FA68 h FA68 59AC
i FA69 i FA69 59C1
j FA6A j FA6A 59C8
k FA6B k FA6B 59C7
l FA6C l FA6C 9FA1
m FA6D m FA6D 59CE
n FA6E n FA6E 59CB
o FA6F o FA6F 59DB
p FA70 p FA70 59E0
q FA71 q FA71 59DA
r FA72 r FA72 59D9
s FA73 s FA73 59E6
t FA74 t FA74 5AA1
u FA75 u FA75 59F1
v FA76 v FA76 59FA
w FA77 w FA77 59F3
x FA78 x FA78 5AA7
y FA79 y FA79 5AAC
z FA7A z FA7A 5AA6
{ FA7B { FA7B 5AB0
| FA7C | FA7C 5ABE
} FA7D } FA7D 5AC1
~ FA7E ~ FA7E 5ACB
 FA80  FA80 5AD3
 FA81  FA81 5AE1
 FA82  FA82 5AE4
 FA83  FA83 6DC3
 FA84  FA84 9FA3
 FA85  FA85 5AF0
 FA86  FA86 5AF1
 FA87  FA87 5AF7
 FA88  FA88 5BA1
 FA89  FA89 5BA9
 FA8A  FA8A 5BAB
 FA8B  FA8B 5BAF
 FA8C  FA8C 5BBC
 FA8D  FA8D 5BC4
 FA8E  FA8E 5BC9
 FA8F  FA8F 5BCE
 FA90  FA90 5BD3
 FA91  FA91 5BDB
 FA92  FA92 5BDA
 FA93  FA93 5BE1
 FA94  FA94 5BE3
 FA95  FA95 5BED
 FA96  FA96 5CB2
 FA97  FA97 5CB6
 FA98  FA98 5CB9
 FA99  FA99 5CBD
 FA9A  FA9A 9FA6
 FA9B  FA9B 5CBB
 FA9D  FA9D 5CD1
 FA9E  FA9E 5CD3
 FA9F  FA9F 5BCD
 FAA0  FAA0 5CE4
 FAA1  FAA1 5CE6
 FAA2  FAA2 5CE8
 FAA3  FAA3 5CE9
 FAA4  FAA4 5CF4
 FAA5  FAA5 5CF7
 FAA6  FAA6 5DB3
 FAA7  FAA7 5DC2
 FAA8  FAA8 5DC5
 FAA9  FAA9 5DC6
 FAAA  FAAA 5DC7
 FAAB  FAAB 5DD2
 FAAC  FAAC 5DDE
 FAAD  FAAD 5DDD
 FAAE  FAAE 5DE6
 FAAF  FAAF 5DE8
 FAB0  FAB0 5DF0
 FAB1  FAB1 5DEC
 FAB2  FAB2 5DEF
 FAB3  FAB3 9FA9
 FAB4  FAB4 5EA3
 FAB5  FAB5 5EA5
 FAB6  FAB6 5EA7
 FAB7  FAB7 5ED2
 FAB8  FAB8 5ED3
 FAB9  FAB9 5FCA
 FABA  FABA 5EE6
 FABB  FABB 5EEE
 FABC  FABC 5EF8
 FABD  FABD 5EF9
 FABE  FABE 5EF6
 FABF  FABF 5FA5
 FAC0  FAC0 5FA3
 FAC1  FAC1 5FAA
 FAC2  FAC2 5FAD
 FAC3  FAC3 5FAF
 FAC4  FAC4 5FB1
 FAC5  FAC5 5FB3
 FAC6  FAC6 5FBE
 FAC7  FAC7 5BD7
 FAC8  FAC8 5FD6
 FAC9  FAC9 5FE2
 FACA  FACA 5FEB
 FACB  FACB 5FEE
 FACC  FACC 5FF2
 FACD  FACD 5FF8
 FACE  FACE 60B3
 FACF  FACF 60B1
 FAD1  FAD1 60AF
 FAD2  FAD2 60BE
 FAD3  FAD3 60C4
 FAD4  FAD4 60B9
 FAD5  FAD5 60D1
 FAD6  FAD6 60D6
 FAD7  FAD7 60D7
 FAD8  FAD8 60DD
 FAD9  FAD9 60E1
 FADA  FADA 60E6
 FADB  FADB 60EA
 FADC  FADC 60EE
 FADD  FADD 60EF
 FADE  FADE 60C7
 FADF  FADF 60FC
 FAE0  FAE0 61A7
 FAE1  FAE1 61B2
 FAE2  FAE2 61BB
 FAE3  FAE3 61BE
 FAE4  FAE4 9FAC
 FAE5  FAE5 61CC
 FAE6  FAE6 61C6
 FAE7  FAE7 61DF
 FAE8  FAE8 61E0
 FAE9  FAE9 61E9
 FAEA  FAEA 61F8
 FAEB  FAEB 65F4
 FAEC  FAEC 61EF
 FAED  FAED 62A3
 FAEE  FAEE 62A9
 FAEF  FAEF 62AE
 FAF0  FAF0 62B2
 FAF1  FAF1 62B3
 FAF2  FAF2 62B9
 FAF3  FAF3 62B8
 FAF4  FAF4 62D0
 FAF5  FAF5 62D5
 FAF6  FAF6 62D6
 FAF7  FAF7 62D8
 FAF8  FAF8 62D9
 FAF9  FAF9 62E2
 FAFA  FAFA 62E4
 FAFB  FAFB 62EB
 FAFC  FAFC 62F2
@ FB40 @ FB40 62EE
A FB41 A FB41 62FC
B FB42 B FB42 63A4
C FB43 C FB43 62FD
D FB44 D FB44 63A6
E FB45 E FB45 63BD
F FB46 F FB46 63B7
G FB47 G FB47 63B4
H FB48 H FB48 63AE
I FB49 I FB49 63B8
J FB4A J FB4A 9FB6
K FB4B K FB4B 63D8
L FB4C L FB4C 63DF
M FB4D M FB4D 63E4
N FB4E N FB4E 63EB
O FB4F O FB4F 63E8
P FB50 P FB50 63F1
Q FB51 Q FB51 63F8
R FB52 R FB52 63FD
S FB53 S FB53 9FB9
T FB54 T FB54 64A5
U FB55 U FB55 64AD
V FB56 V FB56 64AE
W FB57 W FB57 64AF
X FB58 X FB58 64B9
Y FB59 Y FB59 64B4
Z FB5A Z FB5A 64C2
[ FB5B [ FB5B 64CC
\ FB5C \ FB5C 9FBA
] FB5D ] FB5D 64D0
^ FB5E ^ FB5E 64CE
_ FB5F _ FB5F 64D2
` FB60 ` FB60 64DF
a FB61 a FB61 64DB
b FB62 b FB62 64E4
c FB63 c FB63 64E5
d FB64 d FB64 64E8
e FB65 e FB65 64EB
f FB66 f FB66 64EC
g FB67 g FB67 64F5
h FB68 h FB68 64F6
i FB69 i FB69 64FC
j FB6A j FB6A 64F8
k FB6B k FB6B 65A8
l FB6C l FB6C 65AE
m FB6D m FB6D 65B2
n FB6E n FB6E 65B9
o FB6F o FB6F 65C3
p FB70 p FB70 65CA
q FB71 q FB71 65CE
r FB72 r FB72 65CF
s FB73 s FB73 65D1
t FB74 t FB74 65D2
u FB75 u FB75 65D8
v FB76 v FB76 65E6
w FB77 w FB77 65F6
x FB78 x FB78 65F7
y FB79 y FB79 65FA
z FB7A z FB7A 66A1
{ FB7B { FB7B 66A5
| FB7C | FB7C 66AE
} FB7D } FB7D 66B0
~ FB7E ~ FB7E 66BB
 FB80  FB80 66C2
 FB81  FB81 66D0
 FB82  FB82 66D3
 FB83  FB83 66D4
 FB84  FB84 66FE
 FB85  FB85 67A2
 FB86  FB86 67A6
 FB87  FB87 67A4
 FB88  FB88 67B7
 FB89  FB89 67CC
 FB8A  FB8A 67DD
 FB8B  FB8B 67E1
 FB8C  FB8C 67EC
 FB8D  FB8D 67EB
 FB8E  FB8E 67F1
 FB8F  FB8F 67FB
 FB90  FB90 68A5
 FB91  FB91 68AE
 FB92  FB92 68B2
 FB93  FB93 68DA
 FB94  FB94 68DD
 FB95  FB95 68F2
 FB96  FB96 68FC
 FB97  FB97 68F8
 FB98  FB98 69A3
 FB99  FB99 69AF
 FB9A  FB9A 69BE
 FB9B  FB9B 69BF
 FB9C  FB9C 69BA
 FB9D  FB9D 69C1
 FB9E  FB9E 69C9
 FB9F  FB9F 69D0
 FBA0  FBA0 69D7
 FBA1  FBA1 69DA
 FBA2  FBA2 69E6
 FBA3  FBA3 69FE
 FBA4  FBA4 6AA5
 FBA5  FBA5 6AAA
 FBA6  FBA6 6AAB
 FBA7  FBA7 6AAD
 FBA8  FBA8 6AB3
 FBA9  FBA9 6AB2
 FBAA  FBAA 6AB4
 FBAB  FBAB 6ABE
 FBAC  FBAC 6AC3
 FBAD  FBAD 6AD0
 FBAE  FBAE 6ACF
 FBAF  FBAF 6AD5
 FBB0  FBB0 6AD8
 FBB1  FBB1 6AD9
 FBB2  FBB2 6AE1
 FBB3  FBB3 6AEB
 FBB4  FBB4 6AFA
 FBB5  FBB5 6BA3
 FBB6  FBB6 6BC7
 FBB7  FBB7 6BCA
 FBB8  FBB8 6BCD
 FBB9  FBB9 6BD1
 FBBA  FBBA 6BD9
 FBBB  FBBB 6BD8
 FBBC  FBBC 6BDA
 FBBD  FBBD 6BDC
 FBBE  FBBE 6BE1
 FBBF  FBBF 6BE0
 FBC0  FBC0 6BDF
 FBC1  FBC1 6BE5
 FBC2  FBC2 6BE9
 FBC3  FBC3 6BE7
 FBC4  FBC4 6BF2
 FBC5  FBC5 6BEE
 FBC6  FBC6 6BF3
 FBC7  FBC7 6BEF
 FBC8  FBC8 6BF1
 FBC9  FBC9 6BEC
 FBCA  FBCA 6BED
 FBCB  FBCB 6BF6
 FBCC  FBCC 6CA6
 FBCD  FBCD 6CA8
 FBCE  FBCE 6CA5
 FBCF  FBCF 6CB1
 FBD0  FBD0 6CAC
 FBD1  FBD1 6CB8
 FBD2  FBD2 6CB3
 FBD3  FBD3 6CB7
 FBD4  FBD4 6CB5
 FBD5  FBD5 6CB0
 FBD6  FBD6 9FCA
 FBD7  FBD7 6CC3
 FBD8  FBD8 6CBE
 FBD9  FBD9 6CCD
 FBDA  FBDA 6CC2
 FBDB  FBDB 6CBF
 FBDC  FBDC 6CC1
 FBDD  FBDD 6CC4
 FBDE  FBDE 6CC5
 FBDF  FBDF 6CCA
 FBE0  FBE0 6CCC
 FBE1  FBE1 6CD8
 FBE2  FBE2 6CE0
 FBE3  FBE3 6CDF
 FBE4  FBE4 6CE6
 FBE5  FBE5 6CEF
 FBE6  FBE6 6CF0
 FBE7  FBE7 6CF1
 FBE8  FBE8 6CF8
 FBE9  FBE9 6DA2
 FBEA  FBEA 6DA4
 FBEB  FBEB 6DA5
 FBEC  FBEC 6DA6
 FBED  FBED 9FCD
 FBEE  FBEE 9FCE
 FBEF  FBEF 6DAE
 FBF0  FBF0 6DB0
 FBF1  FBF1 9FCF
 FBF2  FBF2 6DB1
 FBF3  FBF3 6DB2
 FBF4  FBF4 6DC1
 FBF5  FBF5 6DC2
 FBF6  FBF6 6DC5
 FBF7  FBF7 6DC6
 FBF8  FBF8 6DC8
 FBF9  FBF9 6DC9
 FBFA  FBFA 6DCC
 FBFB  FBFB 6DD9
 FBFC  FBFC 6DD4
@ FC40 @ FC40 6DDC
A FC41 A FC41 9FD2
B FC42 B FC42 6DE0
C FC43 C FC43 6DE2
D FC44 D FC44 6DE5
E FC45 E FC45 6DE7
F FC46 F FC46 9FD3
G FC47 G FC47 9FD8
H FC48 H FC48 6DF2
I FC49 I FC49 6DF4
J FC4A J FC4A 6EAC
K FC4B K FC4B 6EA1
 81B8  81B8 A2BA
 81B9  81B9 A2BB
 81BA  81BA A2BC
 81BB  81BB A2BD
 81BC  81BC A2BE
 81BD  81BD A2BF
 81C8  81C8 A2CA
 81C9  81C9 A2CB
 81CB  81CB A2CD
 81CC  81CC A2CE
 81CD  81CD A2CF
 81CE  81CE A2D0
 81DC  81DC A2DE
 81DD  81DD A2DF
 81DE  81DE A2E0
 81E1  81E1 A2E3
 81E2  81E2 A2E4
 81E4  81E4 A2E6
 81E5  81E5 A2E7
 81E7  81E7 A2E9
 81E8  81E8 A2EA
 81F0  81F0 A2F2
 81F1  81F1 A2F3
 81F2  81F2 A2F4
 81F3  81F3 A2F5
 81F4  81F4 A2F6
 81F5  81F5 A2F7
 81F6  81F6 A2F8
 81F7  81F7 A2F9
 81FC  81FC A2FE
 849F  849F A8A1
 84A0  84A0 A8A2
 84A1  84A1 A8A3
 84A2  84A2 A8A4
 84A3  84A3 A8A5
 84A4  84A4 A8A6
 84A5  84A5 A8A7
 84A6  84A6 A8A8
 84A7  84A7 A8A9
 84A8  84A8 A8AA
 84A9  84A9 A8AB
 84AA  84AA A8AC
 84AB  84AB A8AD
 84AC  84AC A8AE
 84AD  84AD A8AF
 84AE  84AE A8B0
 84AF  84AF A8B1
 84B0  84B0 A8B2
 84B1  84B1 A8B3
 84B2  84B2 A8B4
 84B3  84B3 A8B5
 84B4  84B4 A8B6
 84B5  84B5 A8B7
 84B6  84B6 A8B8
 84B7  84B7 A8B9
 84B8  84B8 A8BA
 84B9  84B9 A8BB
 84BA  84BA A8BC
 84BB  84BB A8BD
 84BC  84BC A8BE
 84BD  84BD A8BF
 84BE  84BE A8C0
 8785  8785 73EA
 8786  8786 73EB
 8787  8787 73EC
 8788  8788 73ED
 8789  8789 73EE
 878D  878D 72F5
 878E  878E 72F6
 878F  878F 72F7
~ 877E ~ 877E 73F8
 8793  8793 6FB8
 8794  8794 6FA2
 8798  8798 6FB7
 8799  8799 6FBA
END

my @KEIS83_by_CP932_b = map { (split(/ /,$_))[3,4] } split(/\n/,<<'END');
 81BE  81BE A2C0
 81BF  81BF A2C1
 81CA  81CA A2CC
 81DA  81DA A2DC
 81DB  81DB A2DD
 81DF  81DF A2E1
 81E0  81E0 A2E2
 81E3  81E3 A2E5
 81E6  81E6 A2E8
 EA9F  EA9F F4A1
 EAA0  EAA0 F4A2
 EAA1  EAA1 F4A3
 EAA2  EAA2 F4A4
 EAA3  EAA3 D1DB
 EAA4  EAA4 64B8
 FA9C  FA9C 5CC7
 FAD0  FAD0 60B6
@ 8740 @ 8740 76B1
A 8741 A 8741 76B2
B 8742 B 8742 76B3
C 8743 C 8743 76B4
D 8744 D 8744 76B5
E 8745 E 8745 76B6
F 8746 F 8746 76B7
G 8747 G 8747 76B8
H 8748 H 8748 76B9
I 8749 I 8749 76BA
J 874A J 874A 77A1
K 874B K 874B 77A2
L 874C L 874C 77A3
M 874D M 874D 77A4
N 874E N 874E 77A5
O 874F O 874F 77A6
P 8750 P 8750 77A7
Q 8751 Q 8751 77A8
R 8752 R 8752 77A9
S 8753 S 8753 77AA
T 8754 T 8754 74B1
U 8755 U 8755 74B2
V 8756 V 8756 74B3
W 8757 W 8757 74B4
X 8758 X 8758 74B5
Y 8759 Y 8759 74B6
Z 875A Z 875A 74B7
[ 875B [ 875B 74B8
\ 875C \ 875C 74B9
] 875D ] 875D 74BA
_ 875F _ 875F 70CF
` 8760 ` 8760 70D1
a 8761 a 8761 70D0
b 8762 b 8762 70D3
c 8763 c 8763 70D5
d 8764 d 8764 70D7
e 8765 e 8765 70D8
f 8766 f 8766 70D9
h 8768 h 8768 70DB
i 8769 i 8769 70DC
j 876A j 876A 70E2
k 876B k 876B 70E1
l 876C l 876C 70E0
m 876D m 876D 70DA
n 876E n 876E 70DF
o 876F o 876F 6FCC
p 8770 p 8770 6FCB
q 8771 q 8771 6FCA
r 8772 r 8772 6FDA
s 8773 s 8773 6FD9
t 8774 t 8774 6FFA
u 8775 u 8775 6FD0
 8782  8782 72BE
 8783  8783 72B6
 8784  8784 72B8
 878A  878A 73D0
 878B  878B 73B1
 878C  878C 73BD
@ FA40 @ FA40 74C1
A FA41 A FA41 74C2
B FA42 B FA42 74C3
C FA43 C FA43 74C4
D FA44 D FA44 74C5
E FA45 E FA45 74C6
F FA46 F FA46 74C7
G FA47 G FA47 74C8
H FA48 H FA48 74C9
I FA49 I FA49 74CA
\ FA5C \ FA5C 67FE
] FA5D ] FA5D 69E8
^ FA5E ^ FA5E 6CC7
_ FA5F _ FA5F 6CA3
` FA60 ` FA60 69AE
a FA61 a FA61 59E4
b FA62 b FA62 63FE
c FA63 c FA63 60F8
d FA64 d FA64 61DC
e FA65 e FA65 6CBB
f FA66 f FA66 60D3
g FA67 g FA67 5ED8
h FA68 h FA68 59AC
i FA69 i FA69 59C1
j FA6A j FA6A 59C8
k FA6B k FA6B 59C7
l FA6C l FA6C 9FA1
m FA6D m FA6D 59CE
n FA6E n FA6E 59CB
o FA6F o FA6F 59DB
p FA70 p FA70 59E0
q FA71 q FA71 59DA
r FA72 r FA72 59D9
s FA73 s FA73 59E6
t FA74 t FA74 5AA1
u FA75 u FA75 59F1
v FA76 v FA76 59FA
w FA77 w FA77 59F3
x FA78 x FA78 5AA7
y FA79 y FA79 5AAC
z FA7A z FA7A 5AA6
{ FA7B { FA7B 5AB0
| FA7C | FA7C 5ABE
} FA7D } FA7D 5AC1
~ FA7E ~ FA7E 5ACB
 FA80  FA80 5AD3
 FA81  FA81 5AE1
 FA82  FA82 5AE4
 FA83  FA83 6DC3
 FA84  FA84 9FA3
 FA85  FA85 5AF0
 FA86  FA86 5AF1
 FA87  FA87 5AF7
 FA88  FA88 5BA1
 FA89  FA89 5BA9
 FA8A  FA8A 5BAB
 FA8B  FA8B 5BAF
 FA8C  FA8C 5BBC
 FA8D  FA8D 5BC4
 FA8E  FA8E 5BC9
 FA8F  FA8F 5BCE
 FA90  FA90 5BD3
 FA91  FA91 5BDB
 FA92  FA92 5BDA
 FA93  FA93 5BE1
 FA94  FA94 5BE3
 FA95  FA95 5BED
 FA96  FA96 5CB2
 FA97  FA97 5CB6
 FA98  FA98 5CB9
 FA99  FA99 5CBD
 FA9A  FA9A 9FA6
 FA9B  FA9B 5CBB
 FA9D  FA9D 5CD1
 FA9E  FA9E 5CD3
 FA9F  FA9F 5BCD
 FAA0  FAA0 5CE4
 FAA1  FAA1 5CE6
 FAA2  FAA2 5CE8
 FAA3  FAA3 5CE9
 FAA4  FAA4 5CF4
 FAA5  FAA5 5CF7
 FAA6  FAA6 5DB3
 FAA7  FAA7 5DC2
 FAA8  FAA8 5DC5
 FAA9  FAA9 5DC6
 FAAA  FAAA 5DC7
 FAAB  FAAB 5DD2
 FAAC  FAAC 5DDE
 FAAD  FAAD 5DDD
 FAAE  FAAE 5DE6
 FAAF  FAAF 5DE8
 FAB0  FAB0 5DF0
 FAB1  FAB1 5DEC
 FAB2  FAB2 5DEF
 FAB3  FAB3 9FA9
 FAB4  FAB4 5EA3
 FAB5  FAB5 5EA5
 FAB6  FAB6 5EA7
 FAB7  FAB7 5ED2
 FAB8  FAB8 5ED3
 FAB9  FAB9 5FCA
 FABA  FABA 5EE6
 FABB  FABB 5EEE
 FABC  FABC 5EF8
 FABD  FABD 5EF9
 FABE  FABE 5EF6
 FABF  FABF 5FA5
 FAC0  FAC0 5FA3
 FAC1  FAC1 5FAA
 FAC2  FAC2 5FAD
 FAC3  FAC3 5FAF
 FAC4  FAC4 5FB1
 FAC5  FAC5 5FB3
 FAC6  FAC6 5FBE
 FAC7  FAC7 5BD7
 FAC8  FAC8 5FD6
 FAC9  FAC9 5FE2
 FACA  FACA 5FEB
 FACB  FACB 5FEE
 FACC  FACC 5FF2
 FACD  FACD 5FF8
 FACE  FACE 60B3
 FACF  FACF 60B1
 FAD1  FAD1 60AF
 FAD2  FAD2 60BE
 FAD3  FAD3 60C4
 FAD4  FAD4 60B9
 FAD5  FAD5 60D1
 FAD6  FAD6 60D6
 FAD7  FAD7 60D7
 FAD8  FAD8 60DD
 FAD9  FAD9 60E1
 FADA  FADA 60E6
 FADB  FADB 60EA
 FADC  FADC 60EE
 FADD  FADD 60EF
 FADE  FADE 60C7
 FADF  FADF 60FC
 FAE0  FAE0 61A7
 FAE1  FAE1 61B2
 FAE2  FAE2 61BB
 FAE3  FAE3 61BE
 FAE4  FAE4 9FAC
 FAE5  FAE5 61CC
 FAE6  FAE6 61C6
 FAE7  FAE7 61DF
 FAE8  FAE8 61E0
 FAE9  FAE9 61E9
 FAEA  FAEA 61F8
 FAEB  FAEB 65F4
 FAEC  FAEC 61EF
 FAED  FAED 62A3
 FAEE  FAEE 62A9
 FAEF  FAEF 62AE
 FAF0  FAF0 62B2
 FAF1  FAF1 62B3
 FAF2  FAF2 62B9
 FAF3  FAF3 62B8
 FAF4  FAF4 62D0
 FAF5  FAF5 62D5
 FAF6  FAF6 62D6
 FAF7  FAF7 62D8
 FAF8  FAF8 62D9
 FAF9  FAF9 62E2
 FAFA  FAFA 62E4
 FAFB  FAFB 62EB
 FAFC  FAFC 62F2
@ FB40 @ FB40 62EE
A FB41 A FB41 62FC
B FB42 B FB42 63A4
C FB43 C FB43 62FD
D FB44 D FB44 63A6
E FB45 E FB45 63BD
F FB46 F FB46 63B7
G FB47 G FB47 63B4
H FB48 H FB48 63AE
I FB49 I FB49 63B8
J FB4A J FB4A 9FB6
K FB4B K FB4B 63D8
L FB4C L FB4C 63DF
M FB4D M FB4D 63E4
N FB4E N FB4E 63EB
O FB4F O FB4F 63E8
P FB50 P FB50 63F1
Q FB51 Q FB51 63F8
R FB52 R FB52 63FD
S FB53 S FB53 9FB9
T FB54 T FB54 64A5
U FB55 U FB55 64AD
V FB56 V FB56 64AE
W FB57 W FB57 64AF
X FB58 X FB58 64B9
Y FB59 Y FB59 64B4
Z FB5A Z FB5A 64C2
[ FB5B [ FB5B 64CC
\ FB5C \ FB5C 9FBA
] FB5D ] FB5D 64D0
^ FB5E ^ FB5E 64CE
_ FB5F _ FB5F 64D2
` FB60 ` FB60 64DF
a FB61 a FB61 64DB
b FB62 b FB62 64E4
c FB63 c FB63 64E5
d FB64 d FB64 64E8
e FB65 e FB65 64EB
f FB66 f FB66 64EC
g FB67 g FB67 64F5
h FB68 h FB68 64F6
i FB69 i FB69 64FC
j FB6A j FB6A 64F8
k FB6B k FB6B 65A8
l FB6C l FB6C 65AE
m FB6D m FB6D 65B2
n FB6E n FB6E 65B9
o FB6F o FB6F 65C3
p FB70 p FB70 65CA
q FB71 q FB71 65CE
r FB72 r FB72 65CF
s FB73 s FB73 65D1
t FB74 t FB74 65D2
u FB75 u FB75 65D8
v FB76 v FB76 65E6
w FB77 w FB77 65F6
x FB78 x FB78 65F7
y FB79 y FB79 65FA
z FB7A z FB7A 66A1
{ FB7B { FB7B 66A5
| FB7C | FB7C 66AE
} FB7D } FB7D 66B0
~ FB7E ~ FB7E 66BB
 FB80  FB80 66C2
 FB81  FB81 66D0
 FB82  FB82 66D3
 FB83  FB83 66D4
 FB84  FB84 66FE
 FB85  FB85 67A2
 FB86  FB86 67A6
 FB87  FB87 67A4
 FB88  FB88 67B7
 FB89  FB89 67CC
 FB8A  FB8A 67DD
 FB8B  FB8B 67E1
 FB8C  FB8C 67EC
 FB8D  FB8D 67EB
 FB8E  FB8E 67F1
 FB8F  FB8F 67FB
 FB90  FB90 68A5
 FB91  FB91 68AE
 FB92  FB92 68B2
 FB93  FB93 68DA
 FB94  FB94 68DD
 FB95  FB95 68F2
 FB96  FB96 68FC
 FB97  FB97 68F8
 FB98  FB98 69A3
 FB99  FB99 69AF
 FB9A  FB9A 69BE
 FB9B  FB9B 69BF
 FB9C  FB9C 69BA
 FB9D  FB9D 69C1
 FB9E  FB9E 69C9
 FB9F  FB9F 69D0
 FBA0  FBA0 69D7
 FBA1  FBA1 69DA
 FBA2  FBA2 69E6
 FBA3  FBA3 69FE
 FBA4  FBA4 6AA5
 FBA5  FBA5 6AAA
 FBA6  FBA6 6AAB
 FBA7  FBA7 6AAD
 FBA8  FBA8 6AB3
 FBA9  FBA9 6AB2
 FBAA  FBAA 6AB4
 FBAB  FBAB 6ABE
 FBAC  FBAC 6AC3
 FBAD  FBAD 6AD0
 FBAE  FBAE 6ACF
 FBAF  FBAF 6AD5
 FBB0  FBB0 6AD8
 FBB1  FBB1 6AD9
 FBB2  FBB2 6AE1
 FBB3  FBB3 6AEB
 FBB4  FBB4 6AFA
 FBB5  FBB5 6BA3
 FBB6  FBB6 6BC7
 FBB7  FBB7 6BCA
 FBB8  FBB8 6BCD
 FBB9  FBB9 6BD1
 FBBA  FBBA 6BD9
 FBBB  FBBB 6BD8
 FBBC  FBBC 6BDA
 FBBD  FBBD 6BDC
 FBBE  FBBE 6BE1
 FBBF  FBBF 6BE0
 FBC0  FBC0 6BDF
 FBC1  FBC1 6BE5
 FBC2  FBC2 6BE9
 FBC3  FBC3 6BE7
 FBC4  FBC4 6BF2
 FBC5  FBC5 6BEE
 FBC6  FBC6 6BF3
 FBC7  FBC7 6BEF
 FBC8  FBC8 6BF1
 FBC9  FBC9 6BEC
 FBCA  FBCA 6BED
 FBCB  FBCB 6BF6
 FBCC  FBCC 6CA6
 FBCD  FBCD 6CA8
 FBCE  FBCE 6CA5
 FBCF  FBCF 6CB1
 FBD0  FBD0 6CAC
 FBD1  FBD1 6CB8
 FBD2  FBD2 6CB3
 FBD3  FBD3 6CB7
 FBD4  FBD4 6CB5
 FBD5  FBD5 6CB0
 FBD6  FBD6 9FCA
 FBD7  FBD7 6CC3
 FBD8  FBD8 6CBE
 FBD9  FBD9 6CCD
 FBDA  FBDA 6CC2
 FBDB  FBDB 6CBF
 FBDC  FBDC 6CC1
 FBDD  FBDD 6CC4
 FBDE  FBDE 6CC5
 FBDF  FBDF 6CCA
 FBE0  FBE0 6CCC
 FBE1  FBE1 6CD8
 FBE2  FBE2 6CE0
 FBE3  FBE3 6CDF
 FBE4  FBE4 6CE6
 FBE5  FBE5 6CEF
 FBE6  FBE6 6CF0
 FBE7  FBE7 6CF1
 FBE8  FBE8 6CF8
 FBE9  FBE9 6DA2
 FBEA  FBEA 6DA4
 FBEB  FBEB 6DA5
 FBEC  FBEC 6DA6
 FBED  FBED 9FCD
 FBEE  FBEE 9FCE
 FBEF  FBEF 6DAE
 FBF0  FBF0 6DB0
 FBF1  FBF1 9FCF
 FBF2  FBF2 6DB1
 FBF3  FBF3 6DB2
 FBF4  FBF4 6DC1
 FBF5  FBF5 6DC2
 FBF6  FBF6 6DC5
 FBF7  FBF7 6DC6
 FBF8  FBF8 6DC8
 FBF9  FBF9 6DC9
 FBFA  FBFA 6DCC
 FBFB  FBFB 6DD9
 FBFC  FBFC 6DD4
@ FC40 @ FC40 6DDC
A FC41 A FC41 9FD2
B FC42 B FC42 6DE0
C FC43 C FC43 6DE2
D FC44 D FC44 6DE5
E FC45 E FC45 6DE7
F FC46 F FC46 9FD3
G FC47 G FC47 9FD8
H FC48 H FC48 6DF2
I FC49 I FC49 6DF4
J FC4A J FC4A 6EAC
K FC4B K FC4B 6EA1
 81B8  81B8 A2BA
 81B9  81B9 A2BB
 81BA  81BA A2BC
 81BB  81BB A2BD
 81BC  81BC A2BE
 81BD  81BD A2BF
 81C8  81C8 A2CA
 81C9  81C9 A2CB
 81CB  81CB A2CD
 81CC  81CC A2CE
 81CD  81CD A2CF
 81CE  81CE A2D0
 81DC  81DC A2DE
 81DD  81DD A2DF
 81DE  81DE A2E0
 81E1  81E1 A2E3
 81E2  81E2 A2E4
 81E4  81E4 A2E6
 81E5  81E5 A2E7
 81E7  81E7 A2E9
 81E8  81E8 A2EA
 81F0  81F0 A2F2
 81F1  81F1 A2F3
 81F2  81F2 A2F4
 81F3  81F3 A2F5
 81F4  81F4 A2F6
 81F5  81F5 A2F7
 81F6  81F6 A2F8
 81F7  81F7 A2F9
 81FC  81FC A2FE
 849F  849F A8A1
 84A0  84A0 A8A2
 84A1  84A1 A8A3
 84A2  84A2 A8A4
 84A3  84A3 A8A5
 84A4  84A4 A8A6
 84A5  84A5 A8A7
 84A6  84A6 A8A8
 84A7  84A7 A8A9
 84A8  84A8 A8AA
 84A9  84A9 A8AB
 84AA  84AA A8AC
 84AB  84AB A8AD
 84AC  84AC A8AE
 84AD  84AD A8AF
 84AE  84AE A8B0
 84AF  84AF A8B1
 84B0  84B0 A8B2
 84B1  84B1 A8B3
 84B2  84B2 A8B4
 84B3  84B3 A8B5
 84B4  84B4 A8B6
 84B5  84B5 A8B7
 84B6  84B6 A8B8
 84B7  84B7 A8B9
 84B8  84B8 A8BA
 84B9  84B9 A8BB
 84BA  84BA A8BC
 84BB  84BB A8BD
 84BC  84BC A8BE
 84BD  84BD A8BF
 84BE  84BE A8C0
 8785  8785 73EA
 8786  8786 73EB
 8787  8787 73EC
 8788  8788 73ED
 8789  8789 73EE
 878D  878D 72F5
 878E  878E 72F6
 878F  878F 72F7
~ 877E ~ 877E 73F8
 8793  8793 6FB8
 8794  8794 6FA2
 8798  8798 6FB7
 8799  8799 6FBA
END

for (@KEIS83_by_CP932_a) {
    if (not /^[0123456789ABCDEF]{4}$/) {
        die;
    }
}

my %KEIS83_by_CP932_a = @KEIS83_by_CP932_a;
if (scalar(keys %KEIS83_by_CP932_a) != scalar(@KEIS83_by_CP932_a)/2) {
    die;
}

my %reverse_KEIS83_by_CP932_a = reverse @KEIS83_by_CP932_a;
if (scalar(keys %reverse_KEIS83_by_CP932_a) != scalar(@KEIS83_by_CP932_a)/2) {
    die;
}

for (@KEIS83_by_CP932_b) {
    if (not /^[0123456789ABCDEF]{4}$/) {
        die;
    }
}

my %KEIS83_by_CP932_b = @KEIS83_by_CP932_b;
if (scalar(keys %KEIS83_by_CP932_b) != scalar(@KEIS83_by_CP932_b)/2) {
    die;
}

my %reverse_KEIS83_by_CP932_b = reverse @KEIS83_by_CP932_b;
if (scalar(keys %reverse_KEIS83_by_CP932_b) != scalar(@KEIS83_by_CP932_b)/2) {
    die;
}

if ("@KEIS83_by_CP932_a" ne "@KEIS83_by_CP932_b") {
    while (@KEIS83_by_CP932_a or @KEIS83_by_CP932_b) {
        my $a = shift @KEIS83_by_CP932_a;
        my $b = shift @KEIS83_by_CP932_b;
        if ($a ne $b) {
            print STDERR "A=$a\n";
            print STDERR "B=$b\n";
            print STDERR "\n";
        }
    }
    die;
}

%KEIS83_by_CP932 = @KEIS83_by_CP932_a;

sub KEIS83_by_CP932 {
    my($cp932) = @_;
    return $KEIS83_by_CP932{$cp932};
}

sub keys_of_KEIS83_by_CP932 {
    return keys %KEIS83_by_CP932;
}

sub values_of_KEIS83_by_CP932 {
    return values %KEIS83_by_CP932;
}

1;

__END__
