# Audio::PortMIDI

Raku MIDI access using the portmidi library

[![CI](https://github.com/Raku-Noise-Gang/Audio-PortMIDI/actions/workflows/main.yml/badge.svg)](https://github.com/Raku-Noise-Gang/Audio-PortMIDI/actions/workflows/main.yml)

## Synopsis

```raku

use Audio::PortMIDI;

my $pm = Audio::PortMIDI.new;

my $dev = $pm.default-output-device;

say $dev;


my $stream = $pm.open-output($dev, 32);

# Play 1/8th note middle C
my $note-on = Audio::PortMIDI::Event.new(event-type => NoteOn, channel => 1, data-one => 60, data-two => 127, timestamp => 0);
my $note-off = Audio::PortMIDI::Event.new(event-type => NoteOff, channel => 1, data-one => 60, data-two => 127, timestamp => 0);

$stream.write($note-on);
sleep .25;
$stream.write($note-off);

$stream.close;

$pm.terminate;

```

See also the [examples](examples) directory for more complete examples.

## Description

This allows you to get MIDI data into or out of your Raku programs. It
provides the minimum abstraction to construct and unpack MIDI messages
and send and receive them via some interface available on your system,
be that ALSA on Linux, CoreMidi on Mac OS/X or whatever it is that
Windows uses.  Depending on the way that the portmidi library is built
there may be other interfaces available.

The MIDI specification itself doesn't particularly provide for the 
arrangement of the events themselves in time and this is assumed to
be the responsibility of the calling application.  

You almost certainly will want to familiarise yourself to some extent
with the [MIDI protocol](http://www.midi.org) and especially the types
of messages that are sent as the interface of PortMIDI and hence this
module is fairly "close to the wire".

## Installation

This requires the [portmidi](http://portmedia.sourceforge.net/portmidi/)
library installed in order to function. Many operating system distributions
will have it available as an installable package or you may be able to
install it from some other compiled package.  Installing it from source
is of course possible but you will need a compiler and the appropriate
tools to do so.

On Linux you will need need permissions to the sequencer device, typically
this is provided by a member of the *audio* group however this may differ
by distribution so you might need to check if this doesn't work.

Assuming you have the libray installed and have a working rakudo 
installation the you should be able to install directly with ```zef```:

    zef install Audio::PortMIDI

Or if you have the source on your local machine (which I recommend as
you can look at the examples):

    zef install .

in the directory that you have downloaded.


## Support

This is a fairly low level API to the MIDI devices, while I have
noted some aspects of the MIDI spec as it effects the implementation
of the module, this is probably not a substitute for some familiarity
with the MIDI specification itself.

Also the degree of compliance and the meaning of certain messages may
differ on specific software or hardware devices so if things aren't
behaving quite as expected you may want to consult the documentation
for your device (most hardware synthesizers and controllers tend to
be fairly well documented in regard of their MIDI implementation.)

I have found that some utility such as ```aseqdump``` for Linux may
help in finding problems, the [dump-stream](examples/dump-stream) 
program in the distribution may help, but using another monitor
may help rule out problems with this module.

If you have a problem or a suggestion then please raise an issue at:

     https://github.com/Raku-Noise-Gang/Audio-PortMIDI/issues

Obviously if you have some query regarding interoperability with some
particular device or software I am unlikely to be able to help much
if I don't have access to a similar device or software. A dump of the
MIDI events being sent or received may help.

## Licence and Copyright

This is free software. Please see the LICENCE file in the distribution
for the terms of the license.

	© Jonathan Stowe, 2016, 2017, 2021
	© Raku Noise Gang
	

