use strict;
use warnings;

use Fcntl qw(SEEK_SET);

$| = 1; # nicer to pipes
$\ = "\n"; # less to type?

my @test = ( # a series of test subs, which return true for success, 0 otherwise
	sub { require MPEG::Audio::Frame }, # see if it actually loads
	sub { # read a frame
		my $frame = MPEG::Audio::Frame->read(\*DATA) || return undef; # read the next frame from the data bit
		
		return undef unless (
			not defined $frame->crc and
			$frame->bitrate() == 128 and
			$frame->sample() == 44100 and
			int($frame->seconds()*10000) == 261 and
			$frame->length() == 418 and
			not $frame->broken and
		1);
		
		seek DATA, $frame->offset, SEEK_SET;
		read DATA, my $data, $frame->length;
		$data eq "$frame" or return undef;
		
		1; # we made it
	},
	sub { # a different frame
		my $frame = MPEG::Audio::Frame->read(\*DATA) || return undef; # read the next frame from the data bit
		
		return undef unless (
			defined $frame->crc() and
			$frame->bitrate() == 224 and
			$frame->sample() == 44100 and
			int($frame->seconds()*10000) == 261 and
			$frame->length() == 731 and
			not $frame->broken and
		1);
		
		seek DATA, $frame->offset, SEEK_SET;
		read DATA, my $data, $frame->length;
		$data eq "$frame" or return undef;

		1; # we made it
	},
	sub { return undef if MPEG::Audio::Frame->read(\*DATA); 1 }, # make sure there's nothing left to read
);

print "1..", scalar @test; # the number of tests we have

my $i = 0; # a counter

foreach (@test) { print (((&$_) ? "" : "not ") . "ok " . ++$i) } # test away

__DATA__
the following data is used to test the module.

and mp3 header and frame will follow this (text|garbage)
and will be parsed and munged and whatever.

here goes nothing...



@     7                                                                                                                                                                                                                                                                                                                                                                                                                  



this is more garbage to be ignored


dgskjhag
  ɊH&N  HH e"= 
jK    c :#f;+\o >5gbqO
P(%1s?&.A"69O'ly+a*r.W"S"PhOfPr.nE|n\.x
Si*oG@0 <No | Y8 	L\1da8ȟ,"9  ,"c0A
@Șx6Arό7 Pо_7p00
D=1sA%YhROA0=AE$afbI%EM$ffkRUUzUj[<L)}JU}ko<ԳZC#3[G2.lӠ55TseC4VUokhY4u0L<
(Fh"̰TB8ӵT4SS3C̔5Egh&ٗ.
|pюu-:[^RߨMme$MTP
y
:~]9&oRLPFP6]A>etMC#=3LsBphq\`YF
	0Ѐsh>!hBYt4b`Y(nQ&<

dgkuwj more ʬĩϫgarbage&&$Y n4bnoet
