######################################################################
#
# 1083_utf8_by_keis90.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x37",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x2D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x2E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x2F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x16",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x05",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x15",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x3C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x3D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x32",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x26",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x3F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x27",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x40",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x4F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x7F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x7B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x6C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x50",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x7D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x4D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x5D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x5C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x4E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x6B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x60",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x4B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x61",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x7A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x5E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x4C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x7E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x6E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x6F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x7C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x4A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x5A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x5F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x6D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x79",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x59",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x62",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x63",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x64",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x65",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x66",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x67",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x68",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x69",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x70",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x71",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x72",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x73",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x74",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x75",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x76",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x77",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x78",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x80",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x8B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x9B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x9C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\xA0",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x6A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x07",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x20",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x21",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x22",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x23",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x24",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x25",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x06",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x17",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x28",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x29",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x2A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x2B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x2C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x09",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x0A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x1B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x30",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x31",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x1A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x33",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x34",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x35",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x36",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x08",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x38",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x39",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x3A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x3B",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x04",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x14",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x3E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x57",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x41",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA1"],
        ["\x42",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA2"],
        ["\x43",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA3"],
        ["\x44",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA4"],
        ["\x45",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA5"],
        ["\x46",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA6"],
        ["\x47",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA7"],
        ["\x48",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA8"],
        ["\x49",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA9"],
        ["\x51",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAA"],
        ["\x52",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAB"],
        ["\x53",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAC"],
        ["\x54",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAD"],
        ["\x55",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAE"],
        ["\x56",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAF"],
        ["\x58",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB0"],
        ["\x81",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB1"],
        ["\x82",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB2"],
        ["\x83",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB3"],
        ["\x84",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB4"],
        ["\x85",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB5"],
        ["\x86",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB6"],
        ["\x87",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB7"],
        ["\x88",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB8"],
        ["\x89",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB9"],
        ["\x8A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBA"],
        ["\x8C",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBB"],
        ["\x8D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBC"],
        ["\x8E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBD"],
        ["\x8F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBE"],
        ["\x90",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBF"],
        ["\x91",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x80"],
        ["\x92",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x81"],
        ["\x93",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x82"],
        ["\x94",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x83"],
        ["\x95",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x84"],
        ["\x96",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x85"],
        ["\x97",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x86"],
        ["\x98",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x87"],
        ["\x99",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x88"],
        ["\x9A",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x89"],
        ["\x9D",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8A"],
        ["\x9E",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8B"],
        ["\x9F",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8C"],
        ["\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8D"],
        ["\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8E"],
        ["\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8F"],
        ["\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x90"],
        ["\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x91"],
        ["\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x92"],
        ["\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x93"],
        ["\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x94"],
        ["\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x95"],
        ["\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x96"],
        ["\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x97"],
        ["\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x98"],
        ["\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x99"],
        ["\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9A"],
        ["\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9B"],
        ["\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9C"],
        ["\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9D"],
        ["\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9E"],
        ["\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9F"],
        ["\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFF",'utf8','keis90',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xA1\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x80"],
        ["\xA1\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x81"],
        ["\xA1\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x82"],
        ["\xA1\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8C"],
        ["\xA1\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8E"],
        ["\xA1\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBB"],
        ["\xA1\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9A"],
        ["\xA1\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9B"],
        ["\xA1\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9F"],
        ["\xA1\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x81"],
        ["\xA1\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9B"],
        ["\xA1\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9C"],
        ["\xA1\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xA1\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x80"],
        ["\xA1\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xA1\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBE"],
        ["\xA1\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA3"],
        ["\xA1\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBF"],
        ["\xA1\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBD"],
        ["\xA1\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBE"],
        ["\xA1\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9D"],
        ["\xA1\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9E"],
        ["\xA1\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x83"],
        ["\xA1\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9D"],
        ["\xA1\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x85"],
        ["\xA1\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x86"],
        ["\xA1\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x87"],
        ["\xA1\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBC"],
        ["\xA1\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x95"],
        ["\xA1\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x90"],
        ["\xA1\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8F"],
        ["\xA1\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBC"],
        ["\xA1\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],
        ["\xA1\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA5"],
        ["\xA1\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9C"],
        ["\xA1\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA6"],
        ["\xA1\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA5"],
        ["\xA1\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x98"],
        ["\xA1\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x99"],
        ["\xA1\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9C"],
        ["\xA1\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9D"],
        ["\xA1\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x88"],
        ["\xA1\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x89"],
        ["\xA1\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x94"],
        ["\xA1\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x95"],
        ["\xA1\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBB"],
        ["\xA1\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBD"],
        ["\xA1\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9B"],
        ["\xA1\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9D"],
        ["\xA1\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x88"],
        ["\xA1\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x89"],
        ["\xA1\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8A"],
        ["\xA1\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8B"],
        ["\xA1\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8C"],
        ["\xA1\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8D"],
        ["\xA1\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8E"],
        ["\xA1\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8F"],
        ["\xA1\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x90"],
        ["\xA1\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x91"],
        ["\xA1\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8B"],
        ["\xA1\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8D"],
        ["\xA1\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xA1\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC3\x97"],
        ["\xA1\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xA1\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9D"],
        ["\xA1\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA0"],
        ["\xA1\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9C"],
        ["\xA1\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9E"],
        ["\xA1\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA6"],
        ["\xA1\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA7"],
        ["\xA1\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9E"],
        ["\xA1\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB4"],
        ["\xA1\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x82"],
        ["\xA1\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x80"],
        ["\xA1\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xA1\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB2"],
        ["\xA1\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB3"],
        ["\xA1\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x83"],
        ["\xA1\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA5"],
        ["\xA1\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x84"],
        ["\xA1\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],
        ["\xA1\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],
        ["\xA1\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x85"],
        ["\xA1\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x83"],
        ["\xA1\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x86"],
        ["\xA1\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8A"],
        ["\xA1\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA0"],
        ["\xA1\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xA1\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x86"],
        ["\xA1\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x85"],
        ["\xA1\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8B"],
        ["\xA1\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8F"],
        ["\xA1\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8E"],
        ["\xA1\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x87"],
        ["\xA2\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x86"],
        ["\xA2\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA1"],
        ["\xA2\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA0"],
        ["\xA2\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB3"],
        ["\xA2\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB2"],
        ["\xA2\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBD"],
        ["\xA2\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBC"],
        ["\xA2\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBB"],
        ["\xA2\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x92"],
        ["\xA2\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x92"],
        ["\xA2\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x90"],
        ["\xA2\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x91"],
        ["\xA2\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x93"],
        ["\xA2\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xA2\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x88"],
        ["\xA2\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x8B"],
        ["\xA2\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x86"],
        ["\xA2\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x87"],
        ["\xA2\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x82"],
        ["\xA2\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x83"],
        ["\xA2\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAA"],
        ["\xA2\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA9"],
        ["\xA2\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA7"],
        ["\xA2\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA8"],
        ["\xA2\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA2"],
        ["\xA2\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x92"],
        ["\xA2\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x94"],
        ["\xA2\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x80"],
        ["\xA2\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x83"],
        ["\xA2\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA0"],
        ["\xA2\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xA5"],
        ["\xA2\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x92"],
        ["\xA2\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x82"],
        ["\xA2\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x87"],
        ["\xA2\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA1"],
        ["\xA2\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x92"],
        ["\xA2\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAA"],
        ["\xA2\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAB"],
        ["\xA2\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9A"],
        ["\xA2\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xBD"],
        ["\xA2\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9D"],
        ["\xA2\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB5"],
        ["\xA2\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAB"],
        ["\xA2\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAC"],
        ["\xA2\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xAB"],
        ["\xA2\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB0"],
        ["\xA2\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAF"],
        ["\xA2\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAD"],
        ["\xA2\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAA"],
        ["\xA2\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA0"],
        ["\xA2\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA1"],
        ["\xA2\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xA2\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xAF"],
        ["\xA3\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x90"],
        ["\xA3\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x91"],
        ["\xA3\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x92"],
        ["\xA3\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x93"],
        ["\xA3\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x94"],
        ["\xA3\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x95"],
        ["\xA3\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x96"],
        ["\xA3\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x97"],
        ["\xA3\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x98"],
        ["\xA3\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x99"],
        ["\xA3\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA1"],
        ["\xA3\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA2"],
        ["\xA3\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA3"],
        ["\xA3\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA4"],
        ["\xA3\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA5"],
        ["\xA3\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA6"],
        ["\xA3\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA7"],
        ["\xA3\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA8"],
        ["\xA3\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA9"],
        ["\xA3\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAA"],
        ["\xA3\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAB"],
        ["\xA3\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAC"],
        ["\xA3\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAD"],
        ["\xA3\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAE"],
        ["\xA3\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAF"],
        ["\xA3\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB0"],
        ["\xA3\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB1"],
        ["\xA3\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB2"],
        ["\xA3\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB3"],
        ["\xA3\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB4"],
        ["\xA3\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB5"],
        ["\xA3\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB6"],
        ["\xA3\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB7"],
        ["\xA3\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB8"],
        ["\xA3\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB9"],
        ["\xA3\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBA"],
        ["\xA3\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x81"],
        ["\xA3\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x82"],
        ["\xA3\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x83"],
        ["\xA3\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x84"],
        ["\xA3\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x85"],
        ["\xA3\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x86"],
        ["\xA3\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x87"],
        ["\xA3\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x88"],
        ["\xA3\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x89"],
        ["\xA3\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8A"],
        ["\xA3\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8B"],
        ["\xA3\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8C"],
        ["\xA3\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8D"],
        ["\xA3\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8E"],
        ["\xA3\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8F"],
        ["\xA3\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x90"],
        ["\xA3\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x91"],
        ["\xA3\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x92"],
        ["\xA3\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x93"],
        ["\xA3\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x94"],
        ["\xA3\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x95"],
        ["\xA3\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x96"],
        ["\xA3\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x97"],
        ["\xA3\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x98"],
        ["\xA3\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x99"],
        ["\xA3\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9A"],
        ["\xA4\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x81"],
        ["\xA4\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x82"],
        ["\xA4\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x83"],
        ["\xA4\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x84"],
        ["\xA4\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x85"],
        ["\xA4\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x86"],
        ["\xA4\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x87"],
        ["\xA4\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x88"],
        ["\xA4\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x89"],
        ["\xA4\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8A"],
        ["\xA4\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B"],
        ["\xA4\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8C"],
        ["\xA4\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D"],
        ["\xA4\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8E"],
        ["\xA4\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F"],
        ["\xA4\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x90"],
        ["\xA4\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91"],
        ["\xA4\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x92"],
        ["\xA4\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93"],
        ["\xA4\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x94"],
        ["\xA4\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x95"],
        ["\xA4\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x96"],
        ["\xA4\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x97"],
        ["\xA4\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x98"],
        ["\xA4\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x99"],
        ["\xA4\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9A"],
        ["\xA4\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9B"],
        ["\xA4\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9C"],
        ["\xA4\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9D"],
        ["\xA4\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9E"],
        ["\xA4\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9F"],
        ["\xA4\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA0"],
        ["\xA4\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA1"],
        ["\xA4\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA2"],
        ["\xA4\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA3"],
        ["\xA4\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA4"],
        ["\xA4\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA5"],
        ["\xA4\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA6"],
        ["\xA4\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA7"],
        ["\xA4\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA8"],
        ["\xA4\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA9"],
        ["\xA4\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAA"],
        ["\xA4\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAB"],
        ["\xA4\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAC"],
        ["\xA4\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAD"],
        ["\xA4\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAE"],
        ["\xA4\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAF"],
        ["\xA4\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB0"],
        ["\xA4\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB1"],
        ["\xA4\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB2"],
        ["\xA4\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB3"],
        ["\xA4\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB4"],
        ["\xA4\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB5"],
        ["\xA4\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB6"],
        ["\xA4\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB7"],
        ["\xA4\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB8"],
        ["\xA4\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB9"],
        ["\xA4\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBA"],
        ["\xA4\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBB"],
        ["\xA4\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBC"],
        ["\xA4\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBD"],
        ["\xA4\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBE"],
        ["\xA4\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBF"],
        ["\xA4\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x80"],
        ["\xA4\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x81"],
        ["\xA4\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x82"],
        ["\xA4\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x83"],
        ["\xA4\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x84"],
        ["\xA4\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x85"],
        ["\xA4\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x86"],
        ["\xA4\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x87"],
        ["\xA4\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x88"],
        ["\xA4\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x89"],
        ["\xA4\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8A"],
        ["\xA4\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8B"],
        ["\xA4\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8C"],
        ["\xA4\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8D"],
        ["\xA4\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8E"],
        ["\xA4\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8F"],
        ["\xA4\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x90"],
        ["\xA4\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x91"],
        ["\xA4\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x92"],
        ["\xA4\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x93"],
        ["\xA5\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA1"],
        ["\xA5\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA2"],
        ["\xA5\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA3"],
        ["\xA5\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA4"],
        ["\xA5\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA5"],
        ["\xA5\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA6"],
        ["\xA5\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA7"],
        ["\xA5\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA8"],
        ["\xA5\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA9"],
        ["\xA5\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAA"],
        ["\xA5\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB"],
        ["\xA5\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAC"],
        ["\xA5\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD"],
        ["\xA5\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAE"],
        ["\xA5\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF"],
        ["\xA5\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB0"],
        ["\xA5\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1"],
        ["\xA5\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB2"],
        ["\xA5\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3"],
        ["\xA5\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB4"],
        ["\xA5\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB5"],
        ["\xA5\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB6"],
        ["\xA5\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB7"],
        ["\xA5\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB8"],
        ["\xA5\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB9"],
        ["\xA5\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBA"],
        ["\xA5\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB"],
        ["\xA5\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBC"],
        ["\xA5\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBD"],
        ["\xA5\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBE"],
        ["\xA5\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBF"],
        ["\xA5\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x80"],
        ["\xA5\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x81"],
        ["\xA5\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x82"],
        ["\xA5\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x83"],
        ["\xA5\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84"],
        ["\xA5\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x85"],
        ["\xA5\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x86"],
        ["\xA5\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x87"],
        ["\xA5\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88"],
        ["\xA5\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x89"],
        ["\xA5\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8A"],
        ["\xA5\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8B"],
        ["\xA5\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8C"],
        ["\xA5\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8D"],
        ["\xA5\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8E"],
        ["\xA5\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8F"],
        ["\xA5\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x90"],
        ["\xA5\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x91"],
        ["\xA5\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x92"],
        ["\xA5\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x93"],
        ["\xA5\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x94"],
        ["\xA5\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x95"],
        ["\xA5\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x96"],
        ["\xA5\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x97"],
        ["\xA5\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x98"],
        ["\xA5\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x99"],
        ["\xA5\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9A"],
        ["\xA5\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9B"],
        ["\xA5\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9C"],
        ["\xA5\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9D"],
        ["\xA5\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9E"],
        ["\xA5\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9F"],
        ["\xA5\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA0"],
        ["\xA5\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA1"],
        ["\xA5\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA2"],
        ["\xA5\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA3"],
        ["\xA5\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA4"],
        ["\xA5\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA5"],
        ["\xA5\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA6"],
        ["\xA5\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA7"],
        ["\xA5\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA8"],
        ["\xA5\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA9"],
        ["\xA5\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAA"],
        ["\xA5\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAB"],
        ["\xA5\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAC"],
        ["\xA5\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAD"],
        ["\xA5\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAE"],
        ["\xA5\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAF"],
        ["\xA5\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB0"],
        ["\xA5\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB1"],
        ["\xA5\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB2"],
        ["\xA5\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB3"],
        ["\xA5\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB4"],
        ["\xA5\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB5"],
        ["\xA5\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB6"],
        ["\xA6\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x91"],
        ["\xA6\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],
        ["\xA6\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x93"],
        ["\xA6\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x94"],
        ["\xA6\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],
        ["\xA6\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x96"],
        ["\xA6\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x97"],
        ["\xA6\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x98"],
        ["\xA6\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x99"],
        ["\xA6\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x9A"],
        ["\xA6\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x9B"],
        ["\xA6\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x9C"],
        ["\xA6\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x9D"],
        ["\xA6\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],
        ["\xA6\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\x9F"],
        ["\xA6\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],
        ["\xA6\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xA6\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xA6\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xA6\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xA6\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xA6\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xA6\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xA6\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xA6\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xA6\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xA6\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xA6\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xA6\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xA6\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xA6\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xA6\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xA6\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xA6\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xA6\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xA6\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xA6\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xA6\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xA6\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xA6\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x80"],
        ["\xA6\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x81"],
        ["\xA6\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x83"],
        ["\xA6\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x84"],
        ["\xA6\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x85"],
        ["\xA6\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x86"],
        ["\xA6\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],
        ["\xA6\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x88"],
        ["\xA6\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xCF\x89"],
        ["\xA7\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x90"],
        ["\xA7\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x91"],
        ["\xA7\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x92"],
        ["\xA7\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x93"],
        ["\xA7\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x94"],
        ["\xA7\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x95"],
        ["\xA7\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x81"],
        ["\xA7\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x96"],
        ["\xA7\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x97"],
        ["\xA7\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x98"],
        ["\xA7\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x99"],
        ["\xA7\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],
        ["\xA7\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x9B"],
        ["\xA7\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x9C"],
        ["\xA7\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x9D"],
        ["\xA7\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x9E"],
        ["\xA7\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],
        ["\xA7\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA0"],
        ["\xA7\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xA7\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xA7\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xA7\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xA7\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xA7\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xA7\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xA7\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xA7\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xA7\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xA7\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xA7\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xA7\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xA7\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xA7\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xA7\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xA7\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xA7\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xA7\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xA7\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xA7\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xA7\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],
        ["\xA7\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xA7\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xA7\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xA7\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xA7\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xA7\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xA7\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xA7\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xA7\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xA7\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xA7\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],
        ["\xA7\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x81"],
        ["\xA7\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x82"],
        ["\xA7\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x83"],
        ["\xA7\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x84"],
        ["\xA7\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x85"],
        ["\xA7\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x86"],
        ["\xA7\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x87"],
        ["\xA7\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],
        ["\xA7\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],
        ["\xA7\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x8A"],
        ["\xA7\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],
        ["\xA7\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],
        ["\xA7\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x8D"],
        ["\xA7\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],
        ["\xA7\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],
        ["\xA8\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x80"],
        ["\xA8\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x82"],
        ["\xA8\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8C"],
        ["\xA8\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x90"],
        ["\xA8\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x98"],
        ["\xA8\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x94"],
        ["\xA8\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9C"],
        ["\xA8\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAC"],
        ["\xA8\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA4"],
        ["\xA8\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB4"],
        ["\xA8\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBC"],
        ["\xA8\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x81"],
        ["\xA8\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x83"],
        ["\xA8\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8F"],
        ["\xA8\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x93"],
        ["\xA8\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9B"],
        ["\xA8\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x97"],
        ["\xA8\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA3"],
        ["\xA8\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB3"],
        ["\xA8\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAB"],
        ["\xA8\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBB"],
        ["\xA8\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x8B"],
        ["\xA8\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA0"],
        ["\xA8\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAF"],
        ["\xA8\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA8"],
        ["\xA8\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB7"],
        ["\xA8\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBF"],
        ["\xA8\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9D"],
        ["\xA8\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB0"],
        ["\xA8\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA5"],
        ["\xA8\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB8"],
        ["\xA8\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x82"],
        ["\x76\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA0"],
        ["\x76\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA1"],
        ["\x76\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA2"],
        ["\x76\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA3"],
        ["\x76\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA4"],
        ["\x76\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA5"],
        ["\x76\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA6"],
        ["\x76\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA7"],
        ["\x76\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA8"],
        ["\x76\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA9"],
        ["\x77\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAA"],
        ["\x77\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAB"],
        ["\x77\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAC"],
        ["\x77\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAD"],
        ["\x77\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAE"],
        ["\x77\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAF"],
        ["\x77\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB0"],
        ["\x77\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB1"],
        ["\x77\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB2"],
        ["\x77\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB3"],
        ["\x74\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA0"],
        ["\x74\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA1"],
        ["\x74\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA2"],
        ["\x74\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA3"],
        ["\x74\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA4"],
        ["\x74\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA5"],
        ["\x74\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA6"],
        ["\x74\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA7"],
        ["\x74\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA8"],
        ["\x74\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA9"],
        ["\x70\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x89"],
        ["\x70\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x94"],
        ["\x70\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA2"],
        ["\x70\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8D"],
        ["\x70\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x98"],
        ["\x70\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA7"],
        ["\x70\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x83"],
        ["\x70\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xB6"],
        ["\x70\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x97"],
        ["\x70\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x8D"],
        ["\x70\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA6"],
        ["\x70\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA3"],
        ["\x70\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xAB"],
        ["\x70\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8A"],
        ["\x70\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xBB"],
        ["\x6F\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9C"],
        ["\x6F\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9D"],
        ["\x6F\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9E"],
        ["\x6F\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8E"],
        ["\x6F\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8F"],
        ["\x6F\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x84"],
        ["\x6F\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\xA1"],
        ["\x73\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBB"],
        ["\x72\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x96"],
        ["\x72\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8D"],
        ["\x72\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA1"],
        ["\x73\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA4"],
        ["\x73\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA5"],
        ["\x73\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA6"],
        ["\x73\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA7"],
        ["\x73\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA8"],
        ["\x73\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB1"],
        ["\x73\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB2"],
        ["\x73\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB9"],
        ["\x72\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBE"],
        ["\x72\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBD"],
        ["\x72\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBC"],
        ["\x6F\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAE"],
        ["\x6F\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x91"],
        ["\x6F\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9F"],
        ["\x6F\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xBF"],
        ["\xB0\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9C"],
        ["\xB0\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x96"],
        ["\xB0\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x83"],
        ["\xB0\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBF"],
        ["\xB0\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x80"],
        ["\xB0\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9B"],
        ["\xB0\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA8"],
        ["\xB0\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB6"],
        ["\xB0\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA2"],
        ["\xB0\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB5"],
        ["\xB0\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9C"],
        ["\xB0\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x90"],
        ["\xB0\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xAA"],
        ["\xB0\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA1"],
        ["\xB0\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA5"],
        ["\xB0\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAD"],
        ["\xB0\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA6"],
        ["\xB0\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA6"],
        ["\xB0\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB5"],
        ["\xB0\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x93"],
        ["\xB0\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA7"],
        ["\xB0\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA1"],
        ["\xB0\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB1"],
        ["\xB0\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9B"],
        ["\xB0\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x90"],
        ["\xB0\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBB"],
        ["\xB0\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB4"],
        ["\xB0\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA2"],
        ["\xB0\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBE"],
        ["\xB0\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8E"],
        ["\xB0\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x96"],
        ["\xB0\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9F"],
        ["\xB0\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB7"],
        ["\xB0\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x89"],
        ["\xB0\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB5"],
        ["\xB0\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x89"],
        ["\xB0\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x97"],
        ["\xB0\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x88"],
        ["\xB0\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x87"],
        ["\xB0\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8D"],
        ["\xB0\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8F"],
        ["\xB0\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA5"],
        ["\xB0\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8A"],
        ["\xB0\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8D"],
        ["\xB0\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9D"],
        ["\xB0\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x89"],
        ["\xB0\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB2"],
        ["\xB0\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB7"],
        ["\xB0\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x94"],
        ["\xB0\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x81"],
        ["\xB0\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x89"],
        ["\xB0\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9F"],
        ["\xB0\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8F"],
        ["\xB0\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB0"],
        ["\xB0\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x93"],
        ["\xB0\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x85"],
        ["\xB0\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBA"],
        ["\xB0\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8F"],
        ["\xB0\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB0"],
        ["\xB0\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xBB"],
        ["\xB0\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAD"],
        ["\xB0\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAF"],
        ["\xB0\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x83"],
        ["\xB0\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8E"],
        ["\xB0\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA3"],
        ["\xB0\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x82"],
        ["\xB0\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x95"],
        ["\xB0\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBA"],
        ["\xB0\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBB"],
        ["\xB0\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x95"],
        ["\xB0\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA5"],
        ["\xB0\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9F"],
        ["\xB0\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB2"],
        ["\xB0\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x81"],
        ["\xB0\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAF"],
        ["\xB0\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x80"],
        ["\xB0\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB1"],
        ["\xB0\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA2"],
        ["\xB0\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB8"],
        ["\xB0\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB2"],
        ["\xB0\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA8"],
        ["\xB0\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8B"],
        ["\xB0\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAF"],
        ["\xB0\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x81"],
        ["\xB0\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB0"],
        ["\xB0\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBD"],
        ["\xB0\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA1"],
        ["\xB0\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA0"],
        ["\xB0\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBB"],
        ["\xB0\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x95"],
        ["\xB0\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB2"],
        ["\xB0\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAB"],
        ["\xB0\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA4"],
        ["\xB0\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAD"],
        ["\xB1\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA2"],
        ["\xB1\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB0"],
        ["\xB1\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA0"],
        ["\xB1\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBB"],
        ["\xB1\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8B"],
        ["\xB1\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB3"],
        ["\xB1\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x87"],
        ["\xB1\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8F"],
        ["\xB1\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBD"],
        ["\xB1\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x82"],
        ["\xB1\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA8"],
        ["\xB1\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAF"],
        ["\xB1\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9C"],
        ["\xB1\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBA"],
        ["\xB1\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x91"],
        ["\xB1\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x93"],
        ["\xB1\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBC"],
        ["\xB1\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA6"],
        ["\xB1\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x98"],
        ["\xB1\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x84"],
        ["\xB1\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9D"],
        ["\xB1\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9A"],
        ["\xB1\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBB"],
        ["\xB1\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA5"],
        ["\xB1\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA9"],
        ["\xB1\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA6"],
        ["\xB1\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9C"],
        ["\xB1\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8F"],
        ["\xB1\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x82"],
        ["\xB1\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x91"],
        ["\xB1\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8B"],
        ["\xB1\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB2"],
        ["\xB1\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8F"],
        ["\xB1\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8C"],
        ["\xB1\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA1"],
        ["\xB1\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB6"],
        ["\xB1\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB0"],
        ["\xB1\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB1"],
        ["\xB1\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA0"],
        ["\xB1\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB3"],
        ["\xB1\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x84"],
        ["\xB1\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB8"],
        ["\xB1\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB3"],
        ["\xB1\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA9"],
        ["\xB1\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9B"],
        ["\xB1\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x88"],
        ["\xB1\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8E"],
        ["\xB1\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB4"],
        ["\xB1\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB1"],
        ["\xB1\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9B"],
        ["\xB1\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA0"],
        ["\xB1\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAD"],
        ["\xB1\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB2"],
        ["\xB1\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xAB"],
        ["\xB1\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8A"],
        ["\xB1\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x85"],
        ["\xB1\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA6"],
        ["\xB1\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x81"],
        ["\xB1\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x8A"],
        ["\xB1\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB2"],
        ["\xB1\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8E"],
        ["\xB1\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAD"],
        ["\xB1\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x86"],
        ["\xB1\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x92"],
        ["\xB1\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB0"],
        ["\xB1\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x84"],
        ["\xB1\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB4"],
        ["\xB1\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB6"],
        ["\xB1\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA8"],
        ["\xB1\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA9"],
        ["\xB1\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB4"],
        ["\xB1\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBF"],
        ["\xB1\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x94"],
        ["\xB1\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8E"],
        ["\xB1\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x94"],
        ["\xB1\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x99"],
        ["\xB1\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x95"],
        ["\xB1\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBF"],
        ["\xB1\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x81"],
        ["\xB1\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB6"],
        ["\xB1\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x91"],
        ["\xB1\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x97"],
        ["\xB1\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA0"],
        ["\xB1\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9B"],
        ["\xB1\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9B"],
        ["\xB1\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA9"],
        ["\xB1\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBC"],
        ["\xB1\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9A"],
        ["\xB1\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA5"],
        ["\xB1\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB9"],
        ["\xB1\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAE"],
        ["\xB1\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA5"],
        ["\xB1\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x80"],
        ["\xB1\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9C"],
        ["\xB2\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBC"],
        ["\xB2\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBA"],
        ["\xB2\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAA"],
        ["\xB2\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA7"],
        ["\xB2\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB4"],
        ["\xB2\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8B"],
        ["\xB2\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x81"],
        ["\xB2\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x96"],
        ["\xB2\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAC"],
        ["\xB2\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8E"],
        ["\xB2\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x84"],
        ["\xB2\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA1"],
        ["\xB2\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x96"],
        ["\xB2\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBB"],
        ["\xB2\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x84"],
        ["\xB2\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8B"],
        ["\xB2\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB6"],
        ["\xB2\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x86"],
        ["\xB2\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB6"],
        ["\xB2\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA1"],
        ["\xB2\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x99"],
        ["\xB2\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBA"],
        ["\xB2\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB8"],
        ["\xB2\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA9"],
        ["\xB2\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA9"],
        ["\xB2\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8F"],
        ["\xB2\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB3"],
        ["\xB2\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8B"],
        ["\xB2\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x96"],
        ["\xB2\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAE"],
        ["\xB2\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x95"],
        ["\xB2\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBD"],
        ["\xB2\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA1"],
        ["\xB2\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB3"],
        ["\xB2\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA0"],
        ["\xB2\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAF"],
        ["\xB2\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x89"],
        ["\xB2\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8F"],
        ["\xB2\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x81"],
        ["\xB2\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB6"],
        ["\xB2\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA1"],
        ["\xB2\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x91"],
        ["\xB2\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x87"],
        ["\xB2\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9C"],
        ["\xB2\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB6"],
        ["\xB2\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8C"],
        ["\xB2\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB3"],
        ["\xB2\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAB"],
        ["\xB2\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x82"],
        ["\xB2\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8D"],
        ["\xB2\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBE"],
        ["\xB2\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBC"],
        ["\xB2\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x87"],
        ["\xB2\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB1"],
        ["\xB2\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9B"],
        ["\xB2\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x84"],
        ["\xB2\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB7"],
        ["\xB2\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAF"],
        ["\xB2\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x93"],
        ["\xB2\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA6"],
        ["\xB2\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB2"],
        ["\xB2\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA9"],
        ["\xB2\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA8"],
        ["\xB2\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA6"],
        ["\xB2\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8E"],
        ["\xB2\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9E"],
        ["\xB2\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8A"],
        ["\xB2\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x84"],
        ["\xB2\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA8"],
        ["\xB2\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x91"],
        ["\xB2\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x99"],
        ["\xB2\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBB"],
        ["\xB2\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA5"],
        ["\xB2\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBD"],
        ["\xB2\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBE"],
        ["\xB2\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x80"],
        ["\xB2\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x85"],
        ["\xB2\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x93"],
        ["\xB2\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x95"],
        ["\xB2\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8B"],
        ["\xB2\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9A"],
        ["\xB2\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA3"],
        ["\xB2\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9E"],
        ["\xB2\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8A"],
        ["\xB2\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8A"],
        ["\xB2\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBB"],
        ["\xB2\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAB"],
        ["\xB2\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAA"],
        ["\xB2\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x94"],
        ["\xB2\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA2"],
        ["\xB2\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x90"],
        ["\xB2\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x92"],
        ["\xB2\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x90"],
        ["\xB2\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB9"],
        ["\xB3\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x81"],
        ["\xB3\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA6"],
        ["\xB3\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB0"],
        ["\xB3\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB7"],
        ["\xB3\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB0"],
        ["\xB3\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8C"],
        ["\xB3\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x86"],
        ["\xB3\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB5"],
        ["\xB3\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA5"],
        ["\xB3\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB9"],
        ["\xB3\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8B"],
        ["\xB3\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8E"],
        ["\xB3\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9D"],
        ["\xB3\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB1"],
        ["\xB3\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBE"],
        ["\xB3\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x96"],
        ["\xB3\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB3"],
        ["\xB3\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB3"],
        ["\xB3\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x96"],
        ["\xB3\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA8"],
        ["\xB3\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x82"],
        ["\xB3\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAF"],
        ["\xB3\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8D"],
        ["\xB3\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8B"],
        ["\xB3\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x97"],
        ["\xB3\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB2"],
        ["\xB3\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA7"],
        ["\xB3\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB8"],
        ["\xB3\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAC"],
        ["\xB3\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA8"],
        ["\xB3\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x99"],
        ["\xB3\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA3"],
        ["\xB3\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBF"],
        ["\xB3\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8E"],
        ["\xB3\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8E"],
        ["\xB3\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x83"],
        ["\xB3\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x87"],
        ["\xB3\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x84"],
        ["\xB3\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x93"],
        ["\xB3\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA1"],
        ["\xB3\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB9"],
        ["\xB3\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBC"],
        ["\xB3\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB8"],
        ["\xB3\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBB"],
        ["\xB3\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB2"],
        ["\xB3\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBA"],
        ["\xB3\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAB"],
        ["\xB3\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9A"],
        ["\xB3\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x92"],
        ["\xB3\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAB"],
        ["\xB3\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x83"],
        ["\xB3\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAD"],
        ["\xB3\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA3"],
        ["\xB3\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x94"],
        ["\xB3\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA9"],
        ["\xB3\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA6"],
        ["\xB3\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB3"],
        ["\xB3\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBD"],
        ["\xB3\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8D"],
        ["\xB3\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8E"],
        ["\xB3\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9B"],
        ["\xB3\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA0"],
        ["\xB3\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAB"],
        ["\xB3\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBF"],
        ["\xB3\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB6"],
        ["\xB3\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8D"],
        ["\xB3\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9F"],
        ["\xB3\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB2"],
        ["\xB3\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9D"],
        ["\xB3\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB0"],
        ["\xB3\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAC"],
        ["\xB3\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBB"],
        ["\xB3\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x87"],
        ["\xB3\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x91"],
        ["\xB3\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9B"],
        ["\xB3\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x90"],
        ["\xB3\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x84"],
        ["\xB3\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x94"],
        ["\xB3\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB9"],
        ["\xB3\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB6"],
        ["\xB3\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9B"],
        ["\xB3\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBA"],
        ["\xB3\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x84"],
        ["\xB3\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAA"],
        ["\xB3\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9C"],
        ["\xB3\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x83"],
        ["\xB3\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB2"],
        ["\xB3\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9C"],
        ["\xB3\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8C"],
        ["\xB3\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9B"],
        ["\xB3\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA8"],
        ["\xB3\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA2"],
        ["\xB3\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x85"],
        ["\xB3\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB1"],
        ["\xB4\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA5"],
        ["\xB4\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x88"],
        ["\xB4\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x85"],
        ["\xB4\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA6"],
        ["\xB4\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xBE"],
        ["\xB4\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x83"],
        ["\xB4\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA0"],
        ["\xB4\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x92"],
        ["\xB4\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8A"],
        ["\xB4\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x98"],
        ["\xB4\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA7"],
        ["\xB4\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBB"],
        ["\xB4\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9A"],
        ["\xB4\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAA"],
        ["\xB4\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA6"],
        ["\xB4\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8C"],
        ["\xB4\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x98"],
        ["\xB4\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9B"],
        ["\xB4\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB2"],
        ["\xB4\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB9"],
        ["\xB4\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA3"],
        ["\xB4\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9F"],
        ["\xB4\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA3"],
        ["\xB4\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBE"],
        ["\xB4\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9B"],
        ["\xB4\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA2"],
        ["\xB4\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x91"],
        ["\xB4\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x93"],
        ["\xB4\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBA"],
        ["\xB4\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBE"],
        ["\xB4\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x93"],
        ["\xB4\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x97"],
        ["\xB4\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA2"],
        ["\xB4\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x97"],
        ["\xB4\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x85"],
        ["\xB4\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB0"],
        ["\xB4\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x98"],
        ["\xB4\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA3"],
        ["\xB4\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8B"],
        ["\xB4\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBF"],
        ["\xB4\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xA1"],
        ["\xB4\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA1"],
        ["\xB4\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA9"],
        ["\xB4\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB6"],
        ["\xB4\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB0"],
        ["\xB4\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9D"],
        ["\xB4\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA6"],
        ["\xB4\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9E"],
        ["\xB4\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB3"],
        ["\xB4\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8C"],
        ["\xB4\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAB"],
        ["\xB4\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x84"],
        ["\xB4\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x91"],
        ["\xB4\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x93"],
        ["\xB4\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x91"],
        ["\xB4\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA2"],
        ["\xB4\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA5"],
        ["\xB4\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x93"],
        ["\xB4\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA8"],
        ["\xB4\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x98"],
        ["\xB4\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB8"],
        ["\xB4\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAB"],
        ["\xB4\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB8"],
        ["\xB4\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8C"],
        ["\xB4\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA9"],
        ["\xB4\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8C"],
        ["\xB4\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBC"],
        ["\xB4\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA9"],
        ["\xB4\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAB"],
        ["\xB4\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8B"],
        ["\xB4\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x81"],
        ["\xB4\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x91"],
        ["\xB4\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x94"],
        ["\xB4\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x98"],
        ["\xB4\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x81"],
        ["\xB4\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8E"],
        ["\xB4\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB1"],
        ["\xB4\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9C"],
        ["\xB4\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA8"],
        ["\xB4\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBA"],
        ["\xB4\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x87"],
        ["\xB4\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x89"],
        ["\xB4\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x84"],
        ["\xB4\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x90"],
        ["\xB4\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8C"],
        ["\xB4\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBE"],
        ["\xB4\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8C"],
        ["\xB4\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAE"],
        ["\xB4\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBA"],
        ["\xB4\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x97"],
        ["\xB4\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA2"],
        ["\xB4\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9F"],
        ["\xB4\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8B"],
        ["\xB4\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x84"],
        ["\xB5\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9F"],
        ["\xB5\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB0"],
        ["\xB5\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x85"],
        ["\xB5\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x97"],
        ["\xB5\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBD"],
        ["\xB5\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBF"],
        ["\xB5\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x88"],
        ["\xB5\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA3"],
        ["\xB5\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x80"],
        ["\xB5\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x80"],
        ["\xB5\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBD"],
        ["\xB5\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8F"],
        ["\xB5\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x98"],
        ["\xB5\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB4"],
        ["\xB5\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB7"],
        ["\xB5\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8C"],
        ["\xB5\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9D"],
        ["\xB5\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA2"],
        ["\xB5\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8E"],
        ["\xB5\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBC"],
        ["\xB5\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x80"],
        ["\xB5\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xBD"],
        ["\xB5\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x80"],
        ["\xB5\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x93"],
        ["\xB5\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9C"],
        ["\xB5\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAF"],
        ["\xB5\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x80"],
        ["\xB5\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAC"],
        ["\xB5\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBA"],
        ["\xB5\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA0"],
        ["\xB5\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x91"],
        ["\xB5\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x87"],
        ["\xB5\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA9"],
        ["\xB5\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBB"],
        ["\xB5\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBC"],
        ["\xB5\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB0"],
        ["\xB5\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAC"],
        ["\xB5\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8A"],
        ["\xB5\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA0"],
        ["\xB5\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x89"],
        ["\xB5\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x83"],
        ["\xB5\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAB"],
        ["\xB5\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x94"],
        ["\xB5\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x98"],
        ["\xB5\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB0"],
        ["\xB5\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA7"],
        ["\xB5\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB5"],
        ["\xB5\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8D"],
        ["\xB5\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB4"],
        ["\xB5\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA2"],
        ["\xB5\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9A"],
        ["\xB5\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x90"],
        ["\xB5\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x86"],
        ["\xB5\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x98"],
        ["\xB5\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x85"],
        ["\xB5\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x87"],
        ["\xB5\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x91"],
        ["\xB5\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8A"],
        ["\xB5\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB8"],
        ["\xB5\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAE"],
        ["\xB5\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x93"],
        ["\xB5\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA5"],
        ["\xB5\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x91"],
        ["\xB5\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBD"],
        ["\xB5\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x82"],
        ["\xB5\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB2"],
        ["\xB5\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA3"],
        ["\xB5\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB8"],
        ["\xB5\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x83"],
        ["\xB5\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB6"],
        ["\xB5\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAE"],
        ["\xB5\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x88"],
        ["\xB5\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9A"],
        ["\xB5\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBE"],
        ["\xB5\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA6"],
        ["\xB5\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA7"],
        ["\xB5\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9B"],
        ["\xB5\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xBB"],
        ["\xB5\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x85"],
        ["\xB5\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA8"],
        ["\xB5\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x92"],
        ["\xB5\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA0"],
        ["\xB5\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x99"],
        ["\xB5\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA0"],
        ["\xB5\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9A"],
        ["\xB5\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB1"],
        ["\xB5\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9D"],
        ["\xB5\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB8"],
        ["\xB5\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x81"],
        ["\xB5\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA6"],
        ["\xB5\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9A"],
        ["\xB5\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA8"],
        ["\xB5\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAB"],
        ["\xB5\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAC"],
        ["\xB6\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9B"],
        ["\xB6\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA0"],
        ["\xB6\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x91"],
        ["\xB6\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x87"],
        ["\xB6\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB6"],
        ["\xB6\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB1"],
        ["\xB6\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB6"],
        ["\xB6\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x94"],
        ["\xB6\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA1"],
        ["\xB6\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBF"],
        ["\xB6\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAB"],
        ["\xB6\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAC"],
        ["\xB6\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x83"],
        ["\xB6\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA1"],
        ["\xB6\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB7"],
        ["\xB6\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8A"],
        ["\xB6\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAF"],
        ["\xB6\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x90"],
        ["\xB6\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAD"],
        ["\xB6\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x9F"],
        ["\xB6\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x99"],
        ["\xB6\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8B"],
        ["\xB6\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x81"],
        ["\xB6\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x82"],
        ["\xB6\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAD"],
        ["\xB6\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAF"],
        ["\xB6\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB8"],
        ["\xB6\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x85"],
        ["\xB6\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x88"],
        ["\xB6\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8E"],
        ["\xB6\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB7"],
        ["\xB6\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA1"],
        ["\xB6\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBF"],
        ["\xB6\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x97"],
        ["\xB6\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9A"],
        ["\xB6\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB0"],
        ["\xB6\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9D"],
        ["\xB6\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAD"],
        ["\xB6\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x81"],
        ["\xB6\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAD"],
        ["\xB6\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x80"],
        ["\xB6\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB2"],
        ["\xB6\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB5"],
        ["\xB6\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x89"],
        ["\xB6\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x90"],
        ["\xB6\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x81"],
        ["\xB6\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x85"],
        ["\xB6\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA4"],
        ["\xB6\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x87"],
        ["\xB6\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBE"],
        ["\xB6\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA6"],
        ["\xB6\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA4"],
        ["\xB6\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA3"],
        ["\xB6\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBD"],
        ["\xB6\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB4"],
        ["\xB6\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x81"],
        ["\xB6\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBD"],
        ["\xB6\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8B"],
        ["\xB6\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8A"],
        ["\xB6\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB9"],
        ["\xB6\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8C"],
        ["\xB6\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBF"],
        ["\xB6\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9F"],
        ["\xB6\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB9"],
        ["\xB6\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x91"],
        ["\xB6\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x91"],
        ["\xB6\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9F"],
        ["\xB6\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x80"],
        ["\xB6\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9D"],
        ["\xB6\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB6"],
        ["\xB6\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA5"],
        ["\xB6\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBA"],
        ["\xB6\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x97"],
        ["\xB6\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x96"],
        ["\xB6\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA9"],
        ["\xB6\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA6"],
        ["\xB6\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAF"],
        ["\xB6\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x86"],
        ["\xB6\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x88"],
        ["\xB6\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x92"],
        ["\xB6\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB7"],
        ["\xB6\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9A"],
        ["\xB6\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9E"],
        ["\xB6\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB0"],
        ["\xB6\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBA"],
        ["\xB6\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB6"],
        ["\xB6\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x93"],
        ["\xB6\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x87"],
        ["\xB6\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x85"],
        ["\xB6\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB2"],
        ["\xB6\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9B"],
        ["\xB6\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA7"],
        ["\xB6\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x91"],
        ["\xB6\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x88"],
        ["\xB7\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x98"],
        ["\xB7\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x9F"],
        ["\xB7\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x93"],
        ["\xB7\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB4"],
        ["\xB7\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA1"],
        ["\xB7\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAA"],
        ["\xB7\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8A"],
        ["\xB7\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x88"],
        ["\xB7\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x82"],
        ["\xB7\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x97"],
        ["\xB7\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB0"],
        ["\xB7\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x91"],
        ["\xB7\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAC"],
        ["\xB7\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB2"],
        ["\xB7\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9B"],
        ["\xB7\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAB"],
        ["\xB7\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x93"],
        ["\xB7\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA4"],
        ["\xB7\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8D"],
        ["\xB7\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA1"],
        ["\xB7\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA6"],
        ["\xB7\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x88"],
        ["\xB7\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x81"],
        ["\xB7\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x82"],
        ["\xB7\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBE"],
        ["\xB7\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x91"],
        ["\xB7\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x84"],
        ["\xB7\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x93"],
        ["\xB7\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAD"],
        ["\xB7\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAA"],
        ["\xB7\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x8B"],
        ["\xB7\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x91"],
        ["\xB7\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA2"],
        ["\xB7\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x84"],
        ["\xB7\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB5"],
        ["\xB7\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB6"],
        ["\xB7\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA7"],
        ["\xB7\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA9"],
        ["\xB7\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB2"],
        ["\xB7\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBA"],
        ["\xB7\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAC"],
        ["\xB7\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAF"],
        ["\xB7\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x82"],
        ["\xB7\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x93"],
        ["\xB7\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA6"],
        ["\xB7\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBD"],
        ["\xB7\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBB"],
        ["\xB7\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8C"],
        ["\xB7\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x99"],
        ["\xB7\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8B"],
        ["\xB7\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAB"],
        ["\xB7\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8E"],
        ["\xB7\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8A"],
        ["\xB7\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8D"],
        ["\xB7\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x88"],
        ["\xB7\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA3"],
        ["\xB7\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA6"],
        ["\xB7\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBD"],
        ["\xB7\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9A"],
        ["\xB7\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8F"],
        ["\xB7\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB8"],
        ["\xB7\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8E"],
        ["\xB7\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA8"],
        ["\xB7\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x87"],
        ["\xB7\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9F"],
        ["\xB7\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x83"],
        ["\xB7\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x80"],
        ["\xB7\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x99"],
        ["\xB7\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x81"],
        ["\xB7\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x91"],
        ["\xB7\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA0"],
        ["\xB7\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBA"],
        ["\xB7\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x94"],
        ["\xB7\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB4"],
        ["\xB7\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x90"],
        ["\xB7\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x80"],
        ["\xB7\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA3"],
        ["\xB7\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x88"],
        ["\xB7\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB6"],
        ["\xB7\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB9"],
        ["\xB7\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA6"],
        ["\xB7\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA5"],
        ["\xB7\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBC"],
        ["\xB7\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB8"],
        ["\xB7\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA3"],
        ["\xB7\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA7"],
        ["\xB7\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8F"],
        ["\xB7\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x85"],
        ["\xB7\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8C"],
        ["\xB7\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBA"],
        ["\xB7\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB2"],
        ["\xB7\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB8"],
        ["\xB7\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB3"],
        ["\xB7\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB2"],
        ["\xB8\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9C"],
        ["\xB8\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA9"],
        ["\xB8\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBD"],
        ["\xB8\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAC"],
        ["\xB8\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAE"],
        ["\xB8\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x94"],
        ["\xB8\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAF"],
        ["\xB8\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB9"],
        ["\xB8\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8C"],
        ["\xB8\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA9"],
        ["\xB8\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8B"],
        ["\xB8\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x99"],
        ["\xB8\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA2"],
        ["\xB8\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x92"],
        ["\xB8\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA3"],
        ["\xB8\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB5"],
        ["\xB8\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBA"],
        ["\xB8\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x95"],
        ["\xB8\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x93"],
        ["\xB8\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB8"],
        ["\xB8\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x83"],
        ["\xB8\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9F"],
        ["\xB8\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB3"],
        ["\xB8\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBB"],
        ["\xB8\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA6"],
        ["\xB8\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9B"],
        ["\xB8\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x90"],
        ["\xB8\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x84"],
        ["\xB8\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBE"],
        ["\xB8\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x83"],
        ["\xB8\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB7"],
        ["\xB8\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x80"],
        ["\xB8\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBA"],
        ["\xB8\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x90"],
        ["\xB8\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8E"],
        ["\xB8\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8B"],
        ["\xB8\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA4"],
        ["\xB8\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBC"],
        ["\xB8\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBA"],
        ["\xB8\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x91"],
        ["\xB8\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA4"],
        ["\xB8\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB1"],
        ["\xB8\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAB"],
        ["\xB8\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA7"],
        ["\xB8\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB8"],
        ["\xB8\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x85"],
        ["\xB8\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xAF"],
        ["\xB8\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x96"],
        ["\xB8\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x90"],
        ["\xB8\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8A"],
        ["\xB8\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB4"],
        ["\xB8\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA1"],
        ["\xB8\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA1"],
        ["\xB8\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB0"],
        ["\xB8\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8E"],
        ["\xB8\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x87"],
        ["\xB8\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA8"],
        ["\xB8\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB7"],
        ["\xB8\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x87"],
        ["\xB8\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA7"],
        ["\xB8\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x93"],
        ["\xB8\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x94"],
        ["\xB8\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x92"],
        ["\xB8\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8D"],
        ["\xB8\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x88"],
        ["\xB8\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x89"],
        ["\xB8\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBE"],
        ["\xB8\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAF"],
        ["\xB8\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8C"],
        ["\xB8\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA1"],
        ["\xB8\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9F"],
        ["\xB8\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA7"],
        ["\xB8\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8E"],
        ["\xB8\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9A"],
        ["\xB8\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x81"],
        ["\xB8\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9E"],
        ["\xB8\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA4"],
        ["\xB8\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB7"],
        ["\xB8\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x90"],
        ["\xB8\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9E"],
        ["\xB8\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x89"],
        ["\xB8\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA4"],
        ["\xB8\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBC"],
        ["\xB8\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAF"],
        ["\xB8\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x99"],
        ["\xB8\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x96"],
        ["\xB8\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x89"],
        ["\xB8\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAC"],
        ["\xB8\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9F"],
        ["\xB8\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB9"],
        ["\xB8\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBE"],
        ["\xB8\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9A"],
        ["\xB8\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA3"],
        ["\xB8\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x91"],
        ["\xB9\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8E"],
        ["\xB9\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x89"],
        ["\xB9\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x91"],
        ["\xB9\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA2"],
        ["\xB9\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBD"],
        ["\xB9\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x94"],
        ["\xB9\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9D"],
        ["\xB9\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8F"],
        ["\xB9\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA5"],
        ["\xB9\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA7"],
        ["\xB9\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB7"],
        ["\xB9\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB8"],
        ["\xB9\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x83"],
        ["\xB9\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9A"],
        ["\xB9\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB7"],
        ["\xB9\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x98"],
        ["\xB9\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x92"],
        ["\xB9\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8C"],
        ["\xB9\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x97"],
        ["\xB9\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x98"],
        ["\xB9\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA7"],
        ["\xB9\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBB"],
        ["\xB9\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x82"],
        ["\xB9\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x83"],
        ["\xB9\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB4"],
        ["\xB9\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAD"],
        ["\xB9\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA1"],
        ["\xB9\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x97"],
        ["\xB9\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8B"],
        ["\xB9\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9F"],
        ["\xB9\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAA"],
        ["\xB9\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA9"],
        ["\xB9\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAF"],
        ["\xB9\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9D"],
        ["\xB9\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB2"],
        ["\xB9\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x87"],
        ["\xB9\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAC"],
        ["\xB9\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBF"],
        ["\xB9\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA0"],
        ["\xB9\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x85"],
        ["\xB9\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x98"],
        ["\xB9\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9E"],
        ["\xB9\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB1"],
        ["\xB9\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x95"],
        ["\xB9\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x83"],
        ["\xB9\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAF"],
        ["\xB9\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB1"],
        ["\xB9\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x94"],
        ["\xB9\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8F"],
        ["\xB9\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAA"],
        ["\xB9\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x92"],
        ["\xB9\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8C"],
        ["\xB9\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA1"],
        ["\xB9\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9B"],
        ["\xB9\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA2"],
        ["\xB9\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBC"],
        ["\xB9\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8A"],
        ["\xB9\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB5"],
        ["\xB9\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB1"],
        ["\xB9\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBF"],
        ["\xB9\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBC"],
        ["\xB9\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA4"],
        ["\xB9\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8D"],
        ["\xB9\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x85"],
        ["\xB9\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x99"],
        ["\xB9\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x98"],
        ["\xB9\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBB"],
        ["\xB9\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9B"],
        ["\xB9\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAB"],
        ["\xB9\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB7"],
        ["\xB9\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x88"],
        ["\xB9\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x95"],
        ["\xB9\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB7"],
        ["\xB9\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA0"],
        ["\xB9\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAA"],
        ["\xB9\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9F"],
        ["\xB9\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB9"],
        ["\xB9\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8B"],
        ["\xB9\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBB"],
        ["\xB9\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8A"],
        ["\xB9\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBD"],
        ["\xB9\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x80"],
        ["\xB9\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB7"],
        ["\xB9\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA0"],
        ["\xB9\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x92"],
        ["\xB9\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x84"],
        ["\xB9\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x89"],
        ["\xB9\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB0"],
        ["\xB9\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x91"],
        ["\xB9\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBD"],
        ["\xB9\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9A"],
        ["\xB9\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xA8"],
        ["\xB9\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x9B"],
        ["\xB9\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBC"],
        ["\xBA\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA4"],
        ["\xBA\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x83"],
        ["\xBA\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8A"],
        ["\xBA\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB0"],
        ["\xBA\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA4"],
        ["\xBA\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBE"],
        ["\xBA\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x9A"],
        ["\xBA\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA8"],
        ["\xBA\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x87"],
        ["\xBA\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8F"],
        ["\xBA\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x86"],
        ["\xBA\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB9"],
        ["\xBA\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB1"],
        ["\xBA\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB7"],
        ["\xBA\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x95"],
        ["\xBA\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBA"],
        ["\xBA\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAE"],
        ["\xBA\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x82"],
        ["\xBA\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9B"],
        ["\xBA\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x90"],
        ["\xBA\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x89"],
        ["\xBA\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x86"],
        ["\xBA\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAF"],
        ["\xBA\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA6"],
        ["\xBA\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAE"],
        ["\xBA\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBB"],
        ["\xBA\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x99"],
        ["\xBA\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB3"],
        ["\xBA\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x82"],
        ["\xBA\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x90"],
        ["\xBA\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x96"],
        ["\xBA\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9F"],
        ["\xBA\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x90"],
        ["\xBA\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA7"],
        ["\xBA\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAB"],
        ["\xBA\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB5"],
        ["\xBA\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAC"],
        ["\xBA\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8D"],
        ["\xBA\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x80"],
        ["\xBA\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x89"],
        ["\xBA\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9E"],
        ["\xBA\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBB"],
        ["\xBA\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB0"],
        ["\xBA\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA9"],
        ["\xBA\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8D"],
        ["\xBA\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA1"],
        ["\xBA\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBD"],
        ["\xBA\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB3"],
        ["\xBA\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x88"],
        ["\xBA\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBD"],
        ["\xBA\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x87"],
        ["\xBA\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x80"],
        ["\xBA\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x95"],
        ["\xBA\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA6"],
        ["\xBA\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xAD"],
        ["\xBA\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8E"],
        ["\xBA\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB0"],
        ["\xBA\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9C"],
        ["\xBA\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x81"],
        ["\xBA\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x89"],
        ["\xBA\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9B"],
        ["\xBA\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA4"],
        ["\xBA\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA8"],
        ["\xBA\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x90"],
        ["\xBA\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAA"],
        ["\xBA\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA1"],
        ["\xBA\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB4"],
        ["\xBA\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x82"],
        ["\xBA\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAA"],
        ["\xBA\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBA"],
        ["\xBA\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8A"],
        ["\xBA\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB4"],
        ["\xBA\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB2"],
        ["\xBA\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8E"],
        ["\xBA\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBC"],
        ["\xBA\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x95"],
        ["\xBA\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBA"],
        ["\xBA\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9C"],
        ["\xBA\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8A"],
        ["\xBA\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8B"],
        ["\xBA\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBE"],
        ["\xBA\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA8"],
        ["\xBA\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x94"],
        ["\xBA\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB5"],
        ["\xBA\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x84"],
        ["\xBA\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x96"],
        ["\xBA\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA2"],
        ["\xBA\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAF"],
        ["\xBA\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9C"],
        ["\xBA\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAD"],
        ["\xBA\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB9"],
        ["\xBA\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x99"],
        ["\xBA\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8A"],
        ["\xBA\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB7"],
        ["\xBB\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9F"],
        ["\xBB\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB6"],
        ["\xBB\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAE"],
        ["\xBB\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA6"],
        ["\xBB\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAD"],
        ["\xBB\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBA"],
        ["\xBB\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA9"],
        ["\xBB\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x91"],
        ["\xBB\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x90"],
        ["\xBB\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x96"],
        ["\xBB\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8C"],
        ["\xBB\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x86"],
        ["\xBB\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAB"],
        ["\xBB\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBF"],
        ["\xBB\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x92"],
        ["\xBB\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x89"],
        ["\xBB\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x98"],
        ["\xBB\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x82"],
        ["\xBB\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB1"],
        ["\xBB\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA8"],
        ["\xBB\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x92"],
        ["\xBB\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA3"],
        ["\xBB\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9F"],
        ["\xBB\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA6"],
        ["\xBB\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8A"],
        ["\xBB\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA3"],
        ["\xBB\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x97"],
        ["\xBB\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x82"],
        ["\xBB\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x95"],
        ["\xBB\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x83"],
        ["\xBB\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9B"],
        ["\xBB\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB8"],
        ["\xBB\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x90"],
        ["\xBB\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAC"],
        ["\xBB\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAB"],
        ["\xBB\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8B"],
        ["\xBB\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x95"],
        ["\xBB\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x94"],
        ["\xBB\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBA"],
        ["\xBB\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBF"],
        ["\xBB\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBA"],
        ["\xBB\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB8"],
        ["\xBB\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB2"],
        ["\xBB\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA3"],
        ["\xBB\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9B"],
        ["\xBB\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAB"],
        ["\xBB\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8B"],
        ["\xBB\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x89"],
        ["\xBB\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBF"],
        ["\xBB\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x90"],
        ["\xBB\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8D"],
        ["\xBB\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x82"],
        ["\xBB\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAB"],
        ["\xBB\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x97"],
        ["\xBB\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9D"],
        ["\xBB\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x87"],
        ["\xBB\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAF"],
        ["\xBB\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9C"],
        ["\xBB\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAF"],
        ["\xBB\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBD"],
        ["\xBB\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA8"],
        ["\xBB\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9D"],
        ["\xBB\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA2"],
        ["\xBB\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBB"],
        ["\xBB\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8F"],
        ["\xBB\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x85"],
        ["\xBB\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x89"],
        ["\xBB\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x81"],
        ["\xBB\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB8"],
        ["\xBB\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x99"],
        ["\xBB\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAB"],
        ["\xBB\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA2"],
        ["\xBB\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x82"],
        ["\xBB\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB3"],
        ["\xBB\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x96"],
        ["\xBB\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9E"],
        ["\xBB\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA9"],
        ["\xBB\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA6"],
        ["\xBB\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8C"],
        ["\xBB\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAE"],
        ["\xBB\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x87"],
        ["\xBB\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9C"],
        ["\xBB\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8C"],
        ["\xBB\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBC"],
        ["\xBB\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAF"],
        ["\xBB\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8B"],
        ["\xBB\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBC"],
        ["\xBB\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8D"],
        ["\xBB\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x90"],
        ["\xBB\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x97"],
        ["\xBB\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBA"],
        ["\xBB\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x88"],
        ["\xBB\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x81"],
        ["\xBB\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x82"],
        ["\xBC\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA1"],
        ["\xBC\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8B"],
        ["\xBC\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBB"],
        ["\xBC\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBE"],
        ["\xBC\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBD"],
        ["\xBC\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x94"],
        ["\xBC\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x81"],
        ["\xBC\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBA"],
        ["\xBC\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8C"],
        ["\xBC\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB3"],
        ["\xBC\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAA"],
        ["\xBC\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x94"],
        ["\xBC\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9E"],
        ["\xBC\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x90"],
        ["\xBC\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBF"],
        ["\xBC\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8F"],
        ["\xBC\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x98"],
        ["\xBC\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAB"],
        ["\xBC\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBA"],
        ["\xBC\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xB8"],
        ["\xBC\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8D"],
        ["\xBC\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAB"],
        ["\xBC\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x83"],
        ["\xBC\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB1"],
        ["\xBC\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB7"],
        ["\xBC\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB1"],
        ["\xBC\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x89"],
        ["\xBC\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA4"],
        ["\xBC\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x89"],
        ["\xBC\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBF"],
        ["\xBC\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x86"],
        ["\xBC\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBE"],
        ["\xBC\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAA"],
        ["\xBC\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9F"],
        ["\xBC\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x80"],
        ["\xBC\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA0"],
        ["\xBC\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB2"],
        ["\xBC\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB4"],
        ["\xBC\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9D"],
        ["\xBC\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA1"],
        ["\xBC\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8A"],
        ["\xBC\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9E"],
        ["\xBC\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8E"],
        ["\xBC\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x99"],
        ["\xBC\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x84"],
        ["\xBC\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA8"],
        ["\xBC\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA6"],
        ["\xBC\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9C"],
        ["\xBC\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAE"],
        ["\xBC\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBE"],
        ["\xBC\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x97"],
        ["\xBC\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x85"],
        ["\xBC\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9D"],
        ["\xBC\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8A"],
        ["\xBC\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAE"],
        ["\xBC\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x87"],
        ["\xBC\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAA"],
        ["\xBC\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9F"],
        ["\xBC\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBA"],
        ["\xBC\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBA"],
        ["\xBC\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x93"],
        ["\xBC\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBC"],
        ["\xBC\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB5"],
        ["\xBC\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8C"],
        ["\xBC\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x88"],
        ["\xBC\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAB"],
        ["\xBC\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA5"],
        ["\xBC\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x82"],
        ["\xBC\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB1"],
        ["\xBC\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB9"],
        ["\xBC\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBB"],
        ["\xBC\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x96"],
        ["\xBC\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x88"],
        ["\xBC\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8B"],
        ["\xBC\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB1"],
        ["\xBC\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8A"],
        ["\xBC\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA9"],
        ["\xBC\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA0"],
        ["\xBC\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAE"],
        ["\xBC\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAB"],
        ["\xBC\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA3"],
        ["\xBC\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x92"],
        ["\xBC\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x96"],
        ["\xBC\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x92"],
        ["\xBC\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x97"],
        ["\xBC\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAA"],
        ["\xBC\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBF"],
        ["\xBC\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x88"],
        ["\xBC\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB9"],
        ["\xBC\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAC"],
        ["\xBC\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x80"],
        ["\xBC\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9A"],
        ["\xBC\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8E"],
        ["\xBC\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA8"],
        ["\xBD\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x97"],
        ["\xBD\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB1"],
        ["\xBD\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9E"],
        ["\xBD\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAE"],
        ["\xBD\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x81"],
        ["\xBD\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBE"],
        ["\xBD\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB2"],
        ["\xBD\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x80"],
        ["\xBD\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8B"],
        ["\xBD\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x82"],
        ["\xBD\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8D"],
        ["\xBD\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x92"],
        ["\xBD\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAD"],
        ["\xBD\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9F"],
        ["\xBD\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x90"],
        ["\xBD\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x86"],
        ["\xBD\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB2"],
        ["\xBD\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x90"],
        ["\xBD\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB4"],
        ["\xBD\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAF"],
        ["\xBD\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB1"],
        ["\xBD\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8B"],
        ["\xBD\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAC"],
        ["\xBD\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x86"],
        ["\xBD\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9C"],
        ["\xBD\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x80"],
        ["\xBD\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8F"],
        ["\xBD\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x85"],
        ["\xBD\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x81"],
        ["\xBD\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x93"],
        ["\xBD\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8E"],
        ["\xBD\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x94"],
        ["\xBD\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x81"],
        ["\xBD\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8B"],
        ["\xBD\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA3"],
        ["\xBD\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA6"],
        ["\xBD\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8D"],
        ["\xBD\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x83"],
        ["\xBD\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x94"],
        ["\xBD\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x99"],
        ["\xBD\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xBF"],
        ["\xBD\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x91"],
        ["\xBD\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9D"],
        ["\xBD\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAE"],
        ["\xBD\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9B"],
        ["\xBD\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBE"],
        ["\xBD\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9F"],
        ["\xBD\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBA"],
        ["\xBD\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x93"],
        ["\xBD\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB0"],
        ["\xBD\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8A"],
        ["\xBD\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBB"],
        ["\xBD\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA5"],
        ["\xBD\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAC"],
        ["\xBD\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA3"],
        ["\xBD\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9C"],
        ["\xBD\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBF"],
        ["\xBD\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x86"],
        ["\xBD\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAA"],
        ["\xBD\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAC"],
        ["\xBD\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAF"],
        ["\xBD\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x89"],
        ["\xBD\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB3"],
        ["\xBD\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x96"],
        ["\xBD\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA4"],
        ["\xBD\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBE"],
        ["\xBD\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x94"],
        ["\xBD\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA1"],
        ["\xBD\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB5"],
        ["\xBD\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x87"],
        ["\xBD\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x86"],
        ["\xBD\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA6"],
        ["\xBD\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x9D"],
        ["\xBD\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x80"],
        ["\xBD\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x91"],
        ["\xBD\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x99"],
        ["\xBD\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9A"],
        ["\xBD\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB6"],
        ["\xBD\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x92"],
        ["\xBD\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB2"],
        ["\xBD\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB8"],
        ["\xBD\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAF"],
        ["\xBD\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB7"],
        ["\xBD\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB8"],
        ["\xBD\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA9"],
        ["\xBD\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x99"],
        ["\xBD\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB3"],
        ["\xBD\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8F"],
        ["\xBD\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x90"],
        ["\xBD\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x95"],
        ["\xBD\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA4"],
        ["\xBD\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA4"],
        ["\xBD\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB7"],
        ["\xBD\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9F"],
        ["\xBE\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9D"],
        ["\xBE\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA0"],
        ["\xBE\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x87"],
        ["\xBE\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAC"],
        ["\xBE\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA8"],
        ["\xBE\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x86"],
        ["\xBE\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB1"],
        ["\xBE\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x97"],
        ["\xBE\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA8"],
        ["\xBE\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBE"],
        ["\xBE\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xBC"],
        ["\xBE\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB5"],
        ["\xBE\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x86"],
        ["\xBE\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8F"],
        ["\xBE\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x91"],
        ["\xBE\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9A"],
        ["\xBE\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x84"],
        ["\xBE\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8A"],
        ["\xBE\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA0"],
        ["\xBE\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB0"],
        ["\xBE\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBF"],
        ["\xBE\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x84"],
        ["\xBE\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9B"],
        ["\xBE\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8C"],
        ["\xBE\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB7"],
        ["\xBE\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x87"],
        ["\xBE\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8C"],
        ["\xBE\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAD"],
        ["\xBE\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB6"],
        ["\xBE\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBE"],
        ["\xBE\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA2"],
        ["\xBE\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9F"],
        ["\xBE\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB5"],
        ["\xBE\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBC"],
        ["\xBE\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x88"],
        ["\xBE\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x89"],
        ["\xBE\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x98"],
        ["\xBE\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xBC"],
        ["\xBE\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA6"],
        ["\xBE\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA7"],
        ["\xBE\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x87"],
        ["\xBE\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x81"],
        ["\xBE\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x9D"],
        ["\xBE\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x81"],
        ["\xBE\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA5"],
        ["\xBE\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xB0"],
        ["\xBE\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA0"],
        ["\xBE\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x91"],
        ["\xBE\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA7"],
        ["\xBE\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB9"],
        ["\xBE\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x96"],
        ["\xBE\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x96"],
        ["\xBE\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x8B"],
        ["\xBE\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x89"],
        ["\xBE\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9D"],
        ["\xBE\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB3"],
        ["\xBE\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9F"],
        ["\xBE\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBC"],
        ["\xBE\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x94"],
        ["\xBE\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB3"],
        ["\xBE\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA1"],
        ["\xBE\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9E"],
        ["\xBE\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA4"],
        ["\xBE\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA6"],
        ["\xBE\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBE"],
        ["\xBE\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x98"],
        ["\xBE\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9C"],
        ["\xBE\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x98"],
        ["\xBE\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8A"],
        ["\xBE\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x88"],
        ["\xBE\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x9E"],
        ["\xBE\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x97"],
        ["\xBE\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x97"],
        ["\xBE\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB0"],
        ["\xBE\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8E"],
        ["\xBE\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB4"],
        ["\xBE\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8C"],
        ["\xBE\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA2"],
        ["\xBE\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB8"],
        ["\xBE\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x85"],
        ["\xBE\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBE"],
        ["\xBE\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA1"],
        ["\xBE\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x96"],
        ["\xBE\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x84"],
        ["\xBE\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB6"],
        ["\xBE\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB3"],
        ["\xBE\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA3"],
        ["\xBE\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB8"],
        ["\xBE\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB2"],
        ["\xBE\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB8"],
        ["\xBE\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA0"],
        ["\xBE\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB1"],
        ["\xBE\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB4"],
        ["\xBE\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBE"],
        ["\xBF\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAD"],
        ["\xBF\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8D"],
        ["\xBF\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x96"],
        ["\xBF\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAD"],
        ["\xBF\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x94"],
        ["\xBF\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB7"],
        ["\xBF\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB2"],
        ["\xBF\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA6"],
        ["\xBF\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9F"],
        ["\xBF\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x95"],
        ["\xBF\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB1"],
        ["\xBF\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBB"],
        ["\xBF\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB8"],
        ["\xBF\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA1"],
        ["\xBF\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB5"],
        ["\xBF\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x87"],
        ["\xBF\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA0"],
        ["\xBF\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9D"],
        ["\xBF\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA9"],
        ["\xBF\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x83"],
        ["\xBF\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8E"],
        ["\xBF\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAF"],
        ["\xBF\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB0"],
        ["\xBF\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8B"],
        ["\xBF\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAE"],
        ["\xBF\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9B"],
        ["\xBF\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB8"],
        ["\xBF\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB1"],
        ["\xBF\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB3"],
        ["\xBF\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB9"],
        ["\xBF\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9F"],
        ["\xBF\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9E"],
        ["\xBF\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA6"],
        ["\xBF\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB3"],
        ["\xBF\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA3"],
        ["\xBF\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAF"],
        ["\xBF\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAA"],
        ["\xBF\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAA"],
        ["\xBF\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBA"],
        ["\xBF\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAB"],
        ["\xBF\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9B"],
        ["\xBF\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB2"],
        ["\xBF\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9D"],
        ["\xBF\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x87"],
        ["\xBF\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBA"],
        ["\xBF\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x81"],
        ["\xBF\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x83"],
        ["\xBF\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB5"],
        ["\xBF\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAC"],
        ["\xBF\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8B"],
        ["\xBF\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9A"],
        ["\xBF\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBD"],
        ["\xBF\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8E"],
        ["\xBF\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8A"],
        ["\xBF\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x85"],
        ["\xBF\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA3"],
        ["\xBF\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAD"],
        ["\xBF\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA5"],
        ["\xBF\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8F"],
        ["\xBF\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x88"],
        ["\xBF\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA2"],
        ["\xBF\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB3"],
        ["\xBF\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA8"],
        ["\xBF\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x97"],
        ["\xBF\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB9"],
        ["\xBF\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x82"],
        ["\xBF\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xA5"],
        ["\xBF\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA8"],
        ["\xBF\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB4"],
        ["\xBF\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8A"],
        ["\xBF\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA1"],
        ["\xBF\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8B"],
        ["\xBF\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA0"],
        ["\xBF\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB0"],
        ["\xBF\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x82"],
        ["\xBF\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x94"],
        ["\xBF\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x90"],
        ["\xBF\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x98"],
        ["\xBF\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8F"],
        ["\xBF\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9E"],
        ["\xBF\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x84"],
        ["\xBF\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x87"],
        ["\xBF\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA9"],
        ["\xBF\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB0"],
        ["\xBF\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA2"],
        ["\xBF\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA8"],
        ["\xBF\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9B"],
        ["\xBF\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAE"],
        ["\xBF\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x89"],
        ["\xBF\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x99"],
        ["\xBF\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x85"],
        ["\xBF\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x97"],
        ["\xBF\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x80"],
        ["\xBF\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBE"],
        ["\xC0\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x84"],
        ["\xC0\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBA"],
        ["\xC0\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB8"],
        ["\xC0\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x96"],
        ["\xC0\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xAC"],
        ["\xC0\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9D"],
        ["\xC0\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAF"],
        ["\xC0\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x84"],
        ["\xC0\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB6"],
        ["\xC0\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA2"],
        ["\xC0\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x93"],
        ["\xC0\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x81"],
        ["\xC0\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA7"],
        ["\xC0\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x90"],
        ["\xC0\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBF"],
        ["\xC0\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB4"],
        ["\xC0\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9F"],
        ["\xC0\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB4"],
        ["\xC0\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB2"],
        ["\xC0\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x96"],
        ["\xC0\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA3"],
        ["\xC0\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x85"],
        ["\xC0\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB2"],
        ["\xC0\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9F"],
        ["\xC0\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9B"],
        ["\xC0\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBE"],
        ["\xC0\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x96"],
        ["\xC0\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB0"],
        ["\xC0\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBD"],
        ["\xC0\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBF"],
        ["\xC0\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA0"],
        ["\xC0\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x93"],
        ["\xC0\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8B"],
        ["\xC0\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9D"],
        ["\xC0\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x92"],
        ["\xC0\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x92"],
        ["\xC0\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x99"],
        ["\xC0\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x89"],
        ["\xC0\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8E"],
        ["\xC0\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x86"],
        ["\xC0\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBB"],
        ["\xC0\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAD"],
        ["\xC0\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9C"],
        ["\xC0\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9A"],
        ["\xC0\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA5"],
        ["\xC0\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x94"],
        ["\xC0\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x90"],
        ["\xC0\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB3"],
        ["\xC0\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8D"],
        ["\xC0\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8D"],
        ["\xC0\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBE"],
        ["\xC0\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8A"],
        ["\xC0\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAC"],
        ["\xC0\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA4"],
        ["\xC0\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA1"],
        ["\xC0\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x9F"],
        ["\xC0\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA9"],
        ["\xC0\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x87"],
        ["\xC0\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x99"],
        ["\xC0\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA5"],
        ["\xC0\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x82"],
        ["\xC0\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x98"],
        ["\xC0\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAD"],
        ["\xC0\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x83"],
        ["\xC0\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x80"],
        ["\xC0\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAC"],
        ["\xC0\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAA"],
        ["\xC0\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB6"],
        ["\xC0\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8C"],
        ["\xC0\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x89"],
        ["\xC0\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x99"],
        ["\xC0\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x88"],
        ["\xC0\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x83"],
        ["\xC0\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA0"],
        ["\xC0\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA3"],
        ["\xC0\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x82"],
        ["\xC0\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x96"],
        ["\xC0\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9D"],
        ["\xC0\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA6"],
        ["\xC0\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x87"],
        ["\xC0\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB0"],
        ["\xC0\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x93"],
        ["\xC0\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB4"],
        ["\xC0\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x89"],
        ["\xC0\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x85"],
        ["\xC0\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x97"],
        ["\xC0\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x93"],
        ["\xC0\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9C"],
        ["\xC0\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8E"],
        ["\xC0\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xBD"],
        ["\xC0\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8B"],
        ["\xC0\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBF"],
        ["\xC0\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAD"],
        ["\xC0\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9A"],
        ["\xC1\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8A"],
        ["\xC1\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA8"],
        ["\xC1\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBA"],
        ["\xC1\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9B"],
        ["\xC1\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB9"],
        ["\xC1\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA6"],
        ["\xC1\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAE"],
        ["\xC1\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8E"],
        ["\xC1\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB5"],
        ["\xC1\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB8"],
        ["\xC1\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB7"],
        ["\xC1\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xAD"],
        ["\xC1\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x91"],
        ["\xC1\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x83"],
        ["\xC1\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAE"],
        ["\xC1\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8D"],
        ["\xC1\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x84"],
        ["\xC1\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB8"],
        ["\xC1\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB6"],
        ["\xC1\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA8"],
        ["\xC1\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x85"],
        ["\xC1\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x95"],
        ["\xC1\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB3"],
        ["\xC1\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8E"],
        ["\xC1\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8C"],
        ["\xC1\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x91"],
        ["\xC1\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA8"],
        ["\xC1\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAA"],
        ["\xC1\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBE"],
        ["\xC1\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBD"],
        ["\xC1\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9A"],
        ["\xC1\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x99"],
        ["\xC1\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8F"],
        ["\xC1\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8E"],
        ["\xC1\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x8E"],
        ["\xC1\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x96"],
        ["\xC1\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9F"],
        ["\xC1\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x97"],
        ["\xC1\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA0"],
        ["\xC1\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x84"],
        ["\xC1\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x87"],
        ["\xC1\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB4"],
        ["\xC1\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBB"],
        ["\xC1\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA1"],
        ["\xC1\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA0"],
        ["\xC1\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA7"],
        ["\xC1\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB5"],
        ["\xC1\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8C"],
        ["\xC1\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA2"],
        ["\xC1\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x89"],
        ["\xC1\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAA"],
        ["\xC1\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAE"],
        ["\xC1\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8F"],
        ["\xC1\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBD"],
        ["\xC1\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8B"],
        ["\xC1\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA4"],
        ["\xC1\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9D"],
        ["\xC1\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA3"],
        ["\xC1\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB3"],
        ["\xC1\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x9C"],
        ["\xC1\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x83"],
        ["\xC1\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBF"],
        ["\xC1\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBB"],
        ["\xC1\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8D"],
        ["\xC1\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA9"],
        ["\xC1\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB9"],
        ["\xC1\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA3"],
        ["\xC1\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8D"],
        ["\xC1\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBD"],
        ["\xC1\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x95"],
        ["\xC1\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA5"],
        ["\xC1\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x89"],
        ["\xC1\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA9"],
        ["\xC1\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB8"],
        ["\xC1\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x93"],
        ["\xC1\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9F"],
        ["\xC1\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8F"],
        ["\xC1\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9C"],
        ["\xC1\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA1"],
        ["\xC1\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x89"],
        ["\xC1\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x98"],
        ["\xC1\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAC"],
        ["\xC1\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBC"],
        ["\xC1\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBB"],
        ["\xC1\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x85"],
        ["\xC1\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB0"],
        ["\xC1\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x81"],
        ["\xC1\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAD"],
        ["\xC1\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x97"],
        ["\xC1\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9C"],
        ["\xC1\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x92"],
        ["\xC1\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8F"],
        ["\xC1\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x97"],
        ["\xC1\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8E"],
        ["\xC2\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x93"],
        ["\xC2\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB5"],
        ["\xC2\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x88"],
        ["\xC2\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA0"],
        ["\xC2\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x83"],
        ["\xC2\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB4"],
        ["\xC2\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x87"],
        ["\xC2\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB3"],
        ["\xC2\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAF"],
        ["\xC2\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x89"],
        ["\xC2\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9F"],
        ["\xC2\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAC"],
        ["\xC2\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xB3"],
        ["\xC2\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9F"],
        ["\xC2\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x97"],
        ["\xC2\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9E"],
        ["\xC2\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8A"],
        ["\xC2\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8F"],
        ["\xC2\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9A"],
        ["\xC2\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x92"],
        ["\xC2\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x96"],
        ["\xC2\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB6"],
        ["\xC2\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x83"],
        ["\xC2\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x98"],
        ["\xC2\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAB"],
        ["\xC2\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8A"],
        ["\xC2\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8D"],
        ["\xC2\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x91"],
        ["\xC2\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9C"],
        ["\xC2\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x96"],
        ["\xC2\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9A"],
        ["\xC2\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAA"],
        ["\xC2\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB0"],
        ["\xC2\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x91"],
        ["\xC2\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBE"],
        ["\xC2\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x95"],
        ["\xC2\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA5"],
        ["\xC2\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB0"],
        ["\xC2\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x93"],
        ["\xC2\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x81"],
        ["\xC2\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB5"],
        ["\xC2\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x95"],
        ["\xC2\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x80"],
        ["\xC2\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x84"],
        ["\xC2\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA8"],
        ["\xC2\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x93"],
        ["\xC2\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x86"],
        ["\xC2\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBE"],
        ["\xC2\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x90"],
        ["\xC2\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB1"],
        ["\xC2\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAF"],
        ["\xC2\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x85"],
        ["\xC2\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA0"],
        ["\xC2\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8B"],
        ["\xC2\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB4"],
        ["\xC2\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBF"],
        ["\xC2\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB0"],
        ["\xC2\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9E"],
        ["\xC2\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8E"],
        ["\xC2\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBF"],
        ["\xC2\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x94"],
        ["\xC2\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8B"],
        ["\xC2\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB8"],
        ["\xC2\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x80"],
        ["\xC2\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAE"],
        ["\xC2\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8A"],
        ["\xC2\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9B"],
        ["\xC2\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9B"],
        ["\xC2\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA3"],
        ["\xC2\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB0"],
        ["\xC2\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA7"],
        ["\xC2\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAC"],
        ["\xC2\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8D"],
        ["\xC2\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8C"],
        ["\xC2\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB9"],
        ["\xC2\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9D"],
        ["\xC2\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA7"],
        ["\xC2\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x93"],
        ["\xC2\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x84"],
        ["\xC2\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x85"],
        ["\xC2\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x98"],
        ["\xC2\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9E"],
        ["\xC2\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x93"],
        ["\xC2\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA2"],
        ["\xC2\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAF"],
        ["\xC2\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA2"],
        ["\xC2\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x97"],
        ["\xC2\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB8"],
        ["\xC2\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x81"],
        ["\xC2\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBE"],
        ["\xC2\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB8"],
        ["\xC2\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA7"],
        ["\xC2\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB8"],
        ["\xC2\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAA"],
        ["\xC3\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA9"],
        ["\xC3\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x86"],
        ["\xC3\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x94"],
        ["\xC3\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB0"],
        ["\xC3\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAA"],
        ["\xC3\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB1"],
        ["\xC3\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBD"],
        ["\xC3\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAA"],
        ["\xC3\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBF"],
        ["\xC3\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9A"],
        ["\xC3\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB7"],
        ["\xC3\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB8"],
        ["\xC3\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x88"],
        ["\xC3\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBD"],
        ["\xC3\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB0"],
        ["\xC3\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB9"],
        ["\xC3\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x98"],
        ["\xC3\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x86"],
        ["\xC3\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA6"],
        ["\xC3\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x85"],
        ["\xC3\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA2"],
        ["\xC3\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA6"],
        ["\xC3\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8E"],
        ["\xC3\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA1"],
        ["\xC3\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9B"],
        ["\xC3\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAD"],
        ["\xC3\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAD"],
        ["\xC3\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAF"],
        ["\xC3\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAA"],
        ["\xC3\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBB"],
        ["\xC3\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBD"],
        ["\xC3\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x86"],
        ["\xC3\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8B"],
        ["\xC3\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x95"],
        ["\xC3\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9B"],
        ["\xC3\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA3"],
        ["\xC3\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x87"],
        ["\xC3\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBE"],
        ["\xC3\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAD"],
        ["\xC3\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x96"],
        ["\xC3\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x80"],
        ["\xC3\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB5"],
        ["\xC3\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB7"],
        ["\xC3\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x87"],
        ["\xC3\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA4"],
        ["\xC3\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA5"],
        ["\xC3\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB0"],
        ["\xC3\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9B"],
        ["\xC3\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA5"],
        ["\xC3\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBA"],
        ["\xC3\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA0"],
        ["\xC3\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB4"],
        ["\xC3\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9A"],
        ["\xC3\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAE"],
        ["\xC3\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB4"],
        ["\xC3\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x98"],
        ["\xC3\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x85"],
        ["\xC3\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB3"],
        ["\xC3\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x89"],
        ["\xC3\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9C"],
        ["\xC3\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB9"],
        ["\xC3\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x91"],
        ["\xC3\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x84"],
        ["\xC3\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x90"],
        ["\xC3\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA9"],
        ["\xC3\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x92"],
        ["\xC3\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB6"],
        ["\xC3\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA1"],
        ["\xC3\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x80"],
        ["\xC3\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAD"],
        ["\xC3\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB2"],
        ["\xC3\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x99"],
        ["\xC3\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA0"],
        ["\xC3\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBD"],
        ["\xC3\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBC"],
        ["\xC3\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB1"],
        ["\xC3\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA8"],
        ["\xC3\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAB"],
        ["\xC3\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB7"],
        ["\xC3\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBB"],
        ["\xC3\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8E"],
        ["\xC3\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB3"],
        ["\xC3\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x90"],
        ["\xC3\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x97"],
        ["\xC3\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA6"],
        ["\xC3\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAA"],
        ["\xC3\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA7"],
        ["\xC3\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x97"],
        ["\xC3\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAF"],
        ["\xC3\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x81"],
        ["\xC3\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x86"],
        ["\xC3\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8B"],
        ["\xC3\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8B"],
        ["\xC3\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB5"],
        ["\xC4\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x96"],
        ["\xC4\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB3"],
        ["\xC4\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x81"],
        ["\xC4\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x94"],
        ["\xC4\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB5"],
        ["\xC4\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAB"],
        ["\xC4\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB4"],
        ["\xC4\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB2"],
        ["\xC4\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x91"],
        ["\xC4\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA2"],
        ["\xC4\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9D"],
        ["\xC4\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAE"],
        ["\xC4\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x92"],
        ["\xC4\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBA"],
        ["\xC4\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBA"],
        ["\xC4\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB4"],
        ["\xC4\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB9"],
        ["\xC4\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB8"],
        ["\xC4\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB6"],
        ["\xC4\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBF"],
        ["\xC4\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9C"],
        ["\xC4\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x85"],
        ["\xC4\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB3"],
        ["\xC4\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9A"],
        ["\xC4\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x95\xB7"],
        ["\xC4\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x82"],
        ["\xC4\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA5"],
        ["\xC4\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x85"],
        ["\xC4\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x97"],
        ["\xC4\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB4"],
        ["\xC4\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x95"],
        ["\xC4\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x88"],
        ["\xC4\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8D"],
        ["\xC4\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x83"],
        ["\xC4\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAE"],
        ["\xC4\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB3"],
        ["\xC4\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA5"],
        ["\xC4\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9C"],
        ["\xC4\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8E"],
        ["\xC4\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8C"],
        ["\xC4\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBD"],
        ["\xC4\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9A"],
        ["\xC4\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9B"],
        ["\xC4\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9A"],
        ["\xC4\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9A"],
        ["\xC4\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x82"],
        ["\xC4\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB4"],
        ["\xC4\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBB"],
        ["\xC4\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x83"],
        ["\xC4\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAC"],
        ["\xC4\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x98"],
        ["\xC4\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBB"],
        ["\xC4\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA6"],
        ["\xC4\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB4"],
        ["\xC4\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x94"],
        ["\xC4\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBF"],
        ["\xC4\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB0"],
        ["\xC4\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAA"],
        ["\xC4\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB7"],
        ["\xC4\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAC"],
        ["\xC4\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAC"],
        ["\xC4\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAA"],
        ["\xC4\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8A"],
        ["\xC4\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA3"],
        ["\xC4\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB4"],
        ["\xC4\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAD"],
        ["\xC4\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8E"],
        ["\xC4\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9C"],
        ["\xC4\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB5"],
        ["\xC4\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x83"],
        ["\xC4\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9E"],
        ["\xC4\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x88"],
        ["\xC4\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA4"],
        ["\xC4\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9A"],
        ["\xC4\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9D"],
        ["\xC4\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x95"],
        ["\xC4\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAD"],
        ["\xC4\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB7"],
        ["\xC4\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9F"],
        ["\xC4\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8C"],
        ["\xC4\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB5"],
        ["\xC4\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBA"],
        ["\xC4\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x90"],
        ["\xC4\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAF"],
        ["\xC4\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x80"],
        ["\xC4\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x87"],
        ["\xC4\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8E"],
        ["\xC4\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8B"],
        ["\xC4\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA0"],
        ["\xC4\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x87"],
        ["\xC4\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x82"],
        ["\xC4\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA6"],
        ["\xC4\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x84"],
        ["\xC4\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x93"],
        ["\xC5\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB8"],
        ["\xC5\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAD"],
        ["\xC5\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x98"],
        ["\xC5\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x8E"],
        ["\xC5\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA5"],
        ["\xC5\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x98"],
        ["\xC5\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA2"],
        ["\xC5\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB5"],
        ["\xC5\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB4"],
        ["\xC5\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x84"],
        ["\xC5\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9B"],
        ["\xC5\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA9"],
        ["\xC5\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x91"],
        ["\xC5\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBA"],
        ["\xC5\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB2"],
        ["\xC5\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB9"],
        ["\xC5\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA4"],
        ["\xC5\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8D"],
        ["\xC5\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAD"],
        ["\xC5\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x84"],
        ["\xC5\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB8"],
        ["\xC5\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xAB"],
        ["\xC5\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA9"],
        ["\xC5\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x95"],
        ["\xC5\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x97"],
        ["\xC5\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBB"],
        ["\xC5\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8F"],
        ["\xC5\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9C"],
        ["\xC5\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBC"],
        ["\xC5\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA2"],
        ["\xC5\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9B"],
        ["\xC5\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB9"],
        ["\xC5\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9D"],
        ["\xC5\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBF"],
        ["\xC5\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB1"],
        ["\xC5\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB0"],
        ["\xC5\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xBB"],
        ["\xC5\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8E"],
        ["\xC5\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x90"],
        ["\xC5\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB5"],
        ["\xC5\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x97"],
        ["\xC5\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAC"],
        ["\xC5\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA0"],
        ["\xC5\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x92"],
        ["\xC5\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x97"],
        ["\xC5\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9C"],
        ["\xC5\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA1"],
        ["\xC5\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBB"],
        ["\xC5\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9F"],
        ["\xC5\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAD"],
        ["\xC5\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x94"],
        ["\xC5\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xBD"],
        ["\xC5\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8D"],
        ["\xC5\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA5"],
        ["\xC5\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBA"],
        ["\xC5\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAA"],
        ["\xC5\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA6"],
        ["\xC5\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9F"],
        ["\xC5\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB4"],
        ["\xC5\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x92"],
        ["\xC5\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x92"],
        ["\xC5\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9A"],
        ["\xC5\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAC"],
        ["\xC5\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8D"],
        ["\xC5\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x80"],
        ["\xC5\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x90"],
        ["\xC5\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x94"],
        ["\xC5\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x98"],
        ["\xC5\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x97"],
        ["\xC5\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x95"],
        ["\xC5\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB6"],
        ["\xC5\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8B"],
        ["\xC5\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBC"],
        ["\xC5\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x95"],
        ["\xC5\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAD"],
        ["\xC5\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB1"],
        ["\xC5\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x83"],
        ["\xC5\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBC"],
        ["\xC5\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9F"],
        ["\xC5\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x97"],
        ["\xC5\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x98"],
        ["\xC5\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAF"],
        ["\xC5\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9B"],
        ["\xC5\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAF"],
        ["\xC5\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x88"],
        ["\xC5\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x93"],
        ["\xC5\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x98"],
        ["\xC5\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB7"],
        ["\xC5\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x89"],
        ["\xC5\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x94"],
        ["\xC5\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x92"],
        ["\xC5\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x96"],
        ["\xC5\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB1"],
        ["\xC5\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB0"],
        ["\xC6\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA3"],
        ["\xC6\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA9"],
        ["\xC6\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA4"],
        ["\xC6\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8E"],
        ["\xC6\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x84"],
        ["\xC6\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x86"],
        ["\xC6\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8F"],
        ["\xC6\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x83"],
        ["\xC6\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8F"],
        ["\xC6\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x99"],
        ["\xC6\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB6"],
        ["\xC6\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAD"],
        ["\xC6\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB0"],
        ["\xC6\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x98"],
        ["\xC6\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8D"],
        ["\xC6\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x95"],
        ["\xC6\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8C"],
        ["\xC6\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x82"],
        ["\xC6\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8E"],
        ["\xC6\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA7"],
        ["\xC6\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9E"],
        ["\xC6\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9E"],
        ["\xC6\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB3"],
        ["\xC6\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA5"],
        ["\xC6\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB4"],
        ["\xC6\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x84"],
        ["\xC6\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x93"],
        ["\xC6\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x85"],
        ["\xC6\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA0"],
        ["\xC6\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x87"],
        ["\xC6\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBF"],
        ["\xC6\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x97"],
        ["\xC6\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB3"],
        ["\xC6\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9C"],
        ["\xC6\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB9"],
        ["\xC6\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA3"],
        ["\xC6\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBF"],
        ["\xC6\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA4"],
        ["\xC6\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x92"],
        ["\xC6\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAC"],
        ["\xC6\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAD"],
        ["\xC6\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x83"],
        ["\xC6\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA1"],
        ["\xC6\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB8"],
        ["\xC6\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x81"],
        ["\xC6\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB4"],
        ["\xC6\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8A"],
        ["\xC6\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB6"],
        ["\xC6\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xAB"],
        ["\xC6\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x85"],
        ["\xC6\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x89"],
        ["\xC6\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9E"],
        ["\xC6\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB8"],
        ["\xC6\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAF"],
        ["\xC6\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x87"],
        ["\xC6\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA6"],
        ["\xC6\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8C"],
        ["\xC6\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x9A"],
        ["\xC6\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x81"],
        ["\xC6\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x93"],
        ["\xC6\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x91"],
        ["\xC6\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x87"],
        ["\xC6\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8D"],
        ["\xC6\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x88"],
        ["\xC6\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA3"],
        ["\xC6\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x85"],
        ["\xC6\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8D"],
        ["\xC6\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAA"],
        ["\xC6\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x99"],
        ["\xC6\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8E"],
        ["\xC6\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x98"],
        ["\xC6\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBA"],
        ["\xC6\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8B"],
        ["\xC6\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA2"],
        ["\xC6\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB4"],
        ["\xC6\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x84"],
        ["\xC6\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB7"],
        ["\xC6\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x97"],
        ["\xC6\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA0"],
        ["\xC6\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9F"],
        ["\xC6\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA3"],
        ["\xC6\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9D"],
        ["\xC6\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8C"],
        ["\xC6\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBC"],
        ["\xC6\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x90"],
        ["\xC6\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA9"],
        ["\xC6\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x82"],
        ["\xC6\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x91"],
        ["\xC6\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x89"],
        ["\xC6\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB9"],
        ["\xC6\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBF"],
        ["\xC6\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA5"],
        ["\xC6\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB3"],
        ["\xC6\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA5"],
        ["\xC7\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x82"],
        ["\xC7\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBF"],
        ["\xC7\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAE"],
        ["\xC7\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBB"],
        ["\xC7\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8A"],
        ["\xC7\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8D"],
        ["\xC7\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8D"],
        ["\xC7\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA1"],
        ["\xC7\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB0"],
        ["\xC7\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA2"],
        ["\xC7\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA7"],
        ["\xC7\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB1"],
        ["\xC7\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAB"],
        ["\xC7\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB1"],
        ["\xC7\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB4"],
        ["\xC7\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB5"],
        ["\xC7\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBB"],
        ["\xC7\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9A"],
        ["\xC7\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x83"],
        ["\xC7\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x98"],
        ["\xC7\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x83"],
        ["\xC7\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBC"],
        ["\xC7\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8B"],
        ["\xC7\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9C"],
        ["\xC7\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA2"],
        ["\xC7\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA9"],
        ["\xC7\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x83"],
        ["\xC7\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8D"],
        ["\xC7\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBD"],
        ["\xC7\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB3"],
        ["\xC7\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBF"],
        ["\xC7\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB2"],
        ["\xC7\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x97"],
        ["\xC7\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA4"],
        ["\xC7\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB4"],
        ["\xC7\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x8A"],
        ["\xC7\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAD"],
        ["\xC7\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x87"],
        ["\xC7\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB7"],
        ["\xC7\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA2"],
        ["\xC7\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBE"],
        ["\xC7\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB6"],
        ["\xC7\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB4"],
        ["\xC7\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x86"],
        ["\xC7\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB5"],
        ["\xC7\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAD"],
        ["\xC7\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAC"],
        ["\xC7\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB3"],
        ["\xC7\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x83"],
        ["\xC7\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9D"],
        ["\xC7\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x92"],
        ["\xC7\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x97"],
        ["\xC7\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAF"],
        ["\xC7\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x83"],
        ["\xC7\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8C"],
        ["\xC7\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8C"],
        ["\xC7\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xBA"],
        ["\xC7\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA9"],
        ["\xC7\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8D"],
        ["\xC7\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8D"],
        ["\xC7\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB9"],
        ["\xC7\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x92"],
        ["\xC7\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x85"],
        ["\xC7\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB3"],
        ["\xC7\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA4"],
        ["\xC7\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBD"],
        ["\xC7\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB7"],
        ["\xC7\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB2"],
        ["\xC7\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA0"],
        ["\xC7\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAA"],
        ["\xC7\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x99"],
        ["\xC7\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBF"],
        ["\xC7\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA4"],
        ["\xC7\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA7"],
        ["\xC7\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA9"],
        ["\xC7\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xAF"],
        ["\xC7\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA5"],
        ["\xC7\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9A"],
        ["\xC7\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8D"],
        ["\xC7\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8F"],
        ["\xC7\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8A"],
        ["\xC7\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBD"],
        ["\xC7\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x94"],
        ["\xC7\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x95"],
        ["\xC7\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB6"],
        ["\xC7\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x84"],
        ["\xC7\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAB"],
        ["\xC7\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9D"],
        ["\xC7\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA0"],
        ["\xC7\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x86"],
        ["\xC7\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9B"],
        ["\xC7\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAB"],
        ["\xC7\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x81"],
        ["\xC7\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA6"],
        ["\xC8\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBD"],
        ["\xC8\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB1"],
        ["\xC8\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB2"],
        ["\xC8\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB8"],
        ["\xC8\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x87"],
        ["\xC8\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x88"],
        ["\xC8\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA8"],
        ["\xC8\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA1"],
        ["\xC8\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8C"],
        ["\xC8\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x91"],
        ["\xC8\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA0"],
        ["\xC8\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAB"],
        ["\xC8\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA2"],
        ["\xC8\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8C"],
        ["\xC8\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBA"],
        ["\xC8\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x97"],
        ["\xC8\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAA"],
        ["\xC8\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x90"],
        ["\xC8\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB0"],
        ["\xC8\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9C"],
        ["\xC8\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8F"],
        ["\xC8\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA5"],
        ["\xC8\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA9"],
        ["\xC8\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xBA"],
        ["\xC8\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x99"],
        ["\xC8\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA4"],
        ["\xC8\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBC"],
        ["\xC8\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB4"],
        ["\xC8\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA4"],
        ["\xC8\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8A"],
        ["\xC8\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8D"],
        ["\xC8\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9B"],
        ["\xC8\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x86"],
        ["\xC8\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAC"],
        ["\xC8\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x91"],
        ["\xC8\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBF"],
        ["\xC8\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBE"],
        ["\xC8\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8E"],
        ["\xC8\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x88"],
        ["\xC8\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAF"],
        ["\xC8\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAD"],
        ["\xC8\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x94"],
        ["\xC8\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x81"],
        ["\xC8\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAC"],
        ["\xC8\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA9"],
        ["\xC8\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA9"],
        ["\xC8\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x84"],
        ["\xC8\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x86"],
        ["\xC8\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA9"],
        ["\xC8\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x92"],
        ["\xC8\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAF"],
        ["\xC8\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBD"],
        ["\xC8\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA9"],
        ["\xC8\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAA"],
        ["\xC8\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA4"],
        ["\xC8\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x90"],
        ["\xC8\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x83"],
        ["\xC8\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAE"],
        ["\xC8\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAA"],
        ["\xC8\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x91"],
        ["\xC8\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA6"],
        ["\xC8\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x83"],
        ["\xC8\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x87"],
        ["\xC8\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBC"],
        ["\xC8\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB2"],
        ["\xC8\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x89"],
        ["\xC8\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB9"],
        ["\xC8\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAB"],
        ["\xC8\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x90"],
        ["\xC8\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x94"],
        ["\xC8\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8C"],
        ["\xC8\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB2"],
        ["\xC8\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAE"],
        ["\xC8\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x91"],
        ["\xC8\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x98"],
        ["\xC8\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8B"],
        ["\xC8\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB7"],
        ["\xC8\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA5"],
        ["\xC8\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAB"],
        ["\xC8\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB9"],
        ["\xC8\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBB"],
        ["\xC8\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBF"],
        ["\xC8\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9E"],
        ["\xC8\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9B"],
        ["\xC8\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8B"],
        ["\xC8\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB8"],
        ["\xC8\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x99"],
        ["\xC8\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBE"],
        ["\xC8\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAE"],
        ["\xC8\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x87"],
        ["\xC8\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x98"],
        ["\xC8\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB5"],
        ["\xC8\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x89"],
        ["\xC8\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8E"],
        ["\xC9\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBB"],
        ["\xC9\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8A"],
        ["\xC9\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x97"],
        ["\xC9\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB9"],
        ["\xC9\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8B"],
        ["\xC9\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAD"],
        ["\xC9\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA6"],
        ["\xC9\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9D"],
        ["\xC9\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB1"],
        ["\xC9\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x98"],
        ["\xC9\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBC"],
        ["\xC9\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x85"],
        ["\xC9\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA2"],
        ["\xC9\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x86"],
        ["\xC9\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBC"],
        ["\xC9\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA7"],
        ["\xC9\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAB"],
        ["\xC9\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9B"],
        ["\xC9\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x90"],
        ["\xC9\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBE"],
        ["\xC9\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAC"],
        ["\xC9\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB5"],
        ["\xC9\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAA"],
        ["\xC9\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x99"],
        ["\xC9\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB7"],
        ["\xC9\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x82"],
        ["\xC9\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA2"],
        ["\xC9\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA8"],
        ["\xC9\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA8"],
        ["\xC9\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x95"],
        ["\xC9\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB9"],
        ["\xC9\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9F"],
        ["\xC9\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x8F"],
        ["\xC9\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x85"],
        ["\xC9\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x92"],
        ["\xC9\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x97"],
        ["\xC9\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA8"],
        ["\xC9\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB2"],
        ["\xC9\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9C"],
        ["\xC9\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAD"],
        ["\xC9\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAD"],
        ["\xC9\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x81"],
        ["\xC9\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAC"],
        ["\xC9\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8C"],
        ["\xC9\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9C"],
        ["\xC9\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x95"],
        ["\xC9\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA7"],
        ["\xC9\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x93"],
        ["\xC9\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBB"],
        ["\xC9\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8F"],
        ["\xC9\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB6"],
        ["\xC9\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8D"],
        ["\xC9\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x98"],
        ["\xC9\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA0"],
        ["\xC9\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAB"],
        ["\xC9\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA6"],
        ["\xC9\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8C"],
        ["\xC9\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA8"],
        ["\xC9\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x83"],
        ["\xC9\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9C"],
        ["\xC9\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x96"],
        ["\xC9\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB6"],
        ["\xC9\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB7"],
        ["\xC9\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA7"],
        ["\xC9\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAE"],
        ["\xC9\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAE"],
        ["\xC9\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB6"],
        ["\xC9\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA6"],
        ["\xC9\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x90"],
        ["\xC9\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9A"],
        ["\xC9\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x99"],
        ["\xC9\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9C"],
        ["\xC9\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA0"],
        ["\xC9\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA6"],
        ["\xC9\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB4"],
        ["\xC9\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\x9C"],
        ["\xC9\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x84"],
        ["\xC9\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAE"],
        ["\xC9\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAB"],
        ["\xC9\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA6"],
        ["\xC9\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9E"],
        ["\xC9\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA1"],
        ["\xC9\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAA"],
        ["\xC9\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA8"],
        ["\xC9\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x81"],
        ["\xC9\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x93"],
        ["\xC9\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xA8"],
        ["\xC9\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBA"],
        ["\xC9\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x97"],
        ["\xC9\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8F"],
        ["\xC9\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAF"],
        ["\xC9\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA9"],
        ["\xC9\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x85"],
        ["\xC9\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8D"],
        ["\xCA\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8F"],
        ["\xCA\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB9"],
        ["\xCA\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x87"],
        ["\xCA\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x86"],
        ["\xCA\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB5"],
        ["\xCA\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x97"],
        ["\xCA\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x95"],
        ["\xCA\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB8"],
        ["\xCA\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8F"],
        ["\xCA\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA9"],
        ["\xCA\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x92"],
        ["\xCA\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x86"],
        ["\xCA\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBB"],
        ["\xCA\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB4"],
        ["\xCA\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB3"],
        ["\xCA\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA4"],
        ["\xCA\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAE"],
        ["\xCA\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9A"],
        ["\xCA\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAE"],
        ["\xCA\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x89"],
        ["\xCA\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9E"],
        ["\xCA\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9B"],
        ["\xCA\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB0"],
        ["\xCA\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x87"],
        ["\xCA\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9E"],
        ["\xCA\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x99"],
        ["\xCA\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB5"],
        ["\xCA\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB5"],
        ["\xCA\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x80"],
        ["\xCA\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA3"],
        ["\xCA\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB3"],
        ["\xCA\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8A"],
        ["\xCA\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x84"],
        ["\xCA\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA6"],
        ["\xCA\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBD"],
        ["\xCA\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x89"],
        ["\xCA\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9B"],
        ["\xCA\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB3"],
        ["\xCA\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x81"],
        ["\xCA\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xBB"],
        ["\xCA\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x81"],
        ["\xCA\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x96"],
        ["\xCA\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA7"],
        ["\xCA\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA5"],
        ["\xCA\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA5"],
        ["\xCA\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x91"],
        ["\xCA\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x86"],
        ["\xCA\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8F"],
        ["\xCA\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x89"],
        ["\xCA\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x87"],
        ["\xCA\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x87"],
        ["\xCA\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA8"],
        ["\xCA\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBA"],
        ["\xCA\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x94"],
        ["\xCA\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8D"],
        ["\xCA\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBF"],
        ["\xCA\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x89"],
        ["\xCA\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA9"],
        ["\xCA\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x81"],
        ["\xCA\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAD"],
        ["\xCA\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9D"],
        ["\xCA\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x97"],
        ["\xCA\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAA"],
        ["\xCA\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x83"],
        ["\xCA\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x95"],
        ["\xCA\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA9"],
        ["\xCA\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAB"],
        ["\xCA\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9C"],
        ["\xCA\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x94"],
        ["\xCA\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x82"],
        ["\xCA\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9F"],
        ["\xCA\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x93"],
        ["\xCA\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x95"],
        ["\xCA\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8A"],
        ["\xCA\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAE"],
        ["\xCA\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8D"],
        ["\xCA\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBF"],
        ["\xCA\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA9"],
        ["\xCA\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA3"],
        ["\xCA\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB8"],
        ["\xCA\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x85"],
        ["\xCA\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x86"],
        ["\xCA\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB1"],
        ["\xCA\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x89"],
        ["\xCA\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9D"],
        ["\xCA\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB0"],
        ["\xCA\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAF"],
        ["\xCA\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA9"],
        ["\xCA\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x96"],
        ["\xCA\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB1"],
        ["\xCA\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA7"],
        ["\xCA\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBE"],
        ["\xCA\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB9"],
        ["\xCA\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8B"],
        ["\xCB\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x95"],
        ["\xCB\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA1"],
        ["\xCB\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB9"],
        ["\xCB\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB2"],
        ["\xCB\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAB"],
        ["\xCB\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9E"],
        ["\xCB\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB3"],
        ["\xCB\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8C"],
        ["\xCB\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAC"],
        ["\xCB\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x82"],
        ["\xCB\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x92"],
        ["\xCB\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAA"],
        ["\xCB\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8A"],
        ["\xCB\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA6"],
        ["\xCB\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x92"],
        ["\xCB\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBD"],
        ["\xCB\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB3"],
        ["\xCB\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAC"],
        ["\xCB\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8F"],
        ["\xCB\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA1"],
        ["\xCB\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x8D"],
        ["\xCB\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x96"],
        ["\xCB\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8A"],
        ["\xCB\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA8"],
        ["\xCB\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBD"],
        ["\xCB\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x98"],
        ["\xCB\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x99"],
        ["\xCB\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBF"],
        ["\xCB\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB4"],
        ["\xCB\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9B"],
        ["\xCB\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x90"],
        ["\xCB\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x92"],
        ["\xCB\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x92"],
        ["\xCB\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA1"],
        ["\xCB\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAA"],
        ["\xCB\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA8"],
        ["\xCB\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x80"],
        ["\xCB\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8C"],
        ["\xCB\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBF"],
        ["\xCB\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xBE"],
        ["\xCB\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB2"],
        ["\xCB\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA0"],
        ["\xCB\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAC"],
        ["\xCB\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x97"],
        ["\xCB\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x95"],
        ["\xCB\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9C"],
        ["\xCB\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA8"],
        ["\xCB\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB2"],
        ["\xCB\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB4"],
        ["\xCB\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA7"],
        ["\xCB\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA6"],
        ["\xCB\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x86"],
        ["\xCB\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA6"],
        ["\xCB\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x83"],
        ["\xCB\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA1"],
        ["\xCB\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x86"],
        ["\xCB\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x80"],
        ["\xCB\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8C"],
        ["\xCB\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x94"],
        ["\xCB\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAC"],
        ["\xCB\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBB"],
        ["\xCB\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA1"],
        ["\xCB\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x86"],
        ["\xCB\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA9"],
        ["\xCB\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA8"],
        ["\xCB\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x94"],
        ["\xCB\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBB"],
        ["\xCB\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8B"],
        ["\xCB\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB9"],
        ["\xCB\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA7"],
        ["\xCB\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9A"],
        ["\xCB\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8E"],
        ["\xCB\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA9"],
        ["\xCB\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x99"],
        ["\xCB\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x95"],
        ["\xCB\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9C"],
        ["\xCB\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x95"],
        ["\xCB\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAA"],
        ["\xCB\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBE"],
        ["\xCB\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x92"],
        ["\xCB\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9D"],
        ["\xCB\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA6"],
        ["\xCB\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA3"],
        ["\xCB\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x88"],
        ["\xCB\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB9"],
        ["\xCB\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAB"],
        ["\xCB\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAB"],
        ["\xCB\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x84"],
        ["\xCB\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAD"],
        ["\xCB\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAD"],
        ["\xCB\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBF"],
        ["\xCB\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x87"],
        ["\xCB\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA2"],
        ["\xCB\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x80"],
        ["\xCC\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAB"],
        ["\xCC\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x93"],
        ["\xCC\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB3"],
        ["\xCC\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAA"],
        ["\xCC\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x85"],
        ["\xCC\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB3"],
        ["\xCC\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x95"],
        ["\xCC\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAC"],
        ["\xCC\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x86"],
        ["\xCC\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9C"],
        ["\xCC\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8A"],
        ["\xCC\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x91"],
        ["\xCC\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x94"],
        ["\xCC\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x88"],
        ["\xCC\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x99"],
        ["\xCC\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8D"],
        ["\xCC\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x91"],
        ["\xCC\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA0"],
        ["\xCC\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x99"],
        ["\xCC\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA2"],
        ["\xCC\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA1"],
        ["\xCC\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9F"],
        ["\xCC\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9B"],
        ["\xCC\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA7"],
        ["\xCC\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA1"],
        ["\xCC\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8B"],
        ["\xCC\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBF"],
        ["\xCC\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x98"],
        ["\xCC\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA5"],
        ["\xCC\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8D"],
        ["\xCC\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBD"],
        ["\xCC\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8E"],
        ["\xCC\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9F"],
        ["\xCC\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB7"],
        ["\xCC\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x98"],
        ["\xCC\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB4"],
        ["\xCC\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAA"],
        ["\xCC\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9D"],
        ["\xCC\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x85"],
        ["\xCC\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8D"],
        ["\xCC\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x89"],
        ["\xCC\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBF"],
        ["\xCC\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAC"],
        ["\xCC\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA2"],
        ["\xCC\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBA"],
        ["\xCC\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB8"],
        ["\xCC\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA1"],
        ["\xCC\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x82"],
        ["\xCC\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x84"],
        ["\xCC\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9F"],
        ["\xCC\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9B"],
        ["\xCC\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9B"],
        ["\xCC\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB2"],
        ["\xCC\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB2"],
        ["\xCC\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x97"],
        ["\xCC\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x99"],
        ["\xCC\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB2"],
        ["\xCC\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA8"],
        ["\xCC\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x99"],
        ["\xCC\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAE"],
        ["\xCC\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA2"],
        ["\xCC\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBF"],
        ["\xCC\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x85"],
        ["\xCC\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA4"],
        ["\xCC\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBB"],
        ["\xCC\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xBE"],
        ["\xCC\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB0"],
        ["\xCC\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8F"],
        ["\xCC\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB6"],
        ["\xCC\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8B"],
        ["\xCC\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x80"],
        ["\xCC\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x81"],
        ["\xCC\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9F"],
        ["\xCC\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB6"],
        ["\xCC\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9C"],
        ["\xCC\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBA"],
        ["\xCC\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB6"],
        ["\xCC\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8E"],
        ["\xCC\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA5"],
        ["\xCC\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA2"],
        ["\xCC\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x84"],
        ["\xCC\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB9"],
        ["\xCC\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x84"],
        ["\xCC\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAC"],
        ["\xCC\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB3"],
        ["\xCC\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8D"],
        ["\xCC\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x96"],
        ["\xCC\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB3"],
        ["\xCC\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAE"],
        ["\xCC\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x93"],
        ["\xCC\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x89"],
        ["\xCC\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x88"],
        ["\xCC\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB9"],
        ["\xCC\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x92"],
        ["\xCD\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAD"],
        ["\xCD\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB8"],
        ["\xCD\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAF"],
        ["\xCD\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x91"],
        ["\xCD\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xAA"],
        ["\xCD\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x87"],
        ["\xCD\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8B"],
        ["\xCD\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA5"],
        ["\xCD\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBD"],
        ["\xCD\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA0"],
        ["\xCD\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x82"],
        ["\xCD\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x96"],
        ["\xCD\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x89"],
        ["\xCD\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9A"],
        ["\xCD\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA7"],
        ["\xCD\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8C"],
        ["\xCD\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB6"],
        ["\xCD\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB7"],
        ["\xCD\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB1"],
        ["\xCD\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x90"],
        ["\xCD\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x95"],
        ["\xCD\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x98"],
        ["\xCD\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8A"],
        ["\xCD\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x91"],
        ["\xCD\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB5"],
        ["\xCD\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x84"],
        ["\xCD\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8D"],
        ["\xCD\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x95"],
        ["\xCD\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x88"],
        ["\xCD\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x99"],
        ["\xCD\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8E"],
        ["\xCD\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x89"],
        ["\xCD\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBF"],
        ["\xCD\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x90"],
        ["\xCD\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAD"],
        ["\xCD\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBC"],
        ["\xCD\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x96"],
        ["\xCD\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB9"],
        ["\xCD\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB8"],
        ["\xCD\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9A"],
        ["\xCD\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xBA"],
        ["\xCD\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x81"],
        ["\xCD\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9C"],
        ["\xCD\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x8A"],
        ["\xCD\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x98"],
        ["\xCD\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8B"],
        ["\xCD\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB6"],
        ["\xCD\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x94"],
        ["\xCD\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA8"],
        ["\xCD\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAF"],
        ["\xCD\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8A"],
        ["\xCD\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x80"],
        ["\xCD\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x89"],
        ["\xCD\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x89"],
        ["\xCD\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x81"],
        ["\xCD\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA1"],
        ["\xCD\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8A"],
        ["\xCD\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA5"],
        ["\xCD\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBD"],
        ["\xCD\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8A"],
        ["\xCD\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBE"],
        ["\xCD\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x91"],
        ["\xCD\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB2"],
        ["\xCD\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x83"],
        ["\xCD\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB4"],
        ["\xCD\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8C"],
        ["\xCD\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBC"],
        ["\xCD\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x80"],
        ["\xCD\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x85"],
        ["\xCD\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBA"],
        ["\xCD\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB8"],
        ["\xCD\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA5"],
        ["\xCD\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB1"],
        ["\xCD\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBC"],
        ["\xCD\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB7"],
        ["\xCD\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9B"],
        ["\xCD\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA1"],
        ["\xCD\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBD"],
        ["\xCD\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAA"],
        ["\xCD\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB1"],
        ["\xCD\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB5"],
        ["\xCD\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x90"],
        ["\xCD\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x84"],
        ["\xCD\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAB"],
        ["\xCD\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8D"],
        ["\xCD\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAD"],
        ["\xCD\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA7"],
        ["\xCD\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA9"],
        ["\xCD\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8F"],
        ["\xCD\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA5"],
        ["\xCD\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8E"],
        ["\xCD\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA8"],
        ["\xCD\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x86"],
        ["\xCD\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x83"],
        ["\xCE\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA2"],
        ["\xCE\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8F"],
        ["\xCE\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA1"],
        ["\xCE\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8C"],
        ["\xCE\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA2"],
        ["\xCE\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB8"],
        ["\xCE\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8B"],
        ["\xCE\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x87"],
        ["\xCE\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8B"],
        ["\xCE\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8E"],
        ["\xCE\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA0"],
        ["\xCE\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA5"],
        ["\xCE\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x89"],
        ["\xCE\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x81"],
        ["\xCE\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9C"],
        ["\xCE\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x89"],
        ["\xCE\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x99"],
        ["\xCE\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAB"],
        ["\xCE\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x92"],
        ["\xCE\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x86"],
        ["\xCE\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9C"],
        ["\xCE\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x8D"],
        ["\xCE\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB6"],
        ["\xCE\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAE"],
        ["\xCE\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x85"],
        ["\xCE\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9C"],
        ["\xCE\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x86"],
        ["\xCE\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAE"],
        ["\xCE\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9A"],
        ["\xCE\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA1"],
        ["\xCE\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8C"],
        ["\xCE\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAE"],
        ["\xCE\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x99"],
        ["\xCE\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x81"],
        ["\xCE\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBC"],
        ["\xCE\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9F"],
        ["\xCE\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x82"],
        ["\xCE\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAD"],
        ["\xCE\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9C"],
        ["\xCE\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA7"],
        ["\xCE\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAF"],
        ["\xCE\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x92"],
        ["\xCE\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBC"],
        ["\xCE\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8F"],
        ["\xCE\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB5"],
        ["\xCE\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x98"],
        ["\xCE\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9B"],
        ["\xCE\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x91"],
        ["\xCE\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAB"],
        ["\xCE\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x98"],
        ["\xCE\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x97"],
        ["\xCE\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8B"],
        ["\xCE\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x90"],
        ["\xCE\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB3"],
        ["\xCE\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA8"],
        ["\xCE\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAA"],
        ["\xCE\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA3"],
        ["\xCE\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x97"],
        ["\xCE\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9F"],
        ["\xCE\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA0"],
        ["\xCE\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x81"],
        ["\xCE\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x99"],
        ["\xCE\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAF"],
        ["\xCE\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9E"],
        ["\xCE\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA4"],
        ["\xCE\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB6"],
        ["\xCE\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8B"],
        ["\xCE\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB7"],
        ["\xCE\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB1"],
        ["\xCE\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBA"],
        ["\xCE\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9C"],
        ["\xCE\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB2"],
        ["\xCE\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBC"],
        ["\xCE\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x93"],
        ["\xCE\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB4"],
        ["\xCE\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB7"],
        ["\xCE\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB6"],
        ["\xCE\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8A"],
        ["\xCE\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x97"],
        ["\xCE\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA2"],
        ["\xCE\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA6"],
        ["\xCE\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB4"],
        ["\xCE\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x97"],
        ["\xCE\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA3"],
        ["\xCE\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x88"],
        ["\xCE\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x82"],
        ["\xCE\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x89"],
        ["\xCE\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8B"],
        ["\xCE\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x90"],
        ["\xCE\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA3"],
        ["\xCE\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x89"],
        ["\xCE\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBE"],
        ["\xCE\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB4"],
        ["\xCE\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xAF"],
        ["\xCF\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAE"],
        ["\xCF\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA3"],
        ["\xCF\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAC"],
        ["\xCF\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x82"],
        ["\xCF\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAF"],
        ["\xCF\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x93"],
        ["\xCF\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x89"],
        ["\xCF\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x82"],
        ["\xCF\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAF"],
        ["\xCF\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB2"],
        ["\xCF\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB4"],
        ["\xCF\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x81"],
        ["\xCF\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8A"],
        ["\xCF\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x84"],
        ["\xCF\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x97"],
        ["\xCF\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBC"],
        ["\xCF\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x94"],
        ["\xCF\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAA"],
        ["\xCF\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8F"],
        ["\xCF\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA2"],
        ["\xCF\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBC"],
        ["\xCF\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAD"],
        ["\xCF\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x81"],
        ["\xCF\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBE"],
        ["\xCF\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8B"],
        ["\xCF\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8E"],
        ["\xCF\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAD"],
        ["\xCF\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x93"],
        ["\xCF\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x84"],
        ["\xCF\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8B"],
        ["\xCF\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB2"],
        ["\xCF\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x96"],
        ["\xCF\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAD"],
        ["\xCF\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8C"],
        ["\xCF\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB1"],
        ["\xCF\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAA"],
        ["\xCF\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x84"],
        ["\xCF\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x87"],
        ["\xCF\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x91"],
        ["\xCF\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA0"],
        ["\xCF\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB2"],
        ["\xCF\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x99"],
        ["\xCF\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x98"],
        ["\xCF\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x90"],
        ["\xCF\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAB"],
        ["\xCF\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x81"],
        ["\xCF\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA8"],
        ["\xCF\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x80"],
        ["\xCF\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBE"],
        ["\xCF\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x97"],
        ["\xCF\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x95"],
        ["\xD0\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8C"],
        ["\xD0\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x90"],
        ["\xD0\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x95"],
        ["\xD0\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAA"],
        ["\xD0\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB1"],
        ["\xD0\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB6"],
        ["\xD0\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBC"],
        ["\xD0\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBF"],
        ["\xD0\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x82"],
        ["\xD0\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x96"],
        ["\xD0\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x98"],
        ["\xD0\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x82"],
        ["\xD0\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x85"],
        ["\xD0\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAB"],
        ["\xD0\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8A"],
        ["\xD0\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x92"],
        ["\xD0\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8D"],
        ["\xD0\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8E"],
        ["\xD0\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9E"],
        ["\xD0\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9F"],
        ["\xD0\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA0"],
        ["\xD0\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA2"],
        ["\xD0\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB0"],
        ["\xD0\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB3"],
        ["\xD0\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB6"],
        ["\xD0\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8E"],
        ["\xD0\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8D"],
        ["\xD0\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x84"],
        ["\xD0\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x86"],
        ["\xD0\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x82"],
        ["\xD0\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x97"],
        ["\xD0\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9E"],
        ["\xD0\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAD"],
        ["\xD0\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9F"],
        ["\xD0\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB7"],
        ["\xD0\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x89"],
        ["\xD0\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9A"],
        ["\xD0\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB0"],
        ["\xD0\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9B"],
        ["\xD0\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9D"],
        ["\xD0\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x97"],
        ["\xD0\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x87"],
        ["\xD0\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB6"],
        ["\xD0\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x88"],
        ["\xD0\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8F"],
        ["\xD0\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x98"],
        ["\xD0\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBB"],
        ["\xD0\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA9"],
        ["\xD0\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB0"],
        ["\xD0\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x91"],
        ["\xD0\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAF"],
        ["\xD0\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x86"],
        ["\xD0\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x96"],
        ["\xD0\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x98"],
        ["\xD0\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x94"],
        ["\xD0\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9F"],
        ["\xD0\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8E"],
        ["\xD0\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x98"],
        ["\xD0\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9B"],
        ["\xD0\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x91"],
        ["\xD0\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9A"],
        ["\xD0\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x90"],
        ["\xD0\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA4"],
        ["\xD0\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA5"],
        ["\xD0\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9A"],
        ["\xD0\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA8"],
        ["\xD0\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x94"],
        ["\xD0\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAA"],
        ["\xD0\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA5"],
        ["\xD0\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x85"],
        ["\xD0\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9C"],
        ["\xD0\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB6"],
        ["\xD0\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA1"],
        ["\xD0\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA9"],
        ["\xD0\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAC"],
        ["\xD0\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBE"],
        ["\xD0\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAF"],
        ["\xD0\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x91"],
        ["\xD0\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x86"],
        ["\xD0\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x83"],
        ["\xD0\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x87"],
        ["\xD0\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x83"],
        ["\xD0\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x95"],
        ["\xD0\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x90"],
        ["\xD0\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x88"],
        ["\xD0\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9A"],
        ["\xD0\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x96"],
        ["\xD0\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAC"],
        ["\xD0\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB8"],
        ["\xD0\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x80"],
        ["\xD0\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9A"],
        ["\xD0\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x85"],
        ["\xD0\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB4"],
        ["\xD0\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB2"],
        ["\xD1\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x89"],
        ["\xD1\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8A"],
        ["\xD1\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB3"],
        ["\xD1\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x82"],
        ["\xD1\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x96"],
        ["\xD1\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9E"],
        ["\xD1\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA5"],
        ["\xD1\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAD"],
        ["\xD1\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA3"],
        ["\xD1\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAE"],
        ["\xD1\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB9"],
        ["\xD1\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB5"],
        ["\xD1\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x89"],
        ["\xD1\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x81"],
        ["\xD1\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x82"],
        ["\xD1\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x96"],
        ["\xD1\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x95"],
        ["\xD1\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x94"],
        ["\xD1\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9A"],
        ["\xD1\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xA1"],
        ["\xD1\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBA"],
        ["\xD1\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB7"],
        ["\xD1\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBC"],
        ["\xD1\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBB"],
        ["\xD1\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBF"],
        ["\xD1\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x80"],
        ["\xD1\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x92"],
        ["\xD1\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8C"],
        ["\xD1\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x94"],
        ["\xD1\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA2"],
        ["\xD1\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB8"],
        ["\xD1\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA9"],
        ["\xD1\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAA"],
        ["\xD1\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAE"],
        ["\xD1\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x80"],
        ["\xD1\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x82"],
        ["\xD1\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x98"],
        ["\xD1\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8C"],
        ["\xD1\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x89"],
        ["\xD1\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8F"],
        ["\xD1\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x91"],
        ["\xD1\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x93"],
        ["\xD1\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x95"],
        ["\xD1\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x96"],
        ["\xD1\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA4"],
        ["\xD1\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA6"],
        ["\xD1\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA2"],
        ["\xD1\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA9"],
        ["\xD1\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAA"],
        ["\xD1\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAB"],
        ["\xD1\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB3"],
        ["\xD1\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB1"],
        ["\xD1\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB2"],
        ["\xD1\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB0"],
        ["\xD1\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB5"],
        ["\xD1\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBD"],
        ["\xD1\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x85"],
        ["\xD1\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x89"],
        ["\xD1\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9B"],
        ["\xD1\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA0"],
        ["\xD1\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x95"],
        ["\xD1\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA9"],
        ["\xD1\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAD"],
        ["\xD1\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB0"],
        ["\xD1\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB5"],
        ["\xD1\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBE"],
        ["\xD1\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x84"],
        ["\xD1\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8B"],
        ["\xD1\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x94"],
        ["\xD1\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8E"],
        ["\xD1\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA7"],
        ["\xD1\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAA"],
        ["\xD1\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAE"],
        ["\xD1\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB3"],
        ["\xD1\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB9"],
        ["\xD1\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8F"],
        ["\xD1\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x84"],
        ["\xD1\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8B"],
        ["\xD1\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8C"],
        ["\xD1\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9E"],
        ["\xD1\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x94"],
        ["\xD1\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAA"],
        ["\xD1\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB4"],
        ["\xD1\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA9"],
        ["\xD1\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB3"],
        ["\xD1\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBF"],
        ["\xD1\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBD"],
        ["\xD1\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x8D"],
        ["\xD1\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x94"],
        ["\xD1\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x92"],
        ["\xD1\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB1"],
        ["\xD1\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x88"],
        ["\xD1\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x91"],
        ["\xD1\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA8"],
        ["\xD2\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA7"],
        ["\xD2\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAC"],
        ["\xD2\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAD"],
        ["\xD2\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBC"],
        ["\xD2\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB5"],
        ["\xD2\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x81"],
        ["\xD2\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8D"],
        ["\xD2\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x97"],
        ["\xD2\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9E"],
        ["\xD2\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA3"],
        ["\xD2\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA6"],
        ["\xD2\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAD"],
        ["\xD2\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA0"],
        ["\xD2\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB3"],
        ["\xD2\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB5"],
        ["\xD2\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB8"],
        ["\xD2\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB9"],
        ["\xD2\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x86"],
        ["\xD2\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x88"],
        ["\xD2\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB8"],
        ["\xD2\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8D"],
        ["\xD2\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x90"],
        ["\xD2\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8F"],
        ["\xD2\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x95"],
        ["\xD2\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9A"],
        ["\xD2\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA3"],
        ["\xD2\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAF"],
        ["\xD2\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB1"],
        ["\xD2\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB3"],
        ["\xD2\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB8"],
        ["\xD2\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x80"],
        ["\xD2\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x86"],
        ["\xD2\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x85"],
        ["\xD2\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x97"],
        ["\xD2\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x89"],
        ["\xD2\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8D"],
        ["\xD2\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x96"],
        ["\xD2\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9E"],
        ["\xD2\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA9"],
        ["\xD2\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAE"],
        ["\xD2\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x98"],
        ["\xD2\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBB"],
        ["\xD2\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB7"],
        ["\xD2\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x82"],
        ["\xD2\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x96"],
        ["\xD2\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA0"],
        ["\xD2\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA6"],
        ["\xD2\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA5"],
        ["\xD2\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAE"],
        ["\xD2\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB0"],
        ["\xD2\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB6"],
        ["\xD2\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x83"],
        ["\xD2\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x92"],
        ["\xD2\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x99"],
        ["\xD2\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9F"],
        ["\xD2\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBC"],
        ["\xD2\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAE"],
        ["\xD2\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAE"],
        ["\xD2\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA8"],
        ["\xD2\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAD"],
        ["\xD2\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xBA"],
        ["\xD2\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x81"],
        ["\xD2\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBD"],
        ["\xD2\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x80"],
        ["\xD2\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAC"],
        ["\xD2\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAD"],
        ["\xD2\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBC"],
        ["\xD2\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAE"],
        ["\xD2\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB6"],
        ["\xD2\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA9"],
        ["\xD2\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9D"],
        ["\xD2\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8E"],
        ["\xD2\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8F"],
        ["\xD2\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB5"],
        ["\xD2\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8E"],
        ["\xD2\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x9F"],
        ["\xD2\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB1"],
        ["\xD2\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB7"],
        ["\xD2\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB0"],
        ["\xD2\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x92"],
        ["\xD2\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBB"],
        ["\xD2\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x80"],
        ["\xD2\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB6"],
        ["\xD2\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x84"],
        ["\xD2\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x90"],
        ["\xD2\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x86"],
        ["\xD2\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x87"],
        ["\xD2\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA2"],
        ["\xD2\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB8"],
        ["\xD2\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA5"],
        ["\xD2\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAC"],
        ["\xD2\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x84"],
        ["\xD2\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x88"],
        ["\xD2\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA8"],
        ["\xD3\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAB"],
        ["\xD3\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x82"],
        ["\xD3\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA4"],
        ["\xD3\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBE"],
        ["\xD3\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBC"],
        ["\xD3\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x98"],
        ["\xD3\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA5"],
        ["\xD3\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA6"],
        ["\xD3\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8F"],
        ["\xD3\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x94"],
        ["\xD3\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBD"],
        ["\xD3\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAE"],
        ["\xD3\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAD"],
        ["\xD3\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBA"],
        ["\xD3\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA2"],
        ["\xD3\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB9"],
        ["\xD3\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x80"],
        ["\xD3\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA3"],
        ["\xD3\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8C"],
        ["\xD3\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAE"],
        ["\xD3\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9C"],
        ["\xD3\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x85"],
        ["\xD3\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x96"],
        ["\xD3\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x97"],
        ["\xD3\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB8"],
        ["\xD3\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB3"],
        ["\xD3\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9D"],
        ["\xD3\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x99"],
        ["\xD3\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x80"],
        ["\xD3\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAF"],
        ["\xD3\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8A"],
        ["\xD3\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9F"],
        ["\xD3\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBB"],
        ["\xD3\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBE"],
        ["\xD3\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x98"],
        ["\xD3\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9E"],
        ["\xD3\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAE"],
        ["\xD3\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBC"],
        ["\xD3\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x83"],
        ["\xD3\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA9"],
        ["\xD3\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x87"],
        ["\xD3\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA8"],
        ["\xD3\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9A"],
        ["\xD3\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x85"],
        ["\xD3\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9F"],
        ["\xD3\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x84"],
        ["\xD3\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9C"],
        ["\xD3\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA4"],
        ["\xD3\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x94"],
        ["\xD3\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x94"],
        ["\xD3\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB7"],
        ["\xD3\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x96"],
        ["\xD3\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBE"],
        ["\xD3\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBD"],
        ["\xD3\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x9B"],
        ["\xD3\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB9"],
        ["\xD3\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8E"],
        ["\xD3\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x90"],
        ["\xD3\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9F"],
        ["\xD3\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB4"],
        ["\xD3\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB6"],
        ["\xD3\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB2"],
        ["\xD3\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB8"],
        ["\xD3\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAB"],
        ["\xD3\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA4"],
        ["\xD3\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xAF"],
        ["\xD3\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAC"],
        ["\xD3\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAA"],
        ["\xD3\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x86"],
        ["\xD3\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x80"],
        ["\xD3\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8A"],
        ["\xD3\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA0"],
        ["\xD3\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x94"],
        ["\xD3\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8F"],
        ["\xD3\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA5"],
        ["\xD3\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAE"],
        ["\xD3\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB6"],
        ["\xD3\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB4"],
        ["\xD3\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x82"],
        ["\xD3\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xBC"],
        ["\xD3\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x81"],
        ["\xD3\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x83"],
        ["\xD3\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x80"],
        ["\xD3\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x88"],
        ["\xD3\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8E"],
        ["\xD3\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x91"],
        ["\xD3\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x93"],
        ["\xD3\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x97"],
        ["\xD3\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xAE"],
        ["\xD3\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB9"],
        ["\xD3\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x80"],
        ["\xD3\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBF"],
        ["\xD3\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x84"],
        ["\xD3\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x89"],
        ["\xD4\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x88"],
        ["\xD4\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8B"],
        ["\xD4\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8D"],
        ["\xD4\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x93"],
        ["\xD4\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x98"],
        ["\xD4\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x96"],
        ["\xD4\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x87"],
        ["\xD4\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9C"],
        ["\xD4\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA6"],
        ["\xD4\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB7"],
        ["\xD4\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB8"],
        ["\xD4\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8E"],
        ["\xD4\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xBB"],
        ["\xD4\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x80"],
        ["\xD4\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8F"],
        ["\xD4\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA9"],
        ["\xD4\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x80"],
        ["\xD4\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x88"],
        ["\xD4\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA1"],
        ["\xD4\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBF"],
        ["\xD4\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x89"],
        ["\xD4\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x93"],
        ["\xD4\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA0"],
        ["\xD4\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB3"],
        ["\xD4\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA4"],
        ["\xD4\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAA"],
        ["\xD4\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB0"],
        ["\xD4\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x83"],
        ["\xD4\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x86"],
        ["\xD4\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x94"],
        ["\xD4\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x92"],
        ["\xD4\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x93"],
        ["\xD4\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8A"],
        ["\xD4\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x96"],
        ["\xD4\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA3"],
        ["\xD4\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8B"],
        ["\xD4\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x99"],
        ["\xD4\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9D"],
        ["\xD4\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB2"],
        ["\xD4\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA1"],
        ["\xD4\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA2"],
        ["\xD4\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8B"],
        ["\xD4\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB0"],
        ["\xD4\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x80"],
        ["\xD4\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x92"],
        ["\xD4\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBD"],
        ["\xD4\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB9"],
        ["\xD4\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x85"],
        ["\xD4\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB9"],
        ["\xD4\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9F"],
        ["\xD4\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAB"],
        ["\xD4\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBA"],
        ["\xD4\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9E"],
        ["\xD4\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBB"],
        ["\xD4\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB8"],
        ["\xD4\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAE"],
        ["\xD4\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x85"],
        ["\xD4\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x93"],
        ["\xD4\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x91"],
        ["\xD4\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x97"],
        ["\xD4\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x99"],
        ["\xD4\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x98"],
        ["\xD4\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA5"],
        ["\xD4\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9C"],
        ["\xD4\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA4"],
        ["\xD4\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9F"],
        ["\xD4\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAF"],
        ["\xD4\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBA"],
        ["\xD4\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB9"],
        ["\xD4\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBB"],
        ["\xD4\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBC"],
        ["\xD4\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBD"],
        ["\xD4\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x82"],
        ["\xD4\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8A"],
        ["\xD4\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x90"],
        ["\xD4\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9B"],
        ["\xD4\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA6"],
        ["\xD4\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA5"],
        ["\xD4\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAC"],
        ["\xD4\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAD"],
        ["\xD4\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB2"],
        ["\xD4\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB8"],
        ["\xD4\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBE"],
        ["\xD4\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x92"],
        ["\xD4\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x95"],
        ["\xD4\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x90"],
        ["\xD4\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8E"],
        ["\xD4\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9A"],
        ["\xD4\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x98"],
        ["\xD4\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA2"],
        ["\xD4\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA0"],
        ["\xD4\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA7"],
        ["\xD4\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAC"],
        ["\xD4\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA9"],
        ["\xD5\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB8"],
        ["\xD5\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x81"],
        ["\xD5\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9D"],
        ["\xD5\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9E"],
        ["\xD5\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAB"],
        ["\xD5\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA3"],
        ["\xD5\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB2"],
        ["\xD5\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x86"],
        ["\xD5\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA8"],
        ["\xD5\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9C"],
        ["\xD5\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8D"],
        ["\xD5\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x99"],
        ["\xD5\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9A"],
        ["\xD5\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA5"],
        ["\xD5\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9F"],
        ["\xD5\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x91"],
        ["\xD5\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9C"],
        ["\xD5\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x89"],
        ["\xD5\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9A"],
        ["\xD5\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x80"],
        ["\xD5\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAC"],
        ["\xD5\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x89"],
        ["\xD5\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB5"],
        ["\xD5\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB6"],
        ["\xD5\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA2"],
        ["\xD5\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAA"],
        ["\xD5\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9A"],
        ["\xD5\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBC"],
        ["\xD5\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBE"],
        ["\xD5\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8B"],
        ["\xD5\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x82"],
        ["\xD5\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBD"],
        ["\xD5\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA3"],
        ["\xD5\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x97"],
        ["\xD5\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA6"],
        ["\xD5\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA9"],
        ["\xD5\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x96"],
        ["\xD5\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBA"],
        ["\xD5\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBB"],
        ["\xD5\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8C"],
        ["\xD5\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8B"],
        ["\xD5\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x96"],
        ["\xD5\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB2"],
        ["\xD5\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x90"],
        ["\xD5\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAA"],
        ["\xD5\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB6"],
        ["\xD5\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xBE"],
        ["\xD5\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x83"],
        ["\xD5\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x85"],
        ["\xD5\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x80"],
        ["\xD5\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x91"],
        ["\xD5\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x95"],
        ["\xD5\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9A"],
        ["\xD5\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9B"],
        ["\xD5\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA5"],
        ["\xD5\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA9"],
        ["\xD5\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB0"],
        ["\xD5\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB3"],
        ["\xD5\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB5"],
        ["\xD5\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB8"],
        ["\xD5\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x88"],
        ["\xD5\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBA"],
        ["\xD5\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x80"],
        ["\xD5\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x83"],
        ["\xD5\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA6"],
        ["\xD5\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB8"],
        ["\xD5\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x83"],
        ["\xD5\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x87"],
        ["\xD5\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x89"],
        ["\xD5\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x94"],
        ["\xD5\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x90"],
        ["\xD5\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA4"],
        ["\xD5\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA6"],
        ["\xD5\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA2"],
        ["\xD5\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9E"],
        ["\xD5\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA5"],
        ["\xD5\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAB"],
        ["\xD5\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB0"],
        ["\xD5\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB6"],
        ["\xD5\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB3"],
        ["\xD5\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x85"],
        ["\xD5\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x87"],
        ["\xD5\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x88"],
        ["\xD5\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8D"],
        ["\xD5\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x93"],
        ["\xD5\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA0"],
        ["\xD5\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA2"],
        ["\xD5\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA8"],
        ["\xD5\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB8"],
        ["\xD5\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB9"],
        ["\xD5\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x81"],
        ["\xD5\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x86"],
        ["\xD5\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8E"],
        ["\xD5\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x93"],
        ["\xD6\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x90"],
        ["\xD6\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8F"],
        ["\xD6\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB1"],
        ["\xD6\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAC"],
        ["\xD6\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAE"],
        ["\xD6\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA2"],
        ["\xD6\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB6"],
        ["\xD6\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB9"],
        ["\xD6\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8C"],
        ["\xD6\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x91"],
        ["\xD6\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x94"],
        ["\xD6\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9B"],
        ["\xD6\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAB"],
        ["\xD6\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBB"],
        ["\xD6\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB6"],
        ["\xD6\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBC"],
        ["\xD6\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB7"],
        ["\xD6\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x85"],
        ["\xD6\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBE"],
        ["\xD6\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x87"],
        ["\xD6\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x99"],
        ["\xD6\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA9"],
        ["\xD6\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBD"],
        ["\xD6\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBA"],
        ["\xD6\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAD"],
        ["\xD6\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8C"],
        ["\xD6\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAA"],
        ["\xD6\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8B"],
        ["\xD6\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x95"],
        ["\xD6\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x97"],
        ["\xD6\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x9C"],
        ["\xD6\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9F"],
        ["\xD6\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9B"],
        ["\xD6\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x91"],
        ["\xD6\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x94"],
        ["\xD6\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA2"],
        ["\xD6\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9A"],
        ["\xD6\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x99"],
        ["\xD6\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x98"],
        ["\xD6\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8C"],
        ["\xD6\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x92"],
        ["\xD6\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8E"],
        ["\xD6\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8B"],
        ["\xD6\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAC"],
        ["\xD6\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB3"],
        ["\xD6\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB6"],
        ["\xD6\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x87"],
        ["\xD6\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x84"],
        ["\xD6\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x82"],
        ["\xD6\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA2"],
        ["\xD6\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x9D"],
        ["\xD6\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAC"],
        ["\xD6\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAE"],
        ["\xD6\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBD"],
        ["\xD6\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x90"],
        ["\xD6\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB7"],
        ["\xD6\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBC"],
        ["\xD6\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x89"],
        ["\xD6\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8D"],
        ["\xD6\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x93"],
        ["\xD6\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x92"],
        ["\xD6\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x96"],
        ["\xD6\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9B"],
        ["\xD6\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAB"],
        ["\xD6\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB2"],
        ["\xD6\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB5"],
        ["\xD6\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8B"],
        ["\xD6\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9A"],
        ["\xD6\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x99"],
        ["\xD6\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x91"],
        ["\xD6\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9B"],
        ["\xD6\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB6"],
        ["\xD6\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB7"],
        ["\xD6\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x84"],
        ["\xD6\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x83"],
        ["\xD6\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x80"],
        ["\xD6\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8E"],
        ["\xD6\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x97"],
        ["\xD6\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x94"],
        ["\xD6\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9F"],
        ["\xD6\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA2"],
        ["\xD6\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA4"],
        ["\xD6\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x87"],
        ["\xD6\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB5"],
        ["\xD6\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB6"],
        ["\xD6\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBA"],
        ["\xD6\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBC"],
        ["\xD6\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBF"],
        ["\xD6\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA0"],
        ["\xD6\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x81"],
        ["\xD6\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x82"],
        ["\xD6\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x88"],
        ["\xD6\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x90"],
        ["\xD6\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8F"],
        ["\xD7\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x96"],
        ["\xD7\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA3"],
        ["\xD7\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9D"],
        ["\xD7\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9A"],
        ["\xD7\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9B"],
        ["\xD7\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA2"],
        ["\xD7\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA1"],
        ["\xD7\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA8"],
        ["\xD7\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA9"],
        ["\xD7\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xAC"],
        ["\xD7\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB1"],
        ["\xD7\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB3"],
        ["\xD7\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB0"],
        ["\xD7\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB4"],
        ["\xD7\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB8"],
        ["\xD7\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBE"],
        ["\xD7\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x83"],
        ["\xD7\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x89"],
        ["\xD7\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9D"],
        ["\xD7\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9C"],
        ["\xD7\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8B"],
        ["\xD7\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x91"],
        ["\xD7\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x96"],
        ["\xD7\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA9"],
        ["\xD7\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAD"],
        ["\xD7\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB8"],
        ["\xD7\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x88"],
        ["\xD7\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8C"],
        ["\xD7\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8E"],
        ["\xD7\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAF"],
        ["\xD7\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x91"],
        ["\xD7\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x96"],
        ["\xD7\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x97"],
        ["\xD7\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x99"],
        ["\xD7\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA1"],
        ["\xD7\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAD"],
        ["\xD7\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB3"],
        ["\xD7\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB7"],
        ["\xD7\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x83"],
        ["\xD7\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x82"],
        ["\xD7\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBF"],
        ["\xD7\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8A"],
        ["\xD7\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x88"],
        ["\xD7\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x91"],
        ["\xD7\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x87"],
        ["\xD7\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9E"],
        ["\xD7\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x99"],
        ["\xD7\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x98"],
        ["\xD7\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA0"],
        ["\xD7\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA8"],
        ["\xD7\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAD"],
        ["\xD7\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBC"],
        ["\xD7\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x96"],
        ["\xD7\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBB"],
        ["\xD7\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA4"],
        ["\xD7\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB8"],
        ["\xD7\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB1"],
        ["\xD7\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9D"],
        ["\xD7\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB3"],
        ["\xD7\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBF"],
        ["\xD7\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA1"],
        ["\xD7\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA0"],
        ["\xD7\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x99"],
        ["\xD7\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x90"],
        ["\xD7\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA9"],
        ["\xD7\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8E"],
        ["\xD7\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB1"],
        ["\xD7\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9B"],
        ["\xD7\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x95"],
        ["\xD7\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAB"],
        ["\xD7\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA6"],
        ["\xD7\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8F"],
        ["\xD7\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xBA"],
        ["\xD7\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9A"],
        ["\xD7\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x81"],
        ["\xD7\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAA"],
        ["\xD7\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB7"],
        ["\xD7\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9F"],
        ["\xD7\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8A"],
        ["\xD7\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x86"],
        ["\xD7\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8D"],
        ["\xD7\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA3"],
        ["\xD7\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x83"],
        ["\xD7\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA4"],
        ["\xD7\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x82"],
        ["\xD7\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAC"],
        ["\xD7\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAB"],
        ["\xD7\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x99"],
        ["\xD7\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x81"],
        ["\xD7\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8D"],
        ["\xD7\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA7"],
        ["\xD7\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x83"],
        ["\xD7\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9A"],
        ["\xD8\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x84"],
        ["\xD8\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9B"],
        ["\xD8\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x96"],
        ["\xD8\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x97"],
        ["\xD8\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x92"],
        ["\xD8\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA7"],
        ["\xD8\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8B"],
        ["\xD8\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA1"],
        ["\xD8\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB8"],
        ["\xD8\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA0"],
        ["\xD8\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x93"],
        ["\xD8\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB4"],
        ["\xD8\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB0"],
        ["\xD8\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBD"],
        ["\xD8\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x86"],
        ["\xD8\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB5"],
        ["\xD8\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x98"],
        ["\xD8\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8D"],
        ["\xD8\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x95"],
        ["\xD8\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x86"],
        ["\xD8\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB6"],
        ["\xD8\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB7"],
        ["\xD8\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x80"],
        ["\xD8\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB4"],
        ["\xD8\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBA"],
        ["\xD8\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x83"],
        ["\xD8\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA1"],
        ["\xD8\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBB"],
        ["\xD8\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB1"],
        ["\xD8\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8D"],
        ["\xD8\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8E"],
        ["\xD8\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x87"],
        ["\xD8\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBE"],
        ["\xD8\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA8"],
        ["\xD8\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA7"],
        ["\xD8\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8A"],
        ["\xD8\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBF"],
        ["\xD8\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBC"],
        ["\xD8\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAC"],
        ["\xD8\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB4"],
        ["\xD8\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBD"],
        ["\xD8\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x82"],
        ["\xD8\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x84"],
        ["\xD8\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB3"],
        ["\xD8\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB7"],
        ["\xD8\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x98"],
        ["\xD8\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x99"],
        ["\xD8\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9A"],
        ["\xD8\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAB"],
        ["\xD8\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB4"],
        ["\xD8\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAF"],
        ["\xD8\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA5"],
        ["\xD8\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB1"],
        ["\xD8\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9F"],
        ["\xD8\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9D"],
        ["\xD8\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x93"],
        ["\xD8\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB5"],
        ["\xD8\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x99"],
        ["\xD8\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x96"],
        ["\xD8\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x87"],
        ["\xD8\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAC"],
        ["\xD8\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x94"],
        ["\xD8\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x9A"],
        ["\xD8\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8A"],
        ["\xD8\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x91"],
        ["\xD8\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAB"],
        ["\xD8\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAE"],
        ["\xD8\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8C"],
        ["\xD8\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8A"],
        ["\xD8\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x89"],
        ["\xD8\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB7"],
        ["\xD8\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x88"],
        ["\xD8\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x83"],
        ["\xD8\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x86"],
        ["\xD8\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBA"],
        ["\xD8\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8B"],
        ["\xD8\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB9"],
        ["\xD8\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8D"],
        ["\xD8\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA6"],
        ["\xD8\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA3"],
        ["\xD8\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB6"],
        ["\xD8\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBA"],
        ["\xD8\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB4"],
        ["\xD8\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBF"],
        ["\xD8\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBD"],
        ["\xD8\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBC"],
        ["\xD8\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBE"],
        ["\xD8\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x80"],
        ["\xD8\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x88"],
        ["\xD8\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x89"],
        ["\xD8\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8D"],
        ["\xD8\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8C"],
        ["\xD8\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x94"],
        ["\xD8\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9B"],
        ["\xD9\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9E"],
        ["\xD9\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA1"],
        ["\xD9\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAA"],
        ["\xD9\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAE"],
        ["\xD9\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB0"],
        ["\xD9\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB2"],
        ["\xD9\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB3"],
        ["\xD9\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x81"],
        ["\xD9\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8E"],
        ["\xD9\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9E"],
        ["\xD9\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA3"],
        ["\xD9\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9B"],
        ["\xD9\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA0"],
        ["\xD9\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA8"],
        ["\xD9\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBC"],
        ["\xD9\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x82"],
        ["\xD9\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x89"],
        ["\xD9\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBE"],
        ["\xD9\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x92"],
        ["\xD9\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x93"],
        ["\xD9\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x96"],
        ["\xD9\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x94"],
        ["\xD9\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x83"],
        ["\xD9\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x94"],
        ["\xD9\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x97"],
        ["\xD9\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x91"],
        ["\xD9\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBB"],
        ["\xD9\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8F"],
        ["\xD9\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBF"],
        ["\xD9\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x86"],
        ["\xD9\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x94"],
        ["\xD9\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x88"],
        ["\xD9\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9C"],
        ["\xD9\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8C"],
        ["\xD9\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8A"],
        ["\xD9\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x82"],
        ["\xD9\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x87"],
        ["\xD9\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9B"],
        ["\xD9\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x89"],
        ["\xD9\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8C"],
        ["\xD9\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAE"],
        ["\xD9\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB1"],
        ["\xD9\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA7"],
        ["\xD9\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x82"],
        ["\xD9\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x88"],
        ["\xD9\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAF"],
        ["\xD9\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB5"],
        ["\xD9\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x90"],
        ["\xD9\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBE"],
        ["\xD9\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8D"],
        ["\xD9\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9C"],
        ["\xD9\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8F"],
        ["\xD9\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x96"],
        ["\xD9\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8E"],
        ["\xD9\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x80"],
        ["\xD9\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAB"],
        ["\xD9\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB6"],
        ["\xD9\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA3"],
        ["\xD9\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8F"],
        ["\xD9\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x89"],
        ["\xD9\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9F"],
        ["\xD9\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB5"],
        ["\xD9\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAB"],
        ["\xD9\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA9"],
        ["\xD9\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBE"],
        ["\xD9\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA9"],
        ["\xD9\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x80"],
        ["\xD9\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x86"],
        ["\xD9\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA3"],
        ["\xD9\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x89"],
        ["\xD9\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x92"],
        ["\xD9\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB6"],
        ["\xD9\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x84"],
        ["\xD9\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x96"],
        ["\xD9\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB4"],
        ["\xD9\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x86"],
        ["\xD9\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x93"],
        ["\xD9\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA6"],
        ["\xD9\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB6"],
        ["\xD9\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9D"],
        ["\xD9\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x97"],
        ["\xD9\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA8"],
        ["\xD9\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8F"],
        ["\xD9\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA7"],
        ["\xD9\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAF"],
        ["\xD9\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB6"],
        ["\xD9\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x8E"],
        ["\xD9\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAA"],
        ["\xD9\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x95"],
        ["\xD9\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x93"],
        ["\xD9\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA5"],
        ["\xD9\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA9"],
        ["\xD9\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x88"],
        ["\xD9\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBC"],
        ["\xDA\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x9A"],
        ["\xDA\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x92"],
        ["\xDA\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x85"],
        ["\xDA\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x87"],
        ["\xDA\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBB"],
        ["\xDA\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x98"],
        ["\xDA\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x82"],
        ["\xDA\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB1"],
        ["\xDA\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA7"],
        ["\xDA\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x89"],
        ["\xDA\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA0"],
        ["\xDA\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA1"],
        ["\xDA\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAC"],
        ["\xDA\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA3"],
        ["\xDA\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAF"],
        ["\xDA\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAC"],
        ["\xDA\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB6"],
        ["\xDA\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB4"],
        ["\xDA\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB2"],
        ["\xDA\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBA"],
        ["\xDA\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x80"],
        ["\xDA\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBD"],
        ["\xDA\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x98"],
        ["\xDA\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9C"],
        ["\xDA\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x85"],
        ["\xDA\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA4"],
        ["\xDA\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA3"],
        ["\xDA\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAB"],
        ["\xDA\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB4"],
        ["\xDA\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB5"],
        ["\xDA\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB7"],
        ["\xDA\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB6"],
        ["\xDA\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB8"],
        ["\xDA\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8B"],
        ["\xDA\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x88"],
        ["\xDA\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x96"],
        ["\xDA\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x95"],
        ["\xDA\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8D"],
        ["\xDA\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x98"],
        ["\xDA\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9E"],
        ["\xDA\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9D"],
        ["\xDA\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB2"],
        ["\xDA\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB8"],
        ["\xDA\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x82"],
        ["\xDA\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x83"],
        ["\xDA\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8A"],
        ["\xDA\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9B"],
        ["\xDA\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9F"],
        ["\xDA\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAB"],
        ["\xDA\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB7"],
        ["\xDA\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x83"],
        ["\xDA\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x86"],
        ["\xDA\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x81"],
        ["\xDA\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x84"],
        ["\xDA\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8C"],
        ["\xDA\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x92"],
        ["\xDA\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x9B"],
        ["\xDA\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x99"],
        ["\xDA\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA0"],
        ["\xDA\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA1"],
        ["\xDA\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB1"],
        ["\xDA\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB2"],
        ["\xDA\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8A"],
        ["\xDA\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x83"],
        ["\xDA\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBB"],
        ["\xDA\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB3"],
        ["\xDA\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB5"],
        ["\xDA\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB6"],
        ["\xDA\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB4"],
        ["\xDA\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9C"],
        ["\xDA\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8F"],
        ["\xDA\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x84"],
        ["\xDA\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x89"],
        ["\xDA\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x81"],
        ["\xDA\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9E"],
        ["\xDA\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9D"],
        ["\xDA\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA4"],
        ["\xDA\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA7"],
        ["\xDA\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA8"],
        ["\xDA\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9F"],
        ["\xDA\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA2"],
        ["\xDA\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB0"],
        ["\xDA\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x83"],
        ["\xDA\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x88"],
        ["\xDA\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8E"],
        ["\xDA\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x89"],
        ["\xDA\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x84"],
        ["\xDA\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x98"],
        ["\xDA\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x9D"],
        ["\xDA\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x81"],
        ["\xDA\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB9"],
        ["\xDA\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x89"],
        ["\xDA\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBE"],
        ["\xDA\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBC"],
        ["\xDB\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x84"],
        ["\xDB\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB8"],
        ["\xDB\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x96"],
        ["\xDB\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9A"],
        ["\xDB\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA0"],
        ["\xDB\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBF"],
        ["\xDB\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA6"],
        ["\xDB\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA9"],
        ["\xDB\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB0"],
        ["\xDB\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB5"],
        ["\xDB\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB7"],
        ["\xDB\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8F"],
        ["\xDB\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x96"],
        ["\xDB\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9E"],
        ["\xDB\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA6"],
        ["\xDB\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA7"],
        ["\xDB\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB8"],
        ["\xDB\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAE"],
        ["\xDB\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBF"],
        ["\xDB\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB6"],
        ["\xDB\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x81"],
        ["\xDB\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB8"],
        ["\xDB\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB7"],
        ["\xDB\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x86"],
        ["\xDB\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9E"],
        ["\xDB\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA0"],
        ["\xDB\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x99"],
        ["\xDB\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA3"],
        ["\xDB\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA4"],
        ["\xDB\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x89"],
        ["\xDB\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB0"],
        ["\xDB\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA9"],
        ["\xDB\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBC"],
        ["\xDB\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAA"],
        ["\xDB\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8C"],
        ["\xDB\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8B"],
        ["\xDB\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA6"],
        ["\xDB\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA1"],
        ["\xDB\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x85"],
        ["\xDB\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB7"],
        ["\xDB\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAF"],
        ["\xDB\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB4"],
        ["\xDB\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAC"],
        ["\xDB\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB3"],
        ["\xDB\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA9"],
        ["\xDB\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB8"],
        ["\xDB\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA4"],
        ["\xDB\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9E"],
        ["\xDB\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9D"],
        ["\xDB\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA2"],
        ["\xDB\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAE"],
        ["\xDB\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB9"],
        ["\xDB\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8E"],
        ["\xDB\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x86"],
        ["\xDB\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA7"],
        ["\xDB\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9C"],
        ["\xDB\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9E"],
        ["\xDB\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x86"],
        ["\xDB\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA9"],
        ["\xDB\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x80"],
        ["\xDB\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8D"],
        ["\xDB\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB2"],
        ["\xDB\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8E"],
        ["\xDB\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB3"],
        ["\xDB\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAB"],
        ["\xDB\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x99"],
        ["\xDB\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA3"],
        ["\xDB\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB7"],
        ["\xDB\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBF"],
        ["\xDB\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9F"],
        ["\xDB\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8F"],
        ["\xDB\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAD"],
        ["\xDB\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x94"],
        ["\xDB\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9D"],
        ["\xDB\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9B"],
        ["\xDB\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x83"],
        ["\xDB\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAE"],
        ["\xDB\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB9"],
        ["\xDB\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB4"],
        ["\xDB\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB5"],
        ["\xDB\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA0"],
        ["\xDB\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBA"],
        ["\xDB\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8F"],
        ["\xDB\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8D"],
        ["\xDB\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBE"],
        ["\xDB\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x81"],
        ["\xDB\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8A"],
        ["\xDB\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x88"],
        ["\xDB\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x98"],
        ["\xDB\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA2"],
        ["\xDB\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA6"],
        ["\xDB\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA1"],
        ["\xDB\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8C"],
        ["\xDB\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8D"],
        ["\xDC\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x94"],
        ["\xDC\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA7"],
        ["\xDC\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x95"],
        ["\xDC\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB6"],
        ["\xDC\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x92"],
        ["\xDC\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x84"],
        ["\xDC\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x97"],
        ["\xDC\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA3"],
        ["\xDC\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA5"],
        ["\xDC\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB9"],
        ["\xDC\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA0"],
        ["\xDC\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAF"],
        ["\xDC\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA8"],
        ["\xDC\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xAA"],
        ["\xDC\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9A"],
        ["\xDC\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA3"],
        ["\xDC\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA1"],
        ["\xDC\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x86"],
        ["\xDC\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB9"],
        ["\xDC\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB7"],
        ["\xDC\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9C"],
        ["\xDC\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB8"],
        ["\xDC\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAB"],
        ["\xDC\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x94"],
        ["\xDC\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBE"],
        ["\xDC\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAE"],
        ["\xDC\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB9"],
        ["\xDC\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB4"],
        ["\xDC\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBD"],
        ["\xDC\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x99"],
        ["\xDC\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB0"],
        ["\xDC\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA1"],
        ["\xDC\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9E"],
        ["\xDC\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9D"],
        ["\xDC\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x81"],
        ["\xDC\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAA"],
        ["\xDC\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB2"],
        ["\xDC\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAE"],
        ["\xDC\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x90"],
        ["\xDC\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBF"],
        ["\xDC\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x81"],
        ["\xDC\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x93"],
        ["\xDC\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBE"],
        ["\xDC\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8E"],
        ["\xDC\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA8"],
        ["\xDC\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8A"],
        ["\xDC\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9D"],
        ["\xDC\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBB"],
        ["\xDC\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x83"],
        ["\xDC\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA7"],
        ["\xDC\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAE"],
        ["\xDC\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x91"],
        ["\xDC\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA0"],
        ["\xDC\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9C"],
        ["\xDC\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x95"],
        ["\xDC\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB4"],
        ["\xDC\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9E"],
        ["\xDC\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA8"],
        ["\xDC\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x82"],
        ["\xDC\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9B"],
        ["\xDC\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBF"],
        ["\xDC\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8A"],
        ["\xDC\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB9"],
        ["\xDC\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB2"],
        ["\xDC\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA7"],
        ["\xDC\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x85"],
        ["\xDC\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB1"],
        ["\xDC\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9E"],
        ["\xDC\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAD"],
        ["\xDC\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x94"],
        ["\xDC\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAB"],
        ["\xDC\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8A"],
        ["\xDC\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x92"],
        ["\xDC\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x81"],
        ["\xDC\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA3"],
        ["\xDC\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x93"],
        ["\xDC\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x84"],
        ["\xDC\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8C"],
        ["\xDC\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB2"],
        ["\xDC\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB6"],
        ["\xDC\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB8"],
        ["\xDC\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x87"],
        ["\xDC\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA2"],
        ["\xDC\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x99"],
        ["\xDC\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA6"],
        ["\xDC\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x88"],
        ["\xDC\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB8"],
        ["\xDC\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA2"],
        ["\xDC\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x90"],
        ["\xDC\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8D"],
        ["\xDC\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA0"],
        ["\xDC\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x84"],
        ["\xDC\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA2"],
        ["\xDC\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA3"],
        ["\xDD\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x97"],
        ["\xDD\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x97"],
        ["\xDD\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBB"],
        ["\xDD\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x83"],
        ["\xDD\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x82"],
        ["\xDD\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB8"],
        ["\xDD\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB3"],
        ["\xDD\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAC"],
        ["\xDD\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9E"],
        ["\xDD\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x91"],
        ["\xDD\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9F"],
        ["\xDD\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAA"],
        ["\xDD\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9A"],
        ["\xDD\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAA"],
        ["\xDD\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBB"],
        ["\xDD\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x85"],
        ["\xDD\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x96"],
        ["\xDD\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBA"],
        ["\xDD\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x92"],
        ["\xDD\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x96"],
        ["\xDD\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB1"],
        ["\xDD\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9F"],
        ["\xDD\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB8"],
        ["\xDD\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB7"],
        ["\xDD\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9C"],
        ["\xDD\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB9"],
        ["\xDD\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAE"],
        ["\xDD\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x87"],
        ["\xDD\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x83"],
        ["\xDD\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x89"],
        ["\xDD\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x90"],
        ["\xDD\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x99"],
        ["\xDD\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x94"],
        ["\xDD\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9B"],
        ["\xDD\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9F"],
        ["\xDD\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA1"],
        ["\xDD\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB8"],
        ["\xDD\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB9"],
        ["\xDD\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBF"],
        ["\xDD\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x80"],
        ["\xDD\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x84"],
        ["\xDD\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x83"],
        ["\xDD\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8D"],
        ["\xDD\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x98"],
        ["\xDD\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x95"],
        ["\xDD\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9E"],
        ["\xDD\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA4"],
        ["\xDD\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAA"],
        ["\xDD\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAB"],
        ["\xDD\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAF"],
        ["\xDD\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB2"],
        ["\xDD\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB1"],
        ["\xDD\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB3"],
        ["\xDD\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB7"],
        ["\xDD\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBC"],
        ["\xDD\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x86"],
        ["\xDD\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8B"],
        ["\xDD\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x93"],
        ["\xDD\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9F"],
        ["\xDD\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAC"],
        ["\xDD\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAB"],
        ["\xDD\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB3"],
        ["\xDD\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAF"],
        ["\xDD\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBE"],
        ["\xDD\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x88"],
        ["\xDD\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x93"],
        ["\xDD\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x94"],
        ["\xDD\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x9B"],
        ["\xDD\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA4"],
        ["\xDD\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA3"],
        ["\xDD\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9E"],
        ["\xDD\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x95"],
        ["\xDD\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA2"],
        ["\xDD\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAA"],
        ["\xDD\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x82"],
        ["\xDD\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8D"],
        ["\xDD\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9A"],
        ["\xDD\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x81"],
        ["\xDD\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9B"],
        ["\xDD\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBE"],
        ["\xDD\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA8"],
        ["\xDD\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB3"],
        ["\xDD\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x92"],
        ["\xDD\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x90"],
        ["\xDD\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x84"],
        ["\xDD\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB1"],
        ["\xDD\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x93"],
        ["\xDD\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBD"],
        ["\xDD\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x97"],
        ["\xDD\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x85"],
        ["\xDD\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9D"],
        ["\xDD\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAE"],
        ["\xDD\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB1"],
        ["\xDD\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBE"],
        ["\xDE\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBA"],
        ["\xDE\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9B"],
        ["\xDE\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAF"],
        ["\xDE\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x99"],
        ["\xDE\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAA"],
        ["\xDE\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9F"],
        ["\xDE\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8D"],
        ["\xDE\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB6"],
        ["\xDE\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAB"],
        ["\xDE\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBD"],
        ["\xDE\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB8"],
        ["\xDE\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x99"],
        ["\xDE\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB5"],
        ["\xDE\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB3"],
        ["\xDE\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x92"],
        ["\xDE\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8C"],
        ["\xDE\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA3"],
        ["\xDE\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x93"],
        ["\xDE\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA4"],
        ["\xDE\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9A"],
        ["\xDE\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB9"],
        ["\xDE\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x99"],
        ["\xDE\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8E"],
        ["\xDE\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x95"],
        ["\xDE\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA4"],
        ["\xDE\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x85"],
        ["\xDE\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB9"],
        ["\xDE\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x95"],
        ["\xDE\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8A"],
        ["\xDE\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB5"],
        ["\xDE\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x87"],
        ["\xDE\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA6"],
        ["\xDE\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB8"],
        ["\xDE\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x86"],
        ["\xDE\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAC"],
        ["\xDE\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9E"],
        ["\xDE\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8C"],
        ["\xDE\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA8"],
        ["\xDE\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x92"],
        ["\xDE\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x85"],
        ["\xDE\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBA"],
        ["\xDE\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x99"],
        ["\xDE\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA4"],
        ["\xDE\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x95"],
        ["\xDE\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAA"],
        ["\xDE\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAE"],
        ["\xDE\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAD"],
        ["\xDE\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAE"],
        ["\xDE\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAE"],
        ["\xDE\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x99"],
        ["\xDE\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB2"],
        ["\xDE\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9F"],
        ["\xDE\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBE"],
        ["\xDE\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA3"],
        ["\xDE\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAB"],
        ["\xDE\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAB"],
        ["\xDE\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB6"],
        ["\xDE\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8D"],
        ["\xDE\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9F"],
        ["\xDE\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x83"],
        ["\xDE\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBA"],
        ["\xDE\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8E"],
        ["\xDE\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA4"],
        ["\xDE\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBF"],
        ["\xDE\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9D"],
        ["\xDE\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB8"],
        ["\xDE\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x82"],
        ["\xDE\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAA"],
        ["\xDE\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x98"],
        ["\xDE\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x89"],
        ["\xDE\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB7"],
        ["\xDE\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x93"],
        ["\xDE\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBD"],
        ["\xDE\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAF"],
        ["\xDE\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x84"],
        ["\xDE\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB2"],
        ["\xDE\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x94"],
        ["\xDE\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x95"],
        ["\xDE\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8F"],
        ["\xDE\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA5"],
        ["\xDE\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x82"],
        ["\xDE\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9F"],
        ["\xDE\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x81"],
        ["\xDE\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x91"],
        ["\xDE\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8C"],
        ["\xDE\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAC"],
        ["\xDE\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB8"],
        ["\xDE\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBE"],
        ["\xDE\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBF"],
        ["\xDE\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB2"],
        ["\xDE\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB1"],
        ["\xDE\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAF"],
        ["\xDE\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB2"],
        ["\xDE\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8C"],
        ["\xDF\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBE"],
        ["\xDF\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x93"],
        ["\xDF\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB7"],
        ["\xDF\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x86"],
        ["\xDF\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBA"],
        ["\xDF\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB8"],
        ["\xDF\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x81"],
        ["\xDF\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x80"],
        ["\xDF\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAF"],
        ["\xDF\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9B"],
        ["\xDF\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB3"],
        ["\xDF\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAD"],
        ["\xDF\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x82"],
        ["\xDF\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBC"],
        ["\xDF\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x98"],
        ["\xDF\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8E"],
        ["\xDF\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x91"],
        ["\xDF\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x82"],
        ["\xDF\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA6"],
        ["\xDF\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB3"],
        ["\xDF\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA3"],
        ["\xDF\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA1"],
        ["\xDF\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA4"],
        ["\xDF\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB9"],
        ["\xDF\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x86"],
        ["\xDF\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAA"],
        ["\xDF\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9F"],
        ["\xDF\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x95"],
        ["\xDF\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAC"],
        ["\xDF\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x94"],
        ["\xDF\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x98"],
        ["\xDF\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB1"],
        ["\xDF\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAE"],
        ["\xDF\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9B"],
        ["\xDF\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x89"],
        ["\xDF\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8B"],
        ["\xDF\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBA"],
        ["\xDF\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x91"],
        ["\xDF\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x81"],
        ["\xDF\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8F"],
        ["\xDF\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBE"],
        ["\xDF\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9B"],
        ["\xDF\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9A"],
        ["\xDF\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB4"],
        ["\xDF\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9D"],
        ["\xDF\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x98"],
        ["\xDF\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9F"],
        ["\xDF\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB0"],
        ["\xDF\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBE"],
        ["\xDF\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB2"],
        ["\xDF\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x91"],
        ["\xDF\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA3"],
        ["\xDF\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x99"],
        ["\xDF\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x92"],
        ["\xDF\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAF"],
        ["\xDF\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB1"],
        ["\xDF\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAC"],
        ["\xDF\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB8"],
        ["\xDF\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB3"],
        ["\xDF\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAE"],
        ["\xDF\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9F"],
        ["\xDF\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8B"],
        ["\xDF\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9D"],
        ["\xDF\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x99"],
        ["\xDF\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x89"],
        ["\xDF\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xBD"],
        ["\xDF\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9C"],
        ["\xDF\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x99"],
        ["\xDF\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA5"],
        ["\xDF\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x95"],
        ["\xDF\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x88"],
        ["\xDF\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA6"],
        ["\xDF\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA2"],
        ["\xDF\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8C"],
        ["\xDF\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x96"],
        ["\xDF\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAC"],
        ["\xDF\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8F"],
        ["\xDF\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBB"],
        ["\xDF\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x84"],
        ["\xDF\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x95"],
        ["\xDF\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA8"],
        ["\xDF\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAC"],
        ["\xDF\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x97"],
        ["\xDF\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB9"],
        ["\xDF\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBE"],
        ["\xDF\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x92"],
        ["\xDF\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x89"],
        ["\xDF\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x94"],
        ["\xDF\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8E"],
        ["\xDF\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA0"],
        ["\xDF\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAC"],
        ["\xDF\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA7"],
        ["\xDF\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB5"],
        ["\xDF\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBC"],
        ["\xE0\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB9"],
        ["\xE0\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBF"],
        ["\xE0\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x8D"],
        ["\xE0\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x90"],
        ["\xE0\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x9B"],
        ["\xE0\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xA8"],
        ["\xE0\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAD"],
        ["\xE0\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAC"],
        ["\xE0\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB0"],
        ["\xE0\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB2"],
        ["\xE0\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBB"],
        ["\xE0\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBC"],
        ["\xE0\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBF"],
        ["\xE0\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x80"],
        ["\xE0\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x86"],
        ["\xE0\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8B"],
        ["\xE0\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x98"],
        ["\xE0\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB4"],
        ["\xE0\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBE"],
        ["\xE0\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x82"],
        ["\xE0\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x81"],
        ["\xE0\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x87"],
        ["\xE0\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x92"],
        ["\xE0\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x96"],
        ["\xE0\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA2"],
        ["\xE0\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA7"],
        ["\xE0\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB9"],
        ["\xE0\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB2"],
        ["\xE0\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x83"],
        ["\xE0\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x86"],
        ["\xE0\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x84"],
        ["\xE0\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8E"],
        ["\xE0\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x92"],
        ["\xE0\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA2"],
        ["\xE0\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA0"],
        ["\xE0\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA1"],
        ["\xE0\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB9"],
        ["\xE0\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB7"],
        ["\xE0\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8F"],
        ["\xE0\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x97"],
        ["\xE0\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x8A"],
        ["\xE0\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9C"],
        ["\xE0\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x96"],
        ["\xE0\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9D"],
        ["\xE0\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB4"],
        ["\xE0\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAF"],
        ["\xE0\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA9"],
        ["\xE0\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA5"],
        ["\xE0\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBE"],
        ["\xE0\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8E"],
        ["\xE0\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8F"],
        ["\xE0\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x98"],
        ["\xE0\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x97"],
        ["\xE0\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAA"],
        ["\xE0\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA8"],
        ["\xE0\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB0"],
        ["\xE0\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB8"],
        ["\xE0\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB5"],
        ["\xE0\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBB"],
        ["\xE0\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBA"],
        ["\xE0\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x88"],
        ["\xE0\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB3"],
        ["\xE0\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8E"],
        ["\xE0\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBB"],
        ["\xE0\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x80"],
        ["\xE0\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA5"],
        ["\xE0\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAE"],
        ["\xE0\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x9E"],
        ["\xE0\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA2"],
        ["\xE0\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x85"],
        ["\xE0\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAF"],
        ["\xE0\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA5"],
        ["\xE0\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB8"],
        ["\xE0\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB2"],
        ["\xE0\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBA"],
        ["\xE0\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x95"],
        ["\xE0\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBF"],
        ["\xE0\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9F"],
        ["\xE0\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x99"],
        ["\xE0\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x81"],
        ["\xE0\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9C"],
        ["\xE0\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA9"],
        ["\xE0\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB0"],
        ["\xE0\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA3"],
        ["\xE0\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAA"],
        ["\xE0\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB6"],
        ["\xE0\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xBE"],
        ["\xE0\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x8B"],
        ["\xE0\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9E"],
        ["\xE0\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA7"],
        ["\xE0\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8A"],
        ["\xE0\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8F"],
        ["\xE0\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x94"],
        ["\xE0\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB1"],
        ["\xE1\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA0"],
        ["\xE1\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA3"],
        ["\xE1\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA7"],
        ["\xE1\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA9"],
        ["\xE1\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAE"],
        ["\xE1\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB2"],
        ["\xE1\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB0"],
        ["\xE1\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB1"],
        ["\xE1\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB8"],
        ["\xE1\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB7"],
        ["\xE1\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x84"],
        ["\xE1\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x83"],
        ["\xE1\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x85"],
        ["\xE1\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8C"],
        ["\xE1\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8E"],
        ["\xE1\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8D"],
        ["\xE1\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x95"],
        ["\xE1\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x93"],
        ["\xE1\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9E"],
        ["\xE1\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA6"],
        ["\xE1\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAC"],
        ["\xE1\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBC"],
        ["\xE1\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x84"],
        ["\xE1\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8D"],
        ["\xE1\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8A"],
        ["\xE1\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x89"],
        ["\xE1\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9B"],
        ["\xE1\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x86"],
        ["\xE1\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9A"],
        ["\xE1\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA9"],
        ["\xE1\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA4"],
        ["\xE1\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA7"],
        ["\xE1\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAB"],
        ["\xE1\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAD"],
        ["\xE1\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB8"],
        ["\xE1\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB6"],
        ["\xE1\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x86"],
        ["\xE1\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x87"],
        ["\xE1\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB4"],
        ["\xE1\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8A"],
        ["\xE1\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x89"],
        ["\xE1\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x82"],
        ["\xE1\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x94"],
        ["\xE1\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9A"],
        ["\xE1\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9D"],
        ["\xE1\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA5"],
        ["\xE1\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA3"],
        ["\xE1\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x82"],
        ["\xE1\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB3"],
        ["\xE1\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x83"],
        ["\xE1\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB5"],
        ["\xE1\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBD"],
        ["\xE1\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB8"],
        ["\xE1\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBC"],
        ["\xE1\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB1"],
        ["\xE1\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8D"],
        ["\xE1\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8A"],
        ["\xE1\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x92"],
        ["\xE1\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x99"],
        ["\xE1\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA3"],
        ["\xE1\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9E"],
        ["\xE1\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBE"],
        ["\xE1\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBF"],
        ["\xE1\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBC"],
        ["\xE1\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x81"],
        ["\xE1\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB0"],
        ["\xE1\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBA"],
        ["\xE1\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB2"],
        ["\xE1\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB3"],
        ["\xE1\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8B"],
        ["\xE1\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8D"],
        ["\xE1\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x89"],
        ["\xE1\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9F"],
        ["\xE1\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA7"],
        ["\xE1\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA0"],
        ["\xE1\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA1"],
        ["\xE1\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA2"],
        ["\xE1\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA4"],
        ["\xE1\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB4"],
        ["\xE1\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB0"],
        ["\xE1\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBB"],
        ["\xE1\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x87"],
        ["\xE1\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x88"],
        ["\xE1\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x86"],
        ["\xE1\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x9C"],
        ["\xE1\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x98"],
        ["\xE1\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA1"],
        ["\xE1\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA2"],
        ["\xE1\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA8"],
        ["\xE1\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA9"],
        ["\xE1\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAA"],
        ["\xE1\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA7"],
        ["\xE1\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAC"],
        ["\xE1\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB0"],
        ["\xE2\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB2"],
        ["\xE2\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB6"],
        ["\xE2\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB8"],
        ["\xE2\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBC"],
        ["\xE2\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x80"],
        ["\xE2\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x83"],
        ["\xE2\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x88"],
        ["\xE2\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8B"],
        ["\xE2\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8E"],
        ["\xE2\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x96"],
        ["\xE2\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x93"],
        ["\xE2\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x99"],
        ["\xE2\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9A"],
        ["\xE2\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB0"],
        ["\xE2\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB4"],
        ["\xE2\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB8"],
        ["\xE2\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB9"],
        ["\xE2\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBA"],
        ["\xE2\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x82"],
        ["\xE2\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8D"],
        ["\xE2\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x96"],
        ["\xE2\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x92"],
        ["\xE2\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9E"],
        ["\xE2\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA1"],
        ["\xE2\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA5"],
        ["\xE2\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA7"],
        ["\xE2\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAA"],
        ["\xE2\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAF"],
        ["\xE2\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBB"],
        ["\xE2\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x88"],
        ["\xE2\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x87"],
        ["\xE2\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x84"],
        ["\xE2\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA9"],
        ["\xE2\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA4"],
        ["\xE2\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9E"],
        ["\xE2\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA5"],
        ["\xE2\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA6"],
        ["\xE2\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9B"],
        ["\xE2\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB7"],
        ["\xE2\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB8"],
        ["\xE2\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x87"],
        ["\xE2\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9A"],
        ["\xE2\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA8"],
        ["\xE2\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAB"],
        ["\xE2\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9B"],
        ["\xE2\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA5"],
        ["\xE2\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBF"],
        ["\xE2\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBE"],
        ["\xE2\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB9"],
        ["\xE2\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8E"],
        ["\xE2\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8B"],
        ["\xE2\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x91"],
        ["\xE2\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA0"],
        ["\xE2\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9E"],
        ["\xE2\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB0"],
        ["\xE2\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB6"],
        ["\xE2\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB9"],
        ["\xE2\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBF"],
        ["\xE2\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBC"],
        ["\xE2\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBD"],
        ["\xE2\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBB"],
        ["\xE2\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x87"],
        ["\xE2\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x8D"],
        ["\xE2\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x97"],
        ["\xE2\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9A"],
        ["\xE2\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9C"],
        ["\xE2\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA3"],
        ["\xE2\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAE"],
        ["\xE2\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBC"],
        ["\xE2\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8C"],
        ["\xE2\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x92"],
        ["\xE2\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA6"],
        ["\xE2\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA0"],
        ["\xE2\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAA"],
        ["\xE2\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x85"],
        ["\xE2\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8E"],
        ["\xE2\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB4"],
        ["\xE2\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x86"],
        ["\xE2\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBC"],
        ["\xE2\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9A"],
        ["\xE2\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8C"],
        ["\xE2\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA3"],
        ["\xE2\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB5"],
        ["\xE2\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAA"],
        ["\xE2\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAF"],
        ["\xE2\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x91"],
        ["\xE2\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x86"],
        ["\xE2\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8B"],
        ["\xE2\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x94"],
        ["\xE2\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBE"],
        ["\xE2\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBC"],
        ["\xE2\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x85"],
        ["\xE2\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8A"],
        ["\xE2\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAC"],
        ["\xE3\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA7"],
        ["\xE3\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x9A"],
        ["\xE3\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBD"],
        ["\xE3\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB4"],
        ["\xE3\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x87"],
        ["\xE3\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x92"],
        ["\xE3\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x91"],
        ["\xE3\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x99"],
        ["\xE3\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAC"],
        ["\xE3\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAB"],
        ["\xE3\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x80"],
        ["\xE3\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA0"],
        ["\xE3\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x97"],
        ["\xE3\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9F"],
        ["\xE3\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9A"],
        ["\xE3\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x95"],
        ["\xE3\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x93"],
        ["\xE3\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBA"],
        ["\xE3\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBF"],
        ["\xE3\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8A"],
        ["\xE3\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9D"],
        ["\xE3\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA7"],
        ["\xE3\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8B"],
        ["\xE3\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAA"],
        ["\xE3\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAE"],
        ["\xE3\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB3"],
        ["\xE3\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB9"],
        ["\xE3\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBA"],
        ["\xE3\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x89"],
        ["\xE3\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x95"],
        ["\xE3\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA7"],
        ["\xE3\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAC"],
        ["\xE3\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA1"],
        ["\xE3\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA3"],
        ["\xE3\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x88"],
        ["\xE3\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8D"],
        ["\xE3\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x98"],
        ["\xE3\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x99"],
        ["\xE3\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xA0"],
        ["\xE3\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9F"],
        ["\xE3\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x80"],
        ["\xE3\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB1"],
        ["\xE3\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBB"],
        ["\xE3\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBE"],
        ["\xE3\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB7"],
        ["\xE3\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x83"],
        ["\xE3\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x97"],
        ["\xE3\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x89"],
        ["\xE3\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA1"],
        ["\xE3\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA2"],
        ["\xE3\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA9"],
        ["\xE3\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9D"],
        ["\xE3\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB0"],
        ["\xE3\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB9"],
        ["\xE3\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBD"],
        ["\xE3\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x88"],
        ["\xE3\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x97"],
        ["\xE3\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x95"],
        ["\xE3\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x98"],
        ["\xE3\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x96"],
        ["\xE3\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA9"],
        ["\xE3\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x88"],
        ["\xE3\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB0"],
        ["\xE3\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB6"],
        ["\xE3\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x85"],
        ["\xE3\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x84"],
        ["\xE3\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBF"],
        ["\xE3\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x83"],
        ["\xE3\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x87"],
        ["\xE3\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8A"],
        ["\xE3\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8D"],
        ["\xE3\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8F"],
        ["\xE3\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x95"],
        ["\xE3\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x93"],
        ["\xE3\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x99"],
        ["\xE3\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9A"],
        ["\xE3\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9D"],
        ["\xE3\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA1"],
        ["\xE3\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA2"],
        ["\xE3\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA6"],
        ["\xE3\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAD"],
        ["\xE3\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB0"],
        ["\xE3\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x82"],
        ["\xE3\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8F"],
        ["\xE3\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8A"],
        ["\xE3\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x86"],
        ["\xE3\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB3"],
        ["\xE3\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x98"],
        ["\xE3\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x99"],
        ["\xE3\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9E"],
        ["\xE3\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB5"],
        ["\xE3\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA8"],
        ["\xE3\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB6"],
        ["\xE3\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x90"],
        ["\xE4\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBA"],
        ["\xE4\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x84"],
        ["\xE4\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8D"],
        ["\xE4\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8B"],
        ["\xE4\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8C"],
        ["\xE4\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x85"],
        ["\xE4\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB5"],
        ["\xE4\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA5"],
        ["\xE4\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB4"],
        ["\xE4\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA7"],
        ["\xE4\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB0"],
        ["\xE4\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB1"],
        ["\xE4\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAC"],
        ["\xE4\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAE"],
        ["\xE4\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9D"],
        ["\xE4\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x98"],
        ["\xE4\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9F"],
        ["\xE4\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8D"],
        ["\xE4\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9C"],
        ["\xE4\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9A"],
        ["\xE4\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8B"],
        ["\xE4\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x92"],
        ["\xE4\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8F"],
        ["\xE4\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x9D"],
        ["\xE4\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x99"],
        ["\xE4\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8B"],
        ["\xE4\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x81"],
        ["\xE4\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8C"],
        ["\xE4\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8F"],
        ["\xE4\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB4"],
        ["\xE4\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x86"],
        ["\xE4\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9D"],
        ["\xE4\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA9"],
        ["\xE4\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x91"],
        ["\xE4\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x94"],
        ["\xE4\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA6"],
        ["\xE4\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA5"],
        ["\xE4\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA0"],
        ["\xE4\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x80"],
        ["\xE4\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x87"],
        ["\xE4\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x93"],
        ["\xE4\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB3"],
        ["\xE4\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB7"],
        ["\xE4\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x97"],
        ["\xE4\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8D"],
        ["\xE4\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB6"],
        ["\xE4\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA3"],
        ["\xE4\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA7"],
        ["\xE4\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAA"],
        ["\xE4\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9F"],
        ["\xE4\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB7"],
        ["\xE4\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAB"],
        ["\xE4\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBD"],
        ["\xE4\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8C"],
        ["\xE4\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x83"],
        ["\xE4\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x94"],
        ["\xE4\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8F"],
        ["\xE4\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x80"],
        ["\xE4\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x90"],
        ["\xE4\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x98"],
        ["\xE4\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9F"],
        ["\xE4\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA4"],
        ["\xE4\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x96"],
        ["\xE4\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA5"],
        ["\xE4\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAC"],
        ["\xE4\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB5"],
        ["\xE4\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x83"],
        ["\xE4\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x90"],
        ["\xE4\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA4"],
        ["\xE4\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAD"],
        ["\xE4\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA2"],
        ["\xE4\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAB"],
        ["\xE4\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA1"],
        ["\xE4\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA8"],
        ["\xE4\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB3"],
        ["\xE4\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB2"],
        ["\xE4\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB1"],
        ["\xE4\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAE"],
        ["\xE4\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB9"],
        ["\xE4\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBD"],
        ["\xE4\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x80"],
        ["\xE4\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x85"],
        ["\xE4\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x82"],
        ["\xE4\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x98"],
        ["\xE4\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x92"],
        ["\xE4\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9C"],
        ["\xE4\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA2"],
        ["\xE4\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBB"],
        ["\xE4\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAF"],
        ["\xE4\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB2"],
        ["\xE4\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB4"],
        ["\xE4\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB6"],
        ["\xE4\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBA"],
        ["\xE4\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x86"],
        ["\xE5\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x82"],
        ["\xE5\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9C"],
        ["\xE5\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x95"],
        ["\xE5\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8A"],
        ["\xE5\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x85"],
        ["\xE5\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8B"],
        ["\xE5\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAE"],
        ["\xE5\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB2"],
        ["\xE5\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBF"],
        ["\xE5\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB5"],
        ["\xE5\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x86"],
        ["\xE5\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB3"],
        ["\xE5\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x96"],
        ["\xE5\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8E"],
        ["\xE5\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB2"],
        ["\xE5\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA8"],
        ["\xE5\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAE"],
        ["\xE5\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8F"],
        ["\xE5\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA3"],
        ["\xE5\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x93"],
        ["\xE5\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x89"],
        ["\xE5\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9B"],
        ["\xE5\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8F"],
        ["\xE5\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBD"],
        ["\xE5\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9B"],
        ["\xE5\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBA"],
        ["\xE5\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAE"],
        ["\xE5\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA3"],
        ["\xE5\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB5"],
        ["\xE5\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x87"],
        ["\xE5\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBD"],
        ["\xE5\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAB"],
        ["\xE5\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBD"],
        ["\xE5\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA2"],
        ["\xE5\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAF"],
        ["\xE5\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9C"],
        ["\xE5\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB8"],
        ["\xE5\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9F"],
        ["\xE5\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB0"],
        ["\xE5\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x98"],
        ["\xE5\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9D"],
        ["\xE5\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA4"],
        ["\xE5\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9E"],
        ["\xE5\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xBB"],
        ["\xE5\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB2"],
        ["\xE5\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA1"],
        ["\xE5\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x85"],
        ["\xE5\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8A"],
        ["\xE5\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA3"],
        ["\xE5\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA1"],
        ["\xE5\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x92"],
        ["\xE5\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB1"],
        ["\xE5\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9F"],
        ["\xE5\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x89"],
        ["\xE5\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8B"],
        ["\xE5\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA2"],
        ["\xE5\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x86"],
        ["\xE5\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA6"],
        ["\xE5\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBB"],
        ["\xE5\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB5"],
        ["\xE5\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB9"],
        ["\xE5\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x83"],
        ["\xE5\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB7"],
        ["\xE5\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB2"],
        ["\xE5\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBA"],
        ["\xE5\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA7"],
        ["\xE5\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9D"],
        ["\xE5\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x96"],
        ["\xE5\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9E"],
        ["\xE5\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x99"],
        ["\xE5\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9A"],
        ["\xE5\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB9"],
        ["\xE5\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAA"],
        ["\xE5\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA9"],
        ["\xE5\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBC"],
        ["\xE5\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBB"],
        ["\xE5\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x83"],
        ["\xE5\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x95"],
        ["\xE5\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBD"],
        ["\xE5\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAE"],
        ["\xE5\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBF"],
        ["\xE5\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x88"],
        ["\xE5\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x89"],
        ["\xE5\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8C"],
        ["\xE5\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x92"],
        ["\xE5\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x90"],
        ["\xE5\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x93"],
        ["\xE5\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x94"],
        ["\xE5\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x96"],
        ["\xE5\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8E"],
        ["\xE5\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9B"],
        ["\xE5\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9C"],
        ["\xE5\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB8"],
        ["\xE5\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBA"],
        ["\xE6\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x85"],
        ["\xE6\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8C"],
        ["\xE6\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8D"],
        ["\xE6\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8E"],
        ["\xE6\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x90"],
        ["\xE6\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x91"],
        ["\xE6\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x95"],
        ["\xE6\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x94"],
        ["\xE6\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x98"],
        ["\xE6\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x9F"],
        ["\xE6\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA0"],
        ["\xE6\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA8"],
        ["\xE6\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA9"],
        ["\xE6\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA7"],
        ["\xE6\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB8"],
        ["\xE6\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x82"],
        ["\xE6\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x86"],
        ["\xE6\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x83"],
        ["\xE6\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x88"],
        ["\xE6\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x87"],
        ["\xE6\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8C"],
        ["\xE6\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x94"],
        ["\xE6\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9E"],
        ["\xE6\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9D"],
        ["\xE6\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9A"],
        ["\xE6\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA3"],
        ["\xE6\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAF"],
        ["\xE6\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB2"],
        ["\xE6\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB9"],
        ["\xE6\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAE"],
        ["\xE6\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB6"],
        ["\xE6\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB8"],
        ["\xE6\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB1"],
        ["\xE6\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x85"],
        ["\xE6\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x86"],
        ["\xE6\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8A"],
        ["\xE6\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x95"],
        ["\xE6\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x94"],
        ["\xE6\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA1"],
        ["\xE6\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA6"],
        ["\xE6\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA9"],
        ["\xE6\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB3"],
        ["\xE6\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB9"],
        ["\xE6\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9C"],
        ["\xE6\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x86"],
        ["\xE6\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x84"],
        ["\xE6\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8B"],
        ["\xE6\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x92"],
        ["\xE6\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x98"],
        ["\xE6\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x99"],
        ["\xE6\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x9C"],
        ["\xE6\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA1"],
        ["\xE6\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA8"],
        ["\xE6\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBF"],
        ["\xE6\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBB"],
        ["\xE6\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x8A"],
        ["\xE6\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x86"],
        ["\xE6\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x92"],
        ["\xE6\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x98"],
        ["\xE6\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9A"],
        ["\xE6\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9F"],
        ["\xE6\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA2"],
        ["\xE6\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA8"],
        ["\xE6\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB3"],
        ["\xE6\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB2"],
        ["\xE6\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB0"],
        ["\xE6\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB6"],
        ["\xE6\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB9"],
        ["\xE6\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBD"],
        ["\xE6\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBF"],
        ["\xE6\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x84"],
        ["\xE6\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x86"],
        ["\xE6\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x85"],
        ["\xE6\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9B"],
        ["\xE6\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x93"],
        ["\xE6\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9A"],
        ["\xE6\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAD"],
        ["\xE6\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x90"],
        ["\xE6\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAC"],
        ["\xE6\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9B"],
        ["\xE6\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA5"],
        ["\xE6\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x99"],
        ["\xE6\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9D"],
        ["\xE6\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x84"],
        ["\xE6\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9A"],
        ["\xE6\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x96"],
        ["\xE6\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x89"],
        ["\xE6\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xAF"],
        ["\xE6\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB1"],
        ["\xE6\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9B"],
        ["\xE6\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA9"],
        ["\xE6\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA3"],
        ["\xE6\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAF"],
        ["\xE6\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8B"],
        ["\xE7\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8B"],
        ["\xE7\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x86"],
        ["\xE7\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBE"],
        ["\xE7\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x93"],
        ["\xE7\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x91"],
        ["\xE7\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBC"],
        ["\xE7\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB1"],
        ["\xE7\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAE"],
        ["\xE7\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA5"],
        ["\xE7\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA6"],
        ["\xE7\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB4"],
        ["\xE7\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x83"],
        ["\xE7\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x88"],
        ["\xE7\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8A"],
        ["\xE7\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x80"],
        ["\xE7\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x82"],
        ["\xE7\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA0"],
        ["\xE7\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x95"],
        ["\xE7\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA4"],
        ["\xE7\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA3"],
        ["\xE7\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x9F"],
        ["\xE7\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x93"],
        ["\xE7\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA9"],
        ["\xE7\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB0"],
        ["\xE7\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB5"],
        ["\xE7\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBE"],
        ["\xE7\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB8"],
        ["\xE7\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBD"],
        ["\xE7\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x80"],
        ["\xE7\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x82"],
        ["\xE7\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBA"],
        ["\xE7\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x89"],
        ["\xE7\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8D"],
        ["\xE7\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x91"],
        ["\xE7\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x99"],
        ["\xE7\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x98"],
        ["\xE7\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x88"],
        ["\xE7\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9A"],
        ["\xE7\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9F"],
        ["\xE7\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA0"],
        ["\xE7\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA7"],
        ["\xE7\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBA"],
        ["\xE7\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBB"],
        ["\xE7\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBE"],
        ["\xE7\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x81"],
        ["\xE7\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x82"],
        ["\xE7\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x85"],
        ["\xE7\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x87"],
        ["\xE7\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8A"],
        ["\xE7\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8D"],
        ["\xE7\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x90"],
        ["\xE7\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x96"],
        ["\xE7\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA9"],
        ["\xE7\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAB"],
        ["\xE7\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB8"],
        ["\xE7\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB3"],
        ["\xE7\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x80"],
        ["\xE7\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x99"],
        ["\xE7\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x98"],
        ["\xE7\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9D"],
        ["\xE7\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9A"],
        ["\xE7\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9F"],
        ["\xE7\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA4"],
        ["\xE7\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA2"],
        ["\xE7\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA8"],
        ["\xE7\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAA"],
        ["\xE7\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAB"],
        ["\xE7\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAE"],
        ["\xE7\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB1"],
        ["\xE7\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB7"],
        ["\xE7\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB8"],
        ["\xE7\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBE"],
        ["\xE7\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8D"],
        ["\xE7\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x92"],
        ["\xE7\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAB"],
        ["\xE7\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9F"],
        ["\xE7\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBB"],
        ["\xE7\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAC"],
        ["\xE7\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA1"],
        ["\xE7\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA3"],
        ["\xE7\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9F"],
        ["\xE7\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x92"],
        ["\xE7\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB4"],
        ["\xE7\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB3"],
        ["\xE7\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBA"],
        ["\xE7\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x93"],
        ["\xE7\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x83"],
        ["\xE7\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBB"],
        ["\xE7\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB9"],
        ["\xE7\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9E"],
        ["\xE7\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x86"],
        ["\xE7\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9C"],
        ["\xE7\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x89"],
        ["\xE7\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x99"],
        ["\xE8\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB5"],
        ["\xE8\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB4"],
        ["\xE8\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x96"],
        ["\xE8\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB2"],
        ["\xE8\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB1"],
        ["\xE8\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x80"],
        ["\xE8\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB9"],
        ["\xE8\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x90"],
        ["\xE8\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x85"],
        ["\xE8\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAF"],
        ["\xE8\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAB"],
        ["\xE8\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x97"],
        ["\xE8\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x98"],
        ["\xE8\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x85"],
        ["\xE8\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9A"],
        ["\xE8\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAA"],
        ["\xE8\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9F"],
        ["\xE8\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA2"],
        ["\xE8\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x96"],
        ["\xE8\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA3"],
        ["\xE8\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8E"],
        ["\xE8\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x87"],
        ["\xE8\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8A"],
        ["\xE8\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBC"],
        ["\xE8\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB5"],
        ["\xE8\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB3"],
        ["\xE8\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB5"],
        ["\xE8\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA0"],
        ["\xE8\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x89"],
        ["\xE8\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA8"],
        ["\xE8\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB4"],
        ["\xE8\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x93"],
        ["\xE8\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAB"],
        ["\xE8\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8E"],
        ["\xE8\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBD"],
        ["\xE8\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x83"],
        ["\xE8\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x98"],
        ["\xE8\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8B"],
        ["\xE8\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x81"],
        ["\xE8\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB7"],
        ["\xE8\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x87"],
        ["\xE8\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA0"],
        ["\xE8\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB2"],
        ["\xE8\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8D"],
        ["\xE8\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA2"],
        ["\xE8\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA0"],
        ["\xE8\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBD"],
        ["\xE8\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB8"],
        ["\xE8\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x86"],
        ["\xE8\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBB"],
        ["\xE8\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAD"],
        ["\xE8\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAA"],
        ["\xE8\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBC"],
        ["\xE8\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9A"],
        ["\xE8\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x84"],
        ["\xE8\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB7"],
        ["\xE8\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAB"],
        ["\xE8\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAD"],
        ["\xE8\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAE"],
        ["\xE8\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x82"],
        ["\xE8\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA9"],
        ["\xE8\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x86"],
        ["\xE8\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAC"],
        ["\xE8\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAF"],
        ["\xE8\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB9"],
        ["\xE8\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB5"],
        ["\xE8\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8A"],
        ["\xE8\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA2"],
        ["\xE8\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB9"],
        ["\xE8\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBF"],
        ["\xE8\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9F"],
        ["\xE8\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x99"],
        ["\xE8\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8D"],
        ["\xE8\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBB"],
        ["\xE8\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9A"],
        ["\xE8\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x90"],
        ["\xE8\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x81"],
        ["\xE8\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x86"],
        ["\xE8\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x96"],
        ["\xE8\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA1"],
        ["\xE8\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA1"],
        ["\xE8\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBF"],
        ["\xE8\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB4"],
        ["\xE8\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x97"],
        ["\xE8\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x98"],
        ["\xE8\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAC"],
        ["\xE8\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9F"],
        ["\xE8\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x95"],
        ["\xE8\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x94"],
        ["\xE8\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBC"],
        ["\xE8\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x80"],
        ["\xE8\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA3"],
        ["\xE8\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x98"],
        ["\xE8\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x88"],
        ["\xE9\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x81"],
        ["\xE9\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x82"],
        ["\xE9\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8B"],
        ["\xE9\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x95"],
        ["\xE9\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x80"],
        ["\xE9\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA4"],
        ["\xE9\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x88"],
        ["\xE9\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x91"],
        ["\xE9\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8A"],
        ["\xE9\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA8"],
        ["\xE9\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAD"],
        ["\xE9\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x94"],
        ["\xE9\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9B"],
        ["\xE9\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAA"],
        ["\xE9\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x87"],
        ["\xE9\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9C"],
        ["\xE9\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xB7"],
        ["\xE9\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBE"],
        ["\xE9\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x90"],
        ["\xE9\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x89"],
        ["\xE9\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBA"],
        ["\xE9\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8F"],
        ["\xE9\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB9"],
        ["\xE9\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x90"],
        ["\xE9\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x95"],
        ["\xE9\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9D"],
        ["\xE9\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA5"],
        ["\xE9\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9C"],
        ["\xE9\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB9"],
        ["\xE9\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8A"],
        ["\xE9\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x93"],
        ["\xE9\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8B"],
        ["\xE9\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBE"],
        ["\xE9\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBA"],
        ["\xE9\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x86"],
        ["\xE9\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA2"],
        ["\xE9\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9A"],
        ["\xE9\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB0"],
        ["\xE9\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBF"],
        ["\xE9\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8D"],
        ["\xE9\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x95"],
        ["\xE9\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x94"],
        ["\xE9\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9F"],
        ["\xE9\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA7"],
        ["\xE9\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB1"],
        ["\xE9\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x93"],
        ["\xE9\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA3"],
        ["\xE9\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA9"],
        ["\xE9\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAA"],
        ["\xE9\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8B"],
        ["\xE9\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8C"],
        ["\xE9\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB6"],
        ["\xE9\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAF"],
        ["\xE9\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x84"],
        ["\xE9\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x86"],
        ["\xE9\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB0"],
        ["\xE9\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x89"],
        ["\xE9\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA3"],
        ["\xE9\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAB"],
        ["\xE9\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x94"],
        ["\xE9\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9E"],
        ["\xE9\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA9"],
        ["\xE9\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAC"],
        ["\xE9\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9F"],
        ["\xE9\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9B"],
        ["\xE9\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAF"],
        ["\xE9\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x92"],
        ["\xE9\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x86"],
        ["\xE9\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x88"],
        ["\xE9\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x80"],
        ["\xE9\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x83"],
        ["\xE9\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBB"],
        ["\xE9\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x91"],
        ["\xE9\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x89"],
        ["\xE9\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8D"],
        ["\xE9\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB9"],
        ["\xE9\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8A"],
        ["\xE9\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB4"],
        ["\xE9\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBF"],
        ["\xE9\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB7"],
        ["\xE9\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBB"],
        ["\xE9\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA5"],
        ["\xE9\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA9"],
        ["\xE9\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9A"],
        ["\xE9\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA0"],
        ["\xE9\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x9F"],
        ["\xE9\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB8"],
        ["\xE9\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8C"],
        ["\xE9\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8E"],
        ["\xE9\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB4"],
        ["\xE9\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x97"],
        ["\xE9\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA8"],
        ["\xE9\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAE"],
        ["\xE9\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x99"],
        ["\xEA\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x93"],
        ["\xEA\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA3"],
        ["\xEA\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAA"],
        ["\xEA\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x85"],
        ["\xEA\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA2"],
        ["\xEA\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x9F"],
        ["\xEA\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x82"],
        ["\xEA\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAF"],
        ["\xEA\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8B"],
        ["\xEA\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBD"],
        ["\xEA\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x80"],
        ["\xEA\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x90"],
        ["\xEA\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x96"],
        ["\xEA\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAB"],
        ["\xEA\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x84"],
        ["\xEA\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB3"],
        ["\xEA\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x87"],
        ["\xEA\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x86"],
        ["\xEA\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBB"],
        ["\xEA\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAF"],
        ["\xEA\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB2"],
        ["\xEA\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA0"],
        ["\xEA\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8F"],
        ["\xEA\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8D"],
        ["\xEA\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBE"],
        ["\xEA\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB6"],
        ["\xEA\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB7"],
        ["\xEA\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8E"],
        ["\xEA\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x92"],
        ["\xEA\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x91"],
        ["\xEA\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x96"],
        ["\xEA\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x95"],
        ["\xEA\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA2"],
        ["\xEA\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA1"],
        ["\xEA\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB1"],
        ["\xEA\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB6"],
        ["\xEA\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB9"],
        ["\xEA\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA7"],
        ["\xEA\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBB"],
        ["\xEA\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x84"],
        ["\xEA\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x82"],
        ["\xEA\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x92"],
        ["\xEA\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x99"],
        ["\xEA\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9E"],
        ["\xEA\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA2"],
        ["\xEA\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAB"],
        ["\xEA\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x81"],
        ["\xEA\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBE"],
        ["\xEA\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x9E"],
        ["\xEA\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB5"],
        ["\xEA\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBD"],
        ["\xEA\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB5"],
        ["\xEA\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB2"],
        ["\xEA\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x82"],
        ["\xEA\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x97"],
        ["\xEA\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x92"],
        ["\xEA\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAE"],
        ["\xEA\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x99"],
        ["\xEA\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA2"],
        ["\xEA\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8D"],
        ["\xEA\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA4"],
        ["\xEA\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB0"],
        ["\xEA\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBF"],
        ["\xEA\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB1"],
        ["\xEA\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x83"],
        ["\xEA\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x84"],
        ["\xEA\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x94"],
        ["\xEA\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x98"],
        ["\xEA\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x99"],
        ["\xEA\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9D"],
        ["\xEA\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB9"],
        ["\xEA\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x82"],
        ["\xEA\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBC"],
        ["\xEA\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB4"],
        ["\xEA\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA8"],
        ["\xEA\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB2"],
        ["\xEA\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x84"],
        ["\xEA\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8C"],
        ["\xEA\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8A"],
        ["\xEA\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x93"],
        ["\xEA\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x83"],
        ["\xEA\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9E"],
        ["\xEA\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA5"],
        ["\xEA\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAA"],
        ["\xEA\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAB"],
        ["\xEA\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x81"],
        ["\xEA\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x84"],
        ["\xEA\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xBB"],
        ["\xEA\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB6"],
        ["\xEA\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB8"],
        ["\xEA\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8C"],
        ["\xEA\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9D"],
        ["\xEA\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA0"],
        ["\xEA\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9E"],
        ["\xEB\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA6"],
        ["\xEB\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA4"],
        ["\xEB\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAD"],
        ["\xEB\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAA"],
        ["\xEB\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAF"],
        ["\xEB\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB4"],
        ["\xEB\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB7"],
        ["\xEB\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBE"],
        ["\xEB\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x83"],
        ["\xEB\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x88"],
        ["\xEB\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8A"],
        ["\xEB\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x93"],
        ["\xEB\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x98"],
        ["\xEB\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA1"],
        ["\xEB\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA9"],
        ["\xEB\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA6"],
        ["\xEB\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAC"],
        ["\xEB\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAF"],
        ["\xEB\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB2"],
        ["\xEB\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBA"],
        ["\xEB\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBD"],
        ["\xEB\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBF"],
        ["\xEB\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x80"],
        ["\xEB\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9A"],
        ["\xEB\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9C"],
        ["\xEB\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9D"],
        ["\xEB\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA7"],
        ["\xEB\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB4"],
        ["\xEB\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB8"],
        ["\xEB\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x83"],
        ["\xEB\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x96"],
        ["\xEB\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x90"],
        ["\xEB\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8C"],
        ["\xEB\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9B"],
        ["\xEB\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9D"],
        ["\xEB\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA5"],
        ["\xEB\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB6"],
        ["\xEB\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x81"],
        ["\xEB\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9B"],
        ["\xEB\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x92"],
        ["\xEB\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x86"],
        ["\xEB\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x88"],
        ["\xEB\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xBC"],
        ["\xEB\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAD"],
        ["\xEB\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAC"],
        ["\xEB\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA2"],
        ["\xEB\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x85"],
        ["\xEB\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x82"],
        ["\xEB\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x84"],
        ["\xEB\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA8"],
        ["\xEB\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA1"],
        ["\xEB\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x91"],
        ["\xEB\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA5"],
        ["\xEB\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA6"],
        ["\xEB\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9A"],
        ["\xEB\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA3"],
        ["\xEB\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x84"],
        ["\xEB\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8D"],
        ["\xEB\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x82"],
        ["\xEB\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9A"],
        ["\xEB\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAB"],
        ["\xEB\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB3"],
        ["\xEB\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA7"],
        ["\xEB\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA4"],
        ["\xEB\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB1"],
        ["\xEB\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x94"],
        ["\xEB\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA0"],
        ["\xEB\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA2"],
        ["\xEB\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB7"],
        ["\xEB\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9E"],
        ["\xEB\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9B"],
        ["\xEB\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8C"],
        ["\xEB\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x87"],
        ["\xEB\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9A"],
        ["\xEB\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA1"],
        ["\xEB\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x96"],
        ["\xEB\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x90"],
        ["\xEB\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x97"],
        ["\xEB\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA0"],
        ["\xEB\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB3"],
        ["\xEB\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAB"],
        ["\xEB\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA6"],
        ["\xEB\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAB"],
        ["\xEB\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xBE"],
        ["\xEB\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA8"],
        ["\xEB\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x81"],
        ["\xEB\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8C"],
        ["\xEB\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8F"],
        ["\xEB\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8E"],
        ["\xEB\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x89"],
        ["\xEB\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x96"],
        ["\xEB\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9B"],
        ["\xEB\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9A"],
        ["\xEB\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAB"],
        ["\xEC\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9F"],
        ["\xEC\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAC"],
        ["\xEC\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAF"],
        ["\xEC\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB4"],
        ["\xEC\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBD"],
        ["\xEC\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x80"],
        ["\xEC\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8C"],
        ["\xEC\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8E"],
        ["\xEC\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x92"],
        ["\xEC\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x93"],
        ["\xEC\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x96"],
        ["\xEC\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x99"],
        ["\xEC\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9A"],
        ["\xEC\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBA"],
        ["\xEC\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x81"],
        ["\xEC\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBF"],
        ["\xEC\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x88"],
        ["\xEC\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8C"],
        ["\xEC\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8E"],
        ["\xEC\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x90"],
        ["\xEC\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x95"],
        ["\xEC\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA2"],
        ["\xEC\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAC"],
        ["\xEC\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB8"],
        ["\xEC\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBA"],
        ["\xEC\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x82"],
        ["\xEC\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x89"],
        ["\xEC\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x85"],
        ["\xEC\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8A"],
        ["\xEC\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8D"],
        ["\xEC\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8E"],
        ["\xEC\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x94"],
        ["\xEC\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBC"],
        ["\xEC\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x98"],
        ["\xEC\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9D"],
        ["\xEC\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAD"],
        ["\xEC\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAA"],
        ["\xEC\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBD"],
        ["\xEC\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB2"],
        ["\xEC\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB3"],
        ["\xEC\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAE"],
        ["\xEC\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB6"],
        ["\xEC\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x88"],
        ["\xEC\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x81"],
        ["\xEC\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA4"],
        ["\xEC\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA3"],
        ["\xEC\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9A"],
        ["\xEC\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBD"],
        ["\xEC\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBA"],
        ["\xEC\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBB"],
        ["\xEC\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x84"],
        ["\xEC\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x85"],
        ["\xEC\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8A"],
        ["\xEC\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x87"],
        ["\xEC\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8F"],
        ["\xEC\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8D"],
        ["\xEC\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x90"],
        ["\xEC\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8E"],
        ["\xEC\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x93"],
        ["\xEC\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8D"],
        ["\xEC\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x94"],
        ["\xEC\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x96"],
        ["\xEC\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA7"],
        ["\xEC\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAD"],
        ["\xEC\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB1"],
        ["\xEC\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB3"],
        ["\xEC\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x81"],
        ["\xEC\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x99"],
        ["\xEC\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x82"],
        ["\xEC\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBE"],
        ["\xEC\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBA"],
        ["\xEC\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8F"],
        ["\xEC\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9A"],
        ["\xEC\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x96"],
        ["\xEC\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8C"],
        ["\xEC\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9B"],
        ["\xEC\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8B"],
        ["\xEC\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAA"],
        ["\xEC\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAB"],
        ["\xEC\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9F"],
        ["\xEC\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA3"],
        ["\xEC\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBC"],
        ["\xEC\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x88"],
        ["\xEC\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x89"],
        ["\xEC\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBF"],
        ["\xEC\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9D"],
        ["\xEC\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9E"],
        ["\xEC\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x90"],
        ["\xEC\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9F"],
        ["\xEC\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x82"],
        ["\xEC\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB5"],
        ["\xEC\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB0"],
        ["\xEC\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB4"],
        ["\xEC\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8A"],
        ["\xED\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x87"],
        ["\xED\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x89"],
        ["\xED\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8C"],
        ["\xED\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x90"],
        ["\xED\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x88"],
        ["\xED\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x99"],
        ["\xED\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA4"],
        ["\xED\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA0"],
        ["\xED\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xAA"],
        ["\xED\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA3"],
        ["\xED\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x95"],
        ["\xED\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB6"],
        ["\xED\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB2"],
        ["\xED\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBC"],
        ["\xED\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x81"],
        ["\xED\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x87"],
        ["\xED\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x85"],
        ["\xED\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x84"],
        ["\xED\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8B"],
        ["\xED\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8A"],
        ["\xED\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x93"],
        ["\xED\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x91"],
        ["\xED\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x94"],
        ["\xED\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x99"],
        ["\xED\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAA"],
        ["\xED\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xA1"],
        ["\xED\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAC"],
        ["\xED\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB0"],
        ["\xED\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x86"],
        ["\xED\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB1"],
        ["\xED\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xBE"],
        ["\xED\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x85"],
        ["\xED\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x88"],
        ["\xED\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8B"],
        ["\xED\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9B"],
        ["\xED\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA3"],
        ["\xED\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBC"],
        ["\xED\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBB"],
        ["\xED\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xAB"],
        ["\xED\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBE"],
        ["\xED\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8A"],
        ["\xED\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x85"],
        ["\xED\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x95"],
        ["\xED\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x92"],
        ["\xED\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x99"],
        ["\xED\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x93"],
        ["\xED\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9C"],
        ["\xED\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9F"],
        ["\xED\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9B"],
        ["\xED\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8C"],
        ["\xED\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA6"],
        ["\xED\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB3"],
        ["\xED\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBB"],
        ["\xED\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB9"],
        ["\xED\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x85"],
        ["\xED\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x82"],
        ["\xED\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBE"],
        ["\xED\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8C"],
        ["\xED\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x89"],
        ["\xED\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x86"],
        ["\xED\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8E"],
        ["\xED\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x97"],
        ["\xED\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9C"],
        ["\xED\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA2"],
        ["\xED\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA3"],
        ["\xED\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA4"],
        ["\xED\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9C"],
        ["\xED\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9F"],
        ["\xED\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA3"],
        ["\xED\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAD"],
        ["\xED\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAF"],
        ["\xED\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB7"],
        ["\xED\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x9A"],
        ["\xED\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA5"],
        ["\xED\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA2"],
        ["\xED\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAA"],
        ["\xED\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAF"],
        ["\xED\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x87"],
        ["\xED\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB4"],
        ["\xED\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x85"],
        ["\xED\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB9"],
        ["\xED\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBA"],
        ["\xED\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x91"],
        ["\xED\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x95"],
        ["\xED\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA1"],
        ["\xED\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8D"],
        ["\xED\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9E"],
        ["\xED\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x96"],
        ["\xED\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8B"],
        ["\xED\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA7"],
        ["\xED\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB6"],
        ["\xED\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB5"],
        ["\xED\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB9"],
        ["\xED\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB8"],
        ["\xEE\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8F"],
        ["\xEE\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x90"],
        ["\xEE\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x91"],
        ["\xEE\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x92"],
        ["\xEE\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8E"],
        ["\xEE\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x89"],
        ["\xEE\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBE"],
        ["\xEE\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x96"],
        ["\xEE\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x98"],
        ["\xEE\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9E"],
        ["\xEE\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA8"],
        ["\xEE\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAF"],
        ["\xEE\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB6"],
        ["\xEE\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA8"],
        ["\xEE\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB2"],
        ["\xEE\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x82"],
        ["\xEE\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBD"],
        ["\xEE\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x81"],
        ["\xEE\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x80"],
        ["\xEE\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8A"],
        ["\xEE\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x89"],
        ["\xEE\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8F"],
        ["\xEE\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA8"],
        ["\xEE\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAF"],
        ["\xEE\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB1"],
        ["\xEE\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB5"],
        ["\xEE\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA2"],
        ["\xEE\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA4"],
        ["\xEE\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x88"],
        ["\xEE\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9B"],
        ["\xEE\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x82"],
        ["\xEE\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x92"],
        ["\xEE\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x99"],
        ["\xEE\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB2"],
        ["\xEE\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB0"],
        ["\xEE\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8A"],
        ["\xEE\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x96"],
        ["\xEE\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x98"],
        ["\xEE\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA3"],
        ["\xEE\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA5"],
        ["\xEE\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA9"],
        ["\xEE\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB3"],
        ["\xEE\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB2"],
        ["\xEE\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8B"],
        ["\xEE\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x89"],
        ["\xEE\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x82"],
        ["\xEE\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA2"],
        ["\xEE\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAB"],
        ["\xEE\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAF"],
        ["\xEE\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAA"],
        ["\xEE\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB5"],
        ["\xEE\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB4"],
        ["\xEE\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBA"],
        ["\xEE\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x80"],
        ["\xEE\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x81"],
        ["\xEE\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x89"],
        ["\xEE\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8B"],
        ["\xEE\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x90"],
        ["\xEE\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x96"],
        ["\xEE\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9F"],
        ["\xEE\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA1"],
        ["\xEE\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9B"],
        ["\xEE\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBC"],
        ["\xEE\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB5"],
        ["\xEE\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB6"],
        ["\xEE\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x9E"],
        ["\xEE\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBF"],
        ["\xEE\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x94"],
        ["\xEE\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xAC"],
        ["\xEE\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x95"],
        ["\xEE\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x91"],
        ["\xEE\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9E"],
        ["\xEE\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x97"],
        ["\xEE\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x85"],
        ["\xEE\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x89"],
        ["\xEE\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA4"],
        ["\xEE\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x88"],
        ["\xEE\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x95"],
        ["\xEE\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBF"],
        ["\xEE\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8B"],
        ["\xEE\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x90"],
        ["\xEE\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9C"],
        ["\xEE\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x96"],
        ["\xEE\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x93"],
        ["\xEE\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9B"],
        ["\xEE\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9A"],
        ["\xEE\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8F"],
        ["\xEE\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB9"],
        ["\xEE\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB7"],
        ["\xEE\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA9"],
        ["\xEE\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x8F"],
        ["\xEE\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBA"],
        ["\xEE\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x84"],
        ["\xEE\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAE"],
        ["\xEF\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x99"],
        ["\xEF\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA2"],
        ["\xEF\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9A"],
        ["\xEF\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA3"],
        ["\xEF\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBA"],
        ["\xEF\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB5"],
        ["\xEF\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBB"],
        ["\xEF\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9C"],
        ["\xEF\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA0"],
        ["\xEF\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBC"],
        ["\xEF\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAE"],
        ["\xEF\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x96"],
        ["\xEF\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB0"],
        ["\xEF\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAC"],
        ["\xEF\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAD"],
        ["\xEF\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x94"],
        ["\xEF\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB9"],
        ["\xEF\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x96"],
        ["\xEF\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x97"],
        ["\xEF\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA8"],
        ["\xEF\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA5"],
        ["\xEF\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x98"],
        ["\xEF\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x83"],
        ["\xEF\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9D"],
        ["\xEF\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x90"],
        ["\xEF\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x88"],
        ["\xEF\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA4"],
        ["\xEF\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x9A"],
        ["\xEF\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x94"],
        ["\xEF\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x93"],
        ["\xEF\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x83"],
        ["\xEF\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x87"],
        ["\xEF\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x90"],
        ["\xEF\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB6"],
        ["\xEF\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xAB"],
        ["\xEF\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB5"],
        ["\xEF\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xA1"],
        ["\xEF\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xBA"],
        ["\xEF\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x81"],
        ["\xEF\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x92"],
        ["\xEF\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x84"],
        ["\xEF\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9B"],
        ["\xEF\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA0"],
        ["\xEF\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA2"],
        ["\xEF\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9E"],
        ["\xEF\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAA"],
        ["\xEF\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xA9"],
        ["\xEF\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB0"],
        ["\xEF\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB5"],
        ["\xEF\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB7"],
        ["\xEF\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBD"],
        ["\xEF\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9A"],
        ["\xEF\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBC"],
        ["\xEF\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBE"],
        ["\xEF\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x92\x81"],
        ["\xEF\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBF"],
        ["\xEF\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x82"],
        ["\xEF\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x87"],
        ["\xEF\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8A"],
        ["\xEF\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x94"],
        ["\xEF\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x96"],
        ["\xEF\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x98"],
        ["\xEF\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x99"],
        ["\xEF\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA0"],
        ["\xEF\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA8"],
        ["\xEF\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA7"],
        ["\xEF\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAD"],
        ["\xEF\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBC"],
        ["\xEF\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBB"],
        ["\xEF\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB9"],
        ["\xEF\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBE"],
        ["\xEF\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8A"],
        ["\xEF\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB6"],
        ["\xEF\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x83"],
        ["\xEF\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8D"],
        ["\xEF\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8C"],
        ["\xEF\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x95"],
        ["\xEF\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x94"],
        ["\xEF\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x96"],
        ["\xEF\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9C"],
        ["\xEF\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA1"],
        ["\xEF\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA5"],
        ["\xEF\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA2"],
        ["\xEF\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA1"],
        ["\xEF\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA8"],
        ["\xEF\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAE"],
        ["\xEF\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAF"],
        ["\xEF\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x82"],
        ["\xEF\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8C"],
        ["\xEF\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8F"],
        ["\xEF\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8B"],
        ["\xEF\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB7"],
        ["\xEF\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9C"],
        ["\xEF\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9E"],
        ["\xF0\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9D"],
        ["\xF0\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9F"],
        ["\xF0\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA6"],
        ["\xF0\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB2"],
        ["\xF0\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAC"],
        ["\xF0\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8D"],
        ["\xF0\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x98"],
        ["\xF0\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x95"],
        ["\xF0\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x97"],
        ["\xF0\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAA"],
        ["\xF0\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA7"],
        ["\xF0\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB1"],
        ["\xF0\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB2"],
        ["\xF0\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB0"],
        ["\xF0\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB4"],
        ["\xF0\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB6"],
        ["\xF0\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB8"],
        ["\xF0\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB9"],
        ["\xF0\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8E"],
        ["\xF0\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8B"],
        ["\xF0\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x89"],
        ["\xF0\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8D"],
        ["\xF0\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8D"],
        ["\xF0\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9C"],
        ["\xF0\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8D"],
        ["\xF0\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x95"],
        ["\xF0\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB9"],
        ["\xF0\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x84"],
        ["\xF0\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x86"],
        ["\xF0\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x88"],
        ["\xF0\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x93"],
        ["\xF0\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8E"],
        ["\xF0\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x91"],
        ["\xF0\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8F"],
        ["\xF0\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x96"],
        ["\xF0\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x99"],
        ["\xF0\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA4"],
        ["\xF0\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xAA"],
        ["\xF0\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB0"],
        ["\xF0\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB9"],
        ["\xF0\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBD"],
        ["\xF0\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBE"],
        ["\xF0\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x84"],
        ["\xF0\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x86"],
        ["\xF0\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x88"],
        ["\xF0\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x82"],
        ["\xF0\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x89"],
        ["\xF0\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9C"],
        ["\xF0\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA0"],
        ["\xF0\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA4"],
        ["\xF0\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA6"],
        ["\xF0\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA8"],
        ["\xF0\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x92"],
        ["\xF0\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAB"],
        ["\xF0\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB1"],
        ["\xF0\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB9"],
        ["\xF0\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x85"],
        ["\xF0\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBC"],
        ["\xF0\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x81"],
        ["\xF0\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBA"],
        ["\xF0\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x86"],
        ["\xF0\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8B"],
        ["\xF0\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8F"],
        ["\xF0\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x90"],
        ["\xF0\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x9C"],
        ["\xF0\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA8"],
        ["\xF0\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA6"],
        ["\xF0\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA3"],
        ["\xF0\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB3"],
        ["\xF0\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB4"],
        ["\xF0\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x83"],
        ["\xF0\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x86"],
        ["\xF0\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x88"],
        ["\xF0\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8B"],
        ["\xF0\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9C"],
        ["\xF0\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAD"],
        ["\xF0\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8F"],
        ["\xF0\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB2"],
        ["\xF0\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9F"],
        ["\xF0\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB6"],
        ["\xF0\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB5"],
        ["\xF0\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8F"],
        ["\xF0\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8C"],
        ["\xF0\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB8"],
        ["\xF0\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA4"],
        ["\xF0\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA1"],
        ["\xF0\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB7"],
        ["\xF0\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBD"],
        ["\xF0\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x86"],
        ["\xF0\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8F"],
        ["\xF0\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8B"],
        ["\xF0\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAB"],
        ["\xF0\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAF"],
        ["\xF0\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB0"],
        ["\xF1\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB1"],
        ["\xF1\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB4"],
        ["\xF1\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB3"],
        ["\xF1\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAA"],
        ["\xF1\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAF"],
        ["\xF1\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB1"],
        ["\xF1\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB6"],
        ["\xF1\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x84"],
        ["\xF1\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x83"],
        ["\xF1\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x86"],
        ["\xF1\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA9"],
        ["\xF1\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAB"],
        ["\xF1\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x83"],
        ["\xF1\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x89"],
        ["\xF1\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x92"],
        ["\xF1\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x94"],
        ["\xF1\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x98"],
        ["\xF1\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA1"],
        ["\xF1\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9D"],
        ["\xF1\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9E"],
        ["\xF1\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA4"],
        ["\xF1\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA0"],
        ["\xF1\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAC"],
        ["\xF1\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAE"],
        ["\xF1\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBD"],
        ["\xF1\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBE"],
        ["\xF1\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x82"],
        ["\xF1\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x89"],
        ["\xF1\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x85"],
        ["\xF1\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x90"],
        ["\xF1\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8B"],
        ["\xF1\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x91"],
        ["\xF1\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x92"],
        ["\xF1\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8C"],
        ["\xF1\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x95"],
        ["\xF1\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x97"],
        ["\xF1\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x98"],
        ["\xF1\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA5"],
        ["\xF1\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAD"],
        ["\xF1\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAE"],
        ["\xF1\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xBC"],
        ["\xF1\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9F"],
        ["\xF1\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9B"],
        ["\xF1\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9D"],
        ["\xF1\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x98"],
        ["\xF1\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x91"],
        ["\xF1\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAD"],
        ["\xF1\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAE"],
        ["\xF1\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB1"],
        ["\xF1\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB2"],
        ["\xF1\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBB"],
        ["\xF1\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB8"],
        ["\xF1\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x81"],
        ["\xF1\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8F"],
        ["\xF1\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x85"],
        ["\xF1\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xA2"],
        ["\xF1\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x99"],
        ["\xF1\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAB"],
        ["\xF1\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB7"],
        ["\xF1\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x85"],
        ["\xF1\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x82"],
        ["\xF1\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x80"],
        ["\xF1\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x83"],
        ["\xF1\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xBE"],
        ["\xF1\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x95"],
        ["\xF1\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8D"],
        ["\xF1\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9B"],
        ["\xF1\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x97"],
        ["\xF1\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9F"],
        ["\xF1\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA2"],
        ["\xF1\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA5"],
        ["\xF1\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA4"],
        ["\xF1\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA9"],
        ["\xF1\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAB"],
        ["\xF1\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAA"],
        ["\xF1\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAD"],
        ["\xF1\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB0"],
        ["\xF1\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xBC"],
        ["\xF1\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x80"],
        ["\xF1\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x8F"],
        ["\xF1\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x91"],
        ["\xF1\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x93"],
        ["\xF1\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x94"],
        ["\xF1\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9E"],
        ["\xF1\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9F"],
        ["\xF1\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA2"],
        ["\xF1\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA3"],
        ["\xF1\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA6"],
        ["\xF1\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAF"],
        ["\xF1\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAB"],
        ["\xF1\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAE"],
        ["\xF1\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB4"],
        ["\xF1\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB1"],
        ["\xF1\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB7"],
        ["\xF2\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xBB"],
        ["\xF2\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x86"],
        ["\xF2\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x98"],
        ["\xF2\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9A"],
        ["\xF2\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9F"],
        ["\xF2\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA2"],
        ["\xF2\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA3"],
        ["\xF2\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA5"],
        ["\xF2\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA7"],
        ["\xF2\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA8"],
        ["\xF2\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA9"],
        ["\xF2\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAA"],
        ["\xF2\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAE"],
        ["\xF2\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAF"],
        ["\xF2\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB2"],
        ["\xF2\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x84"],
        ["\xF2\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x83"],
        ["\xF2\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8F"],
        ["\xF2\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8D"],
        ["\xF2\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8E"],
        ["\xF2\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x91"],
        ["\xF2\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x98"],
        ["\xF2\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB4"],
        ["\xF2\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x93"],
        ["\xF2\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x83"],
        ["\xF2\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x91"],
        ["\xF2\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x96"],
        ["\xF2\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x97"],
        ["\xF2\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9F"],
        ["\xF2\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA0"],
        ["\xF2\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA8"],
        ["\xF2\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB4"],
        ["\xF2\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x80"],
        ["\xF2\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8A"],
        ["\xF2\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB9"],
        ["\xF2\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x86"],
        ["\xF2\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8F"],
        ["\xF2\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x91"],
        ["\xF2\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x92"],
        ["\xF2\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA3"],
        ["\xF2\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA2"],
        ["\xF2\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA4"],
        ["\xF2\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x94"],
        ["\xF2\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA1"],
        ["\xF2\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBA"],
        ["\xF2\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB2"],
        ["\xF2\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB1"],
        ["\xF2\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB0"],
        ["\xF2\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x95"],
        ["\xF2\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x94"],
        ["\xF2\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x89"],
        ["\xF2\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x93"],
        ["\xF2\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8C"],
        ["\xF2\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x86"],
        ["\xF2\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x88"],
        ["\xF2\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x92"],
        ["\xF2\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8A"],
        ["\xF2\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x84"],
        ["\xF2\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAE"],
        ["\xF2\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9B"],
        ["\xF2\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA5"],
        ["\xF2\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA4"],
        ["\xF2\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA1"],
        ["\xF2\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB0"],
        ["\xF2\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x87"],
        ["\xF2\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB2"],
        ["\xF2\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x86"],
        ["\xF2\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBE"],
        ["\xF2\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9A"],
        ["\xF2\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA0"],
        ["\xF2\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA7"],
        ["\xF2\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB6"],
        ["\xF2\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB8"],
        ["\xF2\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA7"],
        ["\xF2\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAC"],
        ["\xF2\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB0"],
        ["\xF2\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x89"],
        ["\xF2\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x88"],
        ["\xF2\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAB"],
        ["\xF2\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x83"],
        ["\xF2\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x86"],
        ["\xF2\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAA"],
        ["\xF2\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA6"],
        ["\xF2\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAF"],
        ["\xF2\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA3"],
        ["\xF2\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9F"],
        ["\xF2\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x84"],
        ["\xF2\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x95"],
        ["\xF2\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x92"],
        ["\xF2\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x81"],
        ["\xF2\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBF"],
        ["\xF2\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBE"],
        ["\xF2\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x86"],
        ["\xF2\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x88"],
        ["\xF3\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9D"],
        ["\xF3\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9E"],
        ["\xF3\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA4"],
        ["\xF3\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x91"],
        ["\xF3\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x90"],
        ["\xF3\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x99"],
        ["\xF3\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB2"],
        ["\xF3\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x89"],
        ["\xF3\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x87"],
        ["\xF3\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAB"],
        ["\xF3\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAF"],
        ["\xF3\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBA"],
        ["\xF3\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x9A"],
        ["\xF3\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA4"],
        ["\xF3\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA9"],
        ["\xF3\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB2"],
        ["\xF3\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x84"],
        ["\xF3\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x81"],
        ["\xF3\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBB"],
        ["\xF3\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB8"],
        ["\xF3\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBA"],
        ["\xF3\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x86"],
        ["\xF3\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x8F"],
        ["\xF3\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x82"],
        ["\xF3\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x99"],
        ["\xF3\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x93"],
        ["\xF3\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB8"],
        ["\xF3\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA6"],
        ["\xF3\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAD"],
        ["\xF3\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAF"],
        ["\xF3\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBD"],
        ["\xF3\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9A"],
        ["\xF3\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9B"],
        ["\xF3\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9E"],
        ["\xF3\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB5"],
        ["\xF3\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB9"],
        ["\xF3\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBD"],
        ["\xF3\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x81"],
        ["\xF3\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x88"],
        ["\xF3\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8B"],
        ["\xF3\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8C"],
        ["\xF3\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x92"],
        ["\xF3\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x95"],
        ["\xF3\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x91"],
        ["\xF3\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9D"],
        ["\xF3\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA5"],
        ["\xF3\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA9"],
        ["\xF3\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB8"],
        ["\xF3\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAA"],
        ["\xF3\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAD"],
        ["\xF3\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA1"],
        ["\xF3\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8C"],
        ["\xF3\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8E"],
        ["\xF3\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8F"],
        ["\xF3\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x90"],
        ["\xF3\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x94"],
        ["\xF3\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9C"],
        ["\xF3\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9E"],
        ["\xF3\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9D"],
        ["\xF3\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA0"],
        ["\xF3\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA5"],
        ["\xF3\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA8"],
        ["\xF3\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xAF"],
        ["\xF3\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB4"],
        ["\xF3\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB6"],
        ["\xF3\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB7"],
        ["\xF3\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB9"],
        ["\xF3\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBB"],
        ["\xF3\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBC"],
        ["\xF3\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBD"],
        ["\xF3\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x87"],
        ["\xF3\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x88"],
        ["\xF3\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB7"],
        ["\xF3\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x95"],
        ["\xF3\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA1"],
        ["\xF3\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xAC"],
        ["\xF3\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBE"],
        ["\xF3\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8A"],
        ["\xF3\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x92"],
        ["\xF3\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x94"],
        ["\xF3\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA3"],
        ["\xF3\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x9F"],
        ["\xF3\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA0"],
        ["\xF3\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA1"],
        ["\xF3\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA6"],
        ["\xF3\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA7"],
        ["\xF3\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAC"],
        ["\xF3\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAA"],
        ["\xF3\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB7"],
        ["\xF3\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB2"],
        ["\xF3\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB6"],
        ["\xF3\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x95"],
        ["\xF3\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9C"],
        ["\xF3\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA0"],
        ["\xF4\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAF"],
        ["\xF4\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x87"],
        ["\xF4\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x99"],
        ["\xF4\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA4"],
        ["\xF4\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9C"],
        ["\xF4\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x99"],
        ["\x74\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB0"],
        ["\x74\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB1"],
        ["\x74\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB2"],
        ["\x74\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB3"],
        ["\x74\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB4"],
        ["\x74\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB5"],
        ["\x74\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB6"],
        ["\x74\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB7"],
        ["\x74\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB8"],
        ["\x74\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB9"],
        ["\x67\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8A"],
        ["\x69\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9C"],
        ["\x6C\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x88"],
        ["\x6C\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x88"],
        ["\x69\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9C"],
        ["\x59\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x89"],
        ["\x63\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBB"],
        ["\x60\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB1"],
        ["\x61\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x88"],
        ["\x6C\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB9"],
        ["\x60\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBB"],
        ["\x5E\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x85"],
        ["\x59\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA8"],
        ["\x59\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA1"],
        ["\x59\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBC"],
        ["\x59\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x80"],
        ["\x9F\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x83"],
        ["\x59\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB9"],
        ["\x59\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x96"],
        ["\x59\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x92"],
        ["\x59\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8A"],
        ["\x59\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9A"],
        ["\x59\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x94"],
        ["\x59\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8D"],
        ["\x5A\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x80"],
        ["\x59\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA2"],
        ["\x59\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBF"],
        ["\x59\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9E"],
        ["\x5A\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x86"],
        ["\x5A\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB0"],
        ["\x5A\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x82"],
        ["\x5A\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x94"],
        ["\x5A\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB4"],
        ["\x5A\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x98"],
        ["\x5A\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8A"],
        ["\x5A\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA4"],
        ["\x5A\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x9D"],
        ["\x5A\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBE"],
        ["\x6D\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAC"],
        ["\x9F\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x95"],
        ["\x5A\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9C"],
        ["\x5A\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA6"],
        ["\x5A\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x80"],
        ["\x5B\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9B"],
        ["\x5B\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x80"],
        ["\x5B\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x87"],
        ["\x5B\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA4"],
        ["\x5B\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB2"],
        ["\x5B\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x93"],
        ["\x5B\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB2"],
        ["\x5B\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9D"],
        ["\x5B\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8E"],
        ["\x5B\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x9C"],
        ["\x5B\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8A"],
        ["\x5B\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA9"],
        ["\x5B\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBF"],
        ["\x5B\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x86"],
        ["\x5C\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x99"],
        ["\x5C\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA5"],
        ["\x5C\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAC"],
        ["\x5C\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x88"],
        ["\x9F\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x87"],
        ["\x5C\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8F"],
        ["\x5C\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x90"],
        ["\x5C\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9E"],
        ["\x5C\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB2"],
        ["\x5B\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8B"],
        ["\x5C\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x93"],
        ["\x5C\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9B"],
        ["\x5C\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9D"],
        ["\x5C\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA3"],
        ["\x5C\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA4"],
        ["\x5C\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBA"],
        ["\x5D\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x96"],
        ["\x5D\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x80"],
        ["\x5D\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAF"],
        ["\x5D\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x98"],
        ["\x5D\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAC"],
        ["\x5D\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9E"],
        ["\x5D\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA6"],
        ["\x5D\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBA"],
        ["\x5D\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB5"],
        ["\x5D\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA7"],
        ["\x5D\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x93"],
        ["\x5D\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x91"],
        ["\x5D\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x82"],
        ["\x9F\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAD"],
        ["\x5E\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB8"],
        ["\x5E\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB9"],
        ["\x5E\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x90"],
        ["\x5E\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA1"],
        ["\x5E\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB4"],
        ["\x5F\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA7"],
        ["\x5E\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB7"],
        ["\x5E\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9E"],
        ["\x5E\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9D"],
        ["\x5E\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x85"],
        ["\x5E\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8A"],
        ["\x5F\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9E"],
        ["\x5F\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x95"],
        ["\x5F\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA0"],
        ["\x5F\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB2"],
        ["\x5F\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x91"],
        ["\x5F\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB7"],
        ["\x5F\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB0"],
        ["\x5F\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x98"],
        ["\x5B\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x93"],
        ["\x5F\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xA6"],
        ["\x5F\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB5"],
        ["\x5F\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA0"],
        ["\x5F\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9D"],
        ["\x5F\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8E"],
        ["\x5F\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8E"],
        ["\x60\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x80"],
        ["\x60\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x95"],
        ["\x60\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBB"],
        ["\x60\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x89"],
        ["\x60\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAE"],
        ["\x60\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9E"],
        ["\x60\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA4"],
        ["\x60\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA5"],
        ["\x60\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x97"],
        ["\x60\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x99"],
        ["\x60\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x92"],
        ["\x60\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB3"],
        ["\x60\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x99"],
        ["\x60\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA0"],
        ["\x60\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB2"],
        ["\x60\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBF"],
        ["\x60\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBA"],
        ["\x60\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8E"],
        ["\x61\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xA9"],
        ["\x61\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA6"],
        ["\x61\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xBB"],
        ["\x61\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x92"],
        ["\x9F\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x80"],
        ["\x61\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x81"],
        ["\x61\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x84"],
        ["\x61\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8F"],
        ["\x61\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x93"],
        ["\x61\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA8"],
        ["\x61\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x94"],
        ["\x65\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x98"],
        ["\x61\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA2"],
        ["\x62\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB0"],
        ["\x62\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xAB"],
        ["\x62\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x86"],
        ["\x62\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB3"],
        ["\x62\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBE"],
        ["\x62\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA2"],
        ["\x62\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA4"],
        ["\x62\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x96"],
        ["\x62\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBF"],
        ["\x62\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9C"],
        ["\x62\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x86"],
        ["\x62\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAF"],
        ["\x62\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9A"],
        ["\x62\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x84"],
        ["\x62\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x87"],
        ["\x62\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAF"],
        ["\x62\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x96"],
        ["\x62\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAC"],
        ["\x63\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8F"],
        ["\x62\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB8"],
        ["\x63\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB2"],
        ["\x63\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBC"],
        ["\x63\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB9"],
        ["\x63\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9C"],
        ["\x63\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA7"],
        ["\x63\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBC"],
        ["\x9F\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBF"],
        ["\x63\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x88"],
        ["\x63\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB5"],
        ["\x63\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB5"],
        ["\x63\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x85"],
        ["\x63\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x87"],
        ["\x63\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA8"],
        ["\x63\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x85"],
        ["\x63\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAB"],
        ["\x9F\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x8F"],
        ["\x64\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x84"],
        ["\x64\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x9C"],
        ["\x64\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x86"],
        ["\x64\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x87"],
        ["\x64\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x95"],
        ["\x64\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x81"],
        ["\x64\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBE"],
        ["\x64\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB1"],
        ["\x9F\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xBE"],
        ["\x64\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA4"],
        ["\x64\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x96"],
        ["\x64\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB7"],
        ["\x64\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBD"],
        ["\x64\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x89"],
        ["\x64\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x96"],
        ["\x64\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA3"],
        ["\x64\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x92"],
        ["\x64\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x87"],
        ["\x64\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB5"],
        ["\x64\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA6"],
        ["\x64\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAA"],
        ["\x64\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA9"],
        ["\x64\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAE"],
        ["\x65\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA2"],
        ["\x65\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x89"],
        ["\x65\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9F"],
        ["\x65\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x81"],
        ["\x65\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAF"],
        ["\x65\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x82"],
        ["\x65\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9C"],
        ["\x65\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9E"],
        ["\x65\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9B"],
        ["\x65\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA6"],
        ["\x65\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x97"],
        ["\x65\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x86"],
        ["\x65\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAF"],
        ["\x65\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA1"],
        ["\x65\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x8E"],
        ["\x66\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xA4"],
        ["\x66\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBA"],
        ["\x66\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB0"],
        ["\x66\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x98"],
        ["\x66\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x99"],
        ["\x66\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9A"],
        ["\x66\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x94"],
        ["\x66\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9B"],
        ["\x66\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9B"],
        ["\x66\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x91"],
        ["\x67\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA7"],
        ["\x67\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9C"],
        ["\x67\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAB"],
        ["\x67\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9E"],
        ["\x67\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9D"],
        ["\x67\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x88"],
        ["\x67\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9C"],
        ["\x67\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB7"],
        ["\x67\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA0"],
        ["\x67\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x96"],
        ["\x67\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x92"],
        ["\x68\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x87"],
        ["\x68\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA1"],
        ["\x68\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9E"],
        ["\x68\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x81"],
        ["\x68\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xA2"],
        ["\x68\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBF"],
        ["\x68\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x87"],
        ["\x68\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB6"],
        ["\x69\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x88"],
        ["\x69\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB4"],
        ["\x69\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x93"],
        ["\x69\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x99"],
        ["\x69\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAB"],
        ["\x69\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9F"],
        ["\x69\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB0"],
        ["\x69\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA0"],
        ["\x69\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA1"],
        ["\x69\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x87"],
        ["\x69\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB5"],
        ["\x69\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x92"],
        ["\x6A\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB7"],
        ["\x6A\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB9"],
        ["\x6A\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA7"],
        ["\x6A\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBE"],
        ["\x6A\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9F"],
        ["\x6A\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA2"],
        ["\x6A\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB6"],
        ["\x6A\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x93"],
        ["\x6A\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBF"],
        ["\x6A\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB0"],
        ["\x6A\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB4"],
        ["\x6A\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x92"],
        ["\x6A\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB6"],
        ["\x6A\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA3"],
        ["\x6A\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8F"],
        ["\x6A\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA4"],
        ["\x6A\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA5"],
        ["\x6B\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA7"],
        ["\x6B\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9E"],
        ["\x6B\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA6"],
        ["\x6B\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x95"],
        ["\x6B\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA7"],
        ["\x6B\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9A"],
        ["\x6B\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x97"],
        ["\x6B\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9E"],
        ["\x6B\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAD"],
        ["\x6B\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAE"],
        ["\x6B\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA4"],
        ["\x6B\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA5"],
        ["\x6B\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x86"],
        ["\x6B\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x90"],
        ["\x6B\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8A"],
        ["\x6B\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBA"],
        ["\x6B\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x80"],
        ["\x6B\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBC"],
        ["\x6B\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8E"],
        ["\x6B\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x99"],
        ["\x6B\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x91"],
        ["\x6B\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB9"],
        ["\x6B\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA7"],
        ["\x6C\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xA7"],
        ["\x6C\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB7"],
        ["\x6C\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB8"],
        ["\x6C\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA7"],
        ["\x6C\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x97"],
        ["\x6C\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x99"],
        ["\x6C\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x90"],
        ["\x6C\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA7"],
        ["\x6C\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x95"],
        ["\x6C\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA0"],
        ["\x9F\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x93"],
        ["\x6C\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA5"],
        ["\x6C\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA1"],
        ["\x6C\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBB"],
        ["\x6C\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA8"],
        ["\x6C\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9E"],
        ["\x6C\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBF"],
        ["\x6C\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9D"],
        ["\x6C\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x82"],
        ["\x6C\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB0"],
        ["\x6C\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x97"],
        ["\x6C\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA4"],
        ["\x6C\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x86"],
        ["\x6C\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9E"],
        ["\x6C\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xB8"],
        ["\x6C\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB1"],
        ["\x6C\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x85"],
        ["\x6C\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x88"],
        ["\x6C\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x92"],
        ["\x6D\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7\x9C"],
        ["\x6D\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA9"],
        ["\x6D\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9D"],
        ["\x6D\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAF"],
        ["\x9F\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB3"],
        ["\x9F\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBB"],
        ["\x6D\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x83"],
        ["\x6D\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8D"],
        ["\x9F\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8F"],
        ["\x6D\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x91"],
        ["\x6D\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x95"],
        ["\x6D\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x97"],
        ["\x6D\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA5"],
        ["\x6D\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAA"],
        ["\x6D\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAB"],
        ["\x6D\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA7"],
        ["\x6D\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAC"],
        ["\x6D\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x9E"],
        ["\x6D\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8E"],
        ["\x6D\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x99"],
        ["\x6D\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9C"],
        ["\x9F\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB5"],
        ["\x6D\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB2"],
        ["\x6D\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8F"],
        ["\x6D\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB1"],
        ["\x6D\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xBB"],
        ["\x9F\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x80"],
        ["\x9F\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB0"],
        ["\x6D\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAB"],
        ["\x6D\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAD"],
        ["\x6E\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x99"],
        ["\x6E\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x91"],
        ["\x6F\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x85"],
        ["\x71\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x85"],
        ["\x71\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x95"],
        ["\x71\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x96"],
        ["\x71\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x97"],
        ["\x6F\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x83"],
        ["\x6F\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x85"],
        ["\x6F\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x88"],
        ["\x6F\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xB7"],
        ["\x70\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x94"],
        ["\x70\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB7"],
        ["\x70\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB6"],
        ["\x70\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x81"],
        ["\x70\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x80"],
        ["\x70\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x97"],
        ["\x70\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x98"],
        ["\x70\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x96"],
        ["\x70\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x99"],
        ["\x70\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x84"],
        ["\x71\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA8"],
        ["\x71\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA6"],
        ["\x71\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA7"],
        ["\x71\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA9"],
        ["\x71\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x89"],
        ["\x70\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xBD"],
        ["\x6F\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x93"],
        ["\x70\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8B"],
        ["\x71\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x93"],
        ["\x70\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA4"],
        ["\x70\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA0"],
        ["\x70\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA2"],
        ["\x70\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA6"],
        ["\x70\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA1"],
        ["\x70\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA5"],
        ["\x70\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA7"],
        ["\x70\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA3"],
        ["\x71\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xA0"],
        ["\x6F\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB1"],
        ["\x6F\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B\x9B"],
        ["\x77\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x91"],
        ["\x77\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x92"],
        ["\x77\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x93"],
        ["\x77\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x94"],
        ["\x77\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x95"],
        ["\x77\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x96"],
        ["\x77\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x97"],
        ["\x77\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x98"],
        ["\x77\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x99"],
        ["\x77\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9A"],
        ["\x77\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9B"],
        ["\x77\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9C"],
        ["\x77\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9D"],
        ["\x77\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9E"],
        ["\x77\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9F"],
        ["\x77\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB1"],
        ["\x77\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB2"],
        ["\x77\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB3"],
        ["\x77\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB4"],
        ["\x77\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB5"],
        ["\x77\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB6"],
        ["\x77\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB7"],
        ["\x77\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB8"],
        ["\x77\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB9"],
        ["\x77\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBA"],
        ["\x77\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBB"],
        ["\x77\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBC"],
        ["\x77\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBD"],
        ["\x77\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBE"],
        ["\x77\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBF"],
        ["\x74\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBA"],
        ["\x74\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBB"],
        ["\x76\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x90"],
        ["\x76\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x91"],
        ["\x76\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x92"],
        ["\x76\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x93"],
        ["\x76\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x94"],
        ["\x76\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x95"],
        ["\x76\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x96"],
        ["\x76\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x97"],
        ["\x76\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x98"],
        ["\x76\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x99"],
        ["\x76\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9A"],
        ["\x76\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9B"],
        ["\x76\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9C"],
        ["\x76\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9D"],
        ["\x76\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9E"],
        ["\x76\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9F"],
        ["\x76\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA0"],
        ["\x76\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA1"],
        ["\x76\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA2"],
        ["\x76\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA3"],
        ["\x76\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA4"],
        ["\x76\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA5"],
        ["\x76\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA6"],
        ["\x76\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA7"],
        ["\x76\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA8"],
        ["\x76\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA9"],
        ["\x79\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x90"],
        ["\x79\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x91"],
        ["\x79\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x92"],
        ["\x79\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x93"],
        ["\x79\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x94"],
        ["\x79\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x95"],
        ["\x79\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x96"],
        ["\x79\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x97"],
        ["\x79\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x98"],
        ["\x79\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x99"],
        ["\x79\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9A"],
        ["\x79\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9B"],
        ["\x79\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9C"],
        ["\x79\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9D"],
        ["\x79\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9E"],
        ["\x79\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9F"],
        ["\x79\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA0"],
        ["\x79\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA1"],
        ["\x79\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA2"],
        ["\x79\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA3"],
        ["\x79\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xBA"],
        ["\x79\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA9"],
        ["\x79\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA5"],
        ["\x79\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAD"],
        ["\x79\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAC"],
        ["\x74\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAA"],
        ["\x74\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAB"],
        ["\x59\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB1"],
        ["\x59\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x80\x8B"],
        ["\x59\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\x82"],
        ["\x59\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBD"],
        ["\x9F\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8B"],
        ["\x59\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBE"],
        ["\x59\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x97"],
        ["\x59\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB0"],
        ["\x6E\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA0"],
        ["\x59\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8E"],
        ["\x59\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x98"],
        ["\x59\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA7"],
        ["\x5A\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8C"],
        ["\x5A\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB1"],
        ["\x5A\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB2"],
        ["\x5A\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x97"],
        ["\x65\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x92\xB5"],
        ["\x5A\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA2"],
        ["\x5A\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAE"],
        ["\x5E\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x93\x9B"],
        ["\x5A\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB3"],
        ["\x5A\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x96"],
        ["\x5B\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB4"],
        ["\x5B\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBB"],
        ["\x5B\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBD"],
        ["\x5B\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x96"],
        ["\x5B\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA1"],
        ["\x5B\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x86"],
        ["\x6E\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9E"],
        ["\x5B\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x81"],
        ["\x5B\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB6"],
        ["\x5B\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB7"],
        ["\x5B\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBB"],
        ["\x5C\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB8"],
        ["\x5B\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAF"],
        ["\x5B\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB2"],
        ["\x6E\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x99"],
        ["\x5C\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9E"],
        ["\x6E\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8A"],
        ["\x5C\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x88\xBD"],
        ["\x5C\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA1"],
        ["\x5C\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB4"],
        ["\x5C\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8C\x9B"],
        ["\x5C\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xAD"],
        ["\x5C\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB5"],
        ["\x5C\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x89"],
        ["\x6E\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA1"],
        ["\x5C\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBA"],
        ["\x5C\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x94"],
        ["\x5C\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8C"],
        ["\x5C\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAD"],
        ["\x5C\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x83"],
        ["\x5C\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9D"],
        ["\x5C\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA3"],
        ["\x5D\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA7"],
        ["\x5D\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x84"],
        ["\x5D\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9E"],
        ["\x6E\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9D"],
        ["\x5B\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xAE\x9F"],
        ["\x5D\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E\x8D"],
        ["\x6E\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA2"],
        ["\x5D\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBB"],
        ["\x5D\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8F"],
        ["\x5D\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x8B"],
        ["\x5D\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB4"],
        ["\x9F\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xA2"],
        ["\x5D\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA0"],
        ["\x5E\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA7"],
        ["\x5E\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8B"],
        ["\xD7\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x81"],
        ["\x6E\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x93"],
        ["\x61\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA2"],
        ["\x5E\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x98"],
        ["\x5E\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xBE"],
        ["\x5E\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xA8"],
        ["\x5E\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB9"],
        ["\x5E\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x87"],
        ["\x5E\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x89"],
        ["\x5E\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB5"],
        ["\x5E\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x89"],
        ["\x5E\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA9"],
        ["\x5E\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB3"],
        ["\x5E\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBD"],
        ["\x5F\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAB"],
        ["\x5F\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBF"],
        ["\x5F\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBC"],
        ["\x5F\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x80"],
        ["\x5F\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA2"],
        ["\x9F\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9A"],
        ["\x5F\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB9"],
        ["\x5F\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAD"],
        ["\x6E\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x94"],
        ["\x6E\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x91"],
        ["\x5F\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8A"],
        ["\x6E\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA2"],
        ["\x5F\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x81"],
        ["\x60\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBA"],
        ["\x60\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA2"],
        ["\x60\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB0"],
        ["\x60\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB3"],
        ["\x60\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x88"],
        ["\x60\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8C"],
        ["\x60\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\x84"],
        ["\x60\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9A"],
        ["\x60\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB7"],
        ["\x60\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x83"],
        ["\x60\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBB"],
        ["\x60\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x86"],
        ["\x60\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x88"],
        ["\x60\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\xA2"],
        ["\x61\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x93"],
        ["\x61\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x87"],
        ["\x9F\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBB"],
        ["\x61\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x81"],
        ["\x61\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x98"],
        ["\x61\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB9"],
        ["\x61\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x97"],
        ["\x61\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB5"],
        ["\x61\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x84"],
        ["\x61\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB2"],
        ["\x61\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB0"],
        ["\x61\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8A"],
        ["\x61\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x89"],
        ["\x9F\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB5"],
        ["\x61\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x97"],
        ["\x9F\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x80"],
        ["\x61\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAD"],
        ["\x6E\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB6"],
        ["\x62\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x85"],
        ["\x6E\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x94"],
        ["\x9F\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9E"],
        ["\x62\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\x9D"],
        ["\x62\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB5"],
        ["\x62\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x96"],
        ["\x62\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA5"],
        ["\x5B\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB7"],
        ["\x62\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8F"],
        ["\x62\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x90"],
        ["\x62\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB6"],
        ["\x62\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xBB"],
        ["\x62\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA0"],
        ["\x62\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAB"],
        ["\x62\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB3\xBE"],
        ["\x62\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAE"],
        ["\x62\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB9"],
        ["\x62\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA5"],
        ["\x62\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x85"],
        ["\x62\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x82"],
        ["\x62\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x89"],
        ["\x62\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9A"],
        ["\x63\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x86"],
        ["\x63\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB4"],
        ["\x63\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9E"],
        ["\x63\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAB"],
        ["\x63\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB1"],
        ["\x63\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x87"],
        ["\x63\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x87"],
        ["\x63\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB3"],
        ["\x6E\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x91"],
        ["\x63\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA1"],
        ["\x9F\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8D"],
        ["\x63\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA7"],
        ["\x6E\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x86"],
        ["\x63\xF6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x9D"],
        ["\x63\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8E"],
        ["\x63\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xA4"],
        ["\x64\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x98"],
        ["\x64\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9E"],
        ["\x6E\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB0"],
        ["\x64\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x88"],
        ["\x64\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x92"],
        ["\x64\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x92"],
        ["\x64\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBA"],
        ["\x64\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x80"],
        ["\x64\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x80"],
        ["\x64\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x90"],
        ["\x64\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9F"],
        ["\x64\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8F"],
        ["\x64\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x99"],
        ["\x64\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA9"],
        ["\x64\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9A"],
        ["\x64\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9B"],
        ["\x64\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8A"],
        ["\x64\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAB"],
        ["\x65\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x8B"],
        ["\x65\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x97"],
        ["\x65\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x87"],
        ["\x65\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x98"],
        ["\x65\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA3"],
        ["\x65\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBF"],
        ["\x65\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA4"],
        ["\x65\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x99"],
        ["\x65\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xAD"],
        ["\x65\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA4"],
        ["\x65\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAD"],
        ["\x65\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB6"],
        ["\x65\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x8D"],
        ["\x65\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9C"],
        ["\x65\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x8F"],
        ["\x65\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x91"],
        ["\x65\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAE"],
        ["\x66\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8C"],
        ["\x66\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8D"],
        ["\x66\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8E"],
        ["\x66\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8F"],
        ["\x66\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x90"],
        ["\x66\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9C"],
        ["\x66\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x91"],
        ["\x66\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB9"],
        ["\x66\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x92"],
        ["\x66\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x93"],
        ["\x80\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB1"],
        ["\x66\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8A"],
        ["\x66\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9E"],
        ["\x66\xEB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x94"],
        ["\x66\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB9"],
        ["\x9F\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9D"],
        ["\x66\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x95"],
        ["\x66\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA0"],
        ["\x66\xFC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xA7\x84"],
        ["\x67\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBD"],
        ["\x67\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAD"],
        ["\x67\xB6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x96"],
        ["\x67\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x99"],
        ["\x67\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB1"],
        ["\x80\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9E"],
        ["\x67\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x89\xA4"],
        ["\x9F\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA0"],
        ["\x9F\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x99"],
        ["\x67\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x88"],
        ["\x67\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x93"],
        ["\x67\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9D"],
        ["\x67\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x93"],
        ["\x67\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8B"],
        ["\x67\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA3"],
        ["\x67\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x97"],
        ["\x67\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x91"],
        ["\x67\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x99"],
        ["\x80\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA1"],
        ["\x68\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9A"],
        ["\x68\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAE"],
        ["\x68\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9B"],
        ["\x68\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x94"],
        ["\x60\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x97"],
        ["\x60\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA0"],
        ["\x68\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9C"],
        ["\x66\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\x93"],
        ["\x9F\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8E"],
        ["\x68\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBE"],
        ["\x68\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x83"],
        ["\x68\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x98"],
        ["\x69\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x80"],
        ["\x80\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8A"],
        ["\x69\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9F"],
        ["\x69\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9F"],
        ["\x69\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB0"],
        ["\x80\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA3"],
        ["\x9F\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAD"],
        ["\x69\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8F"],
        ["\x69\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x92"],
        ["\x69\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x84"],
        ["\x69\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x98"],
        ["\x69\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9B"],
        ["\x69\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xB6"],
        ["\x69\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x96\x9D"],
        ["\x80\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAC"],
        ["\x80\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x9F"],
        ["\x69\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA0"],
        ["\x66\xC7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA1"],
        ["\x69\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x94"],
        ["\x69\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA5"],
        ["\x69\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x95"],
        ["\x6A\xA2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA2"],
        ["\x6A\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x87"],
        ["\x6A\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x8E"],
        ["\x6A\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA2"],
        ["\x6A\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA3"],
        ["\x6A\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x86"],
        ["\x6A\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x94"],
        ["\x6A\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA4"],
        ["\x6A\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA5"],
        ["\x80\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x80"],
        ["\x6A\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x94"],
        ["\x5B\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA6"],
        ["\x6A\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA8"],
        ["\x6A\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAE"],
        ["\x6B\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA2"],
        ["\x6B\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x84"],
        ["\x80\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAC"],
        ["\x80\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB1"],
        ["\x6B\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB1"],
        ["\x6B\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB8"],
        ["\x6C\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8B"],
        ["\x6C\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x84"],
        ["\x6C\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9F"],
        ["\x6C\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x89"],
        ["\x6C\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8A"],
        ["\x9F\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xBA"],
        ["\x6C\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9F"],
        ["\x6C\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB3"],
        ["\x6C\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAB"],
        ["\x6C\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8E"],
        ["\x6C\xF9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAC"],
        ["\x6C\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6\xB0"],
        ["\x6D\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9E"],
        ["\x6D\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA8"],
        ["\x6D\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAF"],
        ["\x6D\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA9"],
        ["\x6D\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8A"],
        ["\x80\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB0"],
        ["\x80\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9A"],
        ["\x6D\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7\x90"],
        ["\x6D\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA4"],
        ["\x6D\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8A"],
        ["\x80\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x92"],
        ["\x9F\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA6"],
        ["\x9F\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA3"],
        ["\x9F\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9E"],
        ["\x9F\xD5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x96"],
        ["\x80\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x97"],
        ["\x80\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBC"],
        ["\x80\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB4"],
        ["\x80\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB5"],
        ["\x6E\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x94"],
        ["\x66\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA2"],
        ["\x6E\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9B"],
        ["\x80\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA6"],
        ["\x80\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAB"],
        ["\x59\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x82"],
        ["\x59\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x92"],
        ["\x59\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x87"],
        ["\x69\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\xAE"],
        ["\x59\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB9"],
        ["\x5A\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9A"],
        ["\x59\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB1"],
        ["\x59\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBE"],
        ["\x59\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA6"],
        ["\x59\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB2"],
        ["\x59\xEC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBE"],
        ["\x59\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8B"],
        ["\x59\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9C"],
        ["\x59\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x91\xA8"],
        ["\x5A\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x97"],
        ["\x5A\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA3"],
        ["\x5A\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA6"],
        ["\x5A\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x93"],
        ["\x5A\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA1"],
        ["\x5D\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xA1"],
        ["\x5D\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x88"],
        ["\x5D\xD9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8A"],
        ["\x5D\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAD"],
        ["\x5D\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB5"],
        ["\x5D\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x89"],
        ["\x5D\xEA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xAB"],
        ["\x5D\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA1"],
        ["\x5D\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0\x80"],
        ["\x5D\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x92"],
        ["\x5D\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x94"],
        ["\x5A\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBC"],
        ["\x5A\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA4"],
        ["\x5A\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8A"],
        ["\x5A\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\x94\x9F"],
        ["\x5A\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x91"],
        ["\x68\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8B"],
        ["\x5B\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x82"],
        ["\x68\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA7"],
        ["\x5B\xBB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAC"],
        ["\x5B\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9A"],
        ["\x5B\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x80"],
        ["\x5B\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA1"],
        ["\x5B\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x90"],
        ["\x5C\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9D"],
        ["\x5C\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAD"],
        ["\x5C\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA3"],
        ["\x5C\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x86"],
        ["\x9F\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x89\xB4"],
        ["\x5C\xBE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8C"],
        ["\x9F\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9E"],
        ["\x5C\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8A"],
        ["\x5C\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8F"],
        ["\x5C\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x86"],
        ["\x5C\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9F"],
        ["\x5C\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB5"],
        ["\x5C\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9F"],
        ["\x5C\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x88"],
        ["\x5C\xFA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9E"],
        ["\x5C\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA4"],
        ["\x5D\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9F"],
        ["\x5D\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xB3"],
        ["\x5D\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xB0"],
        ["\x5D\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xA7\x83"],
        ["\x5E\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAC"],
        ["\x5E\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBD"],
        ["\x5E\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8E"],
        ["\x5E\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9C"],
        ["\x5E\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA3"],
        ["\x5E\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA4"],
        ["\x5E\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x87"],
        ["\x5E\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA2"],
        ["\x5E\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4\x97"],
        ["\x5E\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4\x9A"],
        ["\x5E\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xBF"],
        ["\x5F\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB0"],
        ["\x5F\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x93"],
        ["\x5F\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x93"],
        ["\x5F\xC2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAD"],
        ["\x5F\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x9D"],
        ["\x5F\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA9"],
        ["\x5F\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB3"],
        ["\x5F\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x89"],
        ["\x5D\xB9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x85"],
        ["\x60\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8A"],
        ["\x60\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB\x96"],
        ["\x60\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB2"],
        ["\x60\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x88"],
        ["\x60\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA1"],
        ["\x60\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x91"],
        ["\x60\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8E"],
        ["\x60\xD4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9B"],
        ["\x60\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA3"],
        ["\x60\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\xB5"],
        ["\x60\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAA"],
        ["\x60\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAB"],
        ["\x60\xE8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x92"],
        ["\x60\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\x9A"],
        ["\x61\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x99"],
        ["\x61\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x93"],
        ["\x61\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x99"],
        ["\x61\xC9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x89"],
        ["\x5B\xB7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8C"],
        ["\x61\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBA"],
        ["\x61\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBC"],
        ["\x61\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9A"],
        ["\x61\xE4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\x88"],
        ["\x9F\xB0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x92"],
        ["\x61\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB7"],
        ["\x61\xAD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBA"],
        ["\x61\xF4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x80"],
        ["\x61\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x98\xBA"],
        ["\x62\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA3"],
        ["\x62\xA5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x91"],
        ["\x62\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8E"],
        ["\x62\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x92"],
        ["\x62\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x94"],
        ["\x6E\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB3"],
        ["\x62\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8A"],
        ["\x62\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBE"],
        ["\x62\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB1"],
        ["\x62\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAD"],
        ["\x9F\xB4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x97"],
        ["\x62\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x82"],
        ["\x62\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x96"],
        ["\x62\xDF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA9"],
        ["\x62\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAF"],
        ["\x62\xF8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB0"],
        ["\x62\xF5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x81"],
        ["\x62\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8D"],
        ["\x63\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8E"],
        ["\x63\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x90"],
        ["\x63\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA9"],
        ["\x63\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB6"],
        ["\x63\xB1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x91"],
        ["\x63\xB2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x93"],
        ["\x9F\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x97"],
        ["\x62\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x99"],
        ["\x63\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA5"],
        ["\x63\xE0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAF"],
        ["\x63\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9A"],
        ["\x63\xFB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x86"],
        ["\x64\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x93"],
        ["\x64\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9C"],
        ["\x64\xAA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAF"],
        ["\x64\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x80"],
        ["\x64\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8B"],
        ["\x64\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x85"],
        ["\x64\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9C"],
        ["\x64\xD6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9E"],
        ["\x64\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA5"],
        ["\x64\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA8"],
        ["\x64\xE1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBF"],
        ["\x64\xDD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8B"],
        ["\x64\xE6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA7"],
        ["\x64\xE7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB9"],
        ["\x64\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x81"],
        ["\x64\xF7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB9"],
        ["\x65\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x83"],
        ["\x65\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB1"],
        ["\x65\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x99"],
        ["\x65\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xBA"],
        ["\x65\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBE"],
        ["\x65\xBF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x80"],
        ["\x9F\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBE"],
        ["\x65\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x95"],
        ["\x65\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA7"],
        ["\x65\xE3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xAD"],
        ["\x65\xED",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB2"],
        ["\x65\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9E"],
        ["\x65\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x82\x93"],
        ["\x66\xA7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9E"],
        ["\x66\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA6"],
        ["\x66\xAC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBA"],
        ["\x66\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBB"],
        ["\x66\xAF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA5"],
        ["\x66\xC0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x98"],
        ["\x66\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x84\x85"],
        ["\x66\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8C"],
        ["\x66\xDC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x96"],
        ["\x66\xE2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\x88"],
        ["\x66\xE5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x91"],
        ["\x66\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\xA3"],
        ["\x66\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9F"],
        ["\x66\xF0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA0"],
        ["\x66\xF3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA7"],
        ["\x66\xF2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAA"],
        ["\x67\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA8"],
        ["\x67\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA7"],
        ["\x67\xB3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA4"],
        ["\x67\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB1\x8B"],
        ["\x67\xC1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8F"],
        ["\x5C\xB8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB8\xAE"],
        ["\x67\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB7"],
        ["\x67\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x83"],
        ["\x67\xD2",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x89"],
        ["\x67\xDE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBE"],
        ["\x67\xDA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x87"],
        ["\x67\xEF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB6"],
        ["\x68\xA6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x84"],
        ["\x68\xAB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBB"],
        ["\x68\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA4"],
        ["\x61\xA3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x9A\xB0"],
        ["\x61\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F\xAE"],
        ["\x61\xA8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB5"],
        ["\x68\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA4"],
        ["\x68\xCB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBF"],
        ["\x68\xCD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x83"],
        ["\x68\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8A"],
        ["\x68\xD0",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA7"],
        ["\x68\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA8"],
        ["\x68\xCF",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBA"],
        ["\x68\xD3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x87"],
        ["\x9F\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB0"],
        ["\x68\xE9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x92\xBE"],
        ["\x69\xA4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8F"],
        ["\x9F\xC6",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9A"],
        ["\x69\xB5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA6"],
        ["\x69\xBC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8F"],
        ["\x69\xBD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\x95\x83"],
        ["\x69\xC4",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x86"],
        ["\x69\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x87"],
        ["\x69\xD1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x93"],
        ["\x69\xD8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBE"],
        ["\x9F\xC8",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8B"],
        ["\x59\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x80"],
        ["\x69\xF1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x90"],
        ["\x6A\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x91"],
        ["\x6A\xAE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x97"],
        ["\x6A\xBA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9C"],
        ["\x6A\xC5",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x94"],
        ["\x6A\xCA",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA4"],
        ["\x6A\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x84"],
        ["\x6B\xFD",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA5"],
        ["\x6C\xA9",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x89"],
        ["\x9F\xCC",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8D"],
        ["\x6C\xFE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB3"],
        ["\x6D\xA1",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x82"],
        ["\x6D\xCE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA3"],
        ["\x6D\xDB",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\xA8"],
        ["\x6D\xEE",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8B"],
        ["\x9F\xD7",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA2"],
        ["\x5E\xC3",'utf8','keis90',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBD"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

require 'jacode4e.pl';

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
