# Generated by default/object.tt
package Paws::DLM::CreateRule;
  use Moose;
  has CronExpression => (is => 'ro', isa => 'Str');
  has Interval => (is => 'ro', isa => 'Int');
  has IntervalUnit => (is => 'ro', isa => 'Str');
  has Location => (is => 'ro', isa => 'Str');
  has Times => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DLM::CreateRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DLM::CreateRule object:

  $service_obj->Method(Att1 => { CronExpression => $value, ..., Times => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DLM::CreateRule object:

  $result = $service_obj->Method(...);
  $result->Att1->CronExpression

=head1 DESCRIPTION

Specifies when to create snapshots of EBS volumes.

You must specify either a Cron expression or an interval, interval
unit, and start time. You cannot specify both.

=head1 ATTRIBUTES


=head2 CronExpression => Str

The schedule, as a Cron expression. The schedule interval must be
between 1 hour and 1 year. For more information, see Cron expressions
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
in the I<Amazon CloudWatch User Guide>.


=head2 Interval => Int

The interval between snapshots. The supported values are 1, 2, 3, 4, 6,
8, 12, and 24.


=head2 IntervalUnit => Str

The interval unit.


=head2 Location => Str

Specifies the destination for snapshots created by the policy. To
create snapshots in the same Region as the source resource, specify
C<CLOUD>. To create snapshots on the same Outpost as the source
resource, specify C<OUTPOST_LOCAL>. If you omit this parameter,
C<CLOUD> is used by default.

If the policy targets resources in an AWS Region, then you must create
snapshots in the same Region as the source resource.

If the policy targets resources on an Outpost, then you can create
snapshots on the same Outpost as the source resource, or in the Region
of that Outpost.


=head2 Times => ArrayRef[Str|Undef]

The time, in UTC, to start the operation. The supported format is
hh:mm.

The operation occurs within a one-hour window following the specified
time. If you do not specify a time, Amazon DLM selects a time within
the next 24 hours.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DLM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

