/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

public class Rational {
    public long num;
    public long denom;
    private static final int MAX_TERMS = 8;

    public Rational(long l, long l2) {
        this.num = l;
        this.denom = l2;
    }

    public Rational(Rational rational) {
        this.num = rational.num;
        this.denom = rational.denom;
    }

    public static Rational createFromFrac(long[] lArray, int n) {
        Rational rational = new Rational(0L, 1L);
        int n2 = n - 1;
        while (n2 >= 0) {
            rational.add(lArray[n2]);
            if (n2 != 0) {
                rational.invert();
            }
            --n2;
        }
        return rational;
    }

    public static Rational approximate(float f, float f2) {
        float f3 = f;
        long[] lArray = new long[8];
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            int n3 = (int)Math.floor(f3);
            lArray[n++] = n3;
            if ((f3 -= (float)n3) == 0.0f) break;
            f3 = 1.0f / f3;
            ++n2;
        }
        Rational rational = null;
        int n4 = 1;
        while (n4 <= n) {
            rational = Rational.createFromFrac(lArray, n4);
            if (Math.abs(rational.floatValue() - f) < f2) {
                return rational;
            }
            ++n4;
        }
        return rational;
    }

    public static Rational approximate(double d, double d2) {
        double d3 = d;
        long[] lArray = new long[8];
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            long l = (long)Math.floor(d3);
            lArray[n++] = l;
            if ((d3 -= (double)l) == 0.0) break;
            d3 = 1.0 / d3;
            ++n2;
        }
        Rational rational = null;
        int n3 = 1;
        while (n3 <= n) {
            rational = Rational.createFromFrac(lArray, n3);
            if (Math.abs(rational.doubleValue() - d) < d2) {
                return rational;
            }
            ++n3;
        }
        return rational;
    }

    private static long gcd(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (l2 > 0L) {
            long l3 = l % l2;
            l = l2;
            l2 = l3;
        }
        return l;
    }

    private void normalize() {
        long l;
        if (this.denom < 0L) {
            this.num = -this.num;
            this.denom = -this.denom;
        }
        if ((l = Rational.gcd(this.num, this.denom)) > 1L) {
            this.num /= l;
            this.denom /= l;
        }
    }

    public void add(long l) {
        this.num += l * this.denom;
        this.normalize();
    }

    public void add(Rational rational) {
        this.num = this.num * rational.denom + rational.num * this.denom;
        this.denom *= rational.denom;
        this.normalize();
    }

    public void subtract(long l) {
        this.num -= l * this.denom;
        this.normalize();
    }

    public void subtract(Rational rational) {
        this.num = this.num * rational.denom - rational.num * this.denom;
        this.denom *= rational.denom;
        this.normalize();
    }

    public void multiply(long l) {
        this.num *= l;
        this.normalize();
    }

    public void multiply(Rational rational) {
        this.num *= rational.num;
        this.denom *= rational.denom;
        this.normalize();
    }

    public void invert() {
        long l = this.num;
        this.num = this.denom;
        this.denom = l;
    }

    public float floatValue() {
        return (float)this.num / (float)this.denom;
    }

    public double doubleValue() {
        return (double)this.num / (double)this.denom;
    }

    public String toString() {
        return this.num + "/" + this.denom;
    }

    public static int ceil(long l, long l2) {
        int n = (int)(l / l2);
        if (l > 0L && l % l2 != 0L) {
            ++n;
        }
        return n;
    }

    public static int floor(long l, long l2) {
        int n = (int)(l / l2);
        if (l < 0L && l % l2 != 0L) {
            --n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        float f = Float.parseFloat(stringArray[0]);
        int n = 1;
        while (n < 15) {
            Rational rational = Rational.approximate(f, (float)Math.pow(10.0, -n));
            System.out.println(rational + " = " + rational.floatValue());
            ++n;
        }
    }
}

