# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220601185319;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6466011", "Marton",
"6472620", "Tauranga",
"6439718", "Mt\ Cook",
"646377", "Masterton",
"6469283", "Opunake",
"6433997", "Gore",
"6435529", "Roxburgh",
"6439752", "Cheviot",
"6462102", "Levin",
"646751", "New\ Plymouth",
"6439279", "Christchurch",
"6493991", "Pukekohe",
"6475627", "Taupo",
"6479108", "Whakatane",
"6496517", "Kaitaia",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6439876", "Roxburgh",
"6479090", "Taupo",
"6439320", "Akaroa",
"6436640", "Palmerston",
"6499001", "Auckland",
"644437", "Wellington",
"649948", "Auckland",
"6435993", "Mt\ Cook",
"647989", "Taupo",
"6449122", "Wellington",
"6478092", "Huntly",
"6436526", "Fox\ Glacier",
"6439007", "Dunedin",
"646327", "Marton",
"6437467", "Queenstown",
"643654", "Timaru",
"6439011", "Queenstown",
"647958", "Hamilton",
"644922", "Wellington",
"6435679", "Alexandra",
"6434270", "Oamaru",
"6462223", "Palmerston\ North",
"644817", "Wellington",
"6475606", "Matamata",
"6499017", "Kaikohe",
"64757", "Tauranga",
"6437487", "Winton",
"6433949", "Rangiora",
"6474655", "Te\ Kuiti",
"6439026", "Riverton",
"6432734", "Waimate",
"6466007", "Stratford",
"6435883", "Dunedin",
"646954", "Palmerston\ North\ W100",
"6436507", "Kaikoura",
"6497775", "Helensville",
"6466548", "Ruatoria",
"6495569", "Maungaturoto",
"6435536", "Invercargill",
"6466994", "Ohakune",
"6436995", "Westport",
"649580", "Auckland",
"6468803", "Gisborne",
"649426", "Hibiscus\ Coast",
"6439884", "Franz\ Josef",
"643455", "Dunedin",
"647836", "Hamilton",
"643248", "Lumsden",
"6479845", "Paeroa",
"6499457", "Kaitaia",
"649476", "Auckland",
"6468249", "Opunake",
"6436595", "Mt\ Cook",
"6439522", "Dunedin",
"6492007", "Warkworth",
"6469022", "Hawera",
"6439451", "Invercargill",
"6469241", "Napier",
"646834", "Napier\/Hastings",
"643331", "Christchurch",
"649428", "Hibiscus\ Coast",
"6439864", "Takaka",
"6463904", "Napier",
"6493209", "Great\ Barrier\ Island",
"6478996", "Huntly",
"649215", "Auckland",
"6474443", "Matamata",
"6472221", "Tauranga",
"6495589", "Pukekohe",
"6472819", "Rotorua",
"643393", "Christchurch",
"6432625", "Twizel",
"649639", "Auckland",
"6469319", "Masterton",
"6462624", "Opunake",
"646365", "Palmerston\ North",
"6466522", "Palmerston\ North",
"649237", "Pukekohe",
"6436684", "Dunedin",
"649478", "Auckland",
"6472118", "Taumarunui",
"643942", "Christchurch",
"6432633", "Otautau",
"647838", "Hamilton",
"6449030", "Paraparaumu",
"6499066", "Helensville",
"643246", "Tokanui",
"6473928", "Te\ Awamutu",
"6435698", "Hokitika",
"644889", "Wellington",
"6468999", "Napier",
"644896", "Wellington",
"6432616", "Ashburton",
"6472225", "Rotorua",
"643768", "Greymouth",
"6479856", "Tauranga",
"6472608", "Waihi",
"6432621", "Oamaru",
"646348", "Wanganui",
"6439091", "Rangiora",
"649812", "Auckland",
"6462816", "Gisborne",
"649552", "Pukekohe",
"647872", "Te\ Awamutu",
"6497771", "Kaikohe",
"6442420", "Wellington",
"6432429", "Timaru",
"6468889", "Levin",
"6439744", "Queenstown",
"6439298", "Motueka",
"6436991", "Culverden",
"6499049", "Great\ Barrier\ Island",
"647542", "Tauranga",
"6496997", "Hibiscus\ Coast",
"647981", "Hamilton",
"6437777", "Christchurch",
"649394", "Auckland",
"6479841", "Huntly",
"649801", "Auckland",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"646759", "New\ Plymouth",
"6435557", "Geraldine",
"646346", "Wanganui",
"6479010", "Thames",
"6436591", "Nelson",
"6439455", "Otautau",
"6433953", "Geraldine",
"6433917", "Franz\ Josef",
"64927", "Auckland",
"6472198", "Opotiki",
"6439015", "Wanaka",
"6469014", "Dannevirke",
"6433986", "Queenstown",
"6462410", "New\ Plymouth",
"6465609", "Pahiatua",
"6472823", "Whakatane",
"6439334", "Fox\ Glacier",
"649845", "Auckland",
"649631", "Auckland",
"643438", "Kurow",
"6439280", "Nelson",
"6474651", "Otorohanga",
"64447", "Wellington",
"6435660", "Haast",
"6434996", "Roxburgh",
"6434269", "Twizel",
"643339", "Christchurch",
"6468253", "Marton",
"6472144", "Matamata",
"6432720", "Nelson",
"647895", "Taumarunui",
"6439760", "Twizel",
"644938", "Wellington",
"643436", "Kurow",
"649903", "Auckland",
"6462164", "New\ Plymouth",
"6493939", "Auckland",
"647462", "Taupo",
"6499005", "Auckland",
"649965", "Auckland",
"6432812", "Haast",
"6435680", "Dunedin",
"6432220", "Dunedin",
"6434289", "Wanaka",
"647883", "Putaruru\/Tokoroa",
"647855", "Hamilton",
"6466996", "Stratford",
"6432807", "Tokanui",
"646378", "Masterton",
"6469273", "New\ Plymouth",
"6463927", "Dannevirke",
"644816", "Wellington",
"6435534", "Takaka",
"6439886", "Haast",
"6434260", "Oamaru",
"64347", "Dunedin",
"6435669", "Wanaka",
"646590", "Palmerston\ North",
"6439289", "Akaroa",
"649403", "Kawakawa",
"6474652", "Paeroa",
"649892", "Auckland",
"64456", "Wellington",
"6462607", "Taihape",
"646328", "Palmerston\ North",
"644589", "Wellington",
"647374", "Taupo",
"6465600", "Palmerston\ North",
"6462419", "Masterton",
"6478451", "Hamilton",
"6499559", "Whangarei",
"6439269", "Dunedin",
"6478994", "Tauranga",
"6434280", "Queenstown",
"6439755", "Rangiora",
"6432229", "Dunedin",
"6462105", "Taihape",
"6435689", "Otautau",
"64497", "Wellington",
"647957", "Hamilton",
"6463906", "Napier",
"6462611", "Napier",
"644818", "Wellington",
"646376", "Pahiatua",
"6469200", "Gisborne",
"6462626", "Mokau",
"646326", "Palmerston\ North",
"6493930", "Whangarei",
"646213", "Wanganui",
"6437477", "Roxburgh",
"6439769", "Roxburgh",
"644436", "Wellington",
"6432729", "Westport",
"6499064", "Helensville",
"6499420", "Pukekohe",
"6432811", "Fox\ Glacier",
"6463943", "Masterton",
"644370", "Wellington",
"6478095", "Taupo",
"6478594", "Hamilton",
"6436686", "Invercargill",
"6436617", "Cromwell",
"6436653", "Edendale",
"6434244", "Amberley",
"6439874", "Cromwell",
"649825", "Auckland",
"6435508", "Cheviot",
"649236", "Pukekohe",
"6434298", "Hokitika",
"6432622", "Balclutha",
"6479750", "Tauranga",
"6468990", "Ruatoria",
"6466525", "Marton",
"6436524", "Hokitika",
"6439092", "Rangiora",
"6436992", "Greymouth",
"649427", "Hibiscus\ Coast",
"649984", "Auckland",
"6497772", "Kaitaia",
"647391", "Hamilton",
"6432648", "Geraldine",
"6475604", "Hamilton",
"6472613", "Putaruru\/Tokoroa",
"6479019", "Whangamata",
"6439853", "Amberley",
"6467554", "New\ Plymouth",
"6439533", "Geraldine",
"6479842", "Matamata",
"6462149", "Ruatoria",
"6499811", "Hibiscus\ Coast",
"646949", "Levin\ W100",
"6432420", "Christchurch",
"647351", "Rotorua",
"647837", "Hamilton",
"6442429", "Paraparaumu",
"644203", "Wellington",
"6439024", "Lumsden",
"6499040", "Helensville",
"6439525", "Milton",
"6436592", "Nelson",
"6439313", "Te\ Anau",
"649477", "Auckland",
"6432736", "Dunedin",
"649238", "Pukekohe",
"6469025", "Mokau",
"6468880", "Napier\/Hastings",
"6475480", "Tauranga",
"6433984", "Roxburgh",
"6469016", "Ohakune",
"6432757", "Lumsden",
"643614", "Timaru",
"644495", "Wellington",
"643442", "Queenstown",
"6439336", "Cromwell",
"6432713", "Ashburton",
"6434994", "Palmerston",
"643767", "Greymouth",
"646843", "Napier\/Hastings",
"6442127", "Paraparaumu",
"6495560", "Whangarei",
"6469242", "Levin",
"6473945", "Tauranga",
"6439521", "Dunedin",
"646347", "Wanganui",
"6472146", "Otorohanga",
"6439452", "Gore",
"6469850", "Napier",
"644897", "Wellington",
"6478133", "Putaruru\/Tokoroa",
"6472222", "Hamilton",
"6472810", "Tauranga",
"6462423", "Gisborne",
"6437448", "Haast",
"6469310", "Wanganui",
"644393", "Paraparaumu",
"6462166", "Opunake",
"643752", "Franz\ Josef",
"6468818", "Opunake",
"643955", "Dunedin",
"64943", "Whangarei",
"6466521", "Palmerston\ North",
"643983", "Christchurch",
"6462101", "Levin",
"6439751", "Culverden",
"6466012", "Pahiatua",
"6498823", "Kaitaia",
"6436649", "Gore",
"6468264", "Palmerston\ North",
"6432614", "Akaroa",
"643437", "Oamaru",
"647245", "Hamilton",
"6462615", "Gisborne",
"649640", "Auckland",
"64423", "Wellington",
"6449121", "Wellington",
"6439270", "Greymouth",
"6499002", "Auckland",
"6479854", "Rotorua",
"6472629", "Taupo",
"649880", "Auckland",
"647386", "Taupo",
"643415", "Balclutha",
"6432815", "Fairlie",
"6462814", "Hawera",
"6478091", "Matamata",
"6439746", "Dunedin",
"649295", "Auckland",
"6439012", "Queenstown",
"644904", "Paraparaumu",
"6433940", "Westport",
"644915", "Wellington",
"649349", "Auckland",
"6439703", "Takaka",
"6462153", "New\ Plymouth",
"643922", "Nelson",
"6434279", "Twizel",
"6435670", "Palmerston",
"643226", "Otautau",
"646861", "Gisborne",
"6493934", "Kaitaia",
"6472197", "Tauranga",
"647869", "Thames",
"644219", "Wellington",
"6462169", "Featherston",
"6472822", "Rotorua",
"6469271", "Pahiatua",
"6478590", "Hamilton",
"6498901", "Pukekohe",
"6499424", "Auckland",
"649959", "Hibiscus\ Coast",
"643923", "Nelson",
"6434284", "Wanaka",
"649986", "Whangarei",
"644571", "Wellington",
"6478990", "Thames",
"649282", "Auckland",
"6432668", "Blenheim",
"6468252", "Dannevirke",
"6439705", "Motueka",
"6462155", "Hawera",
"649666", "Auckland",
"6498825", "Maungaturoto",
"6465604", "Ohakune",
"6469019", "Pahiatua",
"6462613", "Waipukurau",
"6435530", "Nelson",
"6472149", "Whangamata",
"646837", "Wairoa",
"6432813", "Geraldine",
"647949", "Hamilton",
"6463941", "Masterton",
"6434264", "Kurow",
"649988", "Whangarei",
"6496009", "Pukekohe",
"6479025", "Huntly",
"644392", "Wellington",
"6436651", "Riverton",
"6473927", "Te\ Kuiti",
"647378", "Taupo",
"6478135", "Te\ Kuiti",
"6467550", "New\ Plymouth",
"646324", "Palmerston\ North",
"643657", "Queenstown",
"646765", "Stratford",
"6468884", "Palmerston\ North",
"6439749", "Christchurch",
"6499044", "Hibiscus\ Coast",
"6449740", "Paraparaumu",
"6439020", "Gore",
"6462425", "Masterton",
"647590", "Hamilton",
"6432424", "Nelson",
"6435697", "Westport",
"64320", "Gore",
"643982", "Christchurch",
"6499100", "Pukekohe",
"643731", "Greymouth",
"644260", "Wellington",
"6472607", "Paeroa",
"6434276", "Palmerston",
"643697", "Geraldine",
"643753", "Hokitika",
"646374", "Dannevirke",
"6475600", "Hamilton",
"6439326", "Rangiora",
"6468994", "Waipukurau",
"6479754", "Tauranga",
"6436646", "Roxburgh",
"6439297", "Takaka",
"644805", "Wellington",
"643443", "Wanaka",
"6436520", "Greymouth",
"6437778", "Greymouth",
"6432715", "Culverden",
"6472611", "Matamata",
"6496998", "Helensville",
"647376", "Taupo",
"6435558", "Waimate",
"6439531", "Timaru",
"6434405", "Alexandra",
"6435512", "Rangiora",
"6472626", "Rotorua",
"6439851", "Culverden",
"649820", "Auckland",
"647213", "Hamilton",
"6433918", "Fox\ Glacier",
"6439311", "Invercargill",
"646842", "Napier\/Hastings",
"6433952", "Fairlie",
"6439870", "Queenstown",
"6434240", "Ashburton",
"643288", "Christchurch",
"6468308", "Napier",
"643950", "Dunedin",
"6439266", "Dunedin",
"6499556", "Maungaturoto",
"6435686", "Gore",
"6472615", "Te\ Kuiti",
"6432711", "Akaroa",
"6432226", "Timaru",
"6468802", "New\ Plymouth",
"6499295", "Kaikohe",
"6442820", "Wellington",
"6439869", "Blenheim",
"6444889", "Paraparaumu",
"643224", "Invercargill",
"6439766", "Balclutha",
"6439535", "Fairlie",
"6499458", "Kawakawa",
"6432726", "Franz\ Josef",
"6434401", "Cromwell",
"644906", "Paraparaumu",
"6439855", "Rangiora",
"6436689", "Christchurch",
"644202", "Wellington",
"6469854", "Waipukurau",
"6439523", "Balclutha",
"64335", "Christchurch",
"6439315", "Tokanui",
"6469314", "Waiouru",
"6462629", "Levin",
"6492008", "Hibiscus\ Coast",
"647332", "Rotorua",
"6472814", "Putaruru\/Tokoroa",
"6478131", "Otorohanga",
"6436655", "Westport",
"6435666", "Oamaru",
"646650", "Napier",
"6434990", "Queenstown",
"6439286", "Cromwell",
"6466999", "New\ Plymouth",
"6474442", "Morrinsville",
"6462421", "New\ Plymouth",
"6495564", "Whangarei",
"6433980", "Milton",
"6462416", "Waipukurau",
"646388", "Taihape",
"644529", "Wellington",
"643469", "Dunedin",
"649951", "Auckland",
"6466523", "Palmerston\ North",
"6468244", "Waipukurau",
"6432632", "Lumsden",
"644211", "Wellington",
"6439717", "Fairlie",
"6498821", "Dargaville",
"6433998", "Lumsden",
"6469282", "Mokau",
"6439753", "Amberley",
"6462103", "Levin",
"6496518", "Kawakawa",
"6435674", "Milton",
"6479107", "Whakatane",
"644910", "Wellington",
"6475628", "Tauranga",
"647843", "Hamilton",
"6435992", "Fox\ Glacier",
"6499726", "Kawakawa",
"6432739", "Balclutha",
"6449123", "Wellington",
"6433944", "Ashburton",
"6439008", "Timaru",
"6479242", "Rotorua",
"6478093", "Rotorua",
"6498816", "Great\ Barrier\ Island",
"6437468", "Wanaka",
"647347", "Rotorua",
"6479021", "Te\ Awamutu",
"6479850", "Tokoroa",
"6439274", "Queenstown",
"6469275", "Wanganui",
"6462222", "Ohakune",
"6462810", "Gisborne",
"6499018", "Maungaturoto",
"6466008", "Ohakune",
"647905", "Taupo",
"6436508", "Rangiora",
"6462151", "New\ Plymouth",
"649402", "Kawakawa",
"6439701", "Nelson",
"64687", "Napier\/Hastings",
"6432610", "Darfield",
"6435882", "Dunedin",
"6468260", "Featherston",
"6449008", "Paraparaumu",
"6469281", "Wairoa",
"647921", "Rotorua",
"6466013", "Featherston",
"6498822", "Kaikohe",
"6432426", "Blenheim",
"649902", "Warkworth",
"6432730", "Blenheim",
"6468886", "Wanganui",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6499046", "Pukekohe",
"646836", "Napier\/Hastings",
"6434274", "Kurow",
"6435991", "Franz\ Josef",
"6499003", "Warkworth",
"647882", "Putaruru\/Tokoroa",
"6479022", "Morrinsville",
"647463", "Whakatane",
"6479241", "Whakatane",
"647834", "Hamilton",
"6439057", "Waimate",
"6436644", "Alexandra",
"6468269", "New\ Plymouth",
"6432619", "Christchurch",
"6439324", "Darfield",
"6468996", "Napier",
"649652", "Warkworth",
"6462221", "Gisborne",
"6462819", "Levin",
"6472624", "Whakatane",
"6439702", "Nelson",
"6462152", "New\ Plymouth",
"6479859", "Tauranga",
"6462118", "Waipukurau",
"6435881", "Dunedin",
"649424", "Hibiscus\ Coast",
"6499631", "Pukekohe",
"6468255", "Pahiatua",
"646838", "Wairoa",
"6462620", "New\ Plymouth",
"649451", "Auckland",
"647377", "Taupo",
"647543", "Tauranga",
"6493936", "Maungaturoto",
"6465627", "Levin",
"6432758", "Otautau",
"647873", "Otorohanga",
"6436680", "Akaroa",
"6468801", "Wanganui",
"643740", "Christchurch",
"6499426", "Auckland",
"6432712", "Amberley",
"6434286", "Christchurch",
"6463900", "Gisborne",
"647823", "Hamilton",
"6439860", "Nelson",
"6434402", "Alexandra",
"6435515", "Oamaru",
"649210", "Auckland",
"6469243", "New\ Plymouth",
"6442128", "Paraparaumu",
"6439453", "Te\ Anau",
"6474649", "Matamata",
"6433955", "Mt\ Cook",
"643211", "Invercargill",
"6478132", "Paeroa",
"6472223", "Hamilton",
"6474441", "Waihi",
"6462422", "Napier\/Hastings",
"6433989", "Waimate",
"643529", "Nelson",
"6437447", "Greymouth",
"6465606", "Waiouru",
"643696", "Geraldine",
"6466990", "Mokau",
"643450", "Queenstown",
"6468817", "Stratford",
"649585", "Auckland",
"647220", "Tauranga",
"643689", "Waimate",
"649813", "Auckland",
"6432631", "Gore",
"6439880", "Greymouth",
"6434266", "Palmerston",
"6434999", "Dunedin",
"6479014", "Matamata",
"6436618", "Blenheim",
"6436652", "Winton",
"6475609", "Paeroa",
"6474445", "Hamilton",
"6435507", "Ashburton",
"643260", "Christchurch",
"6435676", "Kurow",
"644299", "Paraparaumu",
"6439029", "Tokanui",
"643943", "Christchurch",
"6432623", "Lawrence",
"6439740", "Christchurch",
"643434", "Oamaru",
"6434297", "Westport",
"6432635", "Riverton",
"6462144", "Ruatoria",
"649919", "Auckland",
"6433946", "Culverden",
"6498814", "Pukekohe",
"6467559", "New\ Plymouth",
"6439276", "Nelson",
"6436993", "Kaikoura",
"643482", "Dunedin",
"6497773", "Dargaville",
"6434249", "Kaikoura",
"6432647", "Fairlie",
"6472612", "Te\ Awamutu",
"6435526", "Kurow",
"6468805", "Wanganui",
"6439852", "Cheviot",
"646387", "Waiouru",
"6479709", "Matamata",
"6436529", "Westport",
"6439532", "Timaru",
"6479843", "Morrinsville",
"6435511", "Kaikoura",
"6436593", "Nelson",
"644907", "Wellington",
"644934", "Wellington",
"6439312", "Riverton",
"6433951", "Timaru",
"646855", "Waipukurau",
"647850", "Hamilton",
"6472821", "Hamilton",
"6469272", "Featherston",
"646344", "Wanganui",
"6432808", "Westport",
"6463928", "Pahiatua",
"6499554", "Kaitaia",
"6478999", "Hamilton",
"643681", "Timaru",
"6493206", "Pukekohe",
"6462225", "Levin",
"6435684", "Winton",
"6432224", "Invercargill",
"643571", "Nelson",
"6498691", "Maungaturoto",
"6474653", "Putaruru\/Tokoroa",
"6478599", "Hamilton",
"6462608", "Dannevirke",
"644461", "Wellington",
"64936", "Auckland",
"6439764", "Lawrence",
"6499069", "Pukekohe",
"6432724", "Greymouth",
"643521", "Nelson",
"6435885", "Invercargill",
"6472816", "Morrinsville",
"647348", "Rotorua",
"6462160", "Masterton",
"6469316", "Dannevirke",
"6468251", "Wanganui",
"643219", "Invercargill",
"6435664", "Timaru",
"6469285", "Hawera",
"6439284", "Blenheim",
"6495566", "Kaikohe",
"6435539", "Otautau",
"6472140", "Putaruru\/Tokoroa",
"6462414", "Napier",
"6435995", "Darfield",
"6437478", "Twizel",
"647346", "Rotorua",
"649840", "Auckland",
"6469010", "Taihape",
"649459", "Whangarei",
"643961", "Christchurch",
"644894", "Wellington",
"6468246", "Hawera",
"6439330", "Westport",
"6463942", "Masterton",
"6479245", "Matamata",
"6439711", "Geraldine",
"6494702", "Whangarei",
"6442609", "Paraparaumu",
"6432999", "Invercargill",
"643487", "Dunedin",
"643924", "Christchurch",
"6492836", "Kaitaia",
"6436518", "Murchison",
"6479101", "Rotorua",
"6432654", "Blenheim",
"6499717", "Whangarei",
"643250", "Christchurch",
"6436579", "Wanaka",
"646382", "Taihape",
"6462800", "Palmerston\ North",
"6499008", "Pukekohe",
"6493944", "Hibiscus\ Coast",
"6439726", "Timaru",
"644902", "Paraparaumu",
"6479027", "Paeroa",
"6473996", "Otorohanga",
"649291", "Auckland",
"646307", "Featherston",
"6472195", "Rotorua",
"6439018", "Ranfurly",
"6435540", "Edendale",
"6439052", "Mt\ Cook",
"6432889", "Blenheim",
"6436629", "Christchurch",
"6439079", "Murchison",
"6469579", "Pahiatua",
"649829", "Auckland",
"649233", "Pukekohe",
"6496508", "Hibiscus\ Coast",
"6479290", "Hamilton",
"6479006", "Taupo",
"6462157", "Stratford",
"646865", "Gisborne",
"6439707", "Takaka",
"644210", "Wellington",
"6469294", "Palmerston\ North",
"6439295", "Nelson",
"6492226", "Helensville",
"646373", "Masterton",
"6477880", "Hamilton",
"6432717", "Kaikoura",
"649950", "Auckland",
"6432753", "Winton",
"6465622", "Stratford",
"646323", "Palmerston\ North",
"6442199", "Paraparaumu",
"64935", "Auckland",
"646651", "Napier",
"649408", "Kaitaia",
"6439739", "Invercargill",
"6439458", "Edendale",
"6467779", "Masterton",
"6478137", "Thames",
"6472804", "Whangamata",
"6473925", "Putaruru\/Tokoroa",
"6498881", "Hibiscus\ Coast",
"6472126", "Otorohanga",
"6469304", "Wairoa",
"6466556", "Stratford",
"6434230", "Christchurch",
"649600", "Auckland",
"6437442", "Murchison",
"6473933", "Rotorua",
"6435695", "Fox\ Glacier",
"643612", "Timaru",
"643444", "Ranfurly",
"64948", "Auckland",
"649406", "Kaitaia",
"6436636", "Waimate",
"6468812", "Waiouru",
"6472605", "Thames",
"643951", "Dunedin",
"6432440", "Christchurch",
"6473921", "Matamata",
"6499464", "Whangarei",
"6436657", "Franz\ Josef",
"6436613", "Wanaka",
"6494312", "Warkworth",
"6439044", "Milton",
"6469045", "Waipukurau",
"6477776", "Whangamata",
"6462129", "Waiouru",
"6435502", "Christchurch",
"6435691", "Murchison",
"6434292", "Hokitika",
"6432628", "Ranfurly",
"6479710", "Putaruru\/Tokoroa",
"6472601", "Hamilton",
"649299", "Auckland",
"649982", "Whangarei",
"6472115", "Taumarunui",
"6439098", "Akaroa",
"6475610", "Putaruru\/Tokoroa",
"6439291", "Dunedin",
"6436998", "Blenheim",
"643419", "Balclutha",
"647533", "Tauranga",
"6497778", "Pukekohe",
"6469613", "Levin",
"6432642", "Fox\ Glacier",
"6499297", "Hibiscus\ Coast",
"647551", "Tauranga",
"6478070", "Morrinsville",
"6498859", "Kaitaia",
"6499870", "Whangarei",
"6434224", "Te\ Anau",
"6439857", "Akaroa",
"6479848", "Te\ Kuiti",
"647887", "Morrinsville",
"6478141", "Taupo",
"6445953", "Wellington",
"6443333", "Paraparaumu",
"6439317", "Gore",
"6436598", "Wanaka",
"6496019", "Auckland",
"6432749", "Wanaka",
"6439060", "Greymouth",
"6432803", "Otautau",
"6472191", "Whakatane",
"643300", "Ashburton\/Akaroa\/Chatham\ Islands",
"6463923", "Ohakune",
"6469277", "Gisborne",
"6437454", "Ashburton",
"6463999", "Palmerston\ North",
"6436580", "Invercargill",
"6474658", "Waihi",
"6462603", "Palmerston\ North",
"6469009", "Palmerston\ North",
"6475829", "Hamilton",
"6465614", "Wanganui",
"6469890", "Gisborne",
"644488", "Wellington",
"6436560", "Palmerston",
"6439715", "Timaru",
"6469714", "Hawera",
"646968", "New\ Plymouth\ W100",
"647372", "Taupo",
"644570", "Wellington",
"643666", "Christchurch",
"6439080", "Ashburton",
"6468824", "Wanganui",
"6499476", "Auckland",
"643234", "Riverton",
"6466509", "Napier\/Waipukurau",
"6437473", "Milton",
"644499", "Wellington",
"647322", "Whakatane",
"6495530", "Great\ Barrier\ Island",
"6492224", "Auckland",
"6472192", "Whakatane",
"646369", "Levin",
"643488", "Dunedin",
"6472827", "Tauranga",
"6439055", "Fairlie",
"6469296", "Levin",
"643960", "Christchurch",
"6475820", "Hamilton",
"643749", "Christchurch",
"6469000", "New\ Plymouth",
"647464", "Hamilton",
"6492808", "Great\ Barrier\ Island",
"6467525", "Mokau",
"643539", "Nelson",
"646306", "Featherston",
"649635", "Auckland",
"6463990", "Featherston",
"6436589", "Otautau",
"6432740", "Lawrence",
"6439069", "Haast",
"6432663", "Christchurch",
"6496010", "Kaitaia",
"64336", "Christchurch",
"6468257", "Taihape",
"6466554", "Hawera",
"6469306", "Hawera",
"6472124", "Matamata",
"646308", "Featherston",
"6495539", "Auckland",
"6494705", "Whangarei",
"6472806", "Matamata",
"649423", "Warkworth",
"644460", "Wellington",
"643520", "Blenheim",
"643486", "Dunedin",
"647315", "Opotiki",
"6462618", "Masterton",
"643680", "Fairlie",
"6436634", "Mt\ Cook",
"649473", "Auckland",
"647833", "Hamilton",
"6449080", "Paraparaumu",
"644666", "Wellington",
"6432818", "Christchurch",
"6436569", "Alexandra",
"647304", "Whakatane",
"647851", "Hamilton",
"647824", "Hamilton",
"6492834", "Kawakawa",
"6496883", "Auckland",
"6473922", "Morrinsville",
"6434353", "Twizel",
"6435692", "Takaka",
"6435501", "Christchurch",
"6474639", "Opotiki",
"6478128", "Huntly",
"6498016", "Hibiscus\ Coast",
"6479719", "Te\ Kuiti",
"6432656", "Nelson",
"6437445", "Fox\ Glacier",
"647544", "Tauranga",
"6468815", "Pahiatua",
"6472602", "Hamilton",
"6462120", "Palmerston\ North",
"6434291", "Westport",
"649392", "Auckland",
"6432449", "Queenstown",
"649407", "Kaikohe",
"6439724", "Blenheim",
"649814", "Auckland",
"6473994", "Rotorua",
"649554", "Hibiscus\ Coast",
"6439292", "Timaru",
"6499879", "Warkworth",
"6437773", "Dunedin",
"6465625", "Gisborne",
"6498850", "Great\ Barrier\ Island",
"6432641", "Franz\ Josef",
"6496993", "Whangarei",
"6435953", "Christchurch",
"6435553", "Wanaka",
"6478142", "Whakatane",
"6478079", "Hamilton",
"6435517", "Lawrence",
"6433913", "Murchison",
"6475619", "Hamilton",
"6499818", "Great\ Barrier\ Island",
"6479004", "Te\ Awamutu",
"6433957", "Palmerston",
"6473948", "Opotiki",
"6468303", "Napier",
"643944", "Christchurch",
"6439730", "Invercargill",
"643433", "Oamaru",
"6465621", "New\ Plymouth",
"6437456", "Culverden",
"6432645", "Greymouth",
"643451", "Queenstown",
"6468807", "Gisborne",
"649969", "Auckland",
"6499453", "Warkworth",
"6477889", "Whakatane",
"6465616", "Hawera",
"646975", "Napier",
"6439528", "Lawrence",
"6479501", "Opotiki",
"647886", "Putaruru\/Tokoroa",
"6494315", "Warkworth",
"6498882", "Whangarei",
"643335", "Christchurch",
"6469716", "Opunake",
"6478080", "Hamilton",
"6474447", "Te\ Kuiti",
"6435505", "Akaroa",
"649211", "Auckland",
"6499474", "Helensville",
"6468826", "Levin",
"649908", "Auckland",
"6437441", "Motueka",
"647888", "Matamata",
"649849", "Auckland",
"6468811", "Marton",
"643741", "Christchurch",
"6434239", "Christchurch",
"6434295", "Fox\ Glacier",
"6432637", "Winton",
"6466528", "Dannevirke",
"6467770", "Gisborne",
"6465950", "Palmerston\ North",
"6469287", "Ohakune",
"6439046", "Kurow",
"6433993", "Te\ Anau",
"6494701", "Whangarei",
"6492426", "Whangarei",
"643667", "Christchurch",
"6439712", "Fairlie",
"6439758", "Ashburton",
"646952", "Palmerston\ North\ W100",
"643206", "Edendale",
"6479747", "Te\ Kuiti",
"6499466", "Kaikohe",
"6462108", "Ohakune",
"6496513", "Whangarei",
"644290", "Paraparaumu",
"6479102", "Rotorua",
"6477774", "Thames",
"6475623", "Tauranga",
"6462809", "Napier\/Hastings",
"646343", "Wanganui",
"6435997", "Amberley",
"644250", "Wellington",
"6432609", "Mt\ Cook",
"646847", "Napier\/Hastings",
"6432990", "Lumsden",
"6439003", "Ashburton",
"6437463", "Mt\ Cook",
"644924", "Wellington",
"6479247", "Hamilton",
"6436546", "Fairlie",
"646967", "New\ Plymouth",
"647970", "Hamilton",
"6469570", "Palmerston\ North",
"644893", "Wellington",
"6472428", "Taupo",
"6439340", "Mt\ Cook",
"6439070", "Motueka",
"6436620", "Kaikoura",
"6499013", "Kawakawa",
"6462227", "Napier",
"6479299", "Rotorua",
"6437483", "Otautau",
"6434226", "Lumsden",
"643692", "Geraldine",
"6466003", "Ruatoria",
"6472130", "Tauranga",
"6436503", "Ashburton",
"6435887", "Invercargill",
"6435549", "Hokitika",
"647920", "Rotorua",
"6469278", "Gisborne",
"6449084", "Wellington",
"644892", "Paraparaumu",
"6432802", "Gore",
"647878", "Te\ Kuiti",
"6463922", "Palmerston\ North",
"6436630", "Takaka",
"643653", "Blenheim",
"649589", "Auckland",
"643685", "Fairlie",
"6499015", "Dargaville",
"6437485", "Te\ Anau",
"6462602", "Palmerston\ North",
"649816", "Auckland",
"643525", "Takaka",
"643693", "Geraldine",
"6472120", "Putaruru\/Tokoroa",
"6474657", "Thames",
"6466550", "New\ Plymouth",
"644465", "Wellington",
"6434236", "Amberley",
"6432661", "Christchurch",
"6466005", "Mokau",
"6436505", "Culverden",
"647828", "Huntly",
"647546", "Tauranga",
"6437459", "Rangiora",
"6463994", "Dannevirke",
"6433995", "Tokanui",
"647876", "Te\ Kuiti",
"643903", "Christchurch",
"643447", "Alexandra",
"6475625", "Rotorua",
"646953", "Palmerston\ North\ W100",
"6496515", "Dargaville",
"6496014", "Dargaville",
"64992", "Auckland",
"6432744", "Ranfurly",
"649320", "Auckland",
"647826", "Huntly",
"649630", "Auckland",
"6437472", "Lawrence",
"643762", "Greymouth",
"64997", "Auckland",
"6492220", "Auckland",
"6477886", "Rotorua",
"643965", "Christchurch",
"647217", "Taupo",
"649558", "Auckland",
"6465619", "Masterton",
"646342", "Wanganui",
"649818", "Auckland",
"6439005", "Invercargill",
"6475824", "Hamilton",
"6469004", "Napier\/Hastings",
"6437465", "Waimate",
"6496881", "Auckland",
"6436612", "Akaroa",
"643977", "Christchurch",
"6479296", "Tauranga",
"6494313", "Warkworth",
"6436658", "Fox\ Glacier",
"6479000", "Hamilton",
"6436549", "Mt\ Cook",
"647306", "Whakatane",
"6434351", "Mt\ Cook",
"6435503", "Christchurch",
"6434293", "Haast",
"647980", "Hamilton",
"643552", "Dunedin",
"6473990", "Te\ Awamutu",
"6432627", "Alexandra",
"6435546", "Greymouth",
"6439097", "Darfield",
"64944", "Auckland",
"643484", "Dunedin",
"6498854", "Hibiscus\ Coast",
"6434229", "Winton",
"6497777", "Auckland",
"6462124", "Marton",
"647308", "Whakatane",
"6436997", "Motueka",
"6462806", "Napier\/Hastings",
"6439049", "Palmerston",
"6432643", "Haast",
"6499298", "Pukekohe",
"6496991", "Kaikohe",
"646279", "Hawera",
"6439720", "Blenheim",
"643432", "Oamaru",
"6435951", "Christchurch",
"6492429", "Pukekohe",
"6499469", "Maungaturoto",
"6437771", "Blenheim",
"6479847", "Te\ Awamutu",
"6439858", "Kaikoura",
"6432606", "Dunedin",
"6435551", "Franz\ Josef",
"6492830", "Auckland",
"6499455", "Dargaville",
"646833", "Napier\/Hastings",
"6443332", "Wellington",
"6445952", "Wellington",
"6436597", "Cromwell",
"647466", "Tauranga",
"6439318", "Lumsden",
"6433911", "Nelson",
"646304", "Featherston",
"6468301", "Napier",
"644928", "Wellington",
"6496995", "Maungaturoto",
"6435955", "Christchurch",
"6469309", "Mokau",
"6467774", "Dannevirke",
"6432752", "Te\ Anau",
"6437775", "Wanaka",
"6472809", "Otorohanga",
"6465623", "Opunake",
"6432718", "Rangiora",
"647343", "Rotorua",
"6436566", "Kurow",
"6499451", "Warkworth",
"6435555", "Timaru",
"647847", "Hamilton",
"6439457", "Winton",
"6433915", "Greymouth",
"6499470", "Hibiscus\ Coast",
"649248", "Auckland",
"6463914", "Stratford",
"6469247", "Wanganui",
"6478084", "Hamilton",
"6479422", "Tauranga",
"643215", "Invercargill",
"6478138", "Waihi",
"6473932", "Rotorua",
"6469468", "Featherston",
"6437443", "Nelson",
"6469299", "Napier\/Hastings",
"6439734", "Edendale",
"6439066", "Hokitika",
"6468813", "Taihape",
"649581", "Auckland",
"6436586", "Edendale",
"6499876", "Kaikohe",
"647925", "Tauranga",
"6494703", "Whangarei",
"6436517", "Motueka",
"649422", "Warkworth",
"6433991", "Invercargill",
"6499718", "Whangarei",
"6468690", "Gisborne",
"6475621", "Tauranga",
"6496511", "Whangarei",
"6475616", "Whangamata",
"6499007", "Kaikohe",
"647832", "Hamilton",
"643948", "Invercargill",
"6439001", "Christchurch",
"6436624", "Darfield",
"6439344", "Timaru",
"6478076", "Te\ Awamutu",
"6437461", "Fairlie",
"6469574", "Taihape",
"6439017", "Cromwell",
"649915", "Auckland",
"6498019", "Pukekohe",
"6432659", "Takaka",
"6479716", "Waihi",
"6499011", "Kaitaia",
"6432994", "Otautau",
"647884", "Morrinsville",
"6437481", "Invercargill",
"6496507", "Helensville",
"6432446", "Blenheim",
"643946", "Invercargill",
"646750", "Mokau",
"6439708", "Murchison",
"6462158", "Opunake",
"6477770", "Tauranga",
"6466001", "Napier",
"6475950", "Hamilton",
"6436501", "Akaroa",
"6479294", "Hamilton",
"647877", "Te\ Kuiti",
"6462107", "Dannevirke",
"6479748", "Taumarunui",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6433992", "Riverton",
"643446", "Roxburgh",
"6439713", "Mt\ Cook",
"649404", "Kawakawa",
"6469288", "Waiouru",
"6496512", "Whangarei",
"647547", "Tauranga",
"6475622", "Tauranga",
"647323", "Whakatane",
"6435544", "Winton",
"647216", "Rotorua",
"6435998", "Rangiora",
"6437475", "Palmerston",
"6439002", "Rangiora",
"647827", "Hamilton",
"6498856", "Maungaturoto",
"6437462", "Geraldine",
"6478097", "Whakatane",
"6477779", "Putaruru\/Tokoroa",
"6432805", "Winton",
"646214", "Gisborne",
"6463925", "Waiouru",
"6462804", "Palmerston\ North",
"6473339", "Taupo",
"643789", "Westport",
"6462126", "Pahiatua",
"649881", "Auckland",
"6462228", "Wanganui",
"6499012", "Kawakawa",
"6472427", "Rotorua",
"643448", "Alexandra",
"6499746", "Kawakawa",
"646769", "New\ Plymouth",
"6437482", "Lumsden",
"6462605", "Marton",
"6466002", "Napier",
"6436502", "Amberley",
"649817", "Auckland",
"649557", "Auckland",
"647218", "Tauranga",
"6432650", "Christchurch",
"643756", "Hokitika",
"6435888", "Timaru",
"6469615", "Masterton",
"643978", "Christchurch",
"6468302", "Napier",
"6499479", "Pukekohe",
"6432751", "Riverton",
"6468808", "Palmerston\ North",
"6469300", "Gisborne",
"6499452", "Warkworth",
"6445955", "Wellington",
"6435560", "Mt\ Cook",
"6472800", "Thames",
"6439527", "Kurow",
"6434234", "Darfield",
"6436615", "Ashburton",
"6463996", "Palmerston\ North",
"6498883", "Whangarei",
"6462139", "Palmerston\ North",
"647334", "Rotorua",
"647307", "Whakatane",
"6479421", "Tauranga",
"6496016", "Warkworth",
"6432746", "Alexandra",
"6443709", "Paraparaumu",
"6474448", "Taumarunui",
"6473931", "Whangamata",
"644204", "Wellington",
"649983", "Whangarei",
"643926", "Christchurch",
"6469290", "Napier\/Hastings",
"6475826", "Hamilton",
"6469006", "Gisborne",
"6466527", "Taihape",
"6477884", "Tauranga",
"647865", "Whangamata",
"6432638", "Tokanui",
"646844", "Napier\/Hastings",
"6436611", "Rangiora",
"6499874", "Kawakawa",
"6434220", "Invercargill",
"6496882", "Auckland",
"647350", "Rotorua",
"6473923", "Otorohanga",
"6473999", "Taupo",
"6435693", "Nelson",
"646761", "Opunake",
"6473935", "Rotorua",
"6479009", "Hamilton",
"6472603", "Hamilton",
"6475614", "Thames",
"6439346", "Christchurch",
"6478074", "Taumarunui",
"6436626", "Akaroa",
"6469576", "Dannevirke",
"647390", "Hamilton",
"649889", "Auckland",
"647848", "Hamilton",
"643236", "Winton",
"6472459", "Rotorua",
"6469611", "Wanganui",
"6479714", "Huntly",
"647968", "Hamilton",
"646372", "Masterton",
"6439293", "Blenheim",
"644801", "Wellington",
"6432755", "Edendale",
"6437772", "Timaru",
"643984", "Blenheim",
"6432996", "Riverton",
"6496992", "Kawakawa",
"6435952", "Christchurch",
"6492839", "Whangarei",
"647846", "Hamilton",
"6439729", "Fox\ Glacier",
"6435552", "Queenstown",
"6435518", "Milton",
"6443331", "Wellington",
"6445951", "Wellington",
"6478143", "Opotiki",
"6439040", "Balclutha",
"6499460", "Whangarei",
"6447771", "Paraparaumu",
"6432444", "Nelson",
"6492420", "Auckland",
"6433912", "Motueka",
"6442125", "Paraparaumu",
"6473947", "Whakatane",
"6436576", "Cromwell",
"6433958", "Oamaru",
"646322", "Marton",
"646964", "Wanganui",
"6472193", "Whakatane",
"6432801", "Lumsden",
"6463921", "Palmerston\ North",
"6472828", "Tauranga",
"6479045", "Taumarunui",
"6467776", "Levin",
"644525", "Wellington",
"643465", "Palmerston",
"6466559", "Mokau",
"6472129", "Whangamata",
"6492807", "Helensville",
"6469710", "New\ Plymouth",
"6462601", "Palmerston\ North",
"6436564", "Milton",
"649232", "Pukekohe",
"6432662", "Christchurch",
"6468820", "Palmerston\ North",
"6478086", "Hamilton",
"6468258", "Waiouru",
"6439084", "Amberley",
"6463916", "Mokau",
"6436639", "Oamaru",
"643947", "Invercargill",
"6462115", "Wairoa",
"6465610", "Napier",
"6462617", "Masterton",
"6492229", "Hibiscus\ Coast",
"644903", "Wellington",
"6439736", "Riverton",
"6437471", "Kurow",
"643305", "Ashburton\/Akaroa\/Chatham\ Islands",
"6436584", "Winton",
"6432817", "Christchurch",
"6437450", "Westport",
"643576", "Nelson",
"643686", "Timaru",
"6433947", "Darfield",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6466009", "Waiouru",
"6479040", "Otorohanga",
"6434296", "Greymouth",
"6435543", "Tokanui",
"6479229", "Opotiki",
"6432651", "Queenstown",
"649391", "Auckland",
"6435677", "Ranfurly",
"6477772", "Rotorua",
"6435506", "Amberley",
"6468825", "Gisborne",
"6473332", "Rotorua",
"649555", "Auckland",
"6499019", "Maungaturoto",
"6469715", "Mokau",
"643526", "Motueka",
"644466", "Wellington",
"6439714", "Waimate",
"643968", "Christchurch",
"649583", "Auckland",
"649815", "Auckland",
"6479293", "Hamilton",
"6468692", "Gisborne",
"646986", "Gisborne",
"643390", "Christchurch",
"6432738", "Oamaru",
"6437469", "Alexandra",
"6439009", "Greymouth",
"6465615", "Wanganui",
"643688", "Timaru",
"64438", "Wellington",
"6433999", "Otautau",
"6435527", "Alexandra",
"6432646", "Timaru",
"6437455", "Cheviot",
"6443990", "Paraparaumu",
"643966", "Christchurch",
"643528", "Motueka",
"6496519", "Maungaturoto",
"647825", "Hamilton",
"6462803", "Palmerston\ North",
"6439277", "Invercargill",
"6469317", "Pahiatua",
"6434233", "Rangiora",
"647305", "Whakatane",
"6473930", "Waihi",
"6472817", "Taupo",
"644281", "Wellington",
"6434225", "Edendale",
"6479420", "Tauranga",
"649957", "Pukekohe",
"6493207", "Hibiscus\ Coast",
"644619", "Wellington",
"647867", "Thames",
"6469291", "Gisborne",
"6466998", "New\ Plymouth",
"6468247", "Mokau",
"6477883", "Hamilton",
"6499459", "Maungaturoto",
"646839", "Napier\/Hastings",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"64925", "Auckland",
"647892", "Taumarunui",
"6432750", "Invercargill",
"6462628", "Wanganui",
"6492009", "Pukekohe",
"649962", "Auckland",
"649634", "Auckland",
"6499472", "Great\ Barrier\ Island",
"6495567", "Kaitaia",
"6468309", "Napier",
"6499465", "Dargaville",
"6472801", "Huntly",
"6435561", "Dunedin",
"646273", "Hawera",
"647852", "Hamilton",
"6439868", "Blenheim",
"6444888", "Paraparaumu",
"6469301", "Ruatoria",
"6463908", "Wairoa",
"6439045", "Twizel",
"647349", "Rotorua",
"646951", "Palmerston\ North",
"6435559", "Haast",
"6439722", "Blenheim",
"643218", "Invercargill",
"6478073", "Tokoroa\/Putaruru",
"6475613", "Te\ Awamutu",
"6433919", "Haast",
"6469610", "Wanganui",
"6472604", "Hamilton",
"643425", "Dunedin",
"6499047", "Pukekohe",
"649650", "Auckland",
"6468887", "Gisborne",
"6432427", "Greymouth",
"6435694", "Franz\ Josef",
"6437779", "Invercargill",
"6472805", "Morrinsville",
"6473924", "Paeroa",
"6499461", "Whangarei",
"6499873", "Kaitaia",
"6447770", "Paraparaumu",
"6494706", "Whangarei",
"6469305", "New\ Plymouth",
"6492832", "Dargaville",
"6496999", "Auckland",
"6443330", "Wellington",
"6445950", "Wellington",
"6479002", "Matamata",
"649458", "Dargaville",
"643651", "Nelson",
"646601", "Napier",
"6434221", "Invercargill",
"6432443", "Christchurch",
"643216", "Invercargill",
"649399", "Auckland",
"647880", "Matamata",
"6478144", "Tauranga",
"6436610", "Kaikoura",
"64930", "Auckland",
"646754", "New\ Plymouth",
"6439294", "Dunedin",
"644975", "Paraparaumu",
"6473992", "Opotiki",
"6434359", "Twizel",
"6469295", "Wanganui",
"6439748", "Dunedin",
"6468997", "Napier",
"6479713", "Morrinsville",
"649918", "Auckland",
"6439083", "Cheviot",
"6472148", "Waihi",
"643452", "Wanaka",
"6436563", "Lawrence",
"6465611", "Napier",
"647926", "Tauranga",
"6434287", "Queenstown",
"6496008", "Hibiscus\ Coast",
"6437451", "Blenheim",
"644298", "Paraparaumu",
"6465626", "Ruatoria",
"6495533", "Whangarei",
"6439338", "Queenstown",
"6493937", "Warkworth",
"6437470", "Balclutha",
"643334", "Christchurch",
"643307", "Ashburton\/Akaroa\/Chatham\ Islands",
"6492222", "Auckland",
"6472194", "Whakatane",
"646831", "Napier\/Hastings",
"6434267", "Ranfurly",
"647928", "Tauranga",
"646974", "Napier",
"6436583", "Te\ Anau",
"644527", "Wellington",
"6466579", "Featherston",
"643467", "Dunedin",
"6439063", "Westport",
"6432669", "Rangiora",
"6432800", "Te\ Anau",
"649212", "Auckland",
"6468816", "Hawera",
"6436632", "Murchison",
"649916", "Auckland",
"6463920", "Palmerston\ North",
"6437446", "Franz\ Josef",
"6432655", "Nelson",
"6465607", "Taihape",
"6469893", "Ruatoria",
"644577", "Wellington",
"6462168", "Featherston",
"6468821", "Featherston",
"643742", "Dunedin",
"6469711", "New\ Plymouth",
"644296", "Paraparaumu",
"6462600", "Palmerston\ North",
"646362", "Levin",
"6466552", "New\ Plymouth",
"6472122", "Te\ Awamutu",
"6437479", "Edendale",
"6465612", "Waipukurau",
"6432727", "Fox\ Glacier",
"6473843", "Taupo",
"644803", "Wellington",
"6439767", "Alexandra",
"643445", "Cromwell",
"6435687", "Lumsden",
"6432227", "Queenstown",
"6437452", "Akaroa",
"6439267", "Dunedin",
"6499557", "Warkworth",
"6435538", "Lumsden",
"6492221", "Auckland",
"643967", "Christchurch",
"6449083", "Wellington",
"647215", "Rotorua",
"6462609", "Pahiatua",
"6472116", "Thames",
"6478598", "Hamilton",
"646763", "Opunake",
"6475823", "Hamilton",
"6469003", "Napier\/Hastings",
"6499068", "Pukekohe",
"6462417", "Wanganui",
"643687", "Timaru",
"6436631", "Motueka",
"6468822", "Masterton",
"6432660", "Christchurch",
"643527", "Motueka",
"6432743", "Kurow",
"6496013", "Whangarei",
"643755", "Hokitika",
"644467", "Wellington",
"6432809", "Hokitika",
"6477775", "Huntly",
"6439287", "Oamaru",
"6472121", "Te\ Kuiti",
"6466551", "New\ Plymouth",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6463993", "Pahiatua",
"6469712", "New\ Plymouth",
"6478998", "Hamilton",
"6479708", "Thames",
"64952", "Auckland",
"6436528", "Westport",
"646864", "Ruatoria",
"6498853", "Whangarei",
"6437770", "Nelson",
"6498817", "Hibiscus\ Coast",
"6496990", "Kaitaia",
"649400", "Kaikohe",
"6439721", "Blenheim",
"6435950", "Christchurch",
"6499727", "Whangarei",
"6434294", "Franz\ Josef",
"6435504", "Christchurch",
"6433910", "Nelson",
"6499475", "Hibiscus\ Coast",
"6434248", "Cheviot",
"649958", "Helensville",
"6435550", "Fox\ Glacier",
"6492831", "Maungaturoto",
"64957", "Auckland",
"6439042", "Oamaru",
"6494314", "Warkworth",
"644901", "Wellington",
"6499462", "Whangarei",
"6439716", "Geraldine",
"647868", "Thames",
"643412", "Balclutha",
"6434350", "Twizel",
"6439028", "Edendale",
"649292", "Auckland",
"6479001", "Hamilton",
"6424", "Scott\ Base",
"6467558", "New\ Plymouth",
"6496880", "Auckland",
"6434222", "Gore",
"647866", "Thames",
"6475608", "Otorohanga",
"6436619", "Cheviot",
"6432644", "Westport",
"643925", "Christchurch",
"649956", "Auckland",
"6462123", "Palmerston\ North",
"6473991", "Whakatane",
"6463913", "Hawera",
"6478083", "Hamilton",
"643217", "Invercargill",
"6479005", "Tauranga",
"6434998", "Dunedin",
"649883", "Auckland",
"6465624", "Featherston",
"647903", "Hamilton",
"6467773", "Wanganui",
"643235", "Invercargill",
"6433988", "Wanaka",
"6472196", "Taupo",
"643736", "Greymouth",
"6469292", "Ruatoria",
"6473995", "Putaruru\/Tokoroa",
"6439725", "Christchurch",
"64483", "Wellington",
"6468814", "Dannevirke",
"6474648", "Huntly",
"649280", "Auckland",
"6468300", "Napier",
"6442129", "Paraparaumu",
"6439733", "Te\ Anau",
"6499471", "Hibiscus\ Coast",
"643738", "Greymouth",
"6437444", "Takaka",
"6499450", "Warkworth",
"6469302", "Napier",
"6492835", "Kaikohe",
"6472802", "Paeroa",
"6435562", "Invercargill",
"6462818", "New\ Plymouth",
"644526", "Wellington",
"6469573", "Palmerston\ North",
"6436623", "Amberley",
"6499010", "Kaitaia",
"6439073", "Motueka",
"6439343", "Waimate",
"643466", "Dunedin",
"649917", "Auckland",
"6472606", "Huntly",
"6479858", "Whakatane",
"6462119", "Wairoa",
"6493942", "Great\ Barrier\ Island",
"6434277", "Ranfurly",
"6436635", "Fairlie",
"649822", "Auckland",
"643409", "Queenstown",
"6472133", "Taupo",
"6479049", "Te\ Kuiti",
"6435696", "Haast",
"6466000", "Napier",
"6446509", "Paraparaumu",
"6473331", "Rotorua",
"6436500", "Christchurch",
"644297", "Paraparaumu",
"6432652", "Cromwell",
"6477771", "Whakatane",
"6432618", "Culverden",
"6468268", "New\ Plymouth",
"644576", "Wellington",
"6466555", "Hawera",
"6472125", "Huntly",
"643308", "Ashburton\/Akaroa\/Chatham\ Islands",
"6473926", "Taumarunui",
"6437480", "Gore",
"643660", "Christchurch",
"6494704", "Whangarei",
"644909", "Wellington",
"6496510", "Whangarei",
"647927", "Tauranga",
"6475620", "Tauranga",
"6468691", "Gisborne",
"643980", "Christchurch",
"647552", "Tauranga",
"643468", "Dunedin",
"647812", "Hamilton",
"6472627", "Rotorua",
"644528", "Wellington",
"6432993", "Balclutha",
"6439000", "Christchurch",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"64338", "Christchurch",
"643306", "Ashburton\/Akaroa\/Chatham\ Islands",
"644390", "Wellington",
"6492225", "Pukekohe",
"6439296", "Invercargill",
"6439327", "Ashburton",
"6436647", "Te\ Anau",
"6472147", "Paeroa",
"647864", "Thames",
"649220", "Auckland",
"6439082", "Culverden",
"6432664", "Christchurch",
"6473841", "Taupo",
"6436562", "Balclutha",
"649954", "Auckland",
"6496007", "Helensville",
"6434288", "Cromwell",
"643750", "Haast",
"646946", "Masterton",
"6439337", "Wanaka",
"644205", "Wellington",
"6499428", "Warkworth",
"6432995", "Winton",
"6432756", "Gore",
"6495532", "Warkworth",
"6449081", "Paraparaumu",
"6469017", "Marton",
"6493938", "Auckland",
"6492223", "Auckland",
"646868", "Gisborne",
"647210", "Hamilton",
"6469001", "New\ Plymouth",
"6475821", "Hamilton",
"6469575", "Waiouru",
"649239", "Pukekohe",
"6434268", "Roxburgh",
"6436625", "Rangiora",
"6439345", "Christchurch",
"6439075", "Takaka",
"6479230", "Opotiki",
"6436582", "Riverton",
"6436633", "Geraldine",
"6462167", "Mokau",
"6469892", "Gisborne",
"643221", "Invercargill",
"6472199", "Opotiki",
"6465608", "Dannevirke",
"6432741", "Milton",
"6496011", "Kaikohe",
"6466553", "New\ Plymouth",
"6472123", "Morrinsville",
"6463991", "Masterton",
"6432640", "Hokitika",
"646329", "Palmerston\ North",
"6439723", "Blenheim",
"64337", "Christchurch",
"643920", "Rangiora",
"6478072", "Paeroa",
"6498851", "Pukekohe",
"6475612", "Te\ Kuiti",
"647987", "Tauranga",
"6439735", "Lumsden",
"644439", "Wellington",
"6432428", "Queenstown",
"6439299", "Murchison",
"6499048", "Pukekohe",
"6468888", "Masterton",
"646379", "Masterton",
"6496884", "Auckland",
"6499872", "Whangarei",
"64332", "Christchurch",
"6492833", "Warkworth",
"6479003", "Thames",
"6472609", "Whangamata",
"6463915", "Opunake",
"6478085", "Tauranga",
"6435500", "Christchurch",
"6433914", "Takaka",
"6432442", "Christchurch",
"6435554", "Cromwell",
"644586", "Wellington",
"6435954", "Christchurch",
"644819", "Wellington",
"6496994", "Dargaville",
"6437774", "Queenstown",
"6473929", "Thames",
"6467775", "Palmerston\ North",
"649405", "Kaikohe",
"6435699", "Amberley",
"6434290", "Greymouth",
"6462121", "Palmerston\ North",
"6473993", "Te\ Awamutu",
"6479712", "Te\ Awamutu",
"6439747", "Wanaka",
"6468998", "Napier",
"6472818", "Rotorua",
"6434232", "Ashburton",
"6437440", "Nelson",
"6478081", "Rotorua",
"6469318", "Levin",
"6463911", "New\ Plymouth",
"643337", "Christchurch",
"643304", "Ashburton\/Akaroa\/Chatham\ Islands",
"6462606", "Waiouru",
"6472119", "Thames",
"6499454", "Whangarei",
"6493208", "Helensville",
"6467771", "New\ Plymouth",
"6462125", "Taihape",
"6495588", "Hibiscus\ Coast",
"6463926", "Taihape",
"644913", "Wellington",
"6466997", "New\ Plymouth",
"6432806", "Edendale",
"6468810", "Ohakune",
"6436687", "Nelson",
"6477882", "Hamilton",
"6465620", "New\ Plymouth",
"6498855", "Kawakawa",
"6468248", "New\ Plymouth",
"6437476", "Ranfurly",
"649890", "Auckland",
"6439731", "Gore",
"643230", "Invercargill",
"6462627", "Wanganui",
"649348", "Auckland",
"644524", "Wellington",
"643413", "Balclutha",
"643464", "Dunedin",
"6495568", "Kawakawa",
"6466549", "Ruatoria",
"6479500", "Whakatane",
"6499473", "Helensville",
"6463907", "Waipukurau",
"6444887", "Paraparaumu",
"647960", "Hamilton",
"646965", "Wanganui\ W100",
"6469571", "Palmerston\ North",
"6475825", "Hamilton",
"6469005", "Wanganui",
"6437464", "Timaru",
"6439071", "Motueka",
"6439341", "Fairlie",
"6433948", "Kaikoura",
"6436621", "Culverden",
"6439004", "Gore",
"6435542", "Riverton",
"646762", "Stratford",
"644551", "Paraparaumu",
"6439050", "Geraldine",
"6475624", "Rotorua",
"646903", "Palmerston\ North",
"6477773", "Taupo",
"6472131", "Rotorua",
"6432745", "Roxburgh",
"6496514", "Whangarei",
"6496015", "Maungaturoto",
"644887", "Wellington",
"6435678", "Roxburgh",
"643782", "Westport",
"6433994", "Winton",
"6479292", "Hamilton",
"6436616", "Geraldine",
"6463995", "Marton",
"6432737", "Palmerston",
"644802", "Wellington",
"6468693", "Gisborne",
"644493", "Wellington",
"6436504", "Cheviot",
"6466004", "Waipukurau",
"6494700", "Whangarei",
"649930", "Auckland",
"6437484", "Riverton",
"6445956", "Wellington",
"646757", "New\ Plymouth",
"646653", "Wanganui",
"6435528", "Ranfurly",
"64962", "Auckland",
"64933", "Auckland",
"6432991", "Milton",
"6499014", "Dargaville",
"6439719", "Waimate",
"6439278", "Invercargill",
"646321", "Marton",
"646845", "Napier\/Hastings",
"6462802", "Palmerston\ North",
"6479109", "Opotiki",
"6469616", "Featherston",
"649213", "Auckland",
"6469572", "Palmerston\ North",
"644931", "Wellington",
"6436622", "Cheviot",
"6436585", "Tokanui",
"6439342", "Geraldine",
"649636", "Auckland",
"6462817", "Napier",
"6493943", "Helensville",
"6435541", "Te\ Anau",
"643249", "Te\ Anau",
"6434278", "Roxburgh",
"6479857", "Opotiki",
"646363", "Levin",
"6472132", "Taupo",
"6432617", "Cheviot",
"6432653", "Wanaka",
"646867", "Gisborne",
"643743", "Christchurch",
"6479291", "Hamilton",
"6467529", "Mokau",
"647870", "Te\ Awamutu",
"649810", "Auckland",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"643485", "Lawrence",
"649479", "Auckland",
"6433916", "Hokitika",
"6462114", "Waipukurau",
"643453", "Dunedin",
"6479100", "Rotorua",
"647839", "Hamilton",
"649550", "Auckland",
"6472628", "Taupo",
"6435556", "Fairlie",
"6439710", "Timaru",
"6436565", "Twizel",
"649638", "Auckland",
"643431", "Oamaru",
"6432992", "Gore",
"6437776", "Cromwell",
"6435956", "Christchurch",
"6496996", "Warkworth",
"6462801", "Palmerston\ North",
"649429", "Great\ Barrier\ Island",
"649590", "Auckland",
"6436648", "Lumsden",
"6463912", "New\ Plymouth",
"6478082", "Tauranga",
"644891", "Wellington",
"6468819", "Mokau",
"6434231", "Christchurch",
"643964", "Christchurch",
"644587", "Wellington",
"6498880", "Helensville",
"6434997", "Lawrence",
"647460", "Rotorua",
"6469040", "Wairoa",
"6432445", "Greymouth",
"647988", "Rotorua",
"649949", "Auckland",
"6432754", "Tokanui",
"6467772", "Hawera",
"6479715", "Paeroa",
"6437449", "Hokitika",
"6433987", "Cromwell",
"6469293", "New\ Plymouth",
"6478075", "Te\ Kuiti",
"647986", "Hamilton",
"6477881", "Hamilton",
"643524", "Takaka",
"644464", "Wellington",
"6475615", "Waihi",
"6439732", "Otautau",
"643684", "Timaru",
"649869", "Auckland",
"6473934", "Rotorua",
"6469303", "Waipukurau",
"646341", "Wanganui",
"647959", "Hamilton",
"6435563", "Queenstown",
"6472803", "Waihi",
"6499875", "Dargaville",
"6437466", "Cromwell",
"6498852", "Warkworth",
"643338", "Christchurch",
"649421", "Hibiscus\ Coast",
"6439006", "Nelson",
"6478071", "Otorohanga",
"6436527", "Haast",
"6477885", "Tauranga",
"647893", "Taumarunui",
"6499728", "Dargaville",
"6475611", "Taumarunui",
"649905", "Auckland",
"6439290", "Christchurch",
"6434247", "Kaikoura",
"647885", "Putaruru\/Tokoroa",
"6496516", "Kaikohe",
"6475626", "Taupo",
"646976", "Napier",
"643439", "Oamaru",
"646272", "Hawera",
"647853", "Hamilton",
"6433996", "Edendale",
"6478140", "Rotorua",
"6436614", "Timaru",
"6432649", "Waimate",
"6499463", "Whangarei",
"6479018", "Putaruru\/Tokoroa",
"649963", "Auckland",
"649914", "Auckland",
"644920", "Wellington",
"647357", "Rotorua",
"6499871", "Whangarei",
"6436506", "Darfield",
"6434299", "Haast",
"6466006", "Opunake",
"6435690", "Motueka",
"647974", "Hamilton",
"6434235", "Akaroa",
"6439027", "Winton",
"6467557", "New\ Plymouth",
"6445954", "Wellington",
"649347", "Auckland",
"643336", "Christchurch",
"6432441", "Christchurch",
"6434223", "Otautau",
"6473920", "Huntly",
"6437486", "Tokanui",
"643420", "Christchurch",
"6475607", "Morrinsville",
"6499016", "Kaikohe",
"6479711", "Whangamata",
"644939", "Wellington",
"6472600", "Hamilton",
"6469614", "Levin",
"6462122", "Palmerston\ North",
"647362", "Rotorua",
"6435509", "Culverden",
"6439081", "Ashburton",
"646349", "Wanganui",
"646756", "New\ Plymouth",
"643940", "Christchurch",
"6492006", "Helensville",
"643769", "Greymouth",
"6465613", "Wairoa",
"6432728", "Haast",
"6499456", "Kaikohe",
"6439768", "Ranfurly",
"6473842", "Taupo",
"6436561", "Oamaru",
"6462604", "Ohakune",
"6435688", "Queenstown",
"644888", "Wellington",
"6432228", "Wanaka",
"6495531", "Helensville",
"6499558", "Great\ Barrier\ Island",
"6439268", "Dunedin",
"6437453", "Amberley",
"6463924", "Marton",
"6462805", "Napier\/Hastings",
"643214", "Invercargill",
"64334", "Christchurch",
"6432804", "Riverton",
"6435537", "Winton",
"6449082", "Wellington",
"6499067", "Pukekohe",
"6469002", "Hawera",
"6436581", "Invercargill",
"6478597", "Hamilton",
"646758", "New\ Plymouth",
"6435545", "Gore",
"6472190", "Whakatane",
"6437474", "Oamaru",
"6462418", "Palmerston\ North",
"6439061", "Greymouth",
"6468823", "Napier\/Hastings",
"649582", "Auckland",
"6432742", "Twizel",
"6496012", "Kawakawa",
"6469891", "Gisborne",
"649941", "Auckland",
"6478997", "Morrinsville",
"6463992", "Levin",
"6479295", "Whakatane",
"6469713", "Stratford",
"6439288", "Ashburton",
"6435668", "Kurow",
"644886", "Wellington",
"6462812", "Napier\/Hastings",
"6462220", "New\ Plymouth",
"6469577", "Ohakune",
"6439347", "Christchurch",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6479852", "Whangamata",
"6499004", "Hibiscus\ Coast",
"6439709", "Motueka",
"6462159", "Mokau",
"6434273", "Lawrence",
"6462165", "Stratford",
"6499630", "Pukekohe",
"6432658", "Murchison",
"647863", "Waihi",
"6435880", "Dunedin",
"6468262", "Napier",
"6432612", "Rangiora",
"644213", "Wellington",
"6498018", "Whangarei",
"643979", "Christchurch",
"649985", "Auckland",
"649953", "Auckland",
"6432887", "Nelson",
"646370", "Masterton",
"6432731", "Timaru",
"6472145", "Huntly",
"6473946", "Taupo",
"6436577", "Cromwell",
"643930", "Christchurch",
"6472623", "Tauranga",
"6479029", "Waihi",
"6469280", "Waipukurau",
"644590", "Wellington",
"644550", "Wellington",
"6439335", "Haast",
"6479240", "Taupo",
"6432997", "Edendale",
"644810", "Wellington",
"6499719", "Whangarei",
"6436643", "Balclutha",
"6439323", "Cheviot",
"6435990", "Hokitika",
"6439454", "Lumsden",
"647961", "Hamilton",
"646766", "New\ Plymouth",
"6474440", "Paeroa",
"6463917", "Wanganui",
"6434992", "Ranfurly",
"643231", "Invercargill",
"6432630", "Christchurch",
"6478139", "Whangamata",
"6467777", "Napier",
"6439881", "Greymouth",
"6433982", "Kurow",
"6448880", "Paraparaumu",
"6466991", "Wanganui",
"6469298", "Masterton",
"6439745", "Greymouth",
"6436681", "Dunedin",
"6468800", "Napier\/Hastings",
"649230", "Pukekohe",
"6432816", "Waimate",
"6442197", "Paraparaumu",
"644806", "Wellington",
"6439737", "Tokanui",
"646768", "New\ Plymouth",
"6462621", "New\ Plymouth",
"6462616", "Ruatoria",
"6472224", "Taupo",
"643449", "Alexandra",
"6463901", "Gisborne",
"6469308", "Opunake",
"647325", "Opotiki",
"6439861", "Nelson",
"643788", "Westport",
"6472808", "Putaruru\/Tokoroa",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6436685", "Nelson",
"6436522", "Greymouth",
"6498857", "Dargaville",
"644914", "Wellington",
"64937", "Auckland",
"6462625", "Hawera",
"6439319", "Otautau",
"6432624", "Milton",
"643303", "Ashburton\/Akaroa\/Chatham\ Islands",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"644240", "Wellington",
"6434242", "Darfield",
"6439872", "Alexandra",
"646385", "Ohakune",
"644905", "Paraparaumu",
"6439865", "Murchison",
"6463905", "Napier",
"6439048", "Lawrence",
"646857", "Waipukurau",
"6499299", "Whangarei",
"6435510", "Darfield",
"6462106", "Pahiatua",
"6499468", "Kawakawa",
"649294", "Auckland",
"6439756", "Akaroa",
"6492428", "Hibiscus\ Coast",
"6436594", "Waimate",
"643463", "Palmerston",
"6479844", "Otorohanga",
"6434228", "Tokanui",
"6467552", "New\ Plymouth",
"6499747", "Dargaville",
"6475602", "Hamilton",
"6436659", "Haast",
"6439885", "Fox\ Glacier",
"6462127", "Dannevirke",
"6436548", "Waimate",
"646862", "Gisborne",
"6497774", "Warkworth",
"643921", "Blenheim",
"6436994", "Murchison",
"6439741", "Christchurch",
"6466995", "Opunake",
"6472141", "Te\ Kuiti",
"6432735", "Mt\ Cook",
"6439526", "Twizel",
"647849", "Hamilton",
"649888", "Auckland",
"6432723", "Takaka",
"6465618", "Masterton",
"6473847", "Taupo",
"6439763", "Palmerston",
"643441", "Queenstown",
"6474654", "Taumarunui",
"6435683", "Te\ Anau",
"6432223", "Akaroa",
"6439331", "Greymouth",
"6499553", "Kaikohe",
"643270", "Christchurch",
"6437458", "Kaikoura",
"6435532", "Motueka",
"647211", "Hamilton",
"6478592", "Hamilton",
"6466526", "Waiouru",
"6475827", "Hamilton",
"6469007", "Masterton",
"6499062", "Hibiscus\ Coast",
"646654", "Gisborne",
"649886", "Auckland",
"643239", "Invercargill",
"6472820", "Hamilton",
"6462413", "Gisborne",
"643751", "Fox\ Glacier",
"6469279", "Levin",
"6462161", "Masterton",
"6468250", "Stratford",
"6432747", "Queenstown",
"643615", "Timaru",
"647906", "Taupo",
"644494", "Wellington",
"6496017", "Great\ Barrier\ Island",
"6498690", "Kawakawa",
"6439283", "Rangiora",
"6463997", "Palmerston\ North",
"6478992", "Paeroa",
"6435663", "Twizel",
"6469246", "Palmerston\ North",
"646364", "Levin",
"6439456", "Riverton",
"6472142", "Te\ Awamutu",
"649940", "Auckland",
"6434283", "Cromwell",
"6436567", "Ranfurly",
"6499423", "Great\ Barrier\ Island",
"649214", "Auckland",
"6463940", "Levin",
"6439332", "Hokitika",
"6469203", "New\ Plymouth",
"646835", "Napier\/Hastings",
"6469012", "Waiouru",
"6435531", "Nelson",
"6493933", "Kaikohe",
"6492228", "Warkworth",
"6499061", "Hibiscus\ Coast",
"6436587", "Gore",
"643332", "Christchurch",
"6462815", "Wairoa",
"6478591", "Hamilton",
"6434263", "Lawrence",
"6432814", "Mt\ Cook",
"6498900", "Pukekohe",
"6468259", "Levin",
"6469270", "Marton",
"6479855", "Taupo",
"6436638", "Kurow",
"6439067", "Franz\ Josef",
"643454", "Dunedin",
"646278", "Hawera",
"6462614", "Wairoa",
"6432615", "Amberley",
"6472226", "Te\ Kuiti",
"6465603", "Palmerston\ North",
"6462162", "Masterton",
"6472829", "Tauranga",
"647366", "Rotorua",
"647309", "Whakatane",
"6478991", "Whangamata",
"643941", "Christchurch",
"6466558", "Opunake",
"6472128", "Waihi",
"644834", "Paraparaumu",
"6435519", "Twizel",
"6439728", "Franz\ Josef",
"6478077", "Waihi",
"6436521", "Greymouth",
"647829", "Hamilton",
"6472610", "Morrinsville",
"6433959", "Balclutha",
"6475617", "Whakatane",
"643421", "Christchurch",
"6499006", "Whangarei",
"646752", "New\ Plymouth",
"6434241", "Rangiora",
"6439871", "Queenstown",
"6432423", "Dunedin",
"643963", "Christchurch",
"6439310", "Invercargill",
"647549", "Tauranga",
"6499043", "Hibiscus\ Coast",
"6468883", "Palmerston\ North",
"649588", "Auckland",
"6439850", "Ashburton",
"649439", "Dargaville",
"6492838", "Pukekohe",
"6439530", "Timaru",
"6499877", "Maungaturoto",
"6479008", "Rotorua",
"6473944", "Tauranga",
"643655", "Dunedin",
"6449741", "Paraparaumu",
"643683", "Timaru",
"6434995", "Te\ Anau",
"6467551", "New\ Plymouth",
"6432447", "Timaru",
"6472458", "Rotorua",
"6436650", "Otautau",
"6475601", "Hamilton",
"6479717", "Otorohanga",
"6473998", "Taumarunui",
"6439742", "Christchurch",
"6433985", "Alexandra",
"643523", "Murchison",
"6474637", "Opotiki",
"6468993", "Taihape",
"644463", "Wellington",
"649420", "Helensville",
"6479753", "Taupo",
"6439016", "Alexandra",
"6499101", "Pukekohe",
"643949", "Dunedin",
"6462420", "Palmerston\ North",
"6472813", "Waihi",
"647854", "Hamilton",
"6434237", "Culverden",
"6469313", "Marton",
"6439524", "Oamaru",
"6439025", "Otautau",
"6467555", "New\ Plymouth",
"6434991", "Cromwell",
"6469853", "Wairoa",
"6474656", "Te\ Awamutu",
"649964", "Auckland",
"649913", "Auckland",
"649632", "Auckland",
"6478130", "Morrinsville",
"6432639", "Edendale",
"6462138", "Palmerston\ North",
"6475605", "Huntly",
"6439882", "Westport",
"6443708", "Paraparaumu",
"6466992", "Hawera",
"647894", "Taumarunui",
"646858", "Waipukurau",
"6433981", "Twizel",
"6474449", "Opotiki",
"644293", "Paraparaumu",
"6442821", "Wellington",
"6436682", "Dunedin",
"6436525", "Franz\ Josef",
"6477887", "Te\ Awamutu",
"6432710", "Christchurch",
"6466524", "Ohakune",
"6468243", "Napier",
"647312", "Whakatane",
"647923", "Whakatane",
"6475483", "Tauranga",
"6434245", "Culverden",
"6439875", "Ranfurly",
"646856", "Waipukurau",
"6495563", "Whangarei",
"6499478", "Pukekohe",
"6468809", "Masterton",
"6439862", "Nelson",
"6463902", "Gisborne",
"644890", "Wellington",
"6434400", "Alexandra",
"649887", "Auckland",
"6499065", "Helensville",
"6478094", "Tauranga",
"6478595", "Hamilton",
"649249", "Auckland",
"6462811", "New\ Plymouth",
"6433943", "Amberley",
"6435547", "Blenheim",
"6449124", "Wellington",
"6432626", "Kurow",
"6435889", "Timaru",
"6479851", "Waihi",
"643213", "Invercargill",
"6462150", "New\ Plymouth",
"643430", "Mt\ Cook",
"6439700", "Nelson",
"6468261", "Masterton",
"6432611", "Kaikoura",
"6477778", "Te\ Awamutu",
"6435673", "Lawrence",
"6473338", "Rotorua",
"6475958", "Taupo",
"6439754", "Darfield",
"6462104", "Marton",
"6479297", "Tauranga",
"649551", "Auckland",
"6478995", "Matamata",
"649811", "Auckland",
"649431", "Maungaturoto",
"6435999", "Christchurch",
"6432732", "Fairlie",
"647871", "Te\ Awamutu",
"6436596", "Queenstown",
"6479249", "Huntly",
"647982", "Hamilton",
"647541", "Tauranga",
"6498820", "Whangarei",
"6479846", "Taumarunui",
"6432607", "Dunedin",
"6479020", "Te\ Awamutu",
"6472424", "Tauranga",
"643590", "Christchurch",
"6469289", "Taihape",
"647345", "Rotorua",
"6436996", "Takaka",
"6462807", "Napier\/Hastings",
"6439273", "Blenheim",
"6435535", "Invercargill",
"6497776", "Hibiscus\ Coast",
"6466508", "Napier\/Wairoa",
"6462610", "Napier",
"649452", "Auckland",
"647983", "Hamilton",
"6432722", "Murchison",
"6439762", "Oamaru",
"6465617", "Mokau",
"6434281", "Queenstown",
"64354", "Nelson",
"6468806", "New\ Plymouth",
"6432222", "Christchurch",
"6435682", "Riverton",
"6499421", "Hibiscus\ Coast",
"6432810", "Franz\ Josef",
"6499552", "Dargaville",
"6437457", "Darfield",
"6493931", "Whangarei",
"6435533", "Murchison",
"6469274", "New\ Plymouth",
"6469201", "Ruatoria",
"6439275", "Nelson",
"6478593", "Hamilton",
"6434261", "Balclutha",
"6463944", "Featherston",
"6475828", "Hamilton",
"6469008", "Palmerston\ North",
"643212", "Invercargill",
"6433945", "Cheviot",
"6474659", "Whangamata",
"6499063", "Hibiscus\ Coast",
"6432636", "Te\ Anau",
"6462412", "Gisborne",
"6432748", "Cromwell",
"6465601", "Palmerston\ North",
"6496018", "Auckland",
"6478450", "Hamilton",
"6435675", "Twizel",
"6468827", "New\ Plymouth",
"6474446", "Otorohanga",
"649200", "Auckland",
"6463998", "Palmerston\ North",
"6439282", "Christchurch",
"6478993", "Waihi",
"6435662", "Geraldine",
"643456", "Dunedin",
"6436523", "Hokitika",
"649425", "Warkworth",
"6479246", "Thames",
"6498858", "Kaikohe",
"643690", "Waimate",
"6468245", "Wairoa",
"647922", "Whakatane",
"6479849", "Thames",
"647557", "Tauranga",
"649218", "Auckland",
"6435996", "Akaroa",
"6436599", "Blenheim",
"6499041", "Helensville",
"647881", "Matamata",
"6436999", "Nelson",
"6468881", "Napier\/Hastings",
"6499810", "Hibiscus\ Coast",
"6439873", "Wanaka",
"6434243", "Akaroa",
"6495565", "Dargaville",
"6497779", "Great\ Barrier\ Island",
"643538", "Nelson",
"6479746", "Opotiki",
"6499467", "Kaitaia",
"6436654", "Tokanui",
"643489", "Dunedin",
"649475", "Auckland",
"646368", "Levin",
"6492427", "Warkworth",
"6469286", "Dannevirke",
"6439047", "Alexandra",
"64635", "Palmerston\ North",
"6469315", "Taihape",
"6439023", "Te\ Anau",
"6432629", "Roxburgh",
"6439314", "Winton",
"649216", "Auckland",
"6435886", "Invercargill",
"6472815", "Whakatane",
"649912", "Auckland",
"649633", "Auckland",
"6434227", "Riverton",
"6439534", "Mt\ Cook",
"6439099", "Kaikoura",
"6467553", "New\ Plymouth",
"649827", "Auckland",
"646274", "Hawera",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"6472614", "Otorohanga",
"644292", "Paraparaumu",
"6462226", "Napier",
"6499748", "Whangarei",
"646366", "Levin",
"6475603", "Hamilton",
"6469869", "Ruatoria",
"6479751", "Tauranga",
"6468991", "Gisborne",
"6462128", "Ohakune",
"6436547", "Geraldine",
"6469311", "Palmerston\ North",
"6463918", "Wanganui",
"644895", "Paraparaumu",
"6468256", "Palmerston\ North",
"6472811", "Tauranga",
"6434404", "Alexandra",
"6496100", "Pukekohe",
"6469851", "Napier",
"6434993", "Alexandra",
"64941", "Auckland",
"6466520", "Palmerston\ North",
"643522", "Nelson",
"6432714", "Cheviot",
"6467778", "Wairoa",
"644462", "Wellington",
"6433983", "Ranfurly",
"6468995", "Napier",
"6469297", "Masterton",
"6472826", "Matamata",
"643957", "Timaru",
"6442198", "Paraparaumu",
"646753", "New\ Plymouth",
"6468241", "Gisborne",
"6469249", "Masterton",
"6439459", "Tokanui",
"6475481", "Tauranga",
"644497", "Wellington",
"6439738", "Winton",
"64983", "Auckland",
"6439520", "Dunedin",
"6499045", "Hibiscus\ Coast",
"6468885", "New\ Plymouth",
"6469020", "Stratford",
"6432425", "Invercargill",
"6495561", "Whangarei",
"6462424", "Wanganui",
"6478134", "Taumarunui",
"646345", "Wanganui",
"6472807", "Te\ Awamutu",
"644280", "Wellington",
"6469307", "Stratford",
"643962", "Christchurch",
"646657", "Masterton",
"6462813", "Wanganui",
"6472420", "Hamilton",
"6434265", "Milton",
"6469578", "Marton",
"6436628", "Ashburton",
"6433941", "Blenheim",
"649297", "Auckland",
"649846", "Auckland",
"6496509", "Pukekohe",
"6479853", "Putaruru",
"6434272", "Alexandra",
"6465605", "Marton",
"644917", "Wellington",
"6432657", "Motueka",
"6498017", "Hibiscus\ Coast",
"6435671", "Oamaru",
"649968", "Auckland",
"6439019", "Roxburgh",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"6468263", "Napier",
"6432888", "Nelson",
"6498824", "Kawakawa",
"6435650", "Greymouth",
"647858", "Hamilton",
"6433956", "Dunedin",
"6436578", "Wanaka",
"643481", "Dunedin",
"6499009", "Auckland",
"6439704", "Murchison",
"6462154", "New\ Plymouth",
"6472622", "Tauranga",
"6435516", "Balclutha",
"647889", "Morrinsville",
"647896", "Taumarunui",
"649390", "Auckland",
"6462100", "Levin",
"6439750", "Kaikoura",
"6434285", "Cheviot",
"6499425", "Auckland",
"6432998", "Tokanui",
"6442608", "Paraparaumu",
"6478090", "Thames",
"647856", "Hamilton",
"6436519", "Takaka",
"649909", "Auckland",
"6493935", "Kawakawa",
"649966", "Auckland",
"6436642", "Milton",
"6439322", "Culverden",
"6449120", "Wellington",
"643417", "Milton",
"6439271", "Westport",
"649409", "Kaitaia",
"6479244", "Tauranga",
"6433942", "Akaroa",
"644391", "Wellington",
"6435994", "Ashburton",
"644815", "Wellington",
"6434271", "Balclutha",
"6462415", "Levin",
"6435548", "Westport",
"6439010", "Queenstown",
"644555", "Wellington",
"6473337", "Rotorua",
"643981", "Christchurch",
"643732", "Greymouth",
"644777", "Wellington",
"6435672", "Balclutha",
"6477777", "Hamilton",
"644804", "Wellington",
"6439285", "Invercargill",
"6472429", "Whakatane",
"6435665", "Waimate",
"6469284", "Stratford",
"6436656", "Hokitika",
"6479298", "Taupo",
"6435884", "Dunedin",
"646375", "Pahiatua",
"64953", "Auckland",
"6479091", "Taupo",
"6432733", "Geraldine",
"6493990", "Great\ Barrier\ Island",
"6439316", "Edendale",
"649980", "Auckland",
"6432608", "Dunedin",
"6439856", "Darfield",
"6466010", "Taihape",
"6472621", "Tauranga",
"6432725", "Hokitika",
"6439765", "Milton",
"6439536", "Waimate",
"6499296", "Kaitaia",
"6439759", "Cromwell",
"646764", "Stratford",
"6435685", "Tokanui",
"6432225", "Greymouth",
"6472616", "Taumarunui",
"6462109", "Waiouru",
"6499555", "Kawakawa",
"6462224", "Masterton",
"646325", "Palmerston\ North",
"6439272", "Timaru",
"6462808", "Napier\/Hastings",
"6439321", "Amberley",
"6499000", "Auckland",
"6436641", "Lawrence",
"6472812", "Tauranga",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6472220", "Tauranga",
"6469312", "Ohakune",
"649826", "Auckland",
"6469852", "Napier",
"6466529", "Pahiatua",
"644572", "Wellington",
"649281", "Auckland",
"6449031", "Paraparaumu",
"6439883", "Hokitika",
"6462137", "Palmerston\ North",
"646863", "Gisborne",
"6468804", "Napier",
"6469276", "Wanganui",
"6466993", "Waiouru",
"649235", "Pukekohe",
"646367", "Levin",
"6499733", "Warkworth",
"6477888", "Taupo",
"6432634", "Invercargill",
"6436683", "Rangiora",
"6498815", "Helensville",
"6468242", "Ruatoria",
"6499725", "Hibiscus\ Coast",
"6475482", "Tauranga",
"6469029", "Opunake",
"649828", "Auckland",
"643457", "Dunedin",
"6462623", "Stratford",
"6439529", "Palmerston",
"644209", "Wellington",
"6499477", "Pukekohe",
"6474444", "Hamilton",
"6469240", "Gisborne",
"6495562", "Whangarei",
"6439450", "Invercargill",
"647589", "Hamilton",
"6439863", "Motueka",
"6463903", "Ruatoria",
"643302", "Ashburton\/Akaroa\/Chatham\ Islands",
"6479026", "Paeroa",
"644650", "Wellington",
"6478078", "Whangamata",
"6439727", "Dunedin",
"644496", "Wellington",
"6475618", "Opotiki",
"6436990", "Cheviot",
"6497770", "Whangarei",
"6473949", "Taupo",
"6499819", "Helensville",
"6499716", "Helensville",
"6436590", "Nelson",
"6499042", "Hibiscus\ Coast",
"6468882", "Napier\/Hastings",
"64357", "Blenheim",
"646656", "Levin",
"6492837", "Hibiscus\ Coast",
"643669", "Christchurch",
"649884", "Auckland",
"6499878", "Warkworth",
"646211", "Napier",
"6498826", "Warkworth",
"6462156", "Hawera",
"6439706", "Nelson",
"6433954", "Lawrence",
"6479007", "Whakatane",
"644900", "Wellington",
"6472457", "Rotorua",
"644498", "Wellington",
"6432448", "Dunedin",
"644245", "Wellington",
"6435514", "Palmerston",
"643989", "Nelson",
"643956", "Timaru",
"6439090", "Rangiora",
"6474638", "Opotiki",
"6432620", "Palmerston",
"646969", "New\ Plymouth",
"6478129", "Matamata",
"649401", "Kaikohe",
"6439743", "Christchurch",
"6479718", "Taumarunui",
"644399", "Wellington",
"6468992", "Wairoa",
"6473997", "Te\ Kuiti",
"6479752", "Rotorua",
"649298", "Auckland",
"6468254", "Ohakune",
"6472143", "Morrinsville",
"6436568", "Roxburgh",
"6432819", "Christchurch",
"6434282", "Queenstown",
"6472625", "Opotiki",
"6432721", "Motueka",
"6439761", "Kurow",
"649967", "Auckland",
"6432221", "Nelson",
"6432716", "Darfield",
"6435681", "Invercargill",
"6499422", "Helensville",
"6495538", "Auckland",
"6499551", "Whangarei",
"6439333", "Franz\ Josef",
"644918", "Wellington",
"6469202", "Levin",
"647857", "Hamilton",
"6492227", "Whangarei",
"6462619", "Featherston",
"6493932", "Dargaville",
"6436645", "Ranfurly",
"6439325", "Kaikoura",
"6434262", "Alexandra",
"6436588", "Lumsden",
"64926", "Auckland",
"6434275", "Milton",
"6462411", "New\ Plymouth",
"6439068", "Fox\ Glacier",
"6436637", "Twizel",
"649296", "Auckland",
"649847", "Auckland",
"649952", "Auckland",
"6462426", "Levin",
"643225", "Otautau",
"6462163", "New\ Plymouth",
"6465602", "Palmerston\ North",
"6492809", "Maungaturoto",
"6474650", "Morrinsville",
"6472127", "Paeroa",
"6439281", "Christchurch",
"643418", "Balclutha",
"647862", "Paeroa",
"6466557", "Stratford",
"644916", "Wellington",
"6435661", "Fairlie",
"644212", "Wellington",
"6478136", "Te\ Awamutu",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;