package Catmandu::Fix::upcase;

use Catmandu::Sane;

our $VERSION = '1.10_01';

use Moo;
use Catmandu::Util::Path qw(as_path);
use Catmandu::Util qw(as_utf8);
use namespace::clean;
use Catmandu::Fix::Has;

with 'Catmandu::Fix::Builder';

has path => (fix_arg => 1);

sub _build_fixer {
    my ($self) = @_;
    as_path($self->path)->updater(if_string => sub {uc(as_utf8($_[0]))});
}

1;

__END__

=pod

=head1 NAME

Catmandu::Fix::upcase - uppercase the value of a field

=head1 SYNOPSIS

   # Uppercase the value of 'foo'. E.g. foo => 'bar'
   upcase(foo) # foo => 'BAR'

=head1 SEE ALSO

L<Catmandu::Fix>

=cut
