#!/usr/bin/perl

package eBay::API::XML::DataType::AttributeSetType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AttributeSetType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AttributeSetType

=head1 DESCRIPTION

A set of salient aspects or features that describe an item in a standardized way.
Most commonly used in the Item Specifics section of a listing.
See the Developer's Guide information on
working with Item Specifics and Pre-filled Item Information.
See the Developer's Guide for information about
characteristics meta-data and how to determine when attributes are required.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AttributeSetType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AttributeType;


my @gaProperties = ( [ 'Attribute', 'ns:AttributeType', '1'
	     ,'eBay::API::XML::DataType::AttributeType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'attributeSetID', 'xs:int', '', '', '' ]
	, [ 'attributeSetVersion', 'xs:string', '', '', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAttribute()

A salient aspect or feature of an item in a given category.
Attributes are known as "Item Specifics" in the eBay Web site.
Use attributes to describe an item in a standard way so that buyers can find it more easily.
For example, "Publication Year" is a standard attribute for books.
In item-listing requests, multiple attributes can be specified.
Some categories (e.g., Tickets) always require certain attributes to be specified.
Therefore, in item-listing requests you need to at least specify "editable" attributes
(EditType 0 and EditType 2 attributes) if they are identified as required
in the attribute meta-data. See the eBay Web Services guide for information
about attrribute meta-data, how to determine the valid attributes for a category,
and how to determine whether attributes are required.
<br><br>
If you are revising or relisting an item, you don't need to pass in attributes
that were already specified in the original listing.
To remove an optional attribute, set all its value IDs to "-100". If the item has bids
(or items have been sold) but there are more than 12 hours remaining until the listing ends,
you can add Attribute nodes but you cannot remove or modify data in previously
specified Attribute nodes. If the item has bids and the listing ends within 12 hours,
you cannot add or remove Attribute nodes or modify the contents of previously
specified Attribute nodes.
<br><br>
For GetCategoryListings, this returns the item condition only (and it is
only returned if IncludeCondition = true in the request).
Not applicable to Half.com.

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Conditionally

  Calls: GetSearchResults
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:AttributeType'

=cut

sub setAttribute {
  my $self = shift;
  $self->{'Attribute'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAttribute()

  Calls: GetCategoryListings
         GetItemRecommendations
         GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnCategories, ReturnAll
           GranularityLevel: Coarse


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: reference to an array  
                      of 'ns:AttributeType'

=cut

sub getAttribute {
  my $self = shift;
  return $self->_getDataTypeArray('Attribute');
}




=head2 setAttributeSetID()

Constant value that identifies the attribute set in a language-independent way.
Unique across all eBay sites. Corresponds to a characteristics set ID.
Call GetCategory2CS to determine valid characteristics set IDs.
For GetCategoryListings, you can ignore this value.
Not applicable to Half.com.

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Conditionally

  Calls: GetSearchResults
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setAttributeSetID {
  my $self = shift;
  $self->{'attributeSetID'} = shift
}

=head2 getAttributeSetID()

  Calls: GetCategoryListings
         GetItemRecommendations
         GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnCategories, ReturnAll
           GranularityLevel: Coarse


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'xs:int'

=cut

sub getAttributeSetID {
  my $self = shift;
  return $self->{'attributeSetID'};
}


=head2 setAttributeSetVersion()

Version of the attribute set being specified (in requests) or that is
currently on the site. This value changes each time changes are made to the
category-to-characteristic set mappings or characteristic set data.
The current version value is not necessarily greater than the previous
value. Therefore, when comparing versions, only compare whether the
value has changed.<br><br>
In listing requests, if you do not specify this value, eBay assumes you are
using the current attribute set version. If you specify the version number of
the attribute meta-data that you have stored locally, eBay will compare it to
the current version on the site and return a warning if the versions do not match.
If an error occurs due to invalid attribute data, this warning can be useful to help you
determine if you might be sending outdated data.
Not applicable to Half.com.

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         VerifyAddItem
  RequiredInput: Conditionally

  Calls: RelistItem
         ReviseItem
         ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setAttributeSetVersion {
  my $self = shift;
  $self->{'attributeSetVersion'} = shift
}

=head2 getAttributeSetVersion()

  Calls: GetItemRecommendations
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getAttributeSetVersion {
  my $self = shift;
  return $self->{'attributeSetVersion'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
