#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ListingTypeCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingTypeCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ListingTypeCodeType

=head1 DESCRIPTION

Specifies the selling format used for a listing.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Unknown

Unknown or undefined auction type. Applicable to
user preferences and other informational use cases.



=cut


use constant Unknown => scalar('Unknown');


=head2 Chinese

Single-quantity online auction format.
A Chinese auction has a Quantity of 1. Buyers engage in competitive bidding,
although Buy It Now may be offered as long as no bids have been placed.
Online auctions are listed on eBay.com, and they are also listed in
the seller's eBay Store if the seller is a Store owner.



=cut


use constant Chinese => scalar('Chinese');


=head2 Dutch

Multiple-quantity online auction format.
A Dutch auction has a Quantity greater than 1. Buyers engage in
competitive bidding. Some sites also offer Buy It Now for Dutch auctions.
Online auctions are listed on eBay.com, and they are also listed in
the seller's eBay Store if the seller is a Store owner.



=cut


use constant Dutch => scalar('Dutch');


=head2 Live

Live auction, on-site auction that can include non-eBay bidders.
(Use AddLiveAuctionItem to list live auctions.)
Live auctions are listed on the eBay Live Auctions site, in live auction categories.
They can also appear on eBay if the seller lists the lot in a secondary category
that is an eBay category.



=cut


use constant Live => scalar('Live');


=head2 Auction

An optional input parameter used with GetMyeBaySelling. When used in
the request, returns items of the following auction types: Chinese, Dutch,
and Live.



=cut


use constant Auction => scalar('Auction');


=head2 AdType

Advertisement to solicit inquiries on listings such as real estate.
Permits no bidding on that item, service, or property.
To express interest,
a buyer fills out a contact form that eBay forwards to the the seller as a lead.
This format does not enable buyers and sellers to transact online through eBay,
and eBay Feedback is not available for ad format listings.



=cut


use constant AdType => scalar('AdType');


=head2 StoresFixedPrice

A fixed-price format for eBay Store sellers.
Store Inventory listings appear after other listings in regular browse and search
item lists on eBay. They have a lower Insertion Fee and longer listing durations.
Only available to sellers who have an eBay Store.
Store Inventory listings are listed on eBay.com, and they are also listed in
the seller's eBay Store.
Starting in early June 2008, on the Italy site, stores fixed price items will be treated as basic
fixed-price items; please see the documentation for FixedPriceItem (that is, for the
basic fixed-price item format).



=cut


use constant StoresFixedPrice => scalar('StoresFixedPrice');


=head2 PersonalOffer

Second chance offer made to a non-winning bidder on an ended listing.
A seller can make an offer to a non-winning bidder when either the winning bidder
has failed to pay for an item or the seller has a duplicate of the item.
A seller can create a Second Chance Offer immediately after a listing ends and up to
60 days after the end of the listing. eBay does not charge an Insertion Fee,
but if the bidder accepts the offer, the regular Final Value Fee is charged.
In the case of an Unpaid Item, the seller should ensure that everything has
been done to resolve the issue with the winning bidder before sending a
Second Chance Offer to another bidder. See the Unpaid Items Process for details.
Make sure you're aware of other rules and restrictions surrounding Second Chance Offers.
Use AddSecondChanceItem to submit Second Chance Offers.
Listed on eBay, but does not appear when browsing or searching listings.



=cut


use constant PersonalOffer => scalar('PersonalOffer');


=head2 FixedPriceItem

A basic fixed-price item format. Bids do not occur.
The quantity of items is one or more.
Also known as Buy It Now Only on some sites (not to be confused with the BuyItNow option that
is available for Chinese auctions).
Sellers must meet certain feedback requirements and/or be ID Verified to use this format.
See Minimum Feedback Requirements for Various Features in the Trading Web Services guide.
Fixed-price listings are listed on eBay.com, and they are listed in
the seller's eBay Store if the seller is a Store owner.
Starting in early June 2008, on the Italy site, stores fixed price items will be treated as basic
fixed-price items. On the Italy site, permitted durations of 30 days
and GTC are now available for store and non-store subscribers (in addition
to the existing durations of 3, 5, 7, and 10 days).



=cut


use constant FixedPriceItem => scalar('FixedPriceItem');


=head2 Half

Half.com listing (item is listed on Half.com, not on eBay).
You must be a registered Half.com seller to use this format.
Starting in April 2007, some Half.com items might also be included
on eBay Express US.



=cut


use constant Half => scalar('Half');


=head2 LeadGeneration

Lead Generation format (advertisement-style listing to solicit
inquiries or offers, no bidding or fixed price, listed on eBay).



=cut


use constant LeadGeneration => scalar('LeadGeneration');


=head2 Express

For Germany only:
eBay Express format (item is listed only on eBay Express only, not on eBay).
You must be an Express Germany seller to use this format.
See "Express Format Criteria" in the eBay Web Services guide.
Starting in late April, this value will no longer work, regardless of the
API version you are using.



=cut


use constant Express => scalar('Express');


=head2 Shopping

Reserved for internal or future use. You can ignore Shopping.com items in your results.



=cut


use constant Shopping => scalar('Shopping');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
