//  $Id: CIDRAdvisor.cc 1.1 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"
#include <cstdlib>

extern "C" {
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif
}
#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include "dbase.hh"
#include "Node.h"
#include "debug.hh"
#include "trace.hh"
#include "rusage.hh"
#include "aut-num.hh"
#include "Route.hh"
#include "CIDRAdvisor.hh"
#include "radix.hh"
#include "Argv.hh"
#include "version.hh"

Rusage ru;

int  opt_radius           = -2;
int  opt_rusage           = 0;
//char *opt_prompt          = "CIDRAdvisor> ";
char *opt_agg_as          = NULL;
char *opt_proxy_as        = NULL;
int  opt_echo_as          = 0;
int  opt_incl_multihomed  = 0;


int start_tracing(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      trace.enable(nextArg);
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0; 
}

int start_debugging(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      Debug(dbg.enable(atoi(nextArg)));
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0;
}

void init_and_set_options (int argc, char **argv, char **envp) {
   ArgvInfo argTable[] = {
      // RAToolSet common arguments
      // key, type, src, dst, help
      {"-T", ARGV_FUNC, (char *) &start_tracing,      (char *) NULL, 
       "Start tracing the next argument"},
      {"-D", ARGV_FUNC, (char *) &start_debugging,    (char *) NULL, 
       "Start debugging the next argument"},
      {"-version", ARGV_FUNC, (char *) &version,      (char *) NULL,
       "Show version"},
      {"-h", ARGV_FUNC, (char *) &Whois::ArgvHost,    (char *) NULL,
       "Host name of the RAWhoisd server"},
      {"-p", ARGV_FUNC, (char *) &Whois::ArgvPort,    (char *) NULL,
       "Port number of the RAWhoisd server"},
      {"-s", ARGV_FUNC, (char *) &Whois::ArgvSources, (char *) NULL,
       "Order of databases"},
      {"-rusage", ARGV_CONSTANT, (char *) 1,          (char *) &opt_rusage,
       "On termination print resource usage"},
//      {"-prompt", ARGV_STRING,  (char *) NULL,        (char *) &opt_prompt,
//       "Prompt"},
      {"-ignore_errors", ARGV_FUNC, (char *)&Whois::IgnoreErrors, (char *)NULL,
       "Ignore IRR error and warning messages"},
      {"-report_errors", ARGV_FUNC, (char *)&Whois::ReportErrors, (char *)NULL,
       "Print IRR error and warning messages"},

      // cidradvisor specific arguments
      {"-as",     ARGV_STRING,  (char *) NULL,        (char *) &opt_agg_as,
       "AS performing the aggregation"},
      {"-proxy",  ARGV_STRING,  (char *) NULL,        (char *) &opt_proxy_as,
       "Comma separated list of ASes to be proxy aggregated"},
      {"-radius", ARGV_INT,     (char *) NULL,        (char *) &opt_radius,
       "Used to configure the amount of policy and topology considered"},
      {"-incl_multihomed", ARGV_CONSTANT, (char *) 1, (char *) &opt_incl_multihomed, 
       "Include all multihomed prefixes in the aggregates"},
             
      {(char *) NULL, ARGV_END, (char *) NULL, (char *) NULL, (char *) NULL}
   };

   for (char **p = envp; *p != NULL; p++) {
      if (strncmp(*p, "IRR_HOST=", 9) == 0)  {
         whois.SetDefaultHost(*p + 9);
         continue;
      }
      if (strncmp(*p, "IRR_PORT=", 9) == 0)  {
         whois.SetDefaultPort(atoi(*p + 9));
         continue;
      }
      if (strncmp(*p, "IRR_SOURCES=", 12) == 0)  {
         whois.SetDefaultSources(*p + 12);
         continue;
      }
   }

   if (ParseArgv(&argc, argv, argTable, 0) != ARGV_OK) {
      cerr << endl;
      exit(1);
   }

   // if there is a remaining argument, it is my as number
   switch (argc) {
   case 2 :
      opt_agg_as = argv[1];
   case 1:
      break;
   default:
      cerr << "Wrong number of arguments..." << endl;
      exit(-1);
   }

   // have a prompt only if the input is coming from a tty
//   if (!isatty(fileno(stdin)) || !isatty(fileno(stdout)))
//      *opt_prompt = 0;
}



Pix source_as;
Pix proxy_as = NULL;
Origin proxies;
addr* chk_multi_homed(addr **);

void parse_proxy_ases() {
   char as_num[8];
   Pix as;
   int i = 0, j = 0;
   int index = 0;

   while (opt_proxy_as[i] != '\0') {
       if(opt_proxy_as[i] != ',') {
           as_num[j++] = opt_proxy_as[i];
       }
       else {
           as_num[j] = '\0';
           j = 0;
           as = AS_map.add_entry(as_num);
	   if(!(proxies.match(as))) {
	       ListNodePix *p = new ListNodePix(as);
	       proxies.append(p->l);
	   }
       }
       ++i;
   }
   as_num[j] = '\0';
   as = AS_map.add_entry(as_num);
   if(!(proxies.match(as))) {
       ListNodePix *p = new ListNodePix(as);
       proxies.append(p->l);   
   }
}    


main (int argc, char **argv, char **envp) {
   radix_node *root;
   addr *aggregates;
   int chk_proxies = 0;
   int num_prefixes;
   _SetOfPix routes;

   init_and_set_options(argc, argv, envp);

   if (opt_agg_as)
     source_as = AS_map.add_entry(opt_agg_as);       
   else {
      ipAddr myip;
      myip.setToMyHost();
      source_as = AS_map.add_entry(myip);
   }      

   root = radix_create_node(NULL,0,0,NULL,EMPTY);

   aggregates = NULL;
   proxies.clear();

   if(opt_proxy_as) 
       parse_proxy_ases();

   //   cout << opt_agg_as << " " << opt_proxy_as << "\n";
   for(ListNodePix *p = proxies.head() ; p ; p = proxies.next(p->l)) {
     //       cout << AS_map.key(p->pix) << " " << "\n";

       routes = AS_map.expand(p->pix);
       
       if(routes.empty()) {
	   cout << "No routes present for " << AS_map.key(p->pix) << "\n";
	   continue;
       }
       
       chk_proxies = 1;
       for(Pix rt = routes.first(); rt; routes.next(rt)) 
	   radix_insert(Prefask_map(routes(rt)).get_prefix(),(int) Prefask_map(routes(rt)).get_length(),p->pix,root);
       routes.clear();
   }


   routes = AS_map.expand(source_as);
   
   if(routes.empty()) {
     cout << "No routes present for " << opt_agg_as << "\n";
   }
   
   for (Pix rt = routes.first(); rt; routes.next(rt)) 
     radix_insert((unsigned int)Prefask_map(routes(rt)).get_prefix(),(unsigned int) Prefask_map(routes(rt)).get_length(),source_as,root);

   radix_aggregate(root);
   aggregates = radix_get_aggs(root);
   if(!opt_incl_multihomed)
     aggregates = chk_multi_homed(&aggregates);
   
   cout <<  "Best possible aggregation:" << endl;
   print_aggregates(aggregates,COMPONENTS);
   
   if(opt_radius > -2 || opt_radius == -3) 
     examine_policy(source_as,chk_proxies,aggregates,opt_radius);
   
   radix_delete_tree(root);
   if (opt_rusage)
     clog << ru;
   
   flush_symbol_tables();
   
   delete_list(&aggregates);
}






addr* chk_multi_homed(addr** aggregates) {
    Route route;
    radix_node *root;
    addr *aggs = NULL, *incl_addrs = NULL, *excl_addrs = NULL;
    addr *incl_aggs = NULL, *incl_nonaggs = NULL;
    char prefix_quad[16];

    for(addr* index = *aggregates; index ; index = index->next) {

	for(addr *comps = index->components; comps ; comps = comps->next) {
	    Pix rt = (comps->rt).nlri.pix;
	    route.clear();
	    route.nlri.pix = rt;
	    route.define();

	    if(route.origin.size() == 1) 
		append(&incl_addrs,comps);
	    if(route.origin.size() > 1) {

// adding the new origin discovered now of the multi-homed route but note that
// that origin domain will not be considered while checking policy for this 
// route. This is because when the aggregator advertises the route only his
// AS# will appear in the origin field.
	      //		for(ListNodePix *p = route.origin.head(); p ; p = route.origin.next(p->l)) {
	      //    if(!((comps->rt).origin.match(p->pix))) {
	      //	ListNodePix *q = new ListNodePix(p->pix);
	      //	(comps->rt).origin.append(q->l);
	      //    }
	      // }
		
		char prefix_quad[16];
		int2dd(prefix_quad,comps->prefix);
		printf("\n%s/%d\n",prefix_quad,comps->length);
		printf("Origins:\n");
		for(ListNodePix *q = route.origin.head() ; q ; q = route.origin.next(q->l)) 
		    cout << AS_map.key(q->pix) << " " ;
		cout << "\n" << "Can the address be aggregated?";
		char ch;
		ch = 'n'; // default is multihomed addrs not incl in aggs
		cin >> ch;
		if(ch == 'y') 
		    append(&incl_addrs,comps);
		else 
		    append(&excl_addrs,comps);
	    }
	}

	if(excl_addrs) {
	    append_aggregates(&aggs,&excl_addrs);
	    root = radix_create_node(NULL,0,0,NULL,EMPTY);

	    for(addr* tmp = incl_addrs; tmp ; tmp = tmp->next) {
		ListNodePix *p = (incl_addrs->rt).origin.head();
		radix_insert(tmp->prefix,tmp->length,p->pix,root);
		incl_aggs = radix_get_aggs(root);
		incl_nonaggs = radix_get_nonaggs(root);
		append_aggregates(&aggs,&incl_aggs);
	    }
	}
	else
	    append(&aggs,index);

	delete_list(&incl_addrs);
	delete_list(&excl_addrs);
	delete_list(&incl_aggs);
	delete_list(&incl_nonaggs);
    }

    delete_list(aggregates);
    cout << "\n";
    return(aggs);
}
