%{
//  $Id: xx_parser.y 1.5.1.2.1.4 Mon, 02 Feb 1998 18:26:49 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"

#include <cstring>
#include <cstdlib>
#include <cctype>
#include <cstdarg>
#include "RtConfig.hh"
#include "dbase.hh"
#include "trace.hh"

extern "C" {
#if HAVE_MEMORY_H && 0
#   include <memory.h>
#endif
#ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#endif
}

extern int yyerror(char *);
extern int yylex();

int xx_eof = 0;

%}

%union {
   int i;
   char *val;
   Pix pi;
}

%token <pi>  TKN_PRFMSK      501
%token <pi>  TKN_ASNUM       503
%token <val> TKN_ERROR       506
%token <val> TKN_STR         507
%token <i>   TKN_INT         508

%token <val> KW_IMPORT                  300
%token <val> KW_EXPORT                  301
%token <val> KW_SET                     302
%token <val> KW_CISCO_MAP_NAME          303
%token <val> KW_CISCO_ACCESS_LIST_NO    304
%token <val> KW_SOURCE                  305
%token <val> KW_CISCO_MAX_PREFERENCE    306
%token <val> KW_NETWORKS                307
%token <val> KW_DEFAULT                 308
%token <val> KW_CISCO_MAP_INC           309
%token <val> KW_CISCO_MAP_START         310
%token <val> KW_PKT_FILTER              311
%token <val> KW_OUTBOUND_PKT_FILTER     312

%%
input_stream: {
   if (opt_prompt)
      cout << opt_prompt;
}
| input_stream input {
   if (opt_prompt)
      cout << opt_prompt;
}
;

input: input_line '\n'
| error '\n'
| '\n'
;

input_line: import_line
| export_line
| default_line
| networks_line
| pkt_filter_line
| outbound_pkt_filter_line
| cisco_map_name_line
| cisco_map_inc_line
| cisco_map_start_line
| cisco_access_list_no_line
| cisco_max_preference_line
| source_line
;

import_line: KW_IMPORT TKN_ASNUM TKN_PRFMSK TKN_ASNUM TKN_PRFMSK {
   AS_map.define($2);
   (*config)(IMPORT_COMMAND, $2, $3, $4, $5);
}
;

export_line: KW_EXPORT TKN_ASNUM TKN_PRFMSK TKN_ASNUM TKN_PRFMSK {
   AS_map.define($2);
   (*config)(EXPORT_COMMAND, $2, $3, $4, $5);
}
;

default_line: KW_DEFAULT TKN_ASNUM TKN_ASNUM {
   (*config)(DEFAULT_COMMAND, $2, $3);
}
;

networks_line: KW_NETWORKS TKN_ASNUM {
   (*config)(NETWORKS_COMMAND, $2);
}
;

pkt_filter_line: KW_PKT_FILTER TKN_STR TKN_ASNUM TKN_PRFMSK TKN_ASNUM TKN_PRFMSK {
   AS_map.define($3);
   (*config)(PKT_FILTER_COMMAND, $3, $4, $5, $6, $2);
}
;

outbound_pkt_filter_line: KW_OUTBOUND_PKT_FILTER TKN_STR TKN_ASNUM TKN_PRFMSK TKN_ASNUM TKN_PRFMSK {
   AS_map.define($3);
   (*config)(OUTBOUND_PKT_FILTER_COMMAND, $3, $4, $5, $6, $2);
}
;

cisco_map_name_line: KW_SET KW_CISCO_MAP_NAME '=' TKN_STR {
   strcpy(cisco_map_name, $4);
   Trace(TR_INPUT) << "RtConfig: cisco_map_name '" 
		   << cisco_map_name << "'" << endl;
}
;

cisco_map_inc_line: KW_SET KW_CISCO_MAP_INC '=' TKN_INT {
   cisco_map_inc = $4;
   Trace(TR_INPUT) << "RtConfig: cisco_map_increment_by '" 
		   << cisco_map_inc << "'" << endl;
}
;

cisco_map_start_line: KW_SET KW_CISCO_MAP_START '=' TKN_INT {
   cisco_map_first_no = $4;
   Trace(TR_INPUT) << "RtConfig: cisco_map_first_no '" 
		   << cisco_map_first_no << "'" << endl;
}
;

cisco_access_list_no_line: KW_SET KW_CISCO_ACCESS_LIST_NO '=' TKN_INT {
   cisco_aspath_access_list_no = cisco_access_list_no = $4;
   if (cisco_access_list_no <= 0) 
      cisco_aspath_access_list_no = cisco_access_list_no = 1;
   Trace(TR_INPUT) << "RtConfig: cisco_access_list_no '" 
		   << cisco_access_list_no << "'" << endl;
}
;

cisco_max_preference_line: KW_SET KW_CISCO_MAX_PREFERENCE '=' TKN_INT {
   if ($4 >= 0) 
      cisco_max_preference = $4;

   Trace(TR_INPUT) << "RtConfig: cisco_max_preference '" 
		   << cisco_max_preference << "'" << endl;
}
;

source_line: KW_SET KW_SOURCE '=' TKN_STR {
   // It's not working at this moment ???
   // flush_symbol_tables();
   Trace(TR_INPUT) << "RtConfig: Caches are flushed" << endl;
   whois.SetSources($4);
   Trace(TR_INPUT) << "RtConfig: database order is changed to'" 
		   << $4 << "'" << endl;
}
;

%%

extern char *yytext;

int yyerror(char *s) {
   cout << "Error\n";
   return(0);
}

