// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _STNameSymTabAVLMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _STNameSymTabAVLMap_h 1

#include "config.hh"
#include "STName.SymTab.Map.h"

struct STNameSymTabAVLNode
{
  STNameSymTabAVLNode*      lt;
  STNameSymTabAVLNode*      rt;
  STName                 item;
  SymTab                 cont;
  char                stat;
                      STNameSymTabAVLNode(STName  h, SymTab& c, 
                                    STNameSymTabAVLNode* l=0, STNameSymTabAVLNode* r=0);
                      ~STNameSymTabAVLNode();
};

inline STNameSymTabAVLNode::STNameSymTabAVLNode(STName  h, SymTab& c, 
                                    STNameSymTabAVLNode* l, STNameSymTabAVLNode* r)
     :lt(l), rt(r), item(h), cont(c), stat(0) {}

inline STNameSymTabAVLNode::~STNameSymTabAVLNode() {}

typedef STNameSymTabAVLNode* STNameSymTabAVLNodePtr;


class STNameSymTabAVLMap : public STNameSymTabMap
{
protected:
  STNameSymTabAVLNode*   root;

  STNameSymTabAVLNode*   leftmost();
  STNameSymTabAVLNode*   rightmost();
  STNameSymTabAVLNode*   pred(STNameSymTabAVLNode* t);
  STNameSymTabAVLNode*   succ(STNameSymTabAVLNode* t);
  void            _kill(STNameSymTabAVLNode* t);
  void            _add(STNameSymTabAVLNode*& t);
  void            _del(STNameSymTabAVLNode* p, STNameSymTabAVLNode*& t);

public:
                STNameSymTabAVLMap(SymTab& dflt);
                STNameSymTabAVLMap(STNameSymTabAVLMap& a);
                ~STNameSymTabAVLMap();

  SymTab&          operator [] (STName  key);

  void          del(STName  key);

  Pix           first();
  void          next(Pix& i);
  STName&          key(Pix i);
  SymTab&          contents(Pix i);

  Pix           seek(STName  key);
  int           contains(STName  key);

  void          clear(); 

  Pix           last();
  void          prev(Pix& i);

  int           OK();
};

inline STNameSymTabAVLMap::~STNameSymTabAVLMap()
{
  _kill(root);
}

inline STNameSymTabAVLMap::STNameSymTabAVLMap(SymTab& dflt) :STNameSymTabMap(dflt)
{
  root = 0;
}

inline Pix STNameSymTabAVLMap::first()
{
  return Pix(leftmost());
}

inline Pix STNameSymTabAVLMap::last()
{
  return Pix(rightmost());
}

inline void STNameSymTabAVLMap::next(Pix& i)
{
  if (i != 0) i = Pix(succ((STNameSymTabAVLNode*)i));
}

inline void STNameSymTabAVLMap::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((STNameSymTabAVLNode*)i));
}

inline STName& STNameSymTabAVLMap::key(Pix i)
{
  if (i == 0) error("null Pix");
  return ((STNameSymTabAVLNode*)i)->item;
}

inline SymTab& STNameSymTabAVLMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return ((STNameSymTabAVLNode*)i)->cont;
}

inline void STNameSymTabAVLMap::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int STNameSymTabAVLMap::contains(STName  key)
{
  return seek(key) != 0;
}

#endif
