//
// NOTE: the 'traceroute' part of this code was taken from 
// traceroute v1.2, and munged into my somewhat confused idea
// of c++ classes. the 'pr' part of the program was inspired by
// the original PRIDE prtraceroute.  The policy evaluation uses
// the ratoolset libs.
//

/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

//
//  $Id: prtraceroute.cc 1.3 Fri, 18 Jul 1997 16:00:26 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Authors(s): eddy@isi.edu
//
// Missing or unworking options: [-s -d -r]
// 

#include "prtraceroute.hh"
#include "version.hh"
#include "Argv.hh"

Rusage ru;

////////////////////////////////////////////////////////////////////////

int  opt_rusage         = 0;

int policy_flag = 1;
int nflag = 0;
int nprobes = 3;
int max_ttl = 30;
int socket_options = 0;
int verbose = 0;
int waittime = 5;
int datalen = sizeof (probe_pkt);
char *dst;
int  port = 32768+666;
int tos = 0;
char *sourceif;
char *progname;

// source routing
#define MAXSOURCES 9
int lsrr = 0;
ipAddr *source_routes[MAXSOURCES] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};

void init_and_set_options (int, char **, char **);
void process_policies (Hop path[], int ttl);
Path path;
extern WhoisParser whois;

////////////////////////////////////////////////////////////////////////
main (int argc, char **argv, char **envp) {
    progname = argv[0];
    init_and_set_options (argc, argv, envp);

    if (!verbose && policy_flag)
	whois.error.ignore (1);
    else
	whois.error.immediate(0);

    // dst and port are globals
    ipAddr *dstip   = new ipAddr (dst); // ipaddrs for src and dst
    dstip->error.die(progname);

    ttlProbe probe(dst, INADDR_ANY, port, lsrr, source_routes);
    probe.error.die (progname);

    u_long lastaddr = probe.srcInaddr();
    u_long dstaddr  = dstip->getInaddr();
    u_long newaddr; 
    ipAddr *localip = new ipAddr (lastaddr);
    localip->error.die (progname);

    if (policy_flag) {
	path.add (localip, 0);		    // set the first hop
	path.add_destination (dstip);	    // set the destination
    }

    ICMPProbeReply reply;		    // wait for incoming icmp's
    Timer t1, t2;
    int ttl, got_there = 0, unreachable = 0;

    printf ("prtraceroute to %s (%s), %d hops max, %d byte packets\n",
	    dst, dstip->getIpaddr(), max_ttl, datalen);
	    
    for (ttl = 1; ttl <= max_ttl; ++ttl ) {
	printf ("%2d ", ttl);
	for (int p = 0, seq = 0; p < nprobes; ++p) {
	    int cc, i;
	    t1.gettimeofday();
	    probe.send (++seq, ttl);
	    if (probe.error.warn(progname))
		continue;

	    while ((cc = reply.wait_for_reply (waittime)) != 0) {
		t2.gettimeofday();
		if ((i = reply.ok(cc, probe.get_ident(), seq)) != 0) {
		    newaddr = reply.srcInaddr();
		    if (newaddr != lastaddr) {
			ipAddr *ipaddr = new ipAddr (newaddr);
			if (policy_flag) {
			    path.add (ipaddr, ttl);
			    printf (" [%s]", ipaddr->getAsname());
			}
			if (!nflag) {
			    printf (" %s (%s)", ipaddr->getName(),
				    ipaddr->getIpaddr());
			} else 
			    printf (" %s", ipaddr->getIpaddr());
			lastaddr = newaddr;
		    }
		    printf ("  %g ms", t2.delta (t1));
		    
		    switch (i-1) {
		      case ICMP_UNREACH_PORT:
			if (reply.getTTL() <= 1)
			    printf (" !");
			++got_there;
			break;
		      case ICMP_UNREACH_NET:
			++unreachable;
			printf (" !N");
			break;
		      case ICMP_UNREACH_HOST:
			++unreachable;
			printf (" !H");
			break;
		      case ICMP_UNREACH_PROTOCOL:
			++got_there;
			printf (" !P");
			break;
		      case ICMP_UNREACH_NEEDFRAG:
			++unreachable;
			printf (" !F");
			break;
		      case ICMP_UNREACH_SRCFAIL:
			++unreachable;
			printf (" !S");
			break;
				// The following are added by rusty.
		      case 6:			
			++unreachable; // UNKNOWN NET
			printf (" ?N");
			break;
		      case 7:
			++unreachable; // DST UNKNOWN HOST
			printf (" ?H");
			break;
		      case 8:
			++unreachable;
			printf (" IH");		// host isolated OBSOLETE!
			break;
		      case 9:
			++unreachable;
			printf (" !AN");	// dst host admin, prohibited
			break;
		      case 10:
			++unreachable;
			printf (" !AH");	// dst net admin, prohibited
			break;
		      case 11:
			++unreachable;
			printf (" !TN");	// net unreach for TOS
			break;
		      case 12:
			++unreachable;
			printf (" !TH");	// dst unreach for TOS
			break;
		      case 13:
			++unreachable;
			printf (" !AF");	// comm. admin prohibited
			break;
		      case 14:
			++unreachable;
			printf (" !PV");	// host preced. violation
			break;
		      case 15:
			++unreachable;
			printf (" !PC");	// precedence cut-off
			break;
		    } // switch
		    break;
		} // if reply.ok
	    } // while wait_for_reply
	    if (cc == 0) {
		printf (" *");
		if (verbose)
		    reply.error.warn(" *");
		else
		    reply.error.reset();
	    }
	    fflush (stdout);
	}
	putchar ('\n');
	if (policy_flag && verbose && whois.error())
	    whois.error.warn ("prtraceroute:");

	if (got_there || unreachable >= nprobes - 1)
	    break;
    }
    if (policy_flag)
	path.process_policies();
    exit (0);
}



////////////////////////////////////////////////////////////////////////
void
usage(char *argv[]) {
    cerr << "\nUsage: " << argv[0] << " [options] host [data size]" << endl;
    cerr << "Options: [-dnrv] [-np] [-w wait] [-m max_ttl] [-p port#] [-t tos]" << endl;
    cerr << "         [-s src_addr] [-q nqueries] [-g gateway]" << endl;
    cerr << "         [-irr_server host] [-irr_port port#] [-irr_databases dbs]\n" << endl;
    exit(1);
}

int start_tracing(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      trace.enable(nextArg);
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0; 
}

int start_debugging(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      Debug(dbg.enable(atoi(nextArg)));
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0;
}

int gFlag(char *dst, char *key, char *nextArg) {
   int limit = ((MAX_IPOPTLEN - IPOPT_MINOFF) / sizeof (u_long));
   if ((lsrr+1) >= limit) {
     fprintf (stderr, "No more than %d gateways\n",
	      (u_int) limit - 1);
     exit (1);
   }
   source_routes[lsrr++] = new ipAddr(nextArg);  
   return 1;
}

int mFlag(char *dst, char *key, char *nextArg) {
   if (nextArg) max_ttl = atoi(nextArg);
   if (max_ttl < 1) {
      fprintf (stderr, "TTL must be greater than one.");
      exit (1);
   }
}

int sFlag(char *dst, char *key, char *nextArg) {
   if (nextArg) sourceif = nextArg;
   fprintf (stderr, "Sorry '-s source' not supported yet'\n");
   return 0;
}

int debug = 0;

void
init_and_set_options (int argc, char **argv, char **envp) {
   ArgvInfo argTable[] = {
      // RAToolSet common arguments
      // key, type, src, dst, help
      {"-T", ARGV_FUNC, (char *) &start_tracing,      (char *) NULL, 
       "Start tracing the next argument"},
      {"-D", ARGV_FUNC, (char *) &start_debugging,    (char *) NULL, 
       "Start debugging the next argument"},
      {"-version", ARGV_FUNC, (char *) &version,      (char *) NULL,
       "Show version"},
      {"-h", ARGV_FUNC, (char *) &Whois::ArgvHost,    (char *) NULL,
       "Host name of the RAWhoisd server"},
//      {"-p", ARGV_FUNC, (char *) &Whois::ArgvPort,    (char *) NULL,
//       "Port number of the RAWhoisd server"},
//      {"-s", ARGV_FUNC, (char *) &Whois::ArgvSources, (char *) NULL,
//       "Order of databases"},
      {"-rusage", ARGV_CONSTANT, (char *) 1,          (char *) &opt_rusage,
       "On termination print resource usage"},
      {"-ignore_errors", ARGV_FUNC, (char *)&Whois::IgnoreErrors, (char *)NULL,
       "Ignore IRR error and warning messages"},
      {"-report_errors", ARGV_FUNC, (char *)&Whois::ReportErrors, (char *)NULL,
       "Print IRR error and warning messages"},

      // prtraceroute specific arguments
      {"-irr_server", ARGV_FUNC, (char *) &Whois::ArgvHost,    (char *) NULL,
       "Same as -h for compability reason"},
      {"-irr_port",   ARGV_FUNC, (char *) &Whois::ArgvPort,    (char *) NULL,
       "Port number of the RAWhoisd server"},
      {"-irr_sources", ARGV_FUNC, (char *)&Whois::ArgvSources, (char *) NULL,
       "Order of databases"},
      {"-g", ARGV_FUNC, (char *)gFlag, (char *)NULL,
       "Gateway"},
      {"-m", ARGV_FUNC, (char *)mFlag, (char *)NULL,
       "Max TTL"},
      {"-n", ARGV_CONSTANT, (char *)1, (char *)&nflag,
       "N flag"},
      {"-np", ARGV_CONSTANT, (char *)0, (char *)&policy_flag,
       "No policy"},
      {"-p", ARGV_INT, (char *)NULL, (char *)&port,
       "Probe port"},
      {"-q", ARGV_INT, (char *)NULL, (char *)&nprobes,
       "Query"},
      {"-s", ARGV_FUNC, (char *)sFlag, (char *)NULL,
       "'-s source' not supported yet"},
      {"-t", ARGV_INT, (char *)NULL, (char *)&tos,
       "Type of service"},
      {"-v", ARGV_CONSTANT, (char *)1, (char *)&verbose,
       "Verbose"},
      {"-w", ARGV_INT, (char *)NULL, (char *)&waittime,
       "Wait time"},

      {(char *) NULL, ARGV_END, (char *) NULL, (char *) NULL, (char *) NULL}
   };


   for (char **p = envp; *p != NULL; p++) {
      if (strncmp(*p, "IRR_HOST=", 9) == 0)  {
	 whois.SetDefaultHost (*p + 9);
         continue;
      }
      if (strncmp(*p, "IRR_PORT=", 9) == 0)  {
	 whois.SetDefaultPort (atoi(*p + 9));
         continue;
      }
      if (strncmp(*p, "IRR_SOURCES=", 12) == 0)  {
	 whois.SetDefaultSources (*p + 12);
         continue;
      }
   }

   Whois::IgnoreErrors(NULL, NULL, NULL);

   if (ParseArgv(&argc, argv, argTable, 0) != ARGV_OK) {
      cerr << endl;
      exit(1);
   }

   switch (argc) {
     case 3:
       if (*argv[--argc] == '-') {
	   fprintf (stderr, "unknown option: %s\n", argv[argc]);
	   usage (argv);
       }
       for (char *c = argv[argc]; *c; c++)
	   if (!isdigit(*c)) {
	       fprintf (stderr, "bad packet len: %s\n", argv[argc]);
	       break;
	   }
       datalen += atoi (argv[argc]);
     case 2:
       if (*argv[--argc] == '-') {
	   fprintf (stderr, "unknown option: %s\n", argv[argc-1]);
	   usage (argv);
       }
       dst = new char[strlen (argv[argc])+1];
       strcpy (dst, argv[argc]);
       break;			// just ignore all extra
     default:
       usage (argv);
       break;
   }
}

////////////////////////////////////////////////////////////////////////
ttlProbe::ttlProbe(char *dst, int sport, int dport,
		   int lsrr, ipAddr **source_routes) :
    rawUDP (dst)
{
    int on = 1;
    if (error()) {
	error.syserr (Yes);
	error.die ("ttlProbe: ");
    }

    if (lsrr && source_routes) {
	addLSRR (lsrr, source_routes);
	error.die ("ttlProbe: ");
    }

#ifdef IP_HDRINCL    
    setsockopt (IPPROTO_IP, IP_HDRINCL, (char *) &on, sizeof (on));
#endif IP_HDRINCL
    init_udp (sport, dport);
    if (error())
	error.die ("ttlProbe: ");
    ident = (getpid() & 0xffff) | 0x8000;
    ip_hdr->ip_id = ntohs(ident);
    probepkt = (probe_pkt *) udp_data;
    size = sizeof(probe_pkt);

    // set sizes
    udp_hdr->uh_ulen += htons(size);	// sets the udp len
    ip_hdr->ip_len += size;	// maps to the ip len
}

int
ttlProbe::send (u_char seq, u_char ttl)
{
    if (error())
	return error.warning("ttlProbe: ");
    struct timezone tz;
    probepkt->ttl = ip_hdr->ip_ttl = ttl;
    probepkt->seq = seq;
    gettimeofday (&(probepkt->tv), &tz);
    udp_hdr->uh_dport = htons(port + seq);
    udp_hdr->uh_sport = ip_hdr->ip_id;
    ip_hdr->ip_p = IPPROTO_UDP;
    return sendto ();
}

////////////////////////////////////////////////////////////////////////
int
ICMPProbeReply::ok(int size, int ident, int seq)
{
#ifdef STRUCT_IP_USES_VHL
    int hlen = (ip_hdr->ip_vhl & 0xF) << 2;
#else // STRUCT_IP_USES_VHL
    int hlen = ip_hdr->ip_hl << 2;
#endif // STRUCT_IP_USES_VHL
    if (size < hlen + ICMP_MINLEN) {
	if (verbose)
	    printf ("Packet too short (%d bytes) from %s\n",
		    size, inet_ntoa (ip_hdr->ip_src));
	return 0;
    }

    size -= hlen;

    int type = icmp_hdr->icmp_type;
    int code = icmp_hdr->icmp_code;

    struct ip *hip = (struct ip *) NULL;
    if ((type == ICMP_TIMXCEED && code == ICMP_TIMXCEED_INTRANS) ||
	type == ICMP_UNREACH) {
	
	struct ip *hip = &icmp_hdr->icmp_ip;
#ifdef STRUCT_IP_USES_VHL
	hlen = (hip->ip_vhl & 0xF) << 2;
#else // STRUCT_IP_USES_VHL
	hlen = hip->ip_hl << 2;
#endif // STRUCT_IP_USES_VHL
	
	struct udphdr *up = (struct udphdr *) ((u_char *) hip + hlen);
	if (hlen + 12 <= size &&
	    hip->ip_p == IPPROTO_UDP &&
	    up->uh_sport == htons(ident) &&
	    up->uh_dport == htons (port+seq)) {
	    return (type == ICMP_TIMXCEED ? -1 : code + 1);
	}
    }
	
    if (verbose) {
	u_long *lp = (u_long *) &icmp_hdr->icmp_ip;
	struct in_addr in;
	in.s_addr = get_srcInaddr();

	printf ("\n%d bytes from %s to %s", size,
		in, inet_ntoa (ip_hdr->ip_dst));
	
	printf (": icmp type %d (%s) code %d (%s)\n",
		type, icmp_type_string(),
		code, icmp_code_string());
    }
    return (0);
}

////////////////////////////////////////////////////////////////////////
void
Hop::_add (ipAddr *ip)
{
    if (ip == (ipAddr *) NULL)
	return; 
    ipaddr = ip;
    rtpix  = Prefask_map.add_entry(ipaddr->getIpaddrMask());
    route->nlri.pix = rtpix;
    route->define_less_or_equal_specific();
    ListNodePix *p;
    char *asptr = (char *) NULL;
    for (p = route->origin.head(); p; p = route->origin.next(p->l)) {
	char *ptr = (char *) AS_map (p->pix);
	// the following checks can be removed when we put
	// in Jerry's corrected radbserver.
	if (ptr != (char *) NULL) { 
	    if (!strcmp (ptr, "AS0") || !strcmp (ptr, "AS1800")) 
		continue;
	    else {
		asname = asptr = ptr;
		ipaddr->setAsname (ptr);
	    }
	}
    }
    if (!asptr)
	return;
    aspix  = AS_map.add_entry(asptr);
    autnum = AS_map.define(aspix);
}


////////////////////////////////////////////////////////////////////////
void
Path::add (ipAddr *ip, int i) 
{
    if (i > last_ttl)
	last_ttl = i;

    hops[i] = new Hop(ip);
}

////////////////////////////////////////////////////////////////////////
void
Path::process_policies()
{
    int i;

    // just print out the path taken, as gathered while the trace
    // was running
    if (!hops[0]->asname)
          printf ("\nPath taken: (???) ");
    else
      printf ("\nPath taken: %s ", hops[0]->asname);
    for (i = 1; i <= last_ttl; i++) {
	if (!hops[i-1] || !hops[i])
	    continue;
	if (hops[i]->aspix != hops[i-1]->aspix)
	    if (hops[i]->asname == NULL)
		printf ("(???) ");
	    else
		printf ("%s ", hops[i]->asname);
    }
    printf ("\n\n");
    
    route.nlri.pix = Prefask_map.add_entry (destination.ipaddr->getIpaddrMask());
    route.define_less_or_equal_specific();
    route.aspath.append ((new ListNodePix(destination.aspix))->l);

    strcpy (asout[0], "source");
    if (hops[last_ttl]->aspix != destination.aspix) 
	strcpy (asin[last_ttl], "!reached");
    else
	strcpy (asin[last_ttl], "destination");

    // analyse from dst -> src
    for (i = last_ttl; i > 0; i--) {
	Pix curpix  = NULL;
	Pix prevpix = NULL;

	ASPolicy *curpeer = NULL, *prevpeer = NULL;
	Filter_Action *casout = NULL, *pasin = NULL, *dflt = NULL;
	Filter_Action *old = NULL;
	int prefval = 0;

	if (hops[i])
	    prevpix = hops[i]->aspix;
	if (hops[i-1])
	    curpix = hops[i-1]->aspix;
	
	if (curpix == prevpix) {
	    if (curpix) {
		// (curpix && prevpix) != NULL
		strcpy (asout[i],  "internal");
		strcpy (asin[i-1], "internal");
	    } else {
		strcpy (asout[i],  "!registered");
		strcpy (asin[i-1], "!registered");
	    }
	    continue;
	}

	// find the asout policy of curpix for prevpix
	if (prevpix) {
	    route.aspath.append((new ListNodePix (prevpix))->l);

	    // we want to find the current AS's asout policy for
	    if (hops[i] == NULL || hops[i]->autnum == NULL)
		break;
	    curpeer = hops[i]->autnum->find_peer (prevpix);
	    if (curpeer) {
		for (casout = curpeer->out.head(); casout;
		     casout = curpeer->out.next(casout->falist)) {
		    break;
		    if (casout->filter->match (route))  {
 			casout->action->Execute(route);
			if (verbose > 1) {
			    casout->filter->InOrderPrint();
			    casout->action->InOrderPrint();
			}
 			break;
		    }
		}
	    }
	}

	// the asin or default policy of prevpix for the curpix
	if (curpix) {
	    // we want to find prevpeers as-in or default to current
	    if (hops[i-1] && hops[i-1]->autnum)
		prevpeer = hops[i-1]->autnum->find_peer (curpix);
	    if (prevpeer) {
		for (pasin = prevpeer->in.head(); pasin;
		     pasin = prevpeer->in.next(pasin->falist)) {
 		    if (pasin->filter->match (route)) {	// XXX: don't care
 			pasin->action->Execute (route);
			if (verbose > 1) {
			    pasin->filter->InOrderPrint();
			    pasin->action->InOrderPrint();
			}
 			prefval = ((PrefNode *) pasin->action->FindFirst(T_PrefNode))->pref();
 			break;
 		    }
		}
		// try default
		if (!pasin) {
		    for (dflt = prevpeer->dflt.head(); dflt;
			 dflt = prevpeer->dflt.next(dflt->falist)) {
 			if (dflt->filter->match (route)) {
 			    dflt->action->Execute (route);
			    if (verbose > 1) {
				dflt->filter->InOrderPrint();
				dflt->action->InOrderPrint();
			    }
 			    prefval = ((PrefNode *) pasin->action->FindFirst(T_PrefNode))->pref();
 			    break;
			}
		    }
		}
	    }
	}
			
	// at this point we should either have 
	if (casout)
	    strcpy (asout[i], "as-out");
	else {
	    if (!prevpix) 
		strcpy (asout[i], "Peer unregistered");
	    else
		strcpy (asout[i], "!as-out");
	}
	
	if (hops[i-1] && pasin) {
	    ASPolicy *p;
	    int nprefval;
	    int pref = 1;
	    
	    // lets check all of the peers of the previous hop (the one
	    // that uses as-in
	    for (p = hops[i-1]->autnum->peers.head(); p;
		 p = hops[i-1]->autnum->peers.next(p->peers)) {
		for (pasin = p->in.head(); pasin;
		     pasin = p->in.next(pasin->falist)) {
		    Route newroute(route);
		    newroute.aspath.dontcare();
		    if (pasin->filter->match(newroute)) {
			if (verbose > 1) {
			    pasin->filter->InOrderPrint();
			    pasin->action->InOrderPrint();
			}
			nprefval = ((PrefNode *) pasin->action->FindFirst(T_PrefNode))->pref();
			if (nprefval < prefval)
			    pref++;
		    }
		}
	    }
	    sprintf (asin[i-1], "as-in: %d", pref);
	} else if (hops[i-1] && dflt) {
	    ASPolicy *p;
	    int nprefval;
	    int pref = 1;
	    
	    // lets check all of the peers of the previous hop (the one
	    // that uses default
	    for (p = hops[i-1]->autnum->peers.head(); p;
		 p = hops[i-1]->autnum->peers.next(p->peers)) {
		for (pasin = p->dflt.head(); pasin;
		     pasin = p->dflt.next(pasin->falist)) {
		    Route newroute(route);
		    newroute.aspath.dontcare();
		    if (pasin->filter->match(newroute)) {
			if (verbose > 1) {
			    pasin->filter->InOrderPrint();
			    pasin->action->InOrderPrint();
			}
			nprefval = ((PrefNode *) pasin->action->FindFirst(T_PrefNode))->pref();
			if (nprefval < prefval)
			    pref++;
		    }
		}
	    }
	    sprintf (asin[i-1], "default: %d", pref);
	} else {
	    if (!hops[i-1])
		strcpy (asin[i-1], "???");
	    if (!curpix)
		strcpy (asin[i-1], "AS !reg");
	    else
		strcpy (asin[i-1], "!as-in");
	}
    }

    // now print the proceessed policies
    for (i = last_ttl; i >= 0; i--) {
	if (hops[i] != NULL) {
	    printf ("%3d %8s", i, hops[i]->ipaddr->getAsname());
	    if (nflag)		// XXX, this is a global, and is bad!!!
		printf (" %-35s", hops[i]->ipaddr->getIpaddr());
	    else
		printf (" %-35s", hops[i]->ipaddr->getName());
	    printf (" %10s -> %s \n", asin[i], asout[i]);
	} else {
	    printf ("%3d %8s", i, "(NULL)");
	    printf (" (???)\n");
	}
    }
}
