// $Id: asno.hh 1.4 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#ifndef ASNO_H
#define ASNO_H

#include "config.hh"
#include <iostream.h>
#include "List.hh"

#define MAX_AS 65535

class re_asno_t {
public:
   static char *prefix_str;
   friend void cisco_print_re_asno(ostream& out, const re_asno_t &no);
   friend void gated_print_re_asno(ostream& out, const re_asno_t &no);
public:
   class range {
   public:
      unsigned int low;
      unsigned int high;

      range () : ranges(this) {};
      range(const range& r) : low(r.low), high(r.high), ranges(this) {}
      range (int l, int h) : low(l), high(h), ranges(this) {}

      ListNode ranges;
   };

private:
   ListHead<range> ranges;

public:
   re_asno_t(int low) {
      ranges.prepend((new range(low, low))->ranges);
   }
   re_asno_t(int low, int high) {
      ranges.prepend((new range(low, high))->ranges);
   }
   re_asno_t(const re_asno_t& n) {
      *this = n;
   }
   re_asno_t() {}
   // ~re_asno_t() {} compiler generated is fine

   void complement();		                 // this destroys *this
   re_asno_t& operator+=(re_asno_t& no);         // this destroys no

   re_asno_t& operator=(const re_asno_t& no) {
      clear();
      for (range *pi = no.ranges.head(); pi; pi = no.ranges.next(pi->ranges))
	 ranges.append((new range(*pi))->ranges);
   }   


   void add(int low) {
      add(low, low);
   }
   void add(int low, int high) {
      if (low > high) {
	 int tmp = low;
	 low = high;
	 high = tmp;
      }
      re_asno_t no(low, high);
      *this += no;
   }
   void clear() {
      ranges.clear();
   }
   int empty() const {
      return ranges.is_empty();
   }
   int universal() const {
      if (ranges.size() != 1)
	 return 0;

      return (ranges.head()->low == 0 
	      && ranges.head()->high == MAX_AS);
   }

   int is_singleton() const {
      if (ranges.size() != 1)
	 return 0;
      
      range *h = ranges.head();

      return (h->low == 0 && h->high == MAX_AS) 
	 || (h->low == h->high);
   }

   int contains(const re_asno_t::range r) const;

   friend ostream& operator<<(ostream&, const re_asno_t &no);
   friend class regexp_symbol;
};
#endif   // ASNO_H
