/* $Id: relayd.hh 1.1 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): eddy@isi.edu
*/

#ifndef __RELAY_HH__
#define __RELAY_HH__

#include <cstdio>
#include <cstdlib>
#include <cstring>

#include "Error.hh"
#include "net.hh"
#include "cache.hh"
#include "whois.hh"

extern "C" {
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif

#include <sys/syslog.h>
#include <sys/signal.h>
#include <signal.h>
#include <fcntl.h>  
}

#define BLOCKSIZE 8192

struct Query {
    char *query;
    char *reply;
    int  query_size;
    int  reply_size;
    int  cache_hit;
    Query *next;
    Error error;

    Query (char *q, int s) {
	query_size = s;
	query = new char[query_size+1];
	strcpy (query, q);
	next = NULL;
	reply = NULL;
	reply_size = 0;
	cache_hit = 0;
    }

    Query () {
	query = NULL;
	reply = NULL;
	reply_size = 0;
	next = NULL;
	cache_hit = 0;
    }
    
    ~Query () {
	delete query;
	if (!cache_hit && reply) 
	    delete reply;
    }

    int add_reply (char *p, int s) {
	reply = p;
	reply_size = s;
	return s;
    }
};

struct QueryList {
    Query *head, *tail;
    int count;
    Error error;

    QueryList () {
	head = tail = NULL;
	count = 0;
    }

    int append (Query *q) {
	if (head == NULL)
	    head = tail = q;
	else {
	    tail->next = q;
	    tail = q;
	}
	return count++;
    }

    Query *getnext () {
	if (head == NULL)
	    return NULL;
	Query *q = head;
	head = head->next;
	if (head == NULL)
	    tail = NULL;
	count--;
	return q;
    }

    int add_reply (char *ptr, int s) {
	Query *q;

	if (head == NULL) {
	    error = -1;
	    return error ("add_reply: no head");
	}
	for (q = head; q && q->reply; q = q->next);
	if (q == NULL) {
	    return (error ("add_reply: outta sync"));
	}
	q->add_reply (ptr, s);
	return s;
    }
};


void set_options (int, char **, char **);
void read_config (const char *config);
void create_channels();
int go_daemonic ();
void relay (Socket &);

#endif  __RELAY_HH__
