// $Id: object.cc 1.2.1.1 Wed, 15 Oct 1997 11:28:18 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "config.hh"
#include "object.hh"
#include "roe_tcl.hh"
#include "roe.hh"
#include "roe_config.hh"
#include "route-list.hh"
#include "dbase.hh"

void Object::clear() {
   tcl_Eval(".object.text configure -state normal");
   tcl_Eval(".object.text delete 1.0 end");
   tcl_Eval(".object.text configure -state disabled");
}

void Object::display(char *dbase, char *as, char *rt) {
   char *buffer;

   tcl_Eval(".object.text configure -state normal");
   tcl_Eval(".object.text delete 1.0 end");
   //   tcl_Eval(".object.buttons.add configure -state normal");
   tcl_Eval(".object.buttons.delete configure -state normal");
   tcl_Eval(".object.buttons.update configure -state normal");
   tcl_Eval(".object.buttons.schedule configure -state normal");

   whois.QueryKillResponse("!ufo=1");
   whois.QueryKillResponse("!uF=0");
   whois.SetSources(dbase);
   int code = whois.QueryResponse(buffer, "!mrt,%s-%s", rt, as);
   whois.SetSources();

   if (code) {
      tcl_Eval(".object.text insert 1.0 {%s}", buffer);
      delete [] buffer;
   }

   tcl_Eval(".object.text configure -state disabled");
}

void Object::del(int index) {
   char buffer[64];
   RouteList::Route *vr = routelist(index);

   tcl_Eval("set AS %s", routelist.as);
   tcl_Eval("set ROUTE %s", Prefask_map(vr->route).get_address(buffer));
   tcl_Eval("set DATE %s", configure.date);

   tcl_Eval(".object.text configure -state normal");
   tcl_delete_matching_lines(".object.text", "^delete:");
   tcl_Eval(".object.text insert end \"%s\"", configure.del_template);
   tcl_Eval("focus .object.text");
}

void Object::add(int index) {
   char buffer[64];
   RouteList::Route *vr = routelist(index);

   tcl_Eval("set AS %s", routelist.as);
   tcl_Eval("set ROUTE %s", Prefask_map(vr->route).get_address(buffer));
   tcl_Eval("set DATE %s", configure.date);

   tcl_Eval(".object.text configure -state normal");
   tcl_Eval(".object.text delete 1.0 end");
   tcl_Eval(".object.text insert end \"%s\"", configure.add_template);
   tcl_Eval("focus .object.text");
   tcl_Eval(".object.buttons.schedule configure -state normal");
}

void Object::upd(int index) {
   char buffer[64];
   RouteList::Route *vr = routelist(index);

   tcl_Eval("set AS %s", routelist.as);
   tcl_Eval("set ROUTE %s", Prefask_map(vr->route).get_address(buffer));
   tcl_Eval("set DATE %s", configure.date);

   tcl_Eval(".object.text configure -state normal");
   tcl_delete_matching_lines(".object.text", "^changed:");
   tcl_Eval(".object.text insert end \"%s\"", configure.upd_template);
   tcl_Eval("focus .object.text");
}

