// $Id: schedule.hh 1.1 Fri, 18 Jul 1997 15:50:39 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#ifndef SCHEDULE_H
#define SCHEDULE_H

#include "config.hh"
#include "List.hh"

#define OP_ADD     0
#define OP_DEL     1
#define OP_UPD     2

class Transaction {
public:
   Transaction() : l(this) {
      op_code = OP_UPD;
      source[0] = 0;
      as[0] = 0;
      route[0] = 0;
      mnt_by[0] = 0;
      text[0] = 0;

      display_position = -1;
   }

   int  op_code;
   char source[64];
   char as[64];
   char route[64];
   char mnt_by[64];
   char text[4*1024];

   int display_position;

   ListNode l;
};

class Schedule : public ListHead<Transaction> {
public:
   void add();
   void select(int index);
   void cancel(int index);
   void add_selected(char *selection);
   void del_selected(char *selection);
   void del_selected_matching_source(char *selection, char *dbase);
   void update_irr();
private:
   void add_internal(char *text);
};

extern Schedule schedule;

#endif // SCHEDULE_H
