//
// $Id: prtraceroute.hh 1.2.1.1 Wed, 28 Jan 1998 15:40:42 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Rusty Eddy <eddy@isi.edu>
//

#ifndef _PRTRACEROUTE_H_
#define _PRTRACEROUTE_H_

#include "config.hh"
#include <cstdlib>
#include <cctype>
#include <cerrno>
#include <cstdio>
#include <cstdlib>
#include <cstring>


#include <iostream.h>
#include <iomanip.h>
#include "dbase.hh"
#include "whois.hh"
#include "Node.h"
#include "debug.hh"
#include "trace.hh"
#include "rusage.hh"
#include "aut-num.hh"
#include "Route.hh"

extern "C" {
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif

#include <sys/param.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>

extern int gettimeofday(...);    
}

#ifndef BYTE_ORDER
#ifdef  WORDS_BIGENDIAN
#define BYTE_ORDER 1234
#else
#define BYTE_ORDER 4321
#endif  // WORDS_BIGENDIAN
#endif  // BYTE_ORDER

#include "netraw.hh"

struct probe_pkt {
    u_char seq;
    u_char ttl;
    struct timeval tv;
};

class ttlProbe : public rawUDP {
    int ident;
    int size;
    probe_pkt *probepkt; 

  public:
    ttlProbe(char *dst, int sport, int dport,
	     int lsrr = 0, ipAddr **source_routes = NULL);

    int send (u_char, u_char);
    int get_ident() { return ident; }
};

class ICMPProbeReply : public ICMP {
  public:
    int ok(int, int, int);
    void print () { icmp_print(); }
};

// for flags

struct Hop {
    char   *asname;
    Route  *route;
    ipAddr *ipaddr;
    AutNum *autnum;
    Pix    aspix;
    Pix    rtpix;
    u_int  flags;
    void _add (ipAddr *ipaddr);

    _hop () {
	ipaddr = (ipAddr *) NULL;
	autnum = NULL;
	route = new Route();
	asname = (char *) NULL;
    }

    Hop () { _hop (); }
    Hop (ipAddr *ipaddr) { _hop(); _add (ipaddr); }
    Hop (ipAddr &ipaddr) { _hop(); _add (&ipaddr); }
    void add (ipAddr *ipaddr) { _add (ipaddr); }
};

#define POLICYLEN 30

struct Path {
    Route route;
    Hop *hops[MAXTTL];
    Hop destination;
    int last_ttl;

    char asout[MAXTTL][POLICYLEN];
    char asin [MAXTTL][POLICYLEN];

    // holds the relation between the current and previous hops
    // i.e. relation[1] holds the peering according to hop0 and hop1
    Path() {
	for (int i = 0; i < MAXTTL; i++) {
	    last_ttl = -1;
	    hops[i] = (Hop *) NULL;
	    bzero ((char *) asin[i],  POLICYLEN);
	    bzero ((char *) asout[i], POLICYLEN);
	}
    }
    void add (ipAddr *ip, int ttl); // rely on the user to insert correct ttls
    void add_destination (ipAddr *ip) {	destination.add (ip); }
    void process_policies();
    void originate ();
    void announce ();
    void import ();
    void foo (int local, int remote);
};


#endif // _PRTRACEROUTE_H_
