# -*- shell-script -*-
#
# Author:       James Brister <brister@vix.com> -- berkeley-unix --
# Start Date:   Thu, 24 Oct 1996 14:44:33 +0200
# Project:      INN
# File:         innshellvars.csh
# RCSId:        $Id: innshellvars.csh,v 1.10 1997/07/23 17:00:36 brister Exp $
# Description:  csh version of innshellvars. Hopefully nobody writes 
#               scripts to use this... 
#
#               The contents should mirror innshellvars (the bourne-shell
#               version). 


##  =()<set active = @<_PATH_ACTIVE>@>()=
set active = /var/news/etc/active

##  =()<set activetimes = @<_PATH_ACTIVETIMES>@>()=
set activetimes = /var/news/etc/active.times

##  =()<set awk = @<_PATH_AWK>@>()=
set awk = /usr/bin/awk

##  =()<set batch = @<_PATH_BATCHDIR>@>()=
set batch = /var/news/spool/out.going

##  =()<set compress = @<_PATH_COMPRESS>@>()=
set compress = /usr/bin/compress

##  =()<set controlprogs = @<_PATH_CONTROLPROGS>@>()=
set controlprogs = /usr/news/bin/control

##  =()<set ctlfile = @<_PATH_CONTROLCTL>@>()=
set ctlfile = /var/news/etc/control.ctl

##  =()<set cycles = @<LOG_CYCLES>@>()=
set cycles = 3

##  =()<set daily = @<_PATH_LOCKS>@/LOCK.news.daily>()=
set daily = /var/news/locks/LOCK.news.daily

##  =()<set inndf = "@<INNWATCH_DF>@">()=
set inndf = "/bin/df"

##  =()<set egrep = @<_PATH_EGREP>@>()=
set egrep = /usr/bin/egrep

##  =()<set errlog = @<_PATH_ERRLOG>@>()=
set errlog = /var/log/news/errlog

##  =()<set ctlwatch = @<_PATH_CTLWATCH>@>()=
set ctlwatch = /var/news/etc/innwatch.ctl

##  =()<set have_uustat = @<HAVE_UUSTAT>@>()=
set have_uustat = DO

##  =()<set history = @<_PATH_HISTORY>@>()=
set history = /var/news/etc/history

##  =()<set incoming = @<_PATH_SPOOLNEWS>@>()=
set incoming = /var/news/spool/in.coming

##  =()<set inews = @<_PATH_INEWS>@>()=
set inews = /usr/news/bin/inews

##  =()<set innconfval = @<_PATH_NEWSBIN>@/innconfval>()=
set innconfval = /usr/news/bin/innconfval

##  =()<set innd = @<_PATH_INND>@>()=
set innd = /usr/news/bin/innd

##  =()<set innddir = @<_PATH_INNDDIR>@>()=
set innddir = /var/news/run

##  =()<set inndstart = @<_PATH_INNDSTART>@>()=
set inndstart = /usr/news/bin/inndstart

##  =()<set innwatch = @<_PATH_NEWSBIN>@/innwatch>()=
set innwatch = /usr/news/bin/innwatch

##  =()<set locks = @<_PATH_LOCKS>@>()=
set locks = /var/news/locks

##  =()<set log = @<_PATH_LOGFILE>@>()=
set log = /var/log/news/news

##  =()<set mail_badcontrols = @<MAIL_BADCONTROLS>@>()=
set mail_badcontrols = DONT

##  =()<set mailcmd = "@<_PATH_MAILCMD>@">()=
set mailcmd = "/usr/news/bin/innmail"

##  =()<set most_logs = @<_PATH_MOST_LOGS>@>()=
set most_logs = /var/log/news

##  =()<set newactive = @<_PATH_NEWACTIVE>@>()=
set newactive = /var/news/etc/active.tmp

##  =()<set newsbin = @<_PATH_NEWSBIN>@>()=
set newsbin = /usr/news/bin

##  =()<set newscontrol = @<_PATH_NEWSCONTROL>@>()=
set newscontrol = /var/news/run/control

##  =()<set newsfeeds = @<_PATH_NEWSFEEDS>@>()=
set newsfeeds = /var/news/etc/newsfeeds

##  =()<set newsgroups = @<_PATH_NEWSGROUPS>@>()=
set newsgroups = /var/news/etc/newsgroups

##  =()<set newslib = @<_PATH_NEWSLIB>@>()=
set newslib = /var/news/etc

##  =()<set newsmaster = @<NEWSMASTER>@>()=
set newsmaster = usenet

##  =()<set newsuser = @<NEWSUSER>@>()=
set newsuser = news

##  =()<set nntpconnect = @<_PATH_NNTPCONNECT>@>()=
set nntpconnect = /var/news/run/nntpin

##  =()<set oldactive = @<_PATH_OLDACTIVE>@>()=
set oldactive = /var/news/etc/active.old

##  =()<set perl = @<_PATH_PERL>@>()=
set perl = /usr/bin/perl5

##  =()<set rnews = @<_PATH_RNEWS>@>()=
set rnews = /usr/news/bin/rnews

##  =()<set sed = @<_PATH_SED>@>()=
set sed = /usr/bin/sed

##  =()<set sort = "@<_PATH_SORT>@">()=
set sort = "/usr/bin/sort"

##  =()<set sendmail = `expr "@<_PATH_SENDMAIL>@" : '\([^ 	]*\)'`>()=
set sendmail = `expr "/usr/sbin/sendmail -oi %s" : '\([^ 	]*\)'`

##  =()<set serverpid = @<_PATH_SERVERPID>@>()=
set serverpid = /var/news/run/innd.pid

##  =()<set sleeptime = @<INNWATCH_SLEEPTIME>@>()=
set sleeptime = 600

##  =()<set spool = @<_PATH_SPOOL>@>()=
set spool = /var/news/spool/articles

##  =()<set overviewdir = @<_PATH_OVERVIEWDIR>@>()=
set overviewdir = /var/news/spool/over.view

##  =()<set innwstatus = @<_PATH_INNWSTATUS>@>()=
set innwstatus = /var/news/run/innwatch.status

##  =()<set tempsock = `basename @<_PATH_TEMPSOCK>@ | ${sed} -e 's/XXXXXX$/*/'`>()=
set tempsock = `basename /var/news/run/ctlinndXXXXXX | ${sed} -e 's/XXXXXX$/*/'`

##  =()<set tempsockdir = `echo @<_PATH_TEMPSOCK>@ | ${sed} -e 's@/[^/]*$@@'`>()=
set tempsockdir = `echo /var/news/run/ctlinndXXXXXX | ${sed} -e 's@/[^/]*$@@'`

##  =()<set want_pgpverify = @<WANT_PGPVERIFY>@>()=
set want_pgpverify = DO

##  =()<set watchpid = @<_PATH_WATCHPID>@>()=
set watchpid = /var/news/run/innwatch.pid

##  =()<set z = @<_PATH_COMPRESSEXT>@>()=
set z = .Z


##  =()<set perl_support = @<PERL_SUPPORT>@>()=
set perl_support = DONT

##  =()<set perl_startup_innd = @<_PATH_PERL_STARTUP_INND>@>()=
set perl_startup_innd = /usr/news/bin/control/startup_innd.pl

##  =()<set perl_filter_innd = @<_PATH_PERL_FILTER_INND>@>()=
set perl_filter_innd = /usr/news/bin/control/filter_innd.pl

##  =()<set perl_filter_nnrpd = @<_PATH_PERL_FILTER_NNRPD>@>()=
set perl_filter_nnrpd = /usr/news/bin/control/filter_nnrpd.pl


##  =()<set tcl_support = @<TCL_SUPPORT>@>()=
set tcl_support = DONT

#### =()<set path_tcl_startup = @<_PATH_TCL_STARTUP>@>()=
set path_tcl_startup = /usr/news/bin/control/startup.tcl

#### =()<set path_tcl_filter = @<_PATH_TCL_FILTER>@>()=
set path_tcl_filter = /usr/news/bin/control/filter.tcl

set localgroups = ${newslib}/localgroups


##  =()<if ( ! $?TMPDIR ) setenv TMPDIR @<_PATH_TMP>@>()=
if ( ! $?TMPDIR ) setenv TMPDIR /var/tmp


##  =()<set expirectl = @<_PATH_EXPIRECTL>@>()=
set expirectl = /var/news/etc/expire.ctl

##  =()<set newshome = @<_PATH_NEWSHOME>@>()=
set newshome = /usr/news

##  =()<set archivedir = @<_PATH_ARCHIVEDIR>@>()=
set archivedir = /var/news/spool/archive

##  =()<set badnews = @<_PATH_BADNEWS>@>()=
set badnews = /var/news/spool/in.coming/bad

## =()<set spoolnews = @<_PATH_SPOOLNEWS>@>()=
set spoolnews = /var/news/spool/in.coming

## =()<set spooltemp = @<_PATH_SPOOLTEMP>@>()=
set spooltemp = /var/news/spool/tmp

##  =()<setenv NEWSLBIN @<_PATH_NEWSLBIN>@>()=
setenv NEWSLBIN /usr/news/local

##
## See config.data for a description of these next values.
##

#### =()<set innd_setpriority = @<INND_SETPRIORITY>@>()=
set innd_setpriority = -4
#### =()<set nnrpd_nice_value = @<NNRPD_NICE_VALUE>@>()=
set nnrpd_nice_value = 2
#### =()<set overchan_nice_value = @<OVERCHAN_NICE_VALUE>@>()=
set overchan_nice_value = 1
#### =()<set overchan_nice_name = "@<OVERCHAN_NICE_NAME>@">()=
set overchan_nice_name = "overchan"
#### =()<set innfeed_nice_value = @<INNFEED_NICE_VALUE>@>()=
set innfeed_nice_value = 4
#### =()<set innfeed_nice_leading_name = "@<INNFEED_NICE_LEADING_NAME>@">()=
set innfeed_nice_leading_name = "innfeed"


##  =()<umask @<NEWSUMASK>@>()=
umask 02

set inn_path = ( ${NEWSLBIN} ${inn_newsbin} $path /bin /usr/bin /usr/ucb )
