/*  $Revision: 1.21 $
**
**  pathgrep, Tobias.Hennerich@swabsib.s.bawue.de
*/
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "configdata.h"
#include "clibrary.h"
#include <ctype.h>
#include <sys/stat.h>
#if	defined(DO_NEED_TIME)
#include <time.h>
#endif	/* defined(DO_NEED_TIME) */
#include <sys/time.h>
#include <errno.h>
#include "paths.h"
#include "libinn.h"
#include "inndcomm.h"
#include "dbz.h"
#include "qio.h"
#include "macros.h"
#include "mydir.h"
#include "tree.h"
#include "can.h"
#include "qci.h"

typedef struct _BUFFER {
    char	*Data;
    int		Size;
    int		Used;
} BUFFER;


STATIC char		*ACTIVE = _PATH_ACTIVE;
STATIC char		SPOOL[] = _PATH_SPOOL;
STATIC char		*HISTORYDIR;
STATIC char		HISTORY[] = _PATH_HISTORY;
STATIC char		PATH[] = "Path:";

/*
**  Process a single article.
*/
STATIC void
DoArticle(qp, canpos, headerSearched)
    register QCISTATE	*qp;
    char		*canpos;
    char		*headerSearched;
{
    static char		IGNORE[] = "Ignoring duplicate %s header in %s\n";
    register char	*p;
    char		*headerFound;
    int			headerLen;

    /* Read the file for Path header. */
    headerFound = NULL;
    headerLen=strlen(headerSearched);
    while ((p = QCIread(qp)) != NULL && *p != '\0' && !headerFound)
    {	if (caseEQn(p, headerSearched, headerLen))
    	{   if (headerFound)
		(void)fprintf(stderr, IGNORE, headerSearched, canpos);
	    else
	    	headerFound=p;
	}
    }

    /* Check for errors, close the input. */
    if (p == NULL) {
	if (QCIerror(qp)) {
	    (void)fprintf(stderr, "Can't read %s, %s\n",
		    canpos, strerror(errno));
	    return;
	}
	if (QCItoolong(qp)) {
	    (void)fprintf(stderr, "Line too long in %s\n", canpos);
	    return;
	}
    }

    printf("%s\n", headerFound);
}


/*
**  Process one newsgroup directory.
*/
STATIC void
DoCan(canName)
    char		*canName;
{
    register QCISTATE	*qp;
    struct stat		Sb;
    int			fd;
    char		buff[SPOOLNAMEBUFF];
    long		Bytepos;
    char		artsize[20];
    long		artlength;
    int			artcount;
    int			canCheck;
    
    if( stat(canName, &Sb)<0 )
    {	(void)fprintf(stderr, "Can't stat %s, %s\n", canName, strerror(errno));
    	return ;
    }

    if( (fd=open(canName, O_RDONLY, 0666))<0 )
    {   (void)fprintf(stderr, "Can't open %s, %s\n", canName, strerror(errno));
	return;
    }
    
    Bytepos=47;						/* !!! */
    lseek(fd, Bytepos, SEEK_SET);
    artcount=0;
    fprintf(stderr, "can %s: ", canName);

    for( ;; )
    {   if( read(fd, artsize, 12)!=12 )
	    break;
	    
	if( *artsize!='-' && *artsize!='+' )
	    break;
    
	if( strspn(artsize+1, "0123456789")!=10 )
	    break;

	if( artsize[11]!='\n' )
	    break;
	
	artlength=atol(artsize);

	if( artlength>0 )
	{	sprintf(buff, "%s!%010ld", canName, Bytepos);
	
	    if ((qp = QCIopen(buff, QIO_BUFFER)) == NULL) {
		(void)fprintf(stderr, "Can't open %s, %s\n",
			buff, strerror(errno));
		continue;
	    }
	    
	    DoArticle(qp, buff);
	    QCIclose(qp);
	}
	else
	    artlength = -artlength;
	
	Bytepos+=artlength+12;
	artcount++;
	lseek(fd, Bytepos, SEEK_SET);
    }
    
    fprintf(stderr, "%d articles\n", artcount);

    close(fd);    
}

/*
**  Print a usage message and exit.
*/
STATIC NORETURN
Usage()
{
    (void)fprintf(stderr,"Usage: nidhdr Header\n");
    exit(1);
}


int
main(ac, av)
    int			ac;
    char		*av[];
{
    static char		CANTCD[] = "Can't cd to %s, %s\n";
    DIR			*dirp, *shelfDirp;
    DIRENTRY		*dp, *shelfDp;
    char		name[SPOOLNAMEBUFF];

    if( ac!=2 )
    	Usage();

    if (chdir(SPOOL) < 0) {
	(void)fprintf(stderr, CANTCD, SPOOL, strerror(errno));
	exit(1);
    }

    dirp=opendir(".");
    for( dp=readdir(dirp); dp!=NULL; dp=readdir(dirp) )
    {	if( !strncmp(dp->d_name, "shelf.", 6))
	{   shelfDirp=opendir(dp->d_name);
	
	    for(shelfDp=readdir(shelfDirp);shelfDp;shelfDp=readdir(shelfDirp) )
	    {	if( strlen(shelfDp->d_name)!=strlen("yyyymmddhhxx") )
		    continue;

		sprintf(name, "%s/%s", dp->d_name, shelfDp->d_name);

		DoCan(name, av[1]);
	    }

	    closedir(shelfDirp);
	}
    }
    closedir(dirp);

    exit(0);
    /* NOTREACHED */
}
