#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "configdata.h"
#include "clibrary.h"
#include <ctype.h>
#include <errno.h>
#include "paths.h"
#include "libinn.h"
#include "macros.h"
#include "tree.h"
#include "can.h"

STATIC char	*Host;

/*
**  Print a usage message and exit.
*/
STATIC NORETURN
Usage()
{
    (void)fprintf(stderr, "Usage: ccat shelf.01/199710281301!123456\n");
    exit(1);
}


int
main(ac, av)
    int		ac;
    char	*av[];
{
    char	*p;
    char	*data;
    SIZE_T	datasize;
    int		i;
    int		j;
    int		canfd=0;
    long	bytepos;
    long	BytesInArt;
    ARTCAN	can;

    Host = av[0];

    if (ac != 2)
	Usage();

    datasize = 8 * 1024;
    data = NEW(char, datasize);

    if (chdir(_PATH_SPOOL) < 0) {
	(void)fprintf(stderr, "ccat %s cant cd %s %s\n",
		Host, _PATH_SPOOL, strerror(errno));
	exit(1);
    }

    if ((p = strchr(av[1], '!')) != NULL) {
	*p++ = '\0';
	/* Try to be forgiving of bad input. */
	bytepos = CTYPE(isdigit, *p) ? atol(p) : -1;
    }
    else
    {	(void)fprintf(stderr, "ccat bad input %s\n", av[1]);
	exit(1);
    }

    if ((canfd = open(av[1], O_RDONLY)) < 0)
    {	(void)fprintf(stderr, "ccat can't open %s: %s\n", av[1], strerror(errno));
	exit(1);
    }
    
    if( lseek(canfd, bytepos, SEEK_SET)<0 )
    {	(void)fprintf(stderr, "ccat, can't lseek to %ld: %s\n", 
    					bytepos, strerror(errno));
	exit(1);
    }

    can.fd[READ]=canfd;
    can.Bytepos[READ]=bytepos;

    if( (BytesInArt=CANartsize(&can))<=0 )
    {	(void)fprintf(stderr, "ccat, %s corrupt?\n", av[1]);
	exit(1);
    }

    j=BytesInArt;
    while( (i=read(canfd, (POINTER)data, (j<datasize?j:datasize))) > 0 
    || 	errno == EINTR)
    {   if (fwrite((POINTER)data, (SIZE_T)1, (SIZE_T)i, stdout) != i)
	    break;

	if( !(j-=i) )
	    break;
    }

    (void)close(canfd);
    DISPOSE(data);
    
    exit(0);
}
