# 
# Author:       James Brister <brister@vix.com> -- berkeley-unix --
# Start Date:   Sat, 24 Aug 1996 22:08:19 +0200
# Project:      INN 
# File:         innshellvars.pl
# RCSId:        $Id: innshellvars.pl,v 1.13 1996/12/05 00:43:46 brister Exp $
# Description:  Set up any and all variables that an INN perl script
#               might need.

package inn ;



##  =()<$active = "@<_PATH_ACTIVE>@" ;>()=
$active = "/news/lib/inn/var/active" ;

##  =()<$activetimes = "@<_PATH_ACTIVETIMES>@" ;>()=
$activetimes = "/news/lib/inn/var/active.times" ;

##  =()<$awk = "@<_PATH_AWK>@" ;>()=
$awk = "/client/bin/gawk" ;

##  =()<$batch = "@<_PATH_BATCHDIR>@" ;>()=
$batch = "/news/spool/batch" ;

##  =()<$compress = "@<_PATH_COMPRESS>@" ;>()=
$compress = "/client/bin/gzip" ;

##  =()<$controlprogs = "@<_PATH_CONTROLPROGS>@" ;>()=
$controlprogs = "/news/lib/inn/libexec/control" ;

##  =()<$ctlfile = "@<_PATH_CONTROLCTL>@" ;>()=
$ctlfile = "/news/lib/inn/etc/control.ctl" ;

##  =()<$cycles = @<LOG_CYCLES>@ ;>()=
$cycles = 7 ;

##  =()<$daily = "@<_PATH_LOCKS>@/LOCK.news.daily" ;>()=
$daily = "/news/spool/batch/LOCK.news.daily" ;

##  =()<$inndf = "@<INNWATCH_DF>@" ;>()=
$inndf = "/usr/ucb/df" ;

##  =()<$egrep = "@<_PATH_EGREP>@" ;>()=
$egrep = "/client/bin/egrep" ;

##  =()<$errlog = "@<_PATH_ERRLOG>@" ;>()=
$errlog = "/news/spool/log/errlog" ;

##  =()<$ctlwatch = "@<_PATH_CTLWATCH>@" ;>()=
$ctlwatch = "/news/lib/inn/etc/innwatch.ctl" ;

##  =()<$have_uustat = ("@<HAVE_UUSTAT>@" eq "DO" ? 1 : 0) ;>()=
$have_uustat = ("DO" eq "DO" ? 1 : 0) ;

##  =()<$history = "@<_PATH_HISTORY>@" ;>()=
$history = "/news/lib/inn/var/history" ;

##  =()<$incoming = "@<_PATH_SPOOLNEWS>@" ;>()=
$incoming = "/news/spool/in.coming" ;

##  =()<$inews = "@<_PATH_INEWS>@" ;>()=
$inews = "/news/lib/inn/libexec/inews" ;

##  =()<$innconfval = "@<_PATH_NEWSBIN>@/innconfval" ;>()=
$innconfval = "/news/lib/inn/bin/innconfval" ;

##  =()<$innd = "@<_PATH_INND>@" ;>()=
$innd = "/news/lib/inn/libexec/innd" ;

##  =()<$innddir = "@<_PATH_INNDDIR>@" ;>()=
$innddir = "/news/lib/inn/lib/sockets" ;

##  =()<$inndstart = "@<_PATH_INNDSTART>@" ;>()=
$inndstart = "/news/lib/inn/libexec/inndstart" ;

##  =()<$innwatch = "@<_PATH_NEWSBIN>@/innwatch" ;>()=
$innwatch = "/news/lib/inn/bin/innwatch" ;

##  =()<$locks = "@<_PATH_LOCKS>@" ;>()=
$locks = "/news/spool/batch" ;

##  =()<$log = "@<_PATH_LOGFILE>@" ;>()=
$log = "/news/spool/log/log" ;

##  =()<$mail_badcontrols = ("@<MAIL_BADCONTROLS>@" eq "DO" ? 1 : 0) ;>()=
$mail_badcontrols = ("DO" eq "DO" ? 1 : 0) ;

##  =()<$mailcmd = "@<_PATH_MAILCMD>@" ;>()=
$mailcmd = "/usr/bin/mailx" ;

##  =()<$most_logs = "@<_PATH_MOST_LOGS>@" ;>()=
$most_logs = "/news/spool/log" ;

##  =()<$newactive = "@<_PATH_NEWACTIVE>@" ;>()=
$newactive = "/news/lib/inn/var/active.tmp" ;

##  =()<$newsbin = "@<_PATH_NEWSBIN>@" ;>()=
$newsbin = "/news/lib/inn/bin" ;

##  =()<$newscontrol = "@<_PATH_NEWSCONTROL>@" ;>()=
$newscontrol = "/news/lib/inn/lib/sockets/control" ;

##  =()<$newsfeeds = "@<_PATH_NEWSFEEDS>@" ;>()=
$newsfeeds = "/news/lib/inn/etc/newsfeeds" ;

##  =()<$newsgroups = "@<_PATH_NEWSGROUPS>@" ;>()=
$newsgroups = "/news/lib/inn/etc/newsgroups" ;

##  =()<$newslib = "@<_PATH_NEWSLIB>@" ;>()=
$newslib = "/news/lib/inn/lib" ;

##  =()<$newsmaster = "@<NEWSMASTER>@" ;>()=
$newsmaster = "news" ;

##  =()<$newsuser = "@<NEWSUSER>@" ;>()=
$newsuser = "news" ;

##  =()<$nntpconnect = "@<_PATH_NNTPCONNECT>@" ;>()=
$nntpconnect = "/news/lib/inn/lib/sockets/nntpin" ;

##  =()<$oldactive = "@<_PATH_OLDACTIVE>@" ;>()=
$oldactive = "/news/lib/inn/var/active.old" ;

##  =()<$perl = "@<_PATH_PERL>@" ;>()=
$perl = "/client/bin/perl" ;

##  =()<$rnews = "@<_PATH_RNEWS>@" ;>()=
$rnews = "/news/lib/inn/libexec/rnews/rnews" ;

##  =()<$sed = "@<_PATH_SED>@" ;>()=
$sed = "/client/bin/sed" ;

##  =()<$sort = "@<_PATH_SORT>@" ;>()=
$sort = "/client/bin/sort" ;

##  =()<$sendmail = "@<_PATH_SENDMAIL>@" ;>()=
$sendmail = "/usr/lib/sendmail -t" ;

##  =()<$serverpid = "@<_PATH_SERVERPID>@" ;>()=
$serverpid = "/news/lib/inn/lib/status/innd.pid" ;

##  =()<$sleeptime = @<INNWATCH_SLEEPTIME>@ ;>()=
$sleeptime = 60 ;

##  =()<$spool = "@<_PATH_SPOOL>@" ;>()=
$spool = "/news/spool/news" ;

##  =()<$overviewdir = "@<_PATH_OVERVIEWDIR>@" ;>()=
$overviewdir = "/news/spool/overview" ;

##  =()<$innwstatus = "@<_PATH_INNWSTATUS>@" ;>()=
$innwstatus = "/news/lib/inn/lib/status/innwatch.status" ;

##  =()<($tempsock = "@<_PATH_TEMPSOCK>@") =~ s!.*/(.*)XXXXXX$!$1*! ;>()=
($tempsock = "/news/lib/inn/lib/sockets/ctlinndXXXXXX") =~ s!.*/(.*)XXXXXX$!$1*! ;

##  =()<($tempsockdir = "@<_PATH_TEMPSOCK>@") =~ s!/[^/]*$!! ;>()=
($tempsockdir = "/news/lib/inn/lib/sockets/ctlinndXXXXXX") =~ s!/[^/]*$!! ;

##  =()<$want_pgpverify = ("@<WANT_PGPVERIFY>@" eq "DO" ? 1 : 0) ;>()=
$want_pgpverify = ("DO" eq "DO" ? 1 : 0) ;

##  =()<$watchpid = "@<_PATH_WATCHPID>@" ;>()=
$watchpid = "/news/lib/inn/lib/status/innwatch.pid" ;

##  =()<$z = "@<_PATH_COMPRESSEXT>@" ;>()=
$z = ".gz" ;

##  =()<$perl_support = ("@<PERL_SUPPORT>@" eq "DO" ? 1 : 0) ;>()=
$perl_support = ("DONT" eq "DO" ? 1 : 0) ;

##  =()<$perl_startup_innd = "@<_PATH_PERL_STARTUP_INND>@" ;>()=
$perl_startup_innd = "/news/lib/inn/bin/control/startup_innd.pl" ;

##  =()<$perl_filter_innd = "@<_PATH_PERL_FILTER_INND>@" ;>()=
$perl_filter_innd = "/news/lib/inn/bin/control/filter_innd.pl" ;

##  =()<$perl_filter_nnrpd = "@<_PATH_PERL_FILTER_NNRPD>@" ;>()=
$perl_filter_nnrpd = "/news/lib/inn/bin/control/filter_nnrpd.pl" ;

##  =()<$tcl_support = ("@<TCL_SUPPORT>@" eq "DO" ? 1 : 0) ;>()=
$tcl_support = ("DONT" eq "DO" ? 1 : 0) ;

#### =()<$path_tcl_startup = "@<_PATH_TCL_STARTUP>@" ;>()=
$path_tcl_startup = "/news/lib/inn/bin/control/startup.tcl" ;

#### =()<$path_tcl_filter = "@<_PATH_TCL_FILTER>@" ;>()=
$path_tcl_filter = "/news/lib/inn/bin/control/filter.tcl" ;

$localgroups = "$newslib/localgroups" ;

if ( ! defined ($ENV{'TMPDIR'}) ) {
    ##  =()<	$ENV{'TMPDIR'} = "@<_PATH_TMP>@" ;>()=
	$ENV{'TMPDIR'} = "/tmp" ;
} 
$tmpdir = $ENV{'TMPDIR'} ;

##  =()<$expirectl = "@<_PATH_EXPIRECTL>@" ;>()=
$expirectl = "/news/lib/inn/etc/expire.ctl" ;

##  =()<$newshome = "@<_PATH_NEWSHOME>@" ;>()=
$newshome = "/home/user/news" ;

##  =()<$archivedir = "@<_PATH_ARCHIVEDIR>@" ;>()=
$archivedir = "/news/spool/archive" ;

##  =()<$badnews = "@<_PATH_BADNEWS>@" ;>()=
$badnews = "/news/spool/in.coming/bad" ;

#### =()<$spoolnews = "@<_PATH_SPOOLNEWS>@" ;>()=
$spoolnews = "/news/spool/in.coming" ;

#### =()<$spooltemp = "@<_PATH_SPOOLTEMP>@" ;>()=
$spooltemp = "/news/spool/in.coming" ;

$newslbin = "$newshome/local" ;

##  =()<$umask = @<NEWSUMASK>@ ;>()=
$umask = 022 ;

$ENV{'PATH'} = "${newslbin}:${newsbin}:$ENV{'PATH'}:/bin:/usr/bin:/usr/ucb" ;

1 ;
