/* @(#) config.h 1.14 93/08/18 00:08:58 
 *
 * "du" enhanced disk usage summary - version 2.
 *
 * Copyright 1990-1993, Unicom Systems Development.  All rights reserved.
 * See accompanying README file for terms of distribution and use.
 *
 * Edit at tabstops=8.
 *
 * This file must be configured for the target system.  Warning -- a lot
 * of this stuff is pretty obscure and esoteric.  That's unavoidable.
 * After all, we are dealing with some very low-level system facilities.
 * Moreover, some vendors take it upon themself to "value add" their Unix
 * to death, which just makes this task more difficult.
 *
 * With patience (and a good file pager) you will persevere!  I've tried
 * to provide hints and assistance wherever possible.  Nonetheless, chances
 * are very good that you will need to trawl through your /usr/include
 * directory to determine which selections are correct.
 *
 * If you get stuck, consult the README.  You'll find some hints for a
 * handful of systems that I have personally used.  If you have any
 * suggestions on how to make this task easier, let me know.
 */

/*
 * Select one of the following.  It says how to read directories.
 */
#define USE_DIR_DIRENT		/* use <dirent.h>, struct dirent       common */
/*#define USE_DIR_SYSDIR	/* use <sys/dir.h>, struct direct     old BSD */
/*#define USE_DIR_SYSNDIR	/* use <sys/ndir.h>, struct direct  old XENIX */

/*
 * Select one of the following.  It says how to look for mounted filesystems.
 */
/*#define USE_MOUNT_MNTTAB	/* use <mnttab.h>, use /etc/mnttab       SysV */
/*#define USE_MOUNT_R4MNTTAB	/* use <sys/mnttab.h>, /etc/mnttab     SysVr4 */
#define USE_MOUNT_MNTENT	/* use <mntent.h>, use /etc/mtab   SunOS,HPUX */
/*#define USE_MOUNT_FSTAB	/* use <fstab.h>, use /etc/fstab          BSD */
/*#define USE_MOUNT_MNTCTL	/* use <sys/mntctl.h>, use mntctl()       AIX */

/*
 * Select one of the following.  It says where your "struct statfs" is
 * defined -- or that your system doesn't support the "statfs()" call.
 */
/*#define USE_STATFS_SYSV		/* include <sys/statfs.h>        */
/*#define USE_STATFS_BSD	/* include <sys/mount.h>		      */
#define USE_STATFS_SUN	/* include <sys/vfs.h>, SysV-style stafs()    */
/*#define USE_STATFS_HPUX	/* include <sys/vfs.h>, BSD-style statfs()    */
/*#define USE_STATFS_NONE	/* statfs() call not available, e.g. S5R2     */

/*
 * Enable USE_SYMLINKS if you have symbolic links, else comment it out.
 *
 * It is important you enable this if appropriate.  It prevents "du" from
 * following symlinks that point to directories, and thus reporting bogus
 * results or ending up in strange twisted loops.
 */
#define USE_SYMLINKS 		/* enable for SysVr4, Sun, etc. */

/*
 * Enable USE_STBLOCKS if the "stat" structure in your <sys/stat.h> file
 * has an "st_blocks" member, else comment it out.
 *
 * It is important to enable this if appropriate for two reasons.  First,
 * performance of "du" is *significantly* improved if "st_blocks"
 * information can be used.  Second, it will avoid reporting errors on
 * so-called "sparse" files.
 */
#define USE_STBLOCKS		/* enable for SysVr4, Sun, etc. */

/*
 * Leave BROKE_STBLOCKS undefined unless you really need it.
 *
 * If you didn't define USE_STBLOCKS above then don't even bother
 * reading this -- just leave BROKE_STBLOCKS undefined.
 *
 * This definition is provided as a workaround for certain vendors who
 * are a little confused about how Unix is supposed to work.  The
 * "st_blocks" information returned by stat(2) is supposed to be in
 * 512-byte blocks.  Some vendors botch this.  AIX, for example, properly
 * reports local filesystems in 512-byte blocks, but across the network
 * reports in 1024-byte blocks.  HPUX does the exact opposite.
 *
 * If you define BROKE_STBLOCKS, then "du" will try to calculate how
 * "st_blocks" should be interpreted rather than assuming 512-byte blocks.
 * This calculation, unfortunately, will fail for filesystems that use
 * fragments and the "f_bsize" value reported by statfs(2) is the block
 * size instead of the fragment size (e.g. Solaris, BSDI).
 *
 * So, enable BROKE_STBLOCKS only if all the following is true:
 *
 *	- You have defined USE_STBLOCKS.  If you haven't, BROKE_STBLOCKS
 *	  is ignored anyway.
 *
 *	- "du" is reporting wrong values, usually either twice or half
 *	  the correct size.
 *
 *	- Either you do not have a fast filesystem with fragments or
 *	  "f_bsize" indicates the size of the fragment.
 *
 * (Please send a note to the author if you wish you could use
 * BROKE_STBLOCKS but can't because your system uses fragments.)
 */
/*#define BROKE_STBLOCKS	/* enable for HPUX, networked AIX */

/*
 * If your system has the ANSI <stdarg.h> facility then enable USE_STDARG.
 * If your system only has the older <varargs.h> then disable it.
 */
/*#define USE_STDARG		/* enable on ANSI-compliant systems */

/*
 * Enable USE_UNISTD if your system has a <unistd.h> file.
 * If you don't have this header file then disable it.
 */
#define USE_UNISTD		/* enable on ANSI-compliant systems */

/*
 * Enable USE_PATHCONF if your system has the POSIX pathconf() facility,
 * else comment it out.
 *
 * ===>	For some reason, this is the definition people seem to flub up
 *	most frequently.  If your system is an older, pre-POSIX system
 *	that lacks pathconf() then do NOT enable this.  If you ain't
 *	got it, I can't use it!
 *
 * If you enable USE_PATHCONF you *must* also have enabled USE_UNISTD.
 * If you disable USE_PATHCONF then we will make a (usually reasonable)
 * guess at how much space to reserve to hold pathnames.
 */
#define USE_PATHCONF		/* enable on POSIX-compliant systems */

/*
 * PTRTYPE indicates what your compiler uses as a generic pointer type.
 * Most modern compilers will accept "void".  Crufty compilers use "char".
 */
#ifndef PTRTYPE
#define PTRTYPE void		/* use (void *) as a generic pointer	*/
/*#define PTRTYPE char		/* use (char *) as a generic pointer	*/
#endif

/*
 * ### YOU ARE NOW FINISHED WITH THE ESSENTIAL CONFIGURATIONS ###
 * 
 * Congratulations!  You made it.  You are now ready to roll.
 *
 * You might, however, want to glance through the following definitions.
 * These allow you to tailor "du" behavior according to your site-specific
 * preferences.
 */

/*
 * REPORT_BLOCKSIZE specifies default block size to use for reporting
 * disk usage, usually either "512" or "1024".  Most versions of "du"
 * (including POSIX conformant versions) use 512.  Others, such as SunOS,
 * use 1024.  Pick whatever you prefer.  This choice does not effect the
 * usage calculations or accuracy, only how the results are displayed,
 * and there are command line switches that will override the default
 * selected here.
 */
/*#define REPORT_BLKSIZE		512	/* report in 512-byte blocks    */
#define REPORT_BLKSIZE	1024	/* report in 1024-byte blocks   */

/*
 * PRINT_ERRORS controls whether or not error messages (e.g. "permission
 * denied", etc.) are displayed.  When defined, these error messages are
 * displayed.  When disabled, the errors are silently ignored -- which
 * is traditional "du" behavior.  I think it makes more sense to print
 * the errors (i.e. enable PRINT_ERRORS).  If, however, you disable this
 * to obtain backward compatibility, you will get a "-r" command line
 * option that will turn error messages back on.
 */
#define PRINT_ERRORS		/* display errors by default if enabled */

/*
 * TIMEOUT is a release hatch for hung NFS servers.  If you define
 * this value, "du" will unceremoniously kill itself after this many
 * seconds of inactivity.
 */
/*#define TIMEOUT	300	/* timeout value in seconds		*/

/*
 * MAX_BREAK is maximum number of columns which can be requested by the
 * "-c" option (breakdown usage by age).  Increasing this value will
 * increase the memory usage, but not by much.
 */
#define MAX_BREAK	64	/* max columns in breakdown by age	*/

/*
 * OBSOLETEOPT enables "-d" which was present in the original "enh-du"
 * release.  This prevents "du" from descending into directories
 * entirely, which in retrospect seems like a pretty useless thing.
 * If you really need it, enable OBSOLETEOPT.  And let me know, because
 * it is slated for removal if and when another release is done.
 */
/*#define OBSOLETEOPT		/* if you want old "-d" option		*/

