// A Bison parser, made by GNU Bison 3.0.5.

// Skeleton interface for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

/**
 ** \file parser.h
 ** Define the isc::eval::parser class.
 */

// C++ LALR(1) parser skeleton written by Akim Demaille.

#ifndef YY_EVAL_PARSER_H_INCLUDED
# define YY_EVAL_PARSER_H_INCLUDED
// //                    "%code requires" blocks.
#line 17 "parser.yy" // lalr1.cc:379

#include <string>
#include <eval/token.h>
#include <eval/eval_context_decl.h>
#include <dhcp/option.h>
#include <boost/lexical_cast.hpp>

using namespace isc::dhcp;
using namespace isc::eval;

#line 55 "parser.h" // lalr1.cc:379

# include <cassert>
# include <cstdlib> // std::abort
# include <iostream>
# include <stdexcept>
# include <string>
# include <vector>
# include "stack.hh"
# include "location.hh"
#include <typeinfo>
#ifndef YYASSERT
# include <cassert>
# define YYASSERT assert
#endif


#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

/* Debug traces.  */
#ifndef EVALDEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define EVALDEBUG 1
#  else
#   define EVALDEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define EVALDEBUG 1
# endif /* ! defined YYDEBUG */
#endif  /* ! defined EVALDEBUG */

#line 14 "parser.yy" // lalr1.cc:379
namespace isc { namespace eval {
#line 140 "parser.h" // lalr1.cc:379



  /// A char[S] buffer to store and retrieve objects.
  ///
  /// Sort of a variant, but does not keep track of the nature
  /// of the stored data, since that knowledge is available
  /// via the current state.
  template <size_t S>
  struct variant
  {
    /// Type of *this.
    typedef variant<S> self_type;

    /// Empty construction.
    variant ()
      : yytypeid_ (YY_NULLPTR)
    {}

    /// Construct and fill.
    template <typename T>
    variant (const T& t)
      : yytypeid_ (&typeid (T))
    {
      YYASSERT (sizeof (T) <= S);
      new (yyas_<T> ()) T (t);
    }

    /// Destruction, allowed only if empty.
    ~variant ()
    {
      YYASSERT (!yytypeid_);
    }

    /// Instantiate an empty \a T in here.
    template <typename T>
    T&
    build ()
    {
      YYASSERT (!yytypeid_);
      YYASSERT (sizeof (T) <= S);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T;
    }

    /// Instantiate a \a T in here from \a t.
    template <typename T>
    T&
    build (const T& t)
    {
      YYASSERT (!yytypeid_);
      YYASSERT (sizeof (T) <= S);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T (t);
    }

    /// Accessor to a built \a T.
    template <typename T>
    T&
    as ()
    {
      YYASSERT (*yytypeid_ == typeid (T));
      YYASSERT (sizeof (T) <= S);
      return *yyas_<T> ();
    }

    /// Const accessor to a built \a T (for %printer).
    template <typename T>
    const T&
    as () const
    {
      YYASSERT (*yytypeid_ == typeid (T));
      YYASSERT (sizeof (T) <= S);
      return *yyas_<T> ();
    }

    /// Swap the content with \a other, of same type.
    ///
    /// Both variants must be built beforehand, because swapping the actual
    /// data requires reading it (with as()), and this is not possible on
    /// unconstructed variants: it would require some dynamic testing, which
    /// should not be the variant's responsability.
    /// Swapping between built and (possibly) non-built is done with
    /// variant::move ().
    template <typename T>
    void
    swap (self_type& other)
    {
      YYASSERT (yytypeid_);
      YYASSERT (*yytypeid_ == *other.yytypeid_);
      std::swap (as<T> (), other.as<T> ());
    }

    /// Move the content of \a other to this.
    ///
    /// Destroys \a other.
    template <typename T>
    void
    move (self_type& other)
    {
      build<T> ();
      swap<T> (other);
      other.destroy<T> ();
    }

    /// Copy the content of \a other to this.
    template <typename T>
    void
    copy (const self_type& other)
    {
      build<T> (other.as<T> ());
    }

    /// Destroy the stored \a T.
    template <typename T>
    void
    destroy ()
    {
      as<T> ().~T ();
      yytypeid_ = YY_NULLPTR;
    }

  private:
    /// Prohibit blind copies.
    self_type& operator=(const self_type&);
    variant (const self_type&);

    /// Accessor to raw memory as \a T.
    template <typename T>
    T*
    yyas_ ()
    {
      void *yyp = yybuffer_.yyraw;
      return static_cast<T*> (yyp);
     }

    /// Const accessor to raw memory as \a T.
    template <typename T>
    const T*
    yyas_ () const
    {
      const void *yyp = yybuffer_.yyraw;
      return static_cast<const T*> (yyp);
     }

    union
    {
      /// Strongest alignment constraints.
      long double yyalign_me;
      /// A buffer large enough to store any of the semantic values.
      char yyraw[S];
    } yybuffer_;

    /// Whether the content is built: if defined, the name of the stored type.
    const std::type_info *yytypeid_;
  };


  /// A Bison parser.
  class EvalParser
  {
  public:
#ifndef EVALSTYPE
    /// An auxiliary type to compute the largest semantic type.
    union union_type
    {
      // option_repr_type
      char dummy1[sizeof(TokenOption::RepresentationType)];

      // pkt4_field
      char dummy2[sizeof(TokenPkt4::FieldType)];

      // pkt6_field
      char dummy3[sizeof(TokenPkt6::FieldType)];

      // pkt_metadata
      char dummy4[sizeof(TokenPkt::MetadataType)];

      // relay6_field
      char dummy5[sizeof(TokenRelay6Field::FieldType)];

      // nest_level
      char dummy6[sizeof(int8_t)];

      // "constant string"
      // "integer"
      // "constant hexstring"
      // "option name"
      // "ip address"
      char dummy7[sizeof(std::string)];

      // option_code
      char dummy8[sizeof(uint16_t)];

      // integer_expr
      // enterprise_id
      char dummy9[sizeof(uint32_t)];
};

    /// Symbol semantic values.
    typedef variant<sizeof(union_type)> semantic_type;
#else
    typedef EVALSTYPE semantic_type;
#endif
    /// Symbol locations.
    typedef location location_type;

    /// Syntax errors thrown from user actions.
    struct syntax_error : std::runtime_error
    {
      syntax_error (const location_type& l, const std::string& m);
      location_type location;
    };

    /// Tokens.
    struct token
    {
      enum yytokentype
      {
        TOKEN_END = 0,
        TOKEN_LPAREN = 258,
        TOKEN_RPAREN = 259,
        TOKEN_NOT = 260,
        TOKEN_AND = 261,
        TOKEN_OR = 262,
        TOKEN_EQUAL = 263,
        TOKEN_OPTION = 264,
        TOKEN_RELAY4 = 265,
        TOKEN_RELAY6 = 266,
        TOKEN_MEMBER = 267,
        TOKEN_PEERADDR = 268,
        TOKEN_LINKADDR = 269,
        TOKEN_LBRACKET = 270,
        TOKEN_RBRACKET = 271,
        TOKEN_DOT = 272,
        TOKEN_TEXT = 273,
        TOKEN_HEX = 274,
        TOKEN_EXISTS = 275,
        TOKEN_PKT = 276,
        TOKEN_IFACE = 277,
        TOKEN_SRC = 278,
        TOKEN_DST = 279,
        TOKEN_LEN = 280,
        TOKEN_PKT4 = 281,
        TOKEN_CHADDR = 282,
        TOKEN_HLEN = 283,
        TOKEN_HTYPE = 284,
        TOKEN_CIADDR = 285,
        TOKEN_GIADDR = 286,
        TOKEN_YIADDR = 287,
        TOKEN_SIADDR = 288,
        TOKEN_SUBSTRING = 289,
        TOKEN_ALL = 290,
        TOKEN_COMA = 291,
        TOKEN_CONCAT = 292,
        TOKEN_IFELSE = 293,
        TOKEN_TOHEXSTRING = 294,
        TOKEN_PKT6 = 295,
        TOKEN_MSGTYPE = 296,
        TOKEN_TRANSID = 297,
        TOKEN_VENDOR_CLASS = 298,
        TOKEN_VENDOR = 299,
        TOKEN_ANY = 300,
        TOKEN_DATA = 301,
        TOKEN_ENTERPRISE = 302,
        TOKEN_TOPLEVEL_BOOL = 303,
        TOKEN_TOPLEVEL_STRING = 304,
        TOKEN_STRING = 305,
        TOKEN_INTEGER = 306,
        TOKEN_HEXSTRING = 307,
        TOKEN_OPTION_NAME = 308,
        TOKEN_IP_ADDRESS = 309
      };
    };

    /// (External) token type, as returned by yylex.
    typedef token::yytokentype token_type;

    /// Symbol type: an internal symbol number.
    typedef int symbol_number_type;

    /// The symbol type number to denote an empty symbol.
    enum { empty_symbol = -2 };

    /// Internal symbol number for tokens (subsumed by symbol_number_type).
    typedef unsigned char token_number_type;

    /// A complete symbol.
    ///
    /// Expects its Base type to provide access to the symbol type
    /// via type_get().
    ///
    /// Provide access to semantic value and location.
    template <typename Base>
    struct basic_symbol : Base
    {
      /// Alias to Base.
      typedef Base super_type;

      /// Default constructor.
      basic_symbol ();

      /// Copy constructor.
      basic_symbol (const basic_symbol& other);

      /// Constructor for valueless symbols, and symbols from each type.

  basic_symbol (typename Base::kind_type t, const location_type& l);

  basic_symbol (typename Base::kind_type t, const TokenOption::RepresentationType v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const TokenPkt4::FieldType v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const TokenPkt6::FieldType v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const TokenPkt::MetadataType v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const TokenRelay6Field::FieldType v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const int8_t v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const std::string v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const uint16_t v, const location_type& l);

  basic_symbol (typename Base::kind_type t, const uint32_t v, const location_type& l);


      /// Constructor for symbols with semantic value.
      basic_symbol (typename Base::kind_type t,
                    const semantic_type& v,
                    const location_type& l);

      /// Destroy the symbol.
      ~basic_symbol ();

      /// Destroy contents, and record that is empty.
      void clear ();

      /// Whether empty.
      bool empty () const;

      /// Destructive move, \a s is emptied into this.
      void move (basic_symbol& s);

      /// The semantic value.
      semantic_type value;

      /// The location.
      location_type location;

    private:
      /// Assignment operator.
      basic_symbol& operator= (const basic_symbol& other);
    };

    /// Type access provider for token (enum) based symbols.
    struct by_type
    {
      /// Default constructor.
      by_type ();

      /// Copy constructor.
      by_type (const by_type& other);

      /// The symbol type as needed by the constructor.
      typedef token_type kind_type;

      /// Constructor from (external) token numbers.
      by_type (kind_type t);

      /// Record that this symbol is empty.
      void clear ();

      /// Steal the symbol type from \a that.
      void move (by_type& that);

      /// The (internal) type number (corresponding to \a type).
      /// \a empty when empty.
      symbol_number_type type_get () const;

      /// The token.
      token_type token () const;

      /// The symbol type.
      /// \a empty_symbol when empty.
      /// An int, not token_number_type, to be able to store empty_symbol.
      int type;
    };

    /// "External" symbols: returned by the scanner.
    typedef basic_symbol<by_type> symbol_type;

    // Symbol constructors declarations.
    static inline
    symbol_type
    make_END (const location_type& l);

    static inline
    symbol_type
    make_LPAREN (const location_type& l);

    static inline
    symbol_type
    make_RPAREN (const location_type& l);

    static inline
    symbol_type
    make_NOT (const location_type& l);

    static inline
    symbol_type
    make_AND (const location_type& l);

    static inline
    symbol_type
    make_OR (const location_type& l);

    static inline
    symbol_type
    make_EQUAL (const location_type& l);

    static inline
    symbol_type
    make_OPTION (const location_type& l);

    static inline
    symbol_type
    make_RELAY4 (const location_type& l);

    static inline
    symbol_type
    make_RELAY6 (const location_type& l);

    static inline
    symbol_type
    make_MEMBER (const location_type& l);

    static inline
    symbol_type
    make_PEERADDR (const location_type& l);

    static inline
    symbol_type
    make_LINKADDR (const location_type& l);

    static inline
    symbol_type
    make_LBRACKET (const location_type& l);

    static inline
    symbol_type
    make_RBRACKET (const location_type& l);

    static inline
    symbol_type
    make_DOT (const location_type& l);

    static inline
    symbol_type
    make_TEXT (const location_type& l);

    static inline
    symbol_type
    make_HEX (const location_type& l);

    static inline
    symbol_type
    make_EXISTS (const location_type& l);

    static inline
    symbol_type
    make_PKT (const location_type& l);

    static inline
    symbol_type
    make_IFACE (const location_type& l);

    static inline
    symbol_type
    make_SRC (const location_type& l);

    static inline
    symbol_type
    make_DST (const location_type& l);

    static inline
    symbol_type
    make_LEN (const location_type& l);

    static inline
    symbol_type
    make_PKT4 (const location_type& l);

    static inline
    symbol_type
    make_CHADDR (const location_type& l);

    static inline
    symbol_type
    make_HLEN (const location_type& l);

    static inline
    symbol_type
    make_HTYPE (const location_type& l);

    static inline
    symbol_type
    make_CIADDR (const location_type& l);

    static inline
    symbol_type
    make_GIADDR (const location_type& l);

    static inline
    symbol_type
    make_YIADDR (const location_type& l);

    static inline
    symbol_type
    make_SIADDR (const location_type& l);

    static inline
    symbol_type
    make_SUBSTRING (const location_type& l);

    static inline
    symbol_type
    make_ALL (const location_type& l);

    static inline
    symbol_type
    make_COMA (const location_type& l);

    static inline
    symbol_type
    make_CONCAT (const location_type& l);

    static inline
    symbol_type
    make_IFELSE (const location_type& l);

    static inline
    symbol_type
    make_TOHEXSTRING (const location_type& l);

    static inline
    symbol_type
    make_PKT6 (const location_type& l);

    static inline
    symbol_type
    make_MSGTYPE (const location_type& l);

    static inline
    symbol_type
    make_TRANSID (const location_type& l);

    static inline
    symbol_type
    make_VENDOR_CLASS (const location_type& l);

    static inline
    symbol_type
    make_VENDOR (const location_type& l);

    static inline
    symbol_type
    make_ANY (const location_type& l);

    static inline
    symbol_type
    make_DATA (const location_type& l);

    static inline
    symbol_type
    make_ENTERPRISE (const location_type& l);

    static inline
    symbol_type
    make_TOPLEVEL_BOOL (const location_type& l);

    static inline
    symbol_type
    make_TOPLEVEL_STRING (const location_type& l);

    static inline
    symbol_type
    make_STRING (const std::string& v, const location_type& l);

    static inline
    symbol_type
    make_INTEGER (const std::string& v, const location_type& l);

    static inline
    symbol_type
    make_HEXSTRING (const std::string& v, const location_type& l);

    static inline
    symbol_type
    make_OPTION_NAME (const std::string& v, const location_type& l);

    static inline
    symbol_type
    make_IP_ADDRESS (const std::string& v, const location_type& l);


    /// Build a parser object.
    EvalParser (EvalContext& ctx_yyarg);
    virtual ~EvalParser ();

    /// Parse.
    /// \returns  0 iff parsing succeeded.
    virtual int parse ();

#if EVALDEBUG
    /// The current debugging stream.
    std::ostream& debug_stream () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging stream.
    void set_debug_stream (std::ostream &);

    /// Type for debugging levels.
    typedef int debug_level_type;
    /// The current debugging level.
    debug_level_type debug_level () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging level.
    void set_debug_level (debug_level_type l);
#endif

    /// Report a syntax error.
    /// \param loc    where the syntax error is found.
    /// \param msg    a description of the syntax error.
    virtual void error (const location_type& loc, const std::string& msg);

    /// Report a syntax error.
    void error (const syntax_error& err);

  private:
    /// This class is not copyable.
    EvalParser (const EvalParser&);
    EvalParser& operator= (const EvalParser&);

    /// State numbers.
    typedef int state_type;

    /// Generate an error message.
    /// \param yystate   the state where the error occurred.
    /// \param yyla      the lookahead token.
    virtual std::string yysyntax_error_ (state_type yystate,
                                         const symbol_type& yyla) const;

    /// Compute post-reduction state.
    /// \param yystate   the current state
    /// \param yysym     the nonterminal to push on the stack
    state_type yy_lr_goto_state_ (state_type yystate, int yysym);

    /// Whether the given \c yypact_ value indicates a defaulted state.
    /// \param yyvalue   the value to check
    static bool yy_pact_value_is_default_ (int yyvalue);

    /// Whether the given \c yytable_ value indicates a syntax error.
    /// \param yyvalue   the value to check
    static bool yy_table_value_is_error_ (int yyvalue);

    static const signed char yypact_ninf_;
    static const signed char yytable_ninf_;

    /// Convert a scanner token number \a t to a symbol number.
    static token_number_type yytranslate_ (token_type t);

    // Tables.
  // YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
  // STATE-NUM.
  static const short int yypact_[];

  // YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
  // Performed when YYTABLE does not specify something else to do.  Zero
  // means the default is an error.
  static const unsigned char yydefact_[];

  // YYPGOTO[NTERM-NUM].
  static const short int yypgoto_[];

  // YYDEFGOTO[NTERM-NUM].
  static const short int yydefgoto_[];

  // YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
  // positive, shift that token.  If negative, reduce the rule whose
  // number is the opposite.  If YYTABLE_NINF, syntax error.
  static const unsigned char yytable_[];

  static const unsigned char yycheck_[];

  // YYSTOS[STATE-NUM] -- The (internal number of the) accessing
  // symbol of state STATE-NUM.
  static const unsigned char yystos_[];

  // YYR1[YYN] -- Symbol number of symbol that rule YYN derives.
  static const unsigned char yyr1_[];

  // YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.
  static const unsigned char yyr2_[];


    /// Convert the symbol name \a n to a form suitable for a diagnostic.
    static std::string yytnamerr_ (const char *n);


    /// For a symbol, its name in clear.
    static const char* const yytname_[];
#if EVALDEBUG
  // YYRLINE[YYN] -- Source line where rule number YYN was defined.
  static const unsigned short int yyrline_[];
    /// Report on the debug stream that the rule \a r is going to be reduced.
    virtual void yy_reduce_print_ (int r);
    /// Print the state stack on the debug stream.
    virtual void yystack_print_ ();

    // Debugging.
    int yydebug_;
    std::ostream* yycdebug_;

    /// \brief Display a symbol type, value and location.
    /// \param yyo    The output stream.
    /// \param yysym  The symbol.
    template <typename Base>
    void yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const;
#endif

    /// \brief Reclaim the memory associated to a symbol.
    /// \param yymsg     Why this token is reclaimed.
    ///                  If null, print nothing.
    /// \param yysym     The symbol.
    template <typename Base>
    void yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const;

  private:
    /// Type access provider for state based symbols.
    struct by_state
    {
      /// Default constructor.
      by_state ();

      /// The symbol type as needed by the constructor.
      typedef state_type kind_type;

      /// Constructor.
      by_state (kind_type s);

      /// Copy constructor.
      by_state (const by_state& other);

      /// Record that this symbol is empty.
      void clear ();

      /// Steal the symbol type from \a that.
      void move (by_state& that);

      /// The (internal) type number (corresponding to \a state).
      /// \a empty_symbol when empty.
      symbol_number_type type_get () const;

      /// The state number used to denote an empty symbol.
      enum { empty_state = -1 };

      /// The state.
      /// \a empty when empty.
      state_type state;
    };

    /// "Internal" symbol: element of the stack.
    struct stack_symbol_type : basic_symbol<by_state>
    {
      /// Superclass.
      typedef basic_symbol<by_state> super_type;
      /// Construct an empty symbol.
      stack_symbol_type ();
      /// Copy construct.
      stack_symbol_type (const stack_symbol_type& that);
      /// Steal the contents from \a sym to build this.
      stack_symbol_type (state_type s, symbol_type& sym);
      /// Assignment, needed by push_back.
      stack_symbol_type& operator= (const stack_symbol_type& that);
    };

    /// Stack type.
    typedef stack<stack_symbol_type> stack_type;

    /// The stack.
    stack_type yystack_;

    /// Push a new state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the symbol
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, stack_symbol_type& s);

    /// Push a new look ahead token on the state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the state
    /// \param sym  the symbol (for its value and location).
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, state_type s, symbol_type& sym);

    /// Pop \a n symbols the three stacks.
    void yypop_ (unsigned n = 1);

    /// Constants.
    enum
    {
      yyeof_ = 0,
      yylast_ = 197,     ///< Last index in yytable_.
      yynnts_ = 16,  ///< Number of nonterminal symbols.
      yyfinal_ = 33, ///< Termination state number.
      yyterror_ = 1,
      yyerrcode_ = 256,
      yyntokens_ = 55  ///< Number of tokens.
    };


    // User arguments.
    EvalContext& ctx;
  };

  // Symbol number corresponding to token number t.
  inline
  EvalParser::token_number_type
  EvalParser::yytranslate_ (token_type t)
  {
    static
    const token_number_type
    translate_table[] =
    {
     0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54
    };
    const unsigned user_token_number_max_ = 309;
    const token_number_type undef_token_ = 2;

    if (static_cast<int> (t) <= yyeof_)
      return yyeof_;
    else if (static_cast<unsigned> (t) <= user_token_number_max_)
      return translate_table[t];
    else
      return undef_token_;
  }

  inline
  EvalParser::syntax_error::syntax_error (const location_type& l, const std::string& m)
    : std::runtime_error (m)
    , location (l)
  {}

  // basic_symbol.
  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol ()
    : value ()
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (const basic_symbol& other)
    : Base (other)
    , value ()
    , location (other.location)
  {
    switch (other.type_get ())
    {
      case 62: // option_repr_type
        value.copy< TokenOption::RepresentationType > (other.value);
        break;

      case 66: // pkt4_field
        value.copy< TokenPkt4::FieldType > (other.value);
        break;

      case 67: // pkt6_field
        value.copy< TokenPkt6::FieldType > (other.value);
        break;

      case 64: // pkt_metadata
        value.copy< TokenPkt::MetadataType > (other.value);
        break;

      case 68: // relay6_field
        value.copy< TokenRelay6Field::FieldType > (other.value);
        break;

      case 63: // nest_level
        value.copy< int8_t > (other.value);
        break;

      case 50: // "constant string"
      case 51: // "integer"
      case 52: // "constant hexstring"
      case 53: // "option name"
      case 54: // "ip address"
        value.copy< std::string > (other.value);
        break;

      case 61: // option_code
        value.copy< uint16_t > (other.value);
        break;

      case 60: // integer_expr
      case 65: // enterprise_id
        value.copy< uint32_t > (other.value);
        break;

      default:
        break;
    }

  }

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const semantic_type& v, const location_type& l)
    : Base (t)
    , value ()
    , location (l)
  {
    (void) v;
    switch (this->type_get ())
    {
      case 62: // option_repr_type
        value.copy< TokenOption::RepresentationType > (v);
        break;

      case 66: // pkt4_field
        value.copy< TokenPkt4::FieldType > (v);
        break;

      case 67: // pkt6_field
        value.copy< TokenPkt6::FieldType > (v);
        break;

      case 64: // pkt_metadata
        value.copy< TokenPkt::MetadataType > (v);
        break;

      case 68: // relay6_field
        value.copy< TokenRelay6Field::FieldType > (v);
        break;

      case 63: // nest_level
        value.copy< int8_t > (v);
        break;

      case 50: // "constant string"
      case 51: // "integer"
      case 52: // "constant hexstring"
      case 53: // "option name"
      case 54: // "ip address"
        value.copy< std::string > (v);
        break;

      case 61: // option_code
        value.copy< uint16_t > (v);
        break;

      case 60: // integer_expr
      case 65: // enterprise_id
        value.copy< uint32_t > (v);
        break;

      default:
        break;
    }
}


  // Implementation of basic_symbol constructor for each type.

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const location_type& l)
    : Base (t)
    , value ()
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const TokenOption::RepresentationType v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const TokenPkt4::FieldType v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const TokenPkt6::FieldType v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const TokenPkt::MetadataType v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const TokenRelay6Field::FieldType v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const int8_t v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const std::string v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const uint16_t v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}

  template <typename Base>
  EvalParser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const uint32_t v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}


  template <typename Base>
  EvalParser::basic_symbol<Base>::~basic_symbol ()
  {
    clear ();
  }

  template <typename Base>
  void
  EvalParser::basic_symbol<Base>::clear ()
  {
    // User destructor.
    symbol_number_type yytype = this->type_get ();
    basic_symbol<Base>& yysym = *this;
    (void) yysym;
    switch (yytype)
    {
   default:
      break;
    }

    // Type destructor.
  switch (yytype)
    {
      case 62: // option_repr_type
        value.template destroy< TokenOption::RepresentationType > ();
        break;

      case 66: // pkt4_field
        value.template destroy< TokenPkt4::FieldType > ();
        break;

      case 67: // pkt6_field
        value.template destroy< TokenPkt6::FieldType > ();
        break;

      case 64: // pkt_metadata
        value.template destroy< TokenPkt::MetadataType > ();
        break;

      case 68: // relay6_field
        value.template destroy< TokenRelay6Field::FieldType > ();
        break;

      case 63: // nest_level
        value.template destroy< int8_t > ();
        break;

      case 50: // "constant string"
      case 51: // "integer"
      case 52: // "constant hexstring"
      case 53: // "option name"
      case 54: // "ip address"
        value.template destroy< std::string > ();
        break;

      case 61: // option_code
        value.template destroy< uint16_t > ();
        break;

      case 60: // integer_expr
      case 65: // enterprise_id
        value.template destroy< uint32_t > ();
        break;

      default:
        break;
    }

    Base::clear ();
  }

  template <typename Base>
  bool
  EvalParser::basic_symbol<Base>::empty () const
  {
    return Base::type_get () == empty_symbol;
  }

  template <typename Base>
  void
  EvalParser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    switch (this->type_get ())
    {
      case 62: // option_repr_type
        value.move< TokenOption::RepresentationType > (s.value);
        break;

      case 66: // pkt4_field
        value.move< TokenPkt4::FieldType > (s.value);
        break;

      case 67: // pkt6_field
        value.move< TokenPkt6::FieldType > (s.value);
        break;

      case 64: // pkt_metadata
        value.move< TokenPkt::MetadataType > (s.value);
        break;

      case 68: // relay6_field
        value.move< TokenRelay6Field::FieldType > (s.value);
        break;

      case 63: // nest_level
        value.move< int8_t > (s.value);
        break;

      case 50: // "constant string"
      case 51: // "integer"
      case 52: // "constant hexstring"
      case 53: // "option name"
      case 54: // "ip address"
        value.move< std::string > (s.value);
        break;

      case 61: // option_code
        value.move< uint16_t > (s.value);
        break;

      case 60: // integer_expr
      case 65: // enterprise_id
        value.move< uint32_t > (s.value);
        break;

      default:
        break;
    }

    location = s.location;
  }

  // by_type.
  inline
  EvalParser::by_type::by_type ()
    : type (empty_symbol)
  {}

  inline
  EvalParser::by_type::by_type (const by_type& other)
    : type (other.type)
  {}

  inline
  EvalParser::by_type::by_type (token_type t)
    : type (yytranslate_ (t))
  {}

  inline
  void
  EvalParser::by_type::clear ()
  {
    type = empty_symbol;
  }

  inline
  void
  EvalParser::by_type::move (by_type& that)
  {
    type = that.type;
    that.clear ();
  }

  inline
  int
  EvalParser::by_type::type_get () const
  {
    return type;
  }

  inline
  EvalParser::token_type
  EvalParser::by_type::token () const
  {
    // YYTOKNUM[NUM] -- (External) token number corresponding to the
    // (internal) symbol number NUM (which must be that of a token).  */
    static
    const unsigned short int
    yytoken_number_[] =
    {
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309
    };
    return static_cast<token_type> (yytoken_number_[type]);
  }
  // Implementation of make_symbol for each symbol type.
  EvalParser::symbol_type
  EvalParser::make_END (const location_type& l)
  {
    return symbol_type (token::TOKEN_END, l);
  }

  EvalParser::symbol_type
  EvalParser::make_LPAREN (const location_type& l)
  {
    return symbol_type (token::TOKEN_LPAREN, l);
  }

  EvalParser::symbol_type
  EvalParser::make_RPAREN (const location_type& l)
  {
    return symbol_type (token::TOKEN_RPAREN, l);
  }

  EvalParser::symbol_type
  EvalParser::make_NOT (const location_type& l)
  {
    return symbol_type (token::TOKEN_NOT, l);
  }

  EvalParser::symbol_type
  EvalParser::make_AND (const location_type& l)
  {
    return symbol_type (token::TOKEN_AND, l);
  }

  EvalParser::symbol_type
  EvalParser::make_OR (const location_type& l)
  {
    return symbol_type (token::TOKEN_OR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_EQUAL (const location_type& l)
  {
    return symbol_type (token::TOKEN_EQUAL, l);
  }

  EvalParser::symbol_type
  EvalParser::make_OPTION (const location_type& l)
  {
    return symbol_type (token::TOKEN_OPTION, l);
  }

  EvalParser::symbol_type
  EvalParser::make_RELAY4 (const location_type& l)
  {
    return symbol_type (token::TOKEN_RELAY4, l);
  }

  EvalParser::symbol_type
  EvalParser::make_RELAY6 (const location_type& l)
  {
    return symbol_type (token::TOKEN_RELAY6, l);
  }

  EvalParser::symbol_type
  EvalParser::make_MEMBER (const location_type& l)
  {
    return symbol_type (token::TOKEN_MEMBER, l);
  }

  EvalParser::symbol_type
  EvalParser::make_PEERADDR (const location_type& l)
  {
    return symbol_type (token::TOKEN_PEERADDR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_LINKADDR (const location_type& l)
  {
    return symbol_type (token::TOKEN_LINKADDR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_LBRACKET (const location_type& l)
  {
    return symbol_type (token::TOKEN_LBRACKET, l);
  }

  EvalParser::symbol_type
  EvalParser::make_RBRACKET (const location_type& l)
  {
    return symbol_type (token::TOKEN_RBRACKET, l);
  }

  EvalParser::symbol_type
  EvalParser::make_DOT (const location_type& l)
  {
    return symbol_type (token::TOKEN_DOT, l);
  }

  EvalParser::symbol_type
  EvalParser::make_TEXT (const location_type& l)
  {
    return symbol_type (token::TOKEN_TEXT, l);
  }

  EvalParser::symbol_type
  EvalParser::make_HEX (const location_type& l)
  {
    return symbol_type (token::TOKEN_HEX, l);
  }

  EvalParser::symbol_type
  EvalParser::make_EXISTS (const location_type& l)
  {
    return symbol_type (token::TOKEN_EXISTS, l);
  }

  EvalParser::symbol_type
  EvalParser::make_PKT (const location_type& l)
  {
    return symbol_type (token::TOKEN_PKT, l);
  }

  EvalParser::symbol_type
  EvalParser::make_IFACE (const location_type& l)
  {
    return symbol_type (token::TOKEN_IFACE, l);
  }

  EvalParser::symbol_type
  EvalParser::make_SRC (const location_type& l)
  {
    return symbol_type (token::TOKEN_SRC, l);
  }

  EvalParser::symbol_type
  EvalParser::make_DST (const location_type& l)
  {
    return symbol_type (token::TOKEN_DST, l);
  }

  EvalParser::symbol_type
  EvalParser::make_LEN (const location_type& l)
  {
    return symbol_type (token::TOKEN_LEN, l);
  }

  EvalParser::symbol_type
  EvalParser::make_PKT4 (const location_type& l)
  {
    return symbol_type (token::TOKEN_PKT4, l);
  }

  EvalParser::symbol_type
  EvalParser::make_CHADDR (const location_type& l)
  {
    return symbol_type (token::TOKEN_CHADDR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_HLEN (const location_type& l)
  {
    return symbol_type (token::TOKEN_HLEN, l);
  }

  EvalParser::symbol_type
  EvalParser::make_HTYPE (const location_type& l)
  {
    return symbol_type (token::TOKEN_HTYPE, l);
  }

  EvalParser::symbol_type
  EvalParser::make_CIADDR (const location_type& l)
  {
    return symbol_type (token::TOKEN_CIADDR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_GIADDR (const location_type& l)
  {
    return symbol_type (token::TOKEN_GIADDR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_YIADDR (const location_type& l)
  {
    return symbol_type (token::TOKEN_YIADDR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_SIADDR (const location_type& l)
  {
    return symbol_type (token::TOKEN_SIADDR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_SUBSTRING (const location_type& l)
  {
    return symbol_type (token::TOKEN_SUBSTRING, l);
  }

  EvalParser::symbol_type
  EvalParser::make_ALL (const location_type& l)
  {
    return symbol_type (token::TOKEN_ALL, l);
  }

  EvalParser::symbol_type
  EvalParser::make_COMA (const location_type& l)
  {
    return symbol_type (token::TOKEN_COMA, l);
  }

  EvalParser::symbol_type
  EvalParser::make_CONCAT (const location_type& l)
  {
    return symbol_type (token::TOKEN_CONCAT, l);
  }

  EvalParser::symbol_type
  EvalParser::make_IFELSE (const location_type& l)
  {
    return symbol_type (token::TOKEN_IFELSE, l);
  }

  EvalParser::symbol_type
  EvalParser::make_TOHEXSTRING (const location_type& l)
  {
    return symbol_type (token::TOKEN_TOHEXSTRING, l);
  }

  EvalParser::symbol_type
  EvalParser::make_PKT6 (const location_type& l)
  {
    return symbol_type (token::TOKEN_PKT6, l);
  }

  EvalParser::symbol_type
  EvalParser::make_MSGTYPE (const location_type& l)
  {
    return symbol_type (token::TOKEN_MSGTYPE, l);
  }

  EvalParser::symbol_type
  EvalParser::make_TRANSID (const location_type& l)
  {
    return symbol_type (token::TOKEN_TRANSID, l);
  }

  EvalParser::symbol_type
  EvalParser::make_VENDOR_CLASS (const location_type& l)
  {
    return symbol_type (token::TOKEN_VENDOR_CLASS, l);
  }

  EvalParser::symbol_type
  EvalParser::make_VENDOR (const location_type& l)
  {
    return symbol_type (token::TOKEN_VENDOR, l);
  }

  EvalParser::symbol_type
  EvalParser::make_ANY (const location_type& l)
  {
    return symbol_type (token::TOKEN_ANY, l);
  }

  EvalParser::symbol_type
  EvalParser::make_DATA (const location_type& l)
  {
    return symbol_type (token::TOKEN_DATA, l);
  }

  EvalParser::symbol_type
  EvalParser::make_ENTERPRISE (const location_type& l)
  {
    return symbol_type (token::TOKEN_ENTERPRISE, l);
  }

  EvalParser::symbol_type
  EvalParser::make_TOPLEVEL_BOOL (const location_type& l)
  {
    return symbol_type (token::TOKEN_TOPLEVEL_BOOL, l);
  }

  EvalParser::symbol_type
  EvalParser::make_TOPLEVEL_STRING (const location_type& l)
  {
    return symbol_type (token::TOKEN_TOPLEVEL_STRING, l);
  }

  EvalParser::symbol_type
  EvalParser::make_STRING (const std::string& v, const location_type& l)
  {
    return symbol_type (token::TOKEN_STRING, v, l);
  }

  EvalParser::symbol_type
  EvalParser::make_INTEGER (const std::string& v, const location_type& l)
  {
    return symbol_type (token::TOKEN_INTEGER, v, l);
  }

  EvalParser::symbol_type
  EvalParser::make_HEXSTRING (const std::string& v, const location_type& l)
  {
    return symbol_type (token::TOKEN_HEXSTRING, v, l);
  }

  EvalParser::symbol_type
  EvalParser::make_OPTION_NAME (const std::string& v, const location_type& l)
  {
    return symbol_type (token::TOKEN_OPTION_NAME, v, l);
  }

  EvalParser::symbol_type
  EvalParser::make_IP_ADDRESS (const std::string& v, const location_type& l)
  {
    return symbol_type (token::TOKEN_IP_ADDRESS, v, l);
  }


#line 14 "parser.yy" // lalr1.cc:379
} } // isc::eval
#line 1727 "parser.h" // lalr1.cc:379




#endif // !YY_EVAL_PARSER_H_INCLUDED
