--
-- Copyright (C) 2002  Internet Software Consortium.
--
-- Permission to use, copy, modify, and distribute this software for any
-- purpose with or without fee is hereby granted, provided that the above
-- copyright notice and this permission notice appear in all copies.
--
-- THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
-- DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
-- INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
-- INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
-- FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
-- NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
-- WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

-- $Id: replication.sql,v 1.9 2002/12/06 21:25:44 lidl Exp $

--
-- Tables used for replication
--

CREATE TABLE rep (
       name            VARCHAR(32),     -- set name
       type            CHAR(1),         -- (M)aster, (S)lave, (F)ailover
       myname          VARCHAR(32),     -- local 'host name'
       repid           INT NOT NULL,    -- local ID for this replication set
       generation      INT8 NOT NULL    -- current local generation number
);

CREATE TABLE rep_version (
       repid           INT NOT NULL,    -- local ID for this replication set
       version         INT8 NOT NULL    -- current local version number
);

CREATE TABLE rep_delta (
       repid           INT NOT NULL,    -- replication ID
       generation      INT8 NOT NULL,   -- generation number
       to_vers         INT8 NOT NULL,   -- ending version
       seq             INT NOT NULL,    -- sequence number for delta ordering
       delta           TEXT NOT NULL,   -- the actual delta
       ts              DATETIME
);
CREATE INDEX rep_delta_idx1 ON rep_delta (repid);
CREATE INDEX rep_delta_idx2 ON rep_delta (ts);

CREATE TABLE rep_track (
       repid           INT NOT NULL,
       mastername      VARCHAR(32),     -- master 'host name'
       d_generation    INT8 NOT NULL,   -- last heard generation
       d_version       INT8 NOT NULL,   -- last heard version
       update_pending  BOOL,            -- indicates we're out of sync
       ts              DATETIME         -- last status update
);

CREATE TABLE rep_state (
       repid           INT NOT NULL,    -- replication ID
       slavename       VARCHAR(32),     -- slave name
       generation      INT8,            -- slave-reported generation
       version         INT8,            -- slave-reported version
       ts              DATETIME         -- when last updated
);

CREATE SEQUENCE rep_seq MINVALUE 10000 START 10000 CYCLE;
