--
-- Copyright (C) 2002, 2003  Internet Software Consortium.
--
-- Permission to use, copy, modify, and distribute this software for any
-- purpose with or without fee is hereby granted, provided that the above
-- copyright notice and this permission notice appear in all copies.
--
-- THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
-- DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
-- INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
-- INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
-- FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
-- NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
-- WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

-- $Id: sample_ote.sql,v 1.23 2003/02/09 21:45:21 lidl Exp $

--
-- insert sample data items into the database.
--

--
-- First, the replication stuff
--
INSERT INTO rep (name, type, myname, repid, generation)
        VALUES ('srs', 'M', 'master', 1000, 1);

INSERT INTO rep_version (repid, version)
        VALUES (1000, 1);

--
-- initial SOA record
--
INSERT INTO soa (st, apex, origin, contact, serial,
                 refresh, retry, expire, minimum, ttl)
        VALUES (1, 'ORG.ISC.ORG', 'NS1.TLD.ISC.ORG.', 'hostmaster.ISC.ORG.',
                1, 1800, 900, 604800, 3600, 600);

--
-- A sample SRS registrar/user
--
INSERT INTO registrar (st, registrar_id, name, userid, password, whois, url)
        VALUES (1, 1, 'ISC Sample Registry', 'isc', 'isc_pw',
                'org-test.isc.org', 'http://org-test.isc.org');

--
-- The 'public' registrar/user, for doing 'public' lookups on items
--
INSERT INTO registrar (st, registrar_id, name, userid, password, whois, url)
        VALUES (1, 2, 'Public Registrar Pseudo-User', 'public', 'public_pw',
                'org-test.isc.org', 'http://org-test.isc.org');

--
-- a sample set of records to describe a contact
--
INSERT INTO contact (st, contact_id, handle, guid, voice, voice_ext, fax,
                     email, clid, crid, crdate)
	VALUES (1, 1, 'C1', 'C1-ISC', '+1.6507797060', '1001',
		'+1.6507797055', 'hostmaster@isc.org', 1, 1, 'now');

INSERT INTO contact_postal (st, contact_id, type, name, org,
		street1, city, sp, pc, cc)
	VALUES (1, 1, 'int', 'Hostmaster', 'Internet Software Consortium',
		'950 Charter Street', 'Redwood City', 'CA', '94063', 'US');

INSERT INTO contact_authinfo (st, contact_id, authtype, authinfo)
	VALUES (1, 1, 'pw', 'isc-pw');

--
-- a second test contact, with two addresses
--
INSERT INTO contact (st, contact_id, handle, guid, voice, fax, email,
		     clid, crid, crdate)
	VALUES (1, 2, 'C2', 'C2-ISC', '+44.1223250122', '+44.1223250133',
		'hostmaster@isc.org', 1, 1, 'now');

INSERT INTO contact_postal (st, contact_id, type, name, org,
		street1, street2, street3, city, pc, cc)
	VALUES (1, 2, 'int', 'Zaphod Bebblebrox',
		'Restaurant at the Edge of the Internet', 'Internet House',
		'330 Science Park', 'Milton Road',
		'Cambridge', 'CB4 4BZ', 'UK');

INSERT INTO contact_postal (st, contact_id, type, name, org,
		street1, street2, street3, city, pc, cc)
	VALUES (1, 2, 'loc', 'Zaphod\'s Second Head',
		'WW2 Bunker in the Middle of the Orbiter', 'Internet House',
		'330A Science Park', 'Milton Road',
		'Cambridge', 'CB4 4BZ', 'UK');

INSERT INTO contact_authinfo (st, contact_id, authtype, authinfo)
	VALUES (1, 2, 'pw', 'zaphod-pw');

--
-- finally, map the sample registrar to a contact
--

INSERT INTO registrar_contact_map (st, registrar_id, contact_id)
	VALUES (1, 1, 1);
INSERT INTO registrar_contact_map (st, registrar_id, contact_id)
	VALUES (1, 2, 1);

--
-- more SRS users
--
INSERT INTO registrar (st, registrar_id, name, userid, password, whois, url)
        VALUES (1, 100, 'Black Gryphon',
                'skan', 'skan_pw',
                'whois.flame.org',
                'http://www.flame.org');
INSERT INTO registrar (st, registrar_id, name, userid, password, whois, url)
        VALUES (1, 101, 'Joe',
                'joe', 'joe-pw',
                'whois.automagic.org',
                'http://www.automatic.org');
INSERT INTO registrar (st, registrar_id, name, userid, password, whois, url)
        VALUES (1, 102, 'Rick',
                'rick', 'rick_pw',
                'whois.ar.com',
                'http://www.ar.com');
INSERT INTO registrar (st, registrar_id, name, userid, password, whois, url)
        VALUES (1, 103, 'Kurt Lidl',
                'lidl', 'lidl_pw',
                'whois.pix.net',
                'http://www.pix.net/staff/lidl/');

INSERT INTO registrar (st, registrar_id, name, userid,
		 password, whois, url)
        VALUES (1, 200, 'Registrar 00',
                'registrar-00', 'registrar-00-pw',
                'whois.registrar-00.xxx',
                'http://www.registrar-00.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 201, 'Registrar 01',
                'registrar-01', 'registrar-01-pw',
                'whois.registrar-01.xxx',
                'http://www.registrar-01.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 202, 'Registrar 02',
                'registrar-02', 'registrar-02-pw',
                'whois.registrar-02.xxx',
                'http://www.registrar-02.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 203, 'Registrar 03',
                'registrar-03', 'registrar-03-pw',
                'whois.registrar-03.xxx',
                'http://www.registrar-03.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 204, 'Registrar 04',
                'registrar-04', 'registrar-04-pw',
                'whois.registrar-04.xxx',
                'http://www.registrar-04.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 205, 'Registrar 05',
                'registrar-05', 'registrar-05-pw',
                'whois.registrar-05.xxx',
                'http://www.registrar-05.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 206, 'Registrar 06',
                'registrar-06', 'registrar-06-pw',
                'whois.registrar-06.xxx',
                'http://www.registrar-06.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 207, 'Registrar 07',
                'registrar-07', 'registrar-07-pw',
                'whois.registrar-07.xxx',
                'http://www.registrar-07.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 208, 'Registrar 08',
                'registrar-08', 'registrar-08-pw',
                'whois.registrar-08.xxx',
                'http://www.registrar-08.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 209, 'Registrar 09',
                'registrar-09', 'registrar-09-pw',
                'whois.registrar-09.xxx',
                'http://www.registrar-09.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 210, 'Registrar 10',
                'registrar-10', 'registrar-10-pw',
                'whois.registrar-10.xxx',
                'http://www.registrar-10.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 211, 'Registrar 11',
                'registrar-11', 'registrar-11-pw',
                'whois.registrar-11.xxx',
                'http://www.registrar-11.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 212, 'Registrar 12',
                'registrar-12', 'registrar-12-pw',
                'whois.registrar-12.xxx',
                'http://www.registrar-12.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 213, 'Registrar 13',
                'registrar-13', 'registrar-13-pw',
                'whois.registrar-13.xxx',
                'http://www.registrar-13.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 214, 'Registrar 14',
                'registrar-14', 'registrar-14-pw',
                'whois.registrar-14.xxx',
                'http://www.registrar-14.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 215, 'Registrar 15',
                'registrar-15', 'registrar-15-pw',
                'whois.registrar-15.xxx',
                'http://www.registrar-15.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 216, 'Registrar 16',
                'registrar-16', 'registrar-16-pw',
                'whois.registrar-16.xxx',
                'http://www.registrar-16.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 217, 'Registrar 17',
                'registrar-17', 'registrar-17-pw',
                'whois.registrar-17.xxx',
                'http://www.registrar-17.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 218, 'Registrar 18',
                'registrar-18', 'registrar-18-pw',
                'whois.registrar-18.xxx',
                'http://www.registrar-18.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 219, 'Registrar 19',
                'registrar-19', 'registrar-19-pw',
                'whois.registrar-19.xxx',
                'http://www.registrar-19.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 220, 'Registrar 20',
                'registrar-20', 'registrar-20-pw',
                'whois.registrar-20.xxx',
                'http://www.registrar-20.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 221, 'Registrar 21',
                'registrar-21', 'registrar-21-pw',
                'whois.registrar-21.xxx',
                'http://www.registrar-21.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 222, 'Registrar 22',
                'registrar-22', 'registrar-22-pw',
                'whois.registrar-22.xxx',
                'http://www.registrar-22.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 223, 'Registrar 23',
                'registrar-23', 'registrar-23-pw',
                'whois.registrar-23.xxx',
                'http://www.registrar-23.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 224, 'Registrar 24',
                'registrar-24', 'registrar-24-pw',
                'whois.registrar-24.xxx',
                'http://www.registrar-24.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 225, 'Registrar 25',
                'registrar-25', 'registrar-25-pw',
                'whois.registrar-25.xxx',
                'http://www.registrar-25.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 226, 'Registrar 26',
                'registrar-26', 'registrar-26-pw',
                'whois.registrar-26.xxx',
                'http://www.registrar-26.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 227, 'Registrar 27',
                'registrar-27', 'registrar-27-pw',
                'whois.registrar-27.xxx',
                'http://www.registrar-27.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 228, 'Registrar 28',
                'registrar-28', 'registrar-28-pw',
                'whois.registrar-28.xxx',
                'http://www.registrar-28.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 229, 'Registrar 29',
                'registrar-29', 'registrar-29-pw',
                'whois.registrar-29.xxx',
                'http://www.registrar-29.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 230, 'Registrar 30',
                'registrar-30', 'registrar-30-pw',
                'whois.registrar-30.xxx',
                'http://www.registrar-30.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 231, 'Registrar 31',
                'registrar-31', 'registrar-31-pw',
                'whois.registrar-31.xxx',
                'http://www.registrar-31.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 232, 'Registrar 32',
                'registrar-32', 'registrar-32-pw',
                'whois.registrar-32.xxx',
                'http://www.registrar-32.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 233, 'Registrar 33',
                'registrar-33', 'registrar-33-pw',
                'whois.registrar-33.xxx',
                'http://www.registrar-33.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 234, 'Registrar 34',
                'registrar-34', 'registrar-34-pw',
                'whois.registrar-34.xxx',
                'http://www.registrar-34.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 235, 'Registrar 35',
                'registrar-35', 'registrar-35-pw',
                'whois.registrar-35.xxx',
                'http://www.registrar-35.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 236, 'Registrar 36',
                'registrar-36', 'registrar-36-pw',
                'whois.registrar-36.xxx',
                'http://www.registrar-36.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 237, 'Registrar 37',
                'registrar-37', 'registrar-37-pw',
                'whois.registrar-37.xxx',
                'http://www.registrar-37.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 238, 'Registrar 38',
                'registrar-38', 'registrar-38-pw',
                'whois.registrar-38.xxx',
                'http://www.registrar-38.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 239, 'Registrar 39',
                'registrar-39', 'registrar-39-pw',
                'whois.registrar-39.xxx',
                'http://www.registrar-39.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 240, 'Registrar 40',
                'registrar-40', 'registrar-40-pw',
                'whois.registrar-40.xxx',
                'http://www.registrar-40.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 241, 'Registrar 41',
                'registrar-41', 'registrar-41-pw',
                'whois.registrar-41.xxx',
                'http://www.registrar-41.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 242, 'Registrar 42',
                'registrar-42', 'registrar-42-pw',
                'whois.registrar-42.xxx',
                'http://www.registrar-42.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 243, 'Registrar 43',
                'registrar-43', 'registrar-43-pw',
                'whois.registrar-43.xxx',
                'http://www.registrar-43.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 244, 'Registrar 44',
                'registrar-44', 'registrar-44-pw',
                'whois.registrar-44.xxx',
                'http://www.registrar-44.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 245, 'Registrar 45',
                'registrar-45', 'registrar-45-pw',
                'whois.registrar-45.xxx',
                'http://www.registrar-45.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 246, 'Registrar 46',
                'registrar-46', 'registrar-46-pw',
                'whois.registrar-46.xxx',
                'http://www.registrar-46.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 247, 'Registrar 47',
                'registrar-47', 'registrar-47-pw',
                'whois.registrar-47.xxx',
                'http://www.registrar-47.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 248, 'Registrar 48',
                'registrar-48', 'registrar-48-pw',
                'whois.registrar-48.xxx',
                'http://www.registrar-48.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 249, 'Registrar 49',
                'registrar-49', 'registrar-49-pw',
                'whois.registrar-49.xxx',
                'http://www.registrar-49.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 250, 'Registrar 50',
                'registrar-50', 'registrar-50-pw',
                'whois.registrar-50.xxx',
                'http://www.registrar-50.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 251, 'Registrar 51',
                'registrar-51', 'registrar-51-pw',
                'whois.registrar-51.xxx',
                'http://www.registrar-51.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 252, 'Registrar 52',
                'registrar-52', 'registrar-52-pw',
                'whois.registrar-52.xxx',
                'http://www.registrar-52.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 253, 'Registrar 53',
                'registrar-53', 'registrar-53-pw',
                'whois.registrar-53.xxx',
                'http://www.registrar-53.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 254, 'Registrar 54',
                'registrar-54', 'registrar-54-pw',
                'whois.registrar-54.xxx',
                'http://www.registrar-54.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 255, 'Registrar 55',
                'registrar-55', 'registrar-55-pw',
                'whois.registrar-55.xxx',
                'http://www.registrar-55.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 256, 'Registrar 56',
                'registrar-56', 'registrar-56-pw',
                'whois.registrar-56.xxx',
                'http://www.registrar-56.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 257, 'Registrar 57',
                'registrar-57', 'registrar-57-pw',
                'whois.registrar-57.xxx',
                'http://www.registrar-57.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 258, 'Registrar 58',
                'registrar-58', 'registrar-58-pw',
                'whois.registrar-58.xxx',
                'http://www.registrar-58.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 259, 'Registrar 59',
                'registrar-59', 'registrar-59-pw',
                'whois.registrar-59.xxx',
                'http://www.registrar-59.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 260, 'Registrar 60',
                'registrar-60', 'registrar-60-pw',
                'whois.registrar-60.xxx',
                'http://www.registrar-60.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 261, 'Registrar 61',
                'registrar-61', 'registrar-61-pw',
                'whois.registrar-61.xxx',
                'http://www.registrar-61.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 262, 'Registrar 62',
                'registrar-62', 'registrar-62-pw',
                'whois.registrar-62.xxx',
                'http://www.registrar-62.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 263, 'Registrar 63',
                'registrar-63', 'registrar-63-pw',
                'whois.registrar-63.xxx',
                'http://www.registrar-63.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 264, 'Registrar 64',
                'registrar-64', 'registrar-64-pw',
                'whois.registrar-64.xxx',
                'http://www.registrar-64.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 265, 'Registrar 65',
                'registrar-65', 'registrar-65-pw',
                'whois.registrar-65.xxx',
                'http://www.registrar-65.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 266, 'Registrar 66',
                'registrar-66', 'registrar-66-pw',
                'whois.registrar-66.xxx',
                'http://www.registrar-66.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 267, 'Registrar 67',
                'registrar-67', 'registrar-67-pw',
                'whois.registrar-67.xxx',
                'http://www.registrar-67.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 268, 'Registrar 68',
                'registrar-68', 'registrar-68-pw',
                'whois.registrar-68.xxx',
                'http://www.registrar-68.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 269, 'Registrar 69',
                'registrar-69', 'registrar-69-pw',
                'whois.registrar-69.xxx',
                'http://www.registrar-69.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 270, 'Registrar 70',
                'registrar-70', 'registrar-70-pw',
                'whois.registrar-70.xxx',
                'http://www.registrar-70.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 271, 'Registrar 71',
                'registrar-71', 'registrar-71-pw',
                'whois.registrar-71.xxx',
                'http://www.registrar-71.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 272, 'Registrar 72',
                'registrar-72', 'registrar-72-pw',
                'whois.registrar-72.xxx',
                'http://www.registrar-72.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 273, 'Registrar 73',
                'registrar-73', 'registrar-73-pw',
                'whois.registrar-73.xxx',
                'http://www.registrar-73.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 274, 'Registrar 74',
                'registrar-74', 'registrar-74-pw',
                'whois.registrar-74.xxx',
                'http://www.registrar-74.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 275, 'Registrar 75',
                'registrar-75', 'registrar-75-pw',
                'whois.registrar-75.xxx',
                'http://www.registrar-75.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 276, 'Registrar 76',
                'registrar-76', 'registrar-76-pw',
                'whois.registrar-76.xxx',
                'http://www.registrar-76.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 277, 'Registrar 77',
                'registrar-77', 'registrar-77-pw',
                'whois.registrar-77.xxx',
                'http://www.registrar-77.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 278, 'Registrar 78',
                'registrar-78', 'registrar-78-pw',
                'whois.registrar-78.xxx',
                'http://www.registrar-78.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 279, 'Registrar 79',
                'registrar-79', 'registrar-79-pw',
                'whois.registrar-79.xxx',
                'http://www.registrar-79.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 280, 'Registrar 80',
                'registrar-80', 'registrar-80-pw',
                'whois.registrar-80.xxx',
                'http://www.registrar-80.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 281, 'Registrar 81',
                'registrar-81', 'registrar-81-pw',
                'whois.registrar-81.xxx',
                'http://www.registrar-81.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 282, 'Registrar 82',
                'registrar-82', 'registrar-82-pw',
                'whois.registrar-82.xxx',
                'http://www.registrar-82.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 283, 'Registrar 83',
                'registrar-83', 'registrar-83-pw',
                'whois.registrar-83.xxx',
                'http://www.registrar-83.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 284, 'Registrar 84',
                'registrar-84', 'registrar-84-pw',
                'whois.registrar-84.xxx',
                'http://www.registrar-84.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 285, 'Registrar 85',
                'registrar-85', 'registrar-85-pw',
                'whois.registrar-85.xxx',
                'http://www.registrar-85.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 286, 'Registrar 86',
                'registrar-86', 'registrar-86-pw',
                'whois.registrar-86.xxx',
                'http://www.registrar-86.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 287, 'Registrar 87',
                'registrar-87', 'registrar-87-pw',
                'whois.registrar-87.xxx',
                'http://www.registrar-87.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 288, 'Registrar 88',
                'registrar-88', 'registrar-88-pw',
                'whois.registrar-88.xxx',
                'http://www.registrar-88.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 289, 'Registrar 89',
                'registrar-89', 'registrar-89-pw',
                'whois.registrar-89.xxx',
                'http://www.registrar-89.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 290, 'Registrar 90',
                'registrar-90', 'registrar-90-pw',
                'whois.registrar-90.xxx',
                'http://www.registrar-90.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 291, 'Registrar 91',
                'registrar-91', 'registrar-91-pw',
                'whois.registrar-91.xxx',
                'http://www.registrar-91.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 292, 'Registrar 92',
                'registrar-92', 'registrar-92-pw',
                'whois.registrar-92.xxx',
                'http://www.registrar-92.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 293, 'Registrar 93',
                'registrar-93', 'registrar-93-pw',
                'whois.registrar-93.xxx',
                'http://www.registrar-93.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 294, 'Registrar 94',
                'registrar-94', 'registrar-94-pw',
                'whois.registrar-94.xxx',
                'http://www.registrar-94.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 295, 'Registrar 95',
                'registrar-95', 'registrar-95-pw',
                'whois.registrar-95.xxx',
                'http://www.registrar-95.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 296, 'Registrar 96',
                'registrar-96', 'registrar-96-pw',
                'whois.registrar-96.xxx',
                'http://www.registrar-96.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 297, 'Registrar 97',
                'registrar-97', 'registrar-97-pw',
                'whois.registrar-97.xxx',
                'http://www.registrar-97.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 298, 'Registrar 98',
                'registrar-98', 'registrar-98-pw',
                'whois.registrar-98.xxx',
                'http://www.registrar-98.xxx');
INSERT INTO registrar (st, registrar_id, name, userid,
		password, whois, url)
        VALUES (1, 299, 'Registrar 99',
                'registrar-99', 'registrar-99-pw',
                'whois.registrar-99.xxx',
                'http://www.registrar-99.xxx');

--
-- some sample domains
--

-- note expiration date is exactly one day before the end of the
-- unix epoch XXX

INSERT INTO domain (st, domain_id, fqdn, owner_id, created_date,
		    created_id, expire_date, registrar_id)
        VALUES (1, 1, 'ORG.ISC.ORG', 1, 'now', 1, '2038-01-18 03:14:07', 1);
INSERT INTO domain_status_map (st, domain_id, status, msg)
        VALUES (1, 1, 'U', 'Registry apex');
INSERT INTO domain (st, domain_id, fqdn, owner_id, created_date,
		    created_id, expire_date, registrar_id)
        VALUES (1, 2, 'TEST.ORG.ISC.ORG', 1, 'now', 1, '2010-01-01', 1);

--
-- map the domain to a admin,billing,tech contact
--

INSERT INTO domain_contact_map (st, domain_id, contact_id, type)
	VALUES (1, 1, 1, 'admin');
INSERT INTO domain_contact_map (st, domain_id, contact_id, type)
	VALUES (1, 1, 1, 'billing');
INSERT INTO domain_contact_map (st, domain_id, contact_id, type)
	VALUES (1, 1, 1, 'tech');

--
-- some sample nameservers
--

INSERT INTO host (st, host_id, fqdn, domain_id, created_date,
		  created_id, registrar_id)
        VALUES (1, 2, 'NS1.TLD.ISC.ORG', 1, 'now', 1, 1);
INSERT INTO host_ip_map(st, host_id, type, addr)
	VALUES (1, 2, '4', '10.0.0.1');
INSERT INTO host_ip_map(st, host_id, type, addr)
	VALUES (1, 2, '6', 'fec0:0:0:bb:0290:27ff:fe73:0001');
INSERT INTO domain_host_map(st, domain_id, host_id)
        VALUES (1, 1, 2);

INSERT INTO host (st, host_id, fqdn, domain_id, created_date,
		  created_id, registrar_id)
        VALUES (1, 3, 'NS2.TLD.ISC.ORG', 1, 'now', 1, 1);
INSERT INTO host_ip_map(st, host_id, type, addr)
	VALUES (1, 3, '4', '10.0.0.2');
INSERT INTO host_ip_map(st, host_id, type, addr)
	VALUES (1, 3, '6', 'fec0:0:0:bb:290:27ff:fe73:0002');
INSERT INTO domain_host_map(st, domain_id, host_id)
        VALUES (1, 1, 3);

INSERT INTO host (st, host_id, fqdn, domain_id, created_date,
		  created_id, registrar_id)
        VALUES (1, 4, 'NS3.TLD.ISC.ORG', 1, 'now', 1, 1);
INSERT INTO host_ip_map(st, host_id, type, addr)
	VALUES (1, 4, '4', '10.0.0.2');
INSERT INTO host_ip_map(st, host_id, type, addr)
	VALUES (1, 4, '6', 'fec0:0:0:bb:290:27ff:fe73:0003');
INSERT INTO domain_host_map(st, domain_id, host_id)
        VALUES (1, 1, 4);

