# Copyright (C) 2002, 2003  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: EPPRegistrar.pm,v 1.13 2003/02/09 23:07:45 lidl Exp $

package ISC::SRS::EPPRegistrar;

use strict;
use warnings;

use ISC::SRS::EPPResultCode ":all";

use ISC::Date ":all";

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    $VERSION = do { my @r = (q$Revision: 1.13 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};
    @ISA = qw(Exporter ISC::SRS::EPPConnection);
    @EXPORT = qw();
    @EXPORT_OK = qw();
    %EXPORT_TAGS = ();
}

our @EXPORT_OK;

sub new {
    my ($class, %args) = @_;

    $class = ref($class) || $class;
    my $self = bless({}, $class);

    $self->{parent} = $args{parent};
    $self->{data} = $args{data};

    $self->{id} = $args{id};
    $self->{sid} = $args{sid};
    # copy in the feid, just for conveinence's sake
    $self->{feid} = $self->{parent}->{feid};

    $self->{cc} = $self->{parent}->{cc};

    return $self;
}

sub data {
    my ($self, $data) = @_;

    if ($data) {
	$self->{data} = $data;
    }
    return $self->{data};
}

sub id {
    my ($self) = @_;

    return $self->{id};
}

sub sid {
    my ($self) = @_;

    return $self->{sid};
}

sub logout {
    my ($self, %args) = @_;

    $self->_generic_sendreq('logout', undef, \%args);

    return 0;
}

sub contact_add {
    my ($self, %args) = @_;

    $self->_generic_sendreq('contact_add', undef, \%args);

    return 0;
}

sub contact_check {
    my ($self, %args) = @_;

    $self->_generic_sendreq('contact_check', undef, \%args);

    return 0;
}

sub contact_del {
    my ($self, %args) = @_;

    $self->_generic_sendreq('contact_del', undef, \%args);

    return 0;
}

sub contact_info {
    my ($self, %args) = @_;

    $self->_generic_sendreq('contact_info', undef, \%args);

    return 0;
}

sub contact_mod {
    my ($self, %args) = @_;

    $self->_generic_sendreq('contact_mod', undef, \%args);

    return 0;
}

sub domain_add {
    my ($self, %args) = @_;

    my $addl = { period => $self->{parent}->{period} };
    $self->_generic_sendreq('domain_add', $addl, \%args);

    return 0;
}

sub domain_check {
    my ($self, %args) = @_;

    $self->_generic_sendreq('domain_check', undef, \%args);

    return 0;
}

sub domain_del {
    my ($self, %args) = @_;

    $self->_generic_sendreq('domain_del', undef, \%args);

    return 0;
}

sub domain_mod {
    my ($self, %args) = @_;

    $self->_generic_sendreq('domain_mod', undef, \%args);

    return 0;
}

sub domain_renew {
    my ($self, %args) = @_;

    $self->_generic_sendreq('domain_renew', undef, \%args);

    return 0;
}

sub domain_info {
    my ($self, %args) = @_;

    $self->_generic_sendreq('domain_info', undef, \%args);

    return 0;
}

sub domain_transfer {
    my ($self, %args) = @_;

    $self->_generic_sendreq('domain_transfer', undef, \%args);

    return 0;
}

sub host_add {
    my ($self, %args) = @_;

    $self->_generic_sendreq('host_add', undef, \%args);

    return 0;
}

sub host_check {
    my ($self, %args) = @_;

    $self->_generic_sendreq('host_check', undef, \%args);

    return 0;
}

sub host_del {
    my ($self, %args) = @_;

    $self->_generic_sendreq('host_del', undef, \%args);

    return 0;
}

sub host_mod {
    my ($self, %args) = @_;

    $self->_generic_sendreq('host_mod', undef, \%args);

    return 0;
}

sub host_info {
    my ($self, %args) = @_;

    $self->_generic_sendreq('host_info', undef, \%args);

    return 0;
}

sub iscadmin {
    my ($self, %args) = @_;

    $self->_generic_sendreq('iscadmin', undef, \%args);

    return 0;
}

1;
