# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: Version.pm,v 1.7 2002/12/11 21:16:28 lidl Exp $

package ISC::SRS::Version;

use strict;
use warnings;

BEGIN {
  use Exporter();
  our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

  $VERSION = do { my @r = (q$Revision: 1.7 $ =~ /\d+/g); \
    sprintf "%d."."%02d" x $#r, @r};
  @ISA = qw(Exporter);
  @EXPORT = qw( ISC_SRS_VERSION ISC_SRS_REGISTRY_VERSION
      ISC_SRS_SERVERNAME ISC_EPP_OBJURIS ISC_EPP_VERSIONS);
  @EXPORT_OK = qw();
  %EXPORT_TAGS = ();
}

our @EXPORT_OK;


# version numbers
our $_SERVERNAME = "ISC OpenReg EPP Server";
our $_VERSION = "1.0";
our $_REGISTRY_VERSION = "1.0";
our @_EPP_VERSIONS = ( "1.0" );

# object URIs we support
our @_OBJURIS = (
    "urn:ietf:params:xml:ns:domain-1.0",
    "urn:ietf:params:xml:ns:contact-1.0",
    "urn:ietf:params:xml:ns:host-1.0" );

sub ISC_SRS_SERVERNAME {
    return ($_SERVERNAME);
}

sub ISC_SRS_VERSION {
    return ($_VERSION);
}

sub ISC_SRS_REGISTRY_VERSION {
    return ($_REGISTRY_VERSION);
}

sub ISC_EPP_OBJURIS {
    return (@_OBJURIS);
}

sub ISC_EPP_VERSIONS {
    return (@_EPP_VERSIONS);
}

sub Version {
  return ({ VERSION => $_VERSION,
            REGISTRY_VERSION => $_REGISTRY_VERSION });
}


1;

__END__

=head1 NAME

ISC::SRS::Version - Return various version numbers relating to the registry

=head1 SYNOPSIS

use ISC::SRS::Version;

my $regv = ISC::SRS::Version::RegistryVersion();
my $srsv = ISC::SRS::Version::SRSVersion();

my %v = ISC::SRS::Version::Version();
my $regv = $v{"RegistryVersion"};
my $srsv = $v{"SRSVersion"};

=head1 DESCRIPTION

This package provides various version numbers related to the ISC Registry.

=over

=item RegistryVersion

Returns a string which represents a version number for the registry as a
whole.

=item SRSVersion

Returns a string which represents a version number for the registry-registrar
interaction software in the registry.

=item Version

Returns a hash populated by keys corresponding to the strings discussed
above.

=back

=head1 AUTHOR

Written by Joe Abley for the Internet Software Consortium.

=head1 COPYRIGHT

Copyright (C) 2002 Internet Software Consortium.

