#!/bin/sh
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: ka_whois.sh,v 1.4 2002/12/06 21:38:44 lidl Exp $

ISC_MSGQ_PROTO=tcp; export ISC_MSGQ_PROTO
ISC_SRS_DBUSER=srs; export ISC_SRS_DBUSER
ISC_SRS_DBNAME=${1}_srs ; export ISC_SRS_DBNAME

PATH=@prefix@:$PATH; export PATH
LOGDIR=@logdir@
LOGFILE=${LOGDIR}/whois-$1.log
WHOISSLEEP=5

case $1 in
org)
	ISC_MSGQ_PORT=9913
        addr="204.152.184.87"
        ;;
ote)
	ISC_MSGQ_PORT=9914
        addr="204.152.184.106"
        ;;
*)
	ISC_MSGQ_PORT=9912
	addr="0.0.0.0"
	ISC_SRS_DBNAME=srs
	LOGFILE=${LOGDIR}/whois.log
        ;;
esac
export ISC_MSGQ_PORT

if [ `id -u` -ne 0 ]; then
	port=1043
	echo -n "NOTICE: whois daemon not run as root"
	echo " -- using port $port for whois queries"
else
	port=43
fi

(	while :
	do
		whois --addr $addr --port $port
		sleep ${WHOISSLEEP}
	done
) 2>&1 | tee -a ${LOGFILE} | whois-parse.awk -v registry=$1

