#!/usr/bin/env perl
#
# Copyright (C) 2002  Internet Software Consortium.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
# DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: poll-stats-op.pl,v 1.6 2002/12/06 21:38:44 lidl Exp $

use lib '@prefix@';
use lib '/usr/local/rrdtool/lib/perl';

use IO::Socket::INET;
use RRDs;

use strict;
use warnings;

# step interval (1 minute)
my $step = 60;

# heartbeat interval (4 * step interval)
my $heartbeat = 4 * $step;

# what directory do we store the RRDs in
my $rrd_home = "/var/org/stats";

# datasources that we are interested in

my %datasources = ( "epp_describe" => "GAUGE",
                    "epp_dom_add" => "GAUGE",
                    "epp_dom_check" => "GAUGE",
                    "epp_dom_del" => "GAUGE",
                    "epp_dom_mod" => "GAUGE",
                    "epp_dom_renew" => "GAUGE",
                    "epp_dom_status" => "GAUGE",
                    "epp_dom_transfer" => "GAUGE",
                    "epp_ns_add" => "GAUGE",
                    "epp_ns_check" => "GAUGE",
                    "epp_ns_del" => "GAUGE",
                    "epp_ns_mod" => "GAUGE",
                    "epp_ns_status" => "GAUGE",
                    "epp_quit" => "GAUGE",
                    "epp_session" => "GAUGE" );

# derived statistics that we will maintain

my @rras =        ( "AVERAGE:0.5:1:6000",
                    "AVERAGE:0.5:5:1200",
                    "AVERAGE:0.5:60:960",
                    "AVERAGE:0.5:1440:2000",
                    "MIN:0.5:60:960",
                    "MIN:0.5:1440:2000",
                    "MAX:0.5:60:960",
                    "MAX:0.5:1440:2000" );

# translations of module names passed from the stats server to shorter
# names that will keep within the 19-character name limit for RRD
# data sources

my %mod_trans =   ( "epp-frontend" => "epp" );


my ($rrd, $module);
my ($template, $values);


# update an RRD with data, creating it if necessary
sub update_rrd {
    my ($rrd, $template, $values) = @_;

    if ($rrd) {
        if (!-f $rrd) {
            my @parms;

            push @parms, $rrd, "--step", $step;

            foreach my $ds (keys %datasources) {
                push @parms, "DS:" . $ds . ":" .
                    $datasources{$ds} . ":" . $heartbeat . ":0:U";
            }

            foreach my $rra (@rras) {
                push @parms, "RRA:" . $rra;
            }

            RRDs::create(@parms);
            my $err = RRDs::error;
            die "Error creating $rrd: $err" if ($err);
        }

        if ($template ne "") {
            RRDs::update($rrd, "--template", $template, $values);
            my $err = RRDs::error;
            die "Error updating $rrd: $err" if ($err);
        }
    }
}


# main program


# loop through host:port pairs passed on the command line
foreach my $hp (@ARGV) {
    my $sock = new IO::Socket::INET($hp) || die "error connecting to $hp: $!";

    while (<$sock>) {
        chomp;

        if (m/^stats ([a-z0-9-]+) ([a-z0-9-\.\/]+)/i) {
            # write the last set of statistics out to the RRD, if there are any
            update_rrd($rrd, $template, $values);

            # remember the module and rrd name
            $module = $mod_trans{$1} || $1;
            $module =~ tr/-/_/;

            $rrd = $2;
            $rrd =~ tr/\//:/;
            $rrd = $rrd_home . "/" . $rrd . ":op.rrd";

            # reset the template and value strings ready for new data
            ($template, $values) = ("", "N");
        }

        # found new data; harvest it.
        if (m/^(counter|gauge) ([a-z0-9_]+) (\d+)/i && $rrd && $module) {
            my $ds = $module . "_" . $2;
            if ($datasources{$ds} && $datasources{$ds} eq uc $1) {
                $template .= ":" if ($template ne "");
                $template .= $ds;

                $values .= ":" . $3;
            }
        }
    }
}

# write the last set of statistics out to the RRD, if there are any
update_rrd($rrd, $template, $values);

