#!/bin/sh
#
# $Id: hourly.sh,v 1.1.1.1 2002/10/23 07:01:36 jabley Exp $
#
# Generate unused and undefined filter reports, and send mail if
# they are different to the last ones we generated

home=$(dirname $0)

# uncomment and modify the following line as appropriate
#group=/usr/local/rancid/group_name

# recipient list for reports
#mailto="someone@example.com noc@isp.net"

if [ -z "${group}" ]; then
  echo "set the group variable in $0 before running"
  exit 1
fi

if [ -z "${mailto}" ]; then
  echo "set the mailto variable in $0 before running"
  exit 1
fi

${home}/filter_audit.awk $(awk -F: -vGROUP=${group} \
  '($3 == "up" && $2 == "cisco") { print GROUP "/configs/" $1; }' \
  ${group}/router.db) | sort >${home}/results

for n in unused undefined; do
  ${home}/report.awk -vTYPE=${n} <${home}/results >${home}/report.${n}.new
  touch ${home}/report.${n}.old
  if ! diff -u ${home}/report.${n}.old ${home}/report.${n}.new \
    >${home}/report.${n}.diffs; then
    ident $0 ${home}/filter_audit.awk ${home}/report.awk >${home}/ident
    cat ${home}/doc/${n}.1.txt ${home}/report.${n}.diffs \
      ${home}/doc/${n}.2.txt ${home}/report.${n}.new \
      ${home}/doc/${n}.3.txt ${home}/ident ${home}/doc/${n}.4.txt | \
        mail -s "[filter-audit] ${n} filter audit report" ${mailto}
    mv ${home}/report.${n}.new ${home}/report.${n}.old
  fi
done

