/////////////////////////////////////////////////////////////
//
// pgAdmin 4 - PostgreSQL Tools
//
// Copyright (C) 2013 - 2022, The pgAdmin Development Team
// This software is released under the PostgreSQL Licence
//
//////////////////////////////////////////////////////////////

import PgaJobScheduleSchema from './pga_schedule.ui';

define('pgadmin.node.pga_schedule', [
  'sources/gettext', 'sources/url_for', 'jquery', 'underscore',
  'sources/pgadmin', 'moment', 'pgadmin.browser',
], function(
  gettext, url_for, $, _, pgAdmin, moment, pgBrowser
) {

  if (!pgBrowser.Nodes['coll-pga_schedule']) {
    pgBrowser.Nodes['coll-pga_schedule'] =
      pgBrowser.Collection.extend({
        node: 'pga_schedule',
        label: gettext('Schedules'),
        type: 'coll-pga_schedule',
        columns: ['jscid', 'jscname', 'jscenabled'],
        hasStatistics: false,
        canDropCascade: false,
      });
  }

  if (!pgBrowser.Nodes['pga_schedule']) {
    pgBrowser.Nodes['pga_schedule'] = pgBrowser.Node.extend({
      parent_type: 'pga_job',
      type: 'pga_schedule',
      dialogHelp: url_for('help.static', {'filename': 'pgagent_jobs.html'}),
      hasSQL: true,
      hasDepends: false,
      hasStatistics: false,
      canDrop: true,
      label: gettext('Schedule'),
      node_image: 'icon-pga_schedule',
      Init: function() {
        /* Avoid mulitple registration of menus */
        if (this.initialized)
          return;

        this.initialized = true;

        pgBrowser.add_menus([{
          name: 'create_pga_schedule_on_job', node: 'pga_job', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: gettext('Schedule...'),
          icon: 'wcTabIcon icon-pga_schedule', data: {action: 'create'},
        },{
          name: 'create_pga_schedule_on_coll', node: 'coll-pga_schedule', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: gettext('Schedule...'),
          icon: 'wcTabIcon icon-pga_schedule', data: {action: 'create'},
        },{
          name: 'create_pga_schedule', node: 'pga_schedule', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: gettext('Schedule...'),
          icon: 'wcTabIcon icon-pga_schedule', data: {action: 'create'},
        }]);
      },

      getSchema: function() {
        return new PgaJobScheduleSchema();
      },

      model: pgBrowser.Node.Model.extend({
        idAttribute: 'jscid',
        schema: [{
          id: 'jscid', label: gettext('ID'), type: 'int',
          cellHeaderClasses: 'width_percent_5', mode: ['properties'],
        },{
          id: 'jscname', label: gettext('Name'), type: 'text',
          cellHeaderClasses: 'width_percent_45',
          disabled: function() { return false; },
        },{
          id: 'jscenabled', label: gettext('Enabled?'), type: 'switch',
          disabled: function() { return false; },
          cellHeaderClasses: 'width_percent_5',
        }],
      }),
    });
  }

  return pgBrowser.Nodes['pga_schedule'];
});
