/////////////////////////////////////////////////////////////
//
// pgAdmin 4 - PostgreSQL Tools
//
// Copyright (C) 2013 - 2022, The pgAdmin Development Team
// This software is released under the PostgreSQL Licence
//
//////////////////////////////////////////////////////////////

import pgAdmin from 'sources/pgadmin';
import gettext from 'sources/gettext';
import { showUrlDialog } from '../../../../static/js/Dialogs/index';
import showUserManagement from './UserManagementDialog';


class UserManagement {
  static instance;

  static getInstance(...args) {
    if (!UserManagement.instance) {
      UserManagement.instance = new UserManagement(...args);
    }
    return UserManagement.instance;
  }

  init() {
    if (this.initialized)
      return;
    this.initialized = true;
  }

  // This is a callback function to show change user dialog.
  change_password(url) {
    showUrlDialog(gettext('Change Password'), url, 'change_user_password.html', undefined, pgAdmin.Browser.stdH.lg);
  }

  // This is a callback function to show 2FA dialog.
  show_mfa(url) {
    showUrlDialog(gettext('Authentication'), url, 'mfa.html', 1200, 680);
  }

  // This is a callback function to show user management dialog.
  show_users() {
    showUserManagement();
  }
}

pgAdmin.UserManagement = UserManagement.getInstance();

module.exports = {
  UserManagement: UserManagement,
};