<?php

function file_extension($filename) {

	//get the file extension
	$pos=strrpos($filename,".");
	$extension = trim(substr($filename,$pos));

	if (!strcasecmp($extension,".pdf")) $file_type="pdf";

	elseif  (   !strcasecmp($extension,".doc") 
		||  !strcasecmp($extension,".xls")		
		||  !strcasecmp($extension,".txt")) $file_type="txt";

	elseif  (   !strcasecmp($extension,".htm")		
		||  !strcasecmp($extension,".html")) $file_type="web";		

	elseif  (   !strcasecmp($extension,".tiff") 
		||  !strcasecmp($extension,".tif")		
		||  !strcasecmp($extension,".mtiff") 
		||  !strcasecmp($extension,".mtif")) $file_type="tiff";

	elseif  (   !strcasecmp($extension,".bmp") 
		||  !strcasecmp($extension,".jpg")		
		||  !strcasecmp($extension,".png") 
		||  !strcasecmp($extension,".psd")		
		||  !strcasecmp($extension,".jpeg") 
		||  !strcasecmp($extension,".ps")
		||  !strcasecmp($extension,".cmyk")		
		||  !strcasecmp($extension,".eps") 
		||  !strcasecmp($extension,".gif")) $file_type="image";

	else 	$file_type="other";


	return $file_type;
}

function file_extension_name($filename) {

	//get the file extension
	$pos=strrpos($filename,".");
	$extension = strtolower(trim(substr($filename,$pos)));

	$name = strtoupper(substr($extension,1));

	if ($extension==".pdf") 				$file_type="Adobe PDF Document";

	elseif  	($extension==".doc") 		$file_type = "MS Word Document";
	elseif  	($extension==".xls")		$file_type = "MS Excel Document";	
	elseif 	($extension==".text"
			||  $extension==".txt") 		$file_type="Text Document";

	elseif  	($extension==".htm"		
			||  $extension==".html") 	$file_type="HTML Document";		

	elseif  	($extension==".tiff" 
			||  $extension==".tif"		
			||  $extension==".mtiff" 
			||  $extension==".mtif"
			||  $extension==".bmp" 
			||  $extension==".jpg"		
			||  $extension==".png" 
			||  $extension==".psd"		
			||  $extension==".jpeg" 
			||  $extension==".ps"
			||  $extension==".cmyk"		
			||  $extension==".eps" 
			||  $extension==".gif") 		$file_type=$name." Image";

	else 	$file_type=$name." File";


	return $file_type;
}

function file_extension_download($filename) {

	//get the file extension
	$pos=strrpos($filename,".");
	$extension = strtolower(trim(substr($filename,$pos)));

	$name = strtoupper(substr($extension,1));

	if ($extension==".pdf") 				$file_type="application/pdf";

	elseif  	($extension==".doc") 		$file_type = "application/msword";
	elseif  	($extension==".xls")		$file_type = "application/vnd.ms-excel";	
	elseif  	($extension==".mdb")		$file_type = "application/msaccess";	
	elseif  	($extension==".ppt")		$file_type = "application/vnd.ms-powerpoint";	

	elseif 	($extension==".text"
			||  $extension==".txt") 		$file_type="text/plain";

	elseif  	($extension==".htm"		
			||  $extension==".html") 	$file_type="text/html";		

	elseif  	($extension==".xml")		$file_type = "text/xml";	

	elseif  	($extension==".tiff" 
			||  $extension==".tif"		
			||  $extension==".mtiff" 
			||  $extension==".mtif")		$file_type="image/tiff";

	elseif	($extension==".jpg"
			||  $extension==".jpeg")		$file_type="image/jpg";

	elseif 	($extension==".bmp")		$file_type="image/bmp"; 
	elseif	($extension==".png")		$file_type="image/png";
	elseif	($extension==".gif")		$file_type="image/gif";

	else 	return false;

	//if we get this far, return the file type
	return $file_type;
}


function actual_extension($filename) {

	//get the file extension
	$pos=strrpos($filename,".");
	$extension = trim(substr($filename,$pos));

	return $extension;
}

function retrievePermissions($conn,$find_cat) {

	$sql = "SELECT id FROM auth_groups";

	$query_return=report_query($conn,$sql);
	$group_num=$query_return[1];
	$g_id_array=array_result("id",$query_return[0],$query_return[1]);

	$sql = "SELECT * FROM dm_cat_permissions WHERE bitset='3' AND cat_id='$find_cat'";

	$query_return=report_query($conn,$sql);
	$id_array_view_edit=array_result("id",$query_return[0],$query_return[1]);

	$query_return=report_query($conn,$sql);
	$group_array_view_edit=array_result("group_id",$query_return[0],$query_return[1]);

	$sql = "SELECT * FROM dm_cat_permissions WHERE bitset='2' AND cat_id='$find_cat'";

	$query_return=report_query($conn,$sql);
	$id_array_view=array_result("id",$query_return[0],$query_return[1]);

	$query_return=report_query($conn,$sql);
	$group_array_view=array_result("group_id",$query_return[0],$query_return[1]);

	$returnArray = array($g_id_array,
				$id_array_view_edit,
				$group_array_view_edit,
				$id_array_view,
				$group_array_view);

	return $returnArray;

}

/*******************************************************************************
	
	this function inserts an entry into the database to record activity
	for a file.

*******************************************************************************/

function activity_log($conn,$entry,$object_id,$accountid) {

	$date = date("Y-m-d H:i:s");

	$sql = "INSERT INTO dm_file_log (entry,object_id,date,account_id) VALUES ('$entry','$object_id','$date','$accountid')";

	if (!db_query($conn,$sql)) return false;

}


function deleteObject($conn,$object_id) {

	beginTransaction($conn);

	$sql = "DELETE FROM dm_object WHERE id='$object_id'";

	if (db_query($conn,$sql)) $step1="yes";

	$sql = "SELECT id FROM dm_file_history WHERE object_id='$object_id'";

	$query_return=report_query($conn,$sql);
	$id_array=array_result("id",$query_return[0],$query_return[1]);

	for ($row=0;$row<count($id_array);$row++) {

		$sql = "DELETE FROM dm_file_history WHERE id='$id_array[$row]'";

		if (db_query($conn,$sql)) {
			@unlink("data/".$id_array[$row].".docmgr");
			$step2="yes";
		} else {
			$step2=null;
			break;
		}

	}

	$sql = "DELETE FROM dm_doclink WHERE file_id='$object_id'";
	if (db_query($conn,$sql)) $step3="yes";

	$sql = "DELETE FROM dm_file_permissions WHERE object_id='$object_id'";
	if (db_query($conn,$sql)) $step4="yes";

	$sql = "DELETE FROM dm_file_cat WHERE file_id='$object_id'";
	if (db_query($conn,$sql)) $step5="yes";

	$sql = "DELETE FROM dm_file_log WHERE object_id='$object_id'";
	if (db_query($conn,$sql)) $step6="yes";

	endTransaction($conn);

	if ($step1 && $step2 && $step3 && $step4 && $step5 && $step6) return true;
	else return false;


}

//this function splits a tif file, and returns the names
//of the files it creates as an array
function tiffSplit($numpages,$userfile) {

	//split the tiff file
	//figure out what the names of the temp files will be.
	$temp_array=array();

	$firstloop = floor($numpages/26);
	$firstremainder = $numpages%26;

	//figure out the directory userfile is stored in
	$dir_value = substr($userfile,0,strrpos($userfile,"/"))."/";

	//generate our file prefixes
	$file_prefix_num = rand(1,10000);
	$prefix_value = $dir_value.$file_prefix_num;			

	for ($newrow=0;$newrow<=$firstloop;$newrow++) {

		if ($newrow!=$firstloop) {
			$secondloop=26;
		}
		else {
			$secondloop=$firstremainder;
		}
		for ($row=0;$row<$secondloop;$row++) {
			$temp_array[]=$prefix_value.chr(97+$newrow).chr(97+$row).".tif";
		}
	
	}

	//split the file
	exec("tiffsplit $userfile $prefix_value 2>&1");

	return $temp_array;
}
