/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/tools/desc/AddTableColumnDesc.java,v $
 * $Author: ronz $ $Revision: 1.1.1.1 $ $Date: 2003/10/21 13:01:38 $
 *
 */

package com.postgres.replic.tools.desc;

import com.postgres.replic.tools.*;

public class AddTableColumnDesc extends GeneratorDescriptor {

    private String host;
    private String port;
    private String user;
    private String pass;
    private String schema;
    private boolean master;
    private boolean print;
    private static String USAGE = "# takes 1 arg - database name:\n" +
             "# Usage:\n" +
             "#       master(slave)_add.sh hostname username password database\n\n";
    public static final String MASTER_ADD_TABLE = "MasterAddTable --host=$1 --user=$2 --password=$3 $4 ";
    public static final String SLAVE_ADD_TABLE =  "SlaveAddTable --host=$1 --user=$2 --password=$3 $4 ";
    //public static final String MASTER_ADD_TABLE = ToolKitConst.EXEC_ALIAS;
    //public static final String SLAVE_ADD_TABLE = ToolKitConst.EXEC_ALIAS;

    private AddMarkerColumn addMarker;

    private String addString;

    public AddTableColumnDesc( String host,
    String port,
    String user,
    String pass,
    String schema,
    boolean master,
    boolean print) throws Exception{

        this.host = host;
        this.port = port;
        this.user =  user;
        this.pass = pass ;
        this.schema =   schema ;
        this.master = master ;
        this.print = print;
        this.addString = master ? MASTER_ADD_TABLE : SLAVE_ADD_TABLE; //+ " -slave ";

        //System.out.println("AddTableColumnDesc:: master="+master);

        this.addMarker = new AddMarkerColumn(print);
    }

    public boolean tableOnly() {
        return true;
    }

    private String getColumnName(String table) throws Exception {
        return addMarker.getColumnName(table);
    }

    public String getLine(String table) throws Exception {
        //System.out.println("::getLine: BEGIN master="+master);
        if (table.toLowerCase().startsWith(ToolKitConst.GLOBAL_PREFIX)) {
            return "";
        }

        String result = "";
        String mainString = "";

        /*
        String password = (pass == null || pass.trim().equals("")) ?
        "" : " -pass " + pass;
        String userString = (user == null || user.trim().equals("")) ?
        "" : " -user " + user;
        String schemaString = (schema == null || schema.trim().equals("")) ?
        "" :  " -db " + schema;
        String modeString = " -mode ADD_TABLE ";

        mainString =
        "-host " + host
        + userString
        + password
        + modeString
        + " " + schemaString + " -table " + table
        + " -column " + getColumnName(table);

        //System.out.println("::getLine: BEGIN print="+print+": mainString=["+"]");


        String resLine = addString + " " + mainString;
        result += resLine + "\n";
        if (print) {
            System.out.println(resLine);
        }
        */


        mainString = table + " " + getColumnName(table);
        String resLine = addString + " " + mainString;
        if (print) {
            System.out.println(resLine);
        }

        result += resLine + "\n";
        return result;
    }
}
