/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/tools/desc/AddMarkerColumn.java,v $
 * $Author: ronz $ $Revision: 1.1.1.1 $ $Date: 2003/10/21 13:01:38 $
 *
 */

package com.postgres.replic.tools.desc;

import com.postgres.replic.tools.*;
import java.sql.*;

public class AddMarkerColumn extends GeneratorDescriptor {
    public static final String COL_NAME = "ts";
    private SequenceDesc seqDesc;
    protected int mode = T_NO;

    public static final int ADD_COLUMN = 1;
    public static final int SET_DEFAULT = 2;
    public static final int CREATE_INDEX = 3;

    public static final String IDX = "_idx";

    public AddMarkerColumn(boolean print) throws Exception {
        this(print, ADD_COLUMN);
    }

    //public AddMarkerColumn(boolean print, boolean master) throws Exception {
    //    this(print, master, ADD_COLUMN);
    //}

    public AddMarkerColumn(boolean print,int mode) throws Exception{
        this.print = print;
        this.mode = mode;
        validateMode();

        if (this.mode == SET_DEFAULT) {
             seqDesc = new SequenceDesc(print);
        }



    }

    private void validateMode() throws Exception {
        if (mode != ADD_COLUMN && mode != SET_DEFAULT && mode != CREATE_INDEX) {
             throw new Exception("AddMarkerColumn::validateMode: wrong mode=" +mode);
        }
    }


    public boolean tableOnly() {
        return true;
    }

    public String getColumnName(String table) throws Exception {
        if (table == null || table.trim().equals("")) {
            throw new Exception("AddMarkerColumn::getColumnName: table name may not be empty!" );
        }

        return ToolKitConst.GLOBAL_PREFIX + COL_NAME;

    }

    public String getIndexName(String table) throws Exception {
        if (table == null || table.trim().equals("")) {
            throw new Exception("AddMarkerColumn::getIndexName: table name may not be empty!" );
        }

        return ToolKitConst.GLOBAL_PREFIX + getFiller(table) + IDX;

    }


    public String getLine(String table) throws Exception {
        if (table.toLowerCase().startsWith(ToolKitConst.GLOBAL_PREFIX)) {
            return "";
        }

        String result = null;

        if (mode == ADD_COLUMN) {
            result = "alter table " + table + " add "
                 +  getColumnName(table) + " integer ;" ;
            if (print) System.out.println(result);
        } else if (mode == SET_DEFAULT) {
            result = "alter table " + table + " alter column "
            +  getColumnName(table) + " set DEFAULT nextval('"
            +  seqDesc.getSeqName(table) + "');";
            if (print) System.out.println(result);
        } else if (mode == CREATE_INDEX) {
            result = "drop index " + getIndexName(table) + "; \n" ;
            result += "create unique index " + getIndexName(table) + " on "
                 +  table + " ("+ getColumnName(table) + ");" ;
            if (print) System.out.println(result);
        }

        return result;

    }
}
