/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class SQLExec
extends Task {
    private int goodSql = 0;
    private int totalSql = 0;
    private Path classpath;
    private AntClassLoader loader;
    private Connection conn = null;
    private boolean autocommit = false;
    private Statement statement = null;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector transactions = new Vector();
    private boolean print = false;
    private boolean showheaders = true;
    private File output = null;
    private String rdbms = null;
    private String version = null;
    private String onError = "abort";

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public Transaction createTransaction() {
        SQLExec sQLExec = this;
        if (sQLExec == null) {
            throw null;
        }
        Transaction t = sQLExec.new Transaction();
        this.transactions.addElement(t);
        return t;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserid(String userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setRdbms(String vendor) {
        this.rdbms = vendor.toLowerCase();
    }

    public void setVersion(String version) {
        this.version = version.toLowerCase();
    }

    public void setOnerror(OnError action) {
        this.onError = action.getValue();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        block40: {
            block39: {
                this.sqlCommand = this.sqlCommand.trim();
                if (this.srcFile == null && this.sqlCommand.length() == 0) {
                    if (this.transactions.size() == 0) {
                        throw new BuildException("Source file, transactions or sql statement must be set!", this.location);
                    }
                } else {
                    t = this.createTransaction();
                    t.setSrc(this.srcFile);
                    t.addText(this.sqlCommand);
                }
                if (this.driver == null) {
                    throw new BuildException("Driver attribute must be set!", this.location);
                }
                if (this.userId == null) {
                    throw new BuildException("User Id attribute must be set!", this.location);
                }
                if (this.password == null) {
                    throw new BuildException("Password attribute must be set!", this.location);
                }
                if (this.url == null) {
                    throw new BuildException("Url attribute must be set!", this.location);
                }
                if (this.srcFile != null && !this.srcFile.exists()) {
                    throw new BuildException("Source file does not exist!", this.location);
                }
                driverInstance = null;
                try {
                    if (this.classpath != null) {
                        this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                        this.loader = new AntClassLoader(this.project, this.classpath, false);
                        var2_2 = this.loader.loadClass(this.driver);
                    } else {
                        this.log("Loading " + this.driver + " using system loader.", 3);
                        dc = Class.forName(this.driver);
                    }
                    driverInstance = (Driver)dc.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (IllegalAccessException e) {
                    throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (InstantiationException e) {
                    throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                try {
                    try {
                        this.log("connecting to " + this.url, 3);
                        info = new Properties();
                        info.put("user", this.userId);
                        info.put("password", this.password);
                        this.conn = driverInstance.connect(this.url, info);
                        if (this.conn == null) {
                            throw new SQLException("No suitable Driver for " + this.url);
                        }
                        if (!this.isValidRdbms(this.conn)) {
                            var3_11 = null;
                            break block39;
                        }
                        this.conn.setAutoCommit(this.autocommit);
                        this.statement = this.conn.createStatement();
                        out = System.out;
                        try {
                            if (this.output != null) {
                                this.log("Opening PrintStream to output file " + this.output, 3);
                                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output)));
                            }
                            e = this.transactions.elements();
                            while (e.hasMoreElements()) {
                                Transaction.access$0((Transaction)e.nextElement(), out);
                                if (this.autocommit) continue;
                                this.log("Commiting transaction", 3);
                                this.conn.commit();
                            }
                            break block40;
                        }
                        finally {
                            var7_18 = null;
                            if (out != null && out != System.out) {
                                out.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        if (this.autocommit != false) throw new BuildException(e, this.location);
                        if (this.conn == null) throw new BuildException(e, this.location);
                        if (this.onError.equals("abort") == false) throw new BuildException(e, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException(e, this.location);
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        throw new BuildException(e, this.location);
                    }
                    catch (SQLException e) {
                        if (this.autocommit != false) throw new BuildException(e, this.location);
                        if (this.conn == null) throw new BuildException(e, this.location);
                        if (this.onError.equals("abort") == false) throw new BuildException(e, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException(e, this.location);
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        throw new BuildException(e, this.location);
                    }
                }
                catch (Throwable var2_6) {
                    var3_13 = null;
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                        if (this.conn == null) throw var2_6;
                        this.conn.close();
                        throw var2_6;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw var2_6;
                }
            }
            ** try [egrp 6[TRYBLOCK] [9 : 885->920)] { 
lbl106:
            // 1 sources

            if (this.statement != null) {
                this.statement.close();
            }
            if (this.conn == null) return;
            this.conn.close();
            return;
lbl111:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
            return;
        }
        var3_12 = null;
        try {}
        catch (SQLException e) {}
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
    }

    protected void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String sql = "";
        String line = "";
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            if (line.trim().startsWith("//") || line.trim().startsWith("--")) continue;
            sql = sql + " " + line;
            sql = sql.trim();
            if (line.indexOf("--") >= 0) {
                sql = sql + "\n";
            }
            if (!sql.endsWith(";")) continue;
            this.log("SQL: " + sql, 3);
            this.execSQL(sql.substring(0, sql.length() - 1), out);
            sql = "";
        }
        if (!sql.equals("")) {
            this.execSQL(sql, out);
        }
    }

    protected boolean isValidRdbms(Connection conn) {
        if (this.rdbms == null && this.version == null) {
            return true;
        }
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if (this.rdbms != null) {
                String theVendor = dmd.getDatabaseProductName().toLowerCase();
                this.log("RDBMS = " + theVendor, 3);
                if (theVendor == null || theVendor.indexOf(this.rdbms) < 0) {
                    this.log("Not the required RDBMS: " + this.rdbms, 3);
                    return false;
                }
            }
            if (this.version != null) {
                String theVersion = dmd.getDatabaseProductVersion().toLowerCase();
                this.log("Version = " + theVersion, 3);
                if (theVersion == null || !theVersion.startsWith(this.version) && theVersion.indexOf(" " + this.version) < 0) {
                    this.log("Not the required version: \"" + this.version + "\"", 3);
                    return false;
                }
            }
        }
        catch (SQLException e) {
            this.log("Failed to obtain required RDBMS information", 0);
            return false;
        }
        return true;
    }

    protected void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        try {
            ++this.totalSql;
            if (!this.statement.execute(sql)) {
                this.log(this.statement.getUpdateCount() + " rows affected", 3);
            }
            if (this.print) {
                this.printResults(out);
            }
            SQLWarning warning = this.conn.getWarnings();
            while (warning != null) {
                this.log(warning + " sql warning", 3);
                warning = warning.getNextWarning();
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException e) {
            this.log("Failed to execute: " + sql, 0);
            if (!this.onError.equals("continue")) {
                throw e;
            }
            this.log(e.toString(), 0);
        }
    }

    protected void printResults(PrintStream out) throws SQLException {
        ResultSet rs = null;
        do {
            if ((rs = this.statement.getResultSet()) == null) continue;
            this.log("Processing new result set.", 3);
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showheaders) {
                int col = 1;
                while (col < columnCount) {
                    line.append(md.getColumnName(col));
                    line.append(",");
                    ++col;
                }
                line.append(md.getColumnName(columnCount));
                out.println(line);
                line.setLength(0);
            }
            while (rs.next()) {
                boolean first = true;
                int col = 1;
                while (col <= columnCount) {
                    String columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(",");
                    }
                    line.append(columnValue);
                    ++col;
                }
                out.println(line);
                line.setLength(0);
            }
        } while (this.statement.getMoreResults());
        out.println();
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public class Transaction {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        public void setSrc(File src) {
            this.tSrcFile = src;
        }

        public void addText(String sql) {
            this.tSqlCommand = this.tSqlCommand + sql;
        }

        private void runTransaction(PrintStream out) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcFile != null) {
                SQLExec.this.log("Executing file: " + this.tSrcFile.getAbsolutePath(), 2);
                SQLExec.this.runStatements(new FileReader(this.tSrcFile), out);
            }
        }

        static /* synthetic */ void access$0(Transaction transaction, PrintStream printStream) throws IOException, SQLException {
            transaction.runTransaction(printStream);
        }
    }
}

