<?
/* complete_order.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();

/* this page will do the CC authentication, so we want to try to prevent
 * people from entering here causually */
$cart_is_empty = $CART->itemcount() == 0;
$order = load_orderinfo();
if ($cart_is_empty || ! $order) {
	header("Location: $CFG->firstpage");
	die;
}

/*

Se si tratta del pulsante del ContrAssegno, semplicemente e` gia` tutto finito
e bisogna solamente fare cio` che e` descritto nell'if sottostante;
forse conviene mettere qualche controllo sul valore di ritorno di $orderid .

Se si tratta del pulsante relativo alla Carta di Credito, bisogna preparare
le variabili necessarie per preparare la form da sottomettere
al Payment Authorization Service (parte da aggiungere), che corrisponde
a un opportuno template.

*/

$t = new Template();
require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
if ($paybutton == $t->get_var("Cash_On_Delivery")) // si tratta di un pagamento in contrassegno
	$DOC_TITLE = "Order_Completed_Successfully";
else if ($paybutton == $t->get_var("Credit_Card"))
	$DOC_TITLE = "submission_to_banca_sella";
include("$CFG->dirroot"."/header.php");

$t = new Template();
require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-shopping.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");

if ($paybutton == $t->get_var("Cash_On_Delivery")) { // si tratta di un pagamento in contrassegno

	/* we will create the order in our database, then try to authorize the
 	* payment.  if all was successful, the user's order will have been
 	* completed.
 	*/
	$emailbody = "";
	$orderid = create_order_ca($order, &$emailbody);
//	echo "<pre>" . $emailbody . "</pre>";	// usare in caso di test
	mail(
		"$CFG->seller_fullname <$CFG->seller_email>",
		$subject_cash_on_delivery,
		$emailbody,
		"From: $CFG->support");

	$t->set_file(array("page" => "templates/".$SESSION["lang"]."/complete_order_success.ihtml"));
	$t->set_var(array(
			"orderid"	=> $orderid,
			"cart_total"	=> formatted_price($CART->grandtotal),
			"firstpage"	=> $CFG->firstpage,
			"myname"	=> $CFG->myname
	));
	/* clear out the shopping cart, so the user doesn't accidentally re-submit
 	* and purchase twice!! */
	$CART->init();
	clear_orderinfo();
	$SESSION["wantsurl"] = "";

} else if ($paybutton == $t->get_var("Credit_Card")) {

/////////////////////////////////////////////////////////////////////////
// A PART OF THE CODE HAS BEEN CUT AWAY BECAUSE IT STRICTLY DEPENDS ON
// THE PARTICULAR PAYMENT AUTHORIZATION SERVICE YOU DECIDE TO USE; HENCE,
// IN GENERAL, THE PART OF CODE CUT AWAY WILL NOT BE USEFUL TO YOU
/////////////////////////////////////////////////////////////////////////

	$orderid = create_order_cc($order, $passwordric);
	$t->set_file(array("page" => "templates/".$SESSION["lang"]."/banca_sella_submit.ihtml"));

}

$t->pparse("out", "page");
//include($template_to_show);

include("$CFG->dirroot"."/footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function create_order_ca(&$order, &$emailbody) {
/* this function saves this order info the database, it will make one entry
 * in the orders table for the order, and then save the shopping cart
 * contents into the order_items table */
// It also creates the email_body to be sent to the market seller

	global $SESSION, $CART;
	global $myday, $mymonth, $ordersdb;

	/* build the custinfo string */
	$custinfo =
		  $ordersdb[Customer] . " $order->customer\n"
		. $ordersdb[Phone]    . " $order->contact\n"
		. $ordersdb[Address]  . "\n$order->address" . " $order->number\n"
		. " $order->city\n" . " $order->country\n" . " $order->zip_code\n";

	/* save order information first */

	$Date = $myday[date("w")] . date(" j ") . $mymonth[date("n")] . date(" Y H:i:s");
	$FromIP = getenv("REMOTE_ADDR");
	$Dateusec = gettimeofday();
	$orderid = $Dateusec["sec"].$Dateusec["usec"]."-".$FromIP;

	$qid = new DB_Sql;
//	$qid = db_begin();
	$qid->begin();

//	$qid = db_query("
	$qid->Query("
		INSERT INTO ordersca (
			id, username, date, fromip, custinfo, notes, amount, delivery
		) VALUES (
			 '$orderid'
			,'{$SESSION["user"]["username"]}'
			,'$Date'
			,'$FromIP'
			,'$custinfo'
			,'$order->comments'
			,'{$CART->grandtotal}'
			,'{$CART->delivery}'
	)");

	$order_comments = stripslashes ($order->comments);
	$emailbody .= "\n" . $ordersdb[Cash_On_Delivery] . "\n"
		. "\n" . $ordersdb[Order] . " " . $orderid
		. "\n" . $ordersdb[Username] . ": " . $SESSION["user"]["username"]
		. "\n" . $ordersdb[Date] . ": " . $Date
		. "\n" . $ordersdb[Comments] . ":\n" . $order_comments
		. "\n\n" . $ordersdb[TOTAL] . ": " . formatted_price_text ($CART->grandtotal) . "\n";

	/* now add the shopping cart items into the order_items table */
//	$qid = get_cart_items();
	get_cart_items(&$qid);
//	$numr = db_num_rows($qid);
//	for ($i=0; $i<$numr; $i++) {
	$qid_null = new DB_Sql;
	$qid_prod_id = new DB_Sql;
	while ($qid->next_record()) {
//		$item = db_fetch_object($qid, $i);
		$qid_id = $qid->f("id");
		$qid_price = $qid->f("price");
		$qid_iva = $qid->f("iva");
		$qid_weight = $qid->f("weight");
//		db_query("
		$qid_null->Query("
			INSERT INTO order_items (
				order_id, product_id, price, iva, weight, qty
			) VALUES (
				 '$orderid'
				,'$qid_id'
				,'$qid_price'
				,'$qid_iva'
				,'$qid_weight'
				,'{$CART->items["$qid_id"]}'
		)");
//		$qid_prod_id = db_query("
		$qid_prod_id->Query("
			SELECT name
			FROM products
			WHERE id = '$qid->f(id)'
		");
//		$row = db_fetch_object($qid_prod_id, 0);
		$emailbody .= "\n" . $ordersdb[Product] . " " . $qid->f(id) . " - " . $qid_prod_id->f(name)
			. "\n" . $ordersdb[Unit_Price] . ": " . formatted_price_text ($qid->f(price))
			. "\n" . $ordersdb[Number_of_items] . ": " . $CART->items["$qid->f(id)"] . "\n";
	}

//	$qid = db_commit();
	$qid->commit();

	$emailbody .= "\n" . $ordersdb[Delivery] . ": " . formatted_price_text ($CART->delivery);

	return $orderid;
}

function create_order_cc(&$order, $passwordric) {
/* this function saves this order info the database, it will make one entry
 * in the orders table for the order, and then save the shopping cart
 * contents into the order_items table */

	global $SESSION, $CART;
	global $myday, $mymonth, $ordersdb;

	/* build the custinfo string */
	$custinfo =
		  $ordersdb[Customer] . " $order->customer\n"
		. $ordersdb[Phone]    . " $order->contact\n"
		. $ordersdb[Address]  . "\n$order->address" . " $order->number\n"
		. " $order->city\n" . " $order->country\n" . " $order->zip_code\n";

	/* save order information first */

	$Date = $myday[date("w")] . date(" j ") . $mymonth[date("n")] . date(" Y H:i:s");
	$FromIP = getenv("REMOTE_ADDR");
	$Dateusec = gettimeofday();
	$orderid = $Dateusec["sec"].$Dateusec["usec"]."-".$FromIP;

	$qid = new DB_Sql;
//	$qid = db_begin();
	$qid->begin();

//	$qid = db_query("
	$qid->Query("
		INSERT INTO orderscc (
			id, username, date, fromip, custinfo, notes, amount, delivery, otpric
		) VALUES (
			 '$orderid'
			,'{$SESSION["user"]["username"]}'
			,'$Date'
			,'$FromIP'
			,'$custinfo'
			,'$order->comments'
			,'{$CART->grandtotal}'
			,'{$CART->delivery}'
			,'$passwordric'
	)");

	/* now add the shopping cart items into the order_items table */
//	$qid = get_cart_items();
	get_cart_items(&$qid);
//	$numr = db_num_rows($qid);
//	for ($i=0; $i<$numr; $i++) {
	$qid_null = new DB_Sql;
	while ($qid->next_record()) {
//		$item = db_fetch_object($qid, $i);
		$qid_id = $qid->f("id");
		$qid_price = $qid->f("price");
		$qid_iva = $qid->f("iva");
		$qid_weight = $qid->f("weight");
//		db_query("
		$qid_null->Query("
			INSERT INTO order_items (
				order_id, product_id, price, iva, weight, qty
			) VALUES (
				 '$orderid'
				,'$qid_id'
				,'$qid_price'
				,'$qid_iva'
				,'$qid_weight'
				,'{$CART->items["$qid_id"]}'
		)");
	}

//	$qid = db_commit();
	$qid->commit();

	return $orderid;
}

?>
