<?php
/* orders.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = "Orders_Log_cc";
include ("header.php");

switch (nvl($mode)) {
	case "details" :
		print_order_details($id);
		break;

	case "edit" :
		print_edit_order_form($id);
		break;

	case "delete" :
		delete_order($id);
//		print_order_list();
		break;

	case "update" :
		update_order($HTTP_POST_VARS);
//		print_order_list();
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_order_list();
		break;
}

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function print_order_details($id) {
/* loads up the details for an order and displays it */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
//	include ($CFG->globalerror);
	include ("$CFG->localedir" . $SESSION["lang"] . "/global-names.inc.php");

	$qid_order = new PGM_Sql;
	$qid_order->Query("
		SELECT o.*, os.name AS state_name
		FROM orderscc o, orders_states os
		WHERE o.state_id = os.id AND o.id = '$id'
	");
	$qid_order->next_record();

	$qid_items = new PGM_Sql;
	get_order_items(&$qid_items, $id);

	$qid_user= new PGM_Sql;
	$order_username = $qid_order->f("username");
	$qid_user->Query("
		SELECT usertype, fiscalcode, email
		FROM users
		WHERE username = '$order_username'
	");
	$qid_user->next_record();

	$t = new Template();
	$t->set_file(array("page" => "templates/order_details.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"order_id"		=> ov($id),
		"page_number"		=> $page_number,
		"order_state_name"	=> $qid_order->f("state_name"),
		"order_date"		=> $userday[$qid_order->f("weekday")] . " " . $qid_order->f("day") . " " . $usermonth[$qid_order->f("month")] . " " . $qid_order->f("year"),
		"order_username"	=> $qid_order->f("username"),
		"order_amount"		=> $qid_order->f("amount"),
		"order_famount"		=> formatted_price($qid_order->f("amount")),
		"order_custinfo"	=> nl2br(ov($qid_order->f("custinfo"))),
		"user_fiscalcode"	=> $qid_user->f("fiscalcode"),
		"user_email"		=> $qid_user->f("email"),
		"order_notes"		=> nl2br(ov($qid_order->f("notes"))),
		"order_ournotes"	=> nl2br(ov($qid_order->f("ournotes")))
	));
	$t->set_block("page", "usertype_pf", "usertype_pf_blck");
	$t->set_var("usertype_pf_blck", "");
	$t->set_block("page", "usertype_az", "usertype_az_blck");
	$t->set_var("usertype_az_blck", "");
	if ($qid_user->f("usertype") == "pf")
		$t->parse("usertype_pf_blck", "usertype_pf", true);
	else
		$t->parse("usertype_az_blck", "usertype_az", true);
	$t->set_block("page", "weight_used_th", "weight_used_th_blck");
	$t->set_var("weight_used_th_blck", "");
	if($SESSION["weight_used"])
		$t->parse("weight_used_th_blck", "weight_used_th", true);
	$t->set_block("page", "iva_used_th", "iva_used_th_blck");
	$t->set_var("iva_used_th_blck", "");
	if($SESSION["iva_used"])
		$t->parse("iva_used_th_blck", "iva_used_th", true);
	$t->set_block("page", "item_row", "item_rows");
	$t->set_var("item_rows", "");
		$t->set_block("item_row", "weight_used_tr", "weight_used_tr_blck");
		$t->set_block("item_row", "iva_used_tr", "iva_used_tr_blck");
	while ($qid_items->next_record()) {
		$t->set_var("weight_used_tr_blck", "");
		$t->set_var("iva_used_tr_blck", "");
		$t->set_var(array(
			"prod_curr_price"	=> $qid_items->f("curr_price"),
			"prod_curr_fprice"	=> formatted_price($qid_items->f("curr_price")),
			"prod_purchase_price"	=> $qid_items->f("purchase_price"),
			"prod_purchase_fprice"	=> formatted_price($qid_items->f("purchase_price")),
			"prod_qty"		=> $qid_items->f("qty"),
			"prod_total"		=> $qid_items->f("total"),
			"prod_ftotal"		=> formatted_price($qid_items->f("total"))
		));
		$appoggio = ov($qid_items->f("oiname"));
		if ($qid_items->f("name") != $appoggio)
			$appoggio = "<div class=\"warning\">" . $appoggio . "</div>";
		if ($qid_items->f("name") != "")
			$appoggio = "<a href=\"" . "$CFG->wwwroot" . "/admin/products.php?mode=details&product_id=" . $qid_items->f("product_id") . "\">" . $appoggio . "</a>";
		$t->set_var("prod_name", $appoggio);
		if($SESSION["weight_used"]) {
			$t->set_var(array(
				"prod_purchase_weight"	=> $qid_items->f("purchase_weight"),
				"prod_purchase_fweight"	=> formatted_weight($qid_items->f("purchase_weight"))
			));
			$t->parse("weight_used_tr_blck", "weight_used_tr", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("prod_purchase_iva", $qid_items->f("purchase_iva"));
			$t->parse("iva_used_tr_blck", "iva_used_tr", true);
		}
		$t->parse("item_rows", "item_row", true);
	}
	$t->set_block("page", "delivery_used", "delivery_used_blck");
	$t->set_var("delivery_used_blck", "");
	if ($SESSION["delivery_used"]) {
		$t->set_var(array(
			"order_delivery"	=> $qid_order->f("delivery"),
			"order_fdelivery"	=> formatted_price($qid_order->f("delivery"))
		));
		$t->parse("delivery_used_blck", "delivery_used", true);
	}
	$t->pparse("out", "page");
}

function print_edit_order_form($id) {
// print an order form so we can edit the selected order

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number;
//	include ($CFG->globalerror);
	include ("$CFG->localedir" . $SESSION["lang"] . "/global-names.inc.php");

	$qid_order = new PGM_Sql;
	$qid_order->Query("SELECT * FROM orderscc WHERE id = '$id'");
	$qid_order->next_record();
	$frm["id"] = $qid_order->f("id");
	$frm["username"] = $qid_order->f("username");
	$frm["date"] = $userday[$qid_order->f("weekday")] . " " . $qid_order->f("day") . " " . $usermonth[$qid_order->f("month")] . " " . $qid_order->f("year");
	$frm["fromip"] = $qid_order->f("fromip");
	$frm["custinfo"] = $qid_order->f("custinfo");
	$frm["notes"] = $qid_order->f("notes");
	$frm["ournotes"] = $qid_order->f("ournotes");
	$frm["amount"] = $qid_order->f("amount");
	$frm["delivery"] = $qid_order->f("delivery");
	$frm["state_id"] = $qid_order->f("state_id");
	$qid_orders_states = new PGM_Sql;
	$qid_orders_states->Query("SELECT * FROM orders_states ORDER BY name");
	$frm["order_state"] = array();
	$numr = $qid_orders_states->num_rows();
	$frm["num_orders_states"] = $numr;
	for ($i=0; $i<$numr; $i++) {
//		$qid_orders_states->seek($i);
		$qid_orders_states->next_record();
		$frm["order_state"][$i]["id"] = $qid_orders_states->f("id");
		$frm["order_state"][$i]["name"] = $qid_orders_states->f("name");
	}

	$qid_items = new PGM_Sql;
	get_order_items(&$qid_items, $id);

	$qid_user = new PGM_Sql;
	$qid_user->Query("
		SELECT usertype, fiscalcode, email
		FROM users
		WHERE username = '$frm[username]'
	");
	$qid_user->next_record();

	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	$t = new Template();
	$t->set_file(array("page" => "templates/order_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"page_number"		=> $page_number,
		"frm_newmode"		=> $frm["newmode"],
		"order_id"		=> ov($id),
		"frm_date"		=> ov($frm["date"]),
		"frm_year"		=> ov($frm["year"]),
		"frm_month"		=> ov($frm["month"]),
		"frm_day"		=> ov($frm["day"]),
		"frm_weekday"		=> ov($frm["weekday"]),
		"frm_username"		=> ov($frm["username"]),
		"frm_amount"		=> $frm["amount"],
		"frm_famount"		=> formatted_price($frm["amount"]),
		"order_custinfo"	=> $qid_order->f("custinfo"),
		"user_fiscalcode"	=> $qid_user->f("fiscalcode"),
		"user_email"		=> $qid_user->f("email"),
		"order_notes"		=> $frm["notes"],
		"order_ournotes"	=> $frm["ournotes"],
		"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->set_block("page", "order_state_option", "order_state_options");
	$t->set_var("order_state_options", "");
	for ($i=0; $i<$frm["num_orders_states"]; $i++) {
		$t->set_var(array(
			"frm_order_state_id"		=> $frm["order_state"][$i]["id"],
			"frm_order_state_selected"	=> $frm["state_id"] == $frm["order_state"][$i]["id"] ? "selected" : "",
			"frm_order_state_name"		=> $frm["order_state"][$i]["name"]
		));
		$t->parse("order_state_options", "order_state_option", true);
	}
	$t->set_block("page", "usertype_pf", "usertype_pf_blck");
	$t->set_var("usertype_pf_blck", "");
	$t->set_block("page", "usertype_az", "usertype_az_blck");
	$t->set_var("usertype_az_blck", "");
	if ($qid_user->f("usertype") == "pf")
		$t->parse("usertype_pf_blck", "usertype_pf", true);
	else
		$t->parse("usertype_az_blck", "usertype_az", true);
	$t->set_block("page", "weight_used_th", "weight_used_th_blck");
	$t->set_var("weight_used_th_blck", "");
	if($SESSION["weight_used"])
		$t->parse("weight_used_th_blck", "weight_used_th", true);
	$t->set_block("page", "iva_used_th", "iva_used_th_blck");
	$t->set_var("iva_used_th_blck", "");
	if($SESSION["iva_used"])
		$t->parse("iva_used_th_blck", "iva_used_th", true);
	$t->set_block("page", "item_row", "item_rows");
	$t->set_var("item_rows", "");
		$t->set_block("item_row", "weight_used_tr", "weight_used_tr_blck");
		$t->set_block("item_row", "iva_used_tr", "iva_used_tr_blck");
	while ($qid_items->next_record()) {
		$t->set_var("weight_used_tr_blck", "");
		$t->set_var("iva_used_tr_blck", "");
		$t->set_var(array(
			"prod_curr_price"	=> $qid_items->f("curr_price"),
			"prod_curr_fprice"	=> formatted_price($qid_items->f("curr_price")),
			"prod_purchase_price"	=> $qid_items->f("purchase_price"),
			"prod_purchase_fprice"	=> formatted_price($qid_items->f("purchase_price")),
			"prod_qty"		=> $qid_items->f("qty"),
			"prod_total"		=> $qid_items->f("total"),
			"prod_ftotal"		=> formatted_price($qid_items->f("total"))
		));
		$appoggio = ov($qid_items->f("oiname"));
		if ($qid_items->f("name") != $appoggio)
			$appoggio = "<div class=\"warning\">" . $appoggio . "</div>";
		if ($qid_items->f("name") != "")
			$appoggio = "<a href=\"" . "$CFG->wwwroot" . "/admin/products.php?mode=details&product_id=" . $qid_items->f("product_id") . "\">" . $appoggio . "</a>";
		$t->set_var("prod_name", $appoggio);
		if($SESSION["weight_used"]) {
			$t->set_var(array(
				"prod_purchase_weight"	=> $qid_items->f("purchase_weight"),
				"prod_purchase_fweight"	=> formatted_weight($qid_items->f("purchase_weight"))
			));
			$t->parse("weight_used_tr_blck", "weight_used_tr", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("prod_purchase_iva", $qid_items->f("purchase_iva"));
			$t->parse("iva_used_tr_blck", "iva_used_tr", true);
		}
		$t->parse("item_rows", "item_row", true);
	}
	$t->set_block("page", "delivery_used", "delivery_used_blck");
	$t->set_var("delivery_used_blck", "");
	if ($SESSION["delivery_used"]) {
		$t->set_var(array(
			"order_delivery"	=> $qid_order->f("delivery"),
			"order_fdelivery"	=> formatted_price($qid_order->f("delivery"))
		));
		$t->parse("delivery_used_blck", "delivery_used", true);
	}
	$t->pparse("out", "page");
}

function delete_order($id) {
// cancella un ordine

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$qid = new PGM_Sql;
	$qid->begin();
	$qid->Query("DELETE FROM orderscc WHERE id = '$id'");
	$qid->Query("DELETE FROM order_items WHERE order_id = '$id'");
	$qid->commit();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/order_deleted.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	$t->set_var(array(
		"order_id"	=> ov($id),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function update_order($frm) {
// update the order record in the database

	global $CFG, $SESSION;

	$qid = new PGM_Sql;
	$qid->Query("
		UPDATE orderscc SET
			 custinfo = '$frm[custinfo]'
			,notes = '$frm[notes]'
			,ournotes = '$frm[ournotes]'
			,state_id = '$frm[state_id]'
		WHERE id = '$frm[id]'
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/order_updated.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	$t->set_var(array(
		"order_id"	=> ov($frm["id"]),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function print_order_list() {
/* reads a list of orders from the database and displays them, we will use
 * a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
//	global $page_number, $dbchanged;
	global $HTTP_GET_VARS;
//	include ($CFG->globalerror);
	include ("$CFG->localedir" . $SESSION["lang"] . "/global-names.inc.php");

	if (!isset($HTTP_GET_VARS["page_number"]) || $HTTP_GET_VARS["dbchanged"]) {
		$qid = new PGM_Sql;
		$qid->Query("
			SELECT o.*, os.name AS state_name
			FROM orderscc o, orders_states os
			WHERE o.state_id = os.id
			ORDER BY os.name, o.id ASC
  		");
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
//			$qid->seek($i);
			$qid->next_record();
			$SESSION["orderscc"][$i]["id"] = $qid->f("id");
			$SESSION["orderscc"][$i]["username"] = $qid->f("username");
			$SESSION["orderscc"][$i]["date"] = $userday[$qid->f("weekday")] . " " . $qid->f("day") . " " . $usermonth[$qid->f("month")] . " " . $qid->f("year");
			$SESSION["orderscc"][$i]["custinfo"] = $qid->f("custinfo");
			$SESSION["orderscc"][$i]["amount"] = $qid->f("amount");
			$SESSION["orderscc"][$i]["notes"] = $qid->f("notes");
			$SESSION["orderscc"][$i]["state_name"] = $qid->f("state_name");
		}
		if (!isset($HTTP_GET_VARS["page_number"])) {
			$page_number = 1;
		} else $page_number = $HTTP_GET_VARS["page_number"];
	} else $page_number = $HTTP_GET_VARS["page_number"];

	if ($SESSION["numr"] > $SESSION["orders_per_page"]) {
		$first = ($page_number-1)*$SESSION["orders_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["orders_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["orders_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["orders_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/ordercc_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		include ("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "order_row", "order_rows");
	$t->set_var("order_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
			"page_number"			=> $page_number,
			"session_order_id"		=> ov($SESSION["orderscc"][$i]["id"]),
			"session_order_state_name"	=> ov($SESSION["orderscc"][$i]["state_name"]),
			"session_order_username"	=> ov($SESSION["orderscc"][$i]["username"]),
			"session_order_date"		=> ov($SESSION["orderscc"][$i]["date"]),
			"session_order_custinfo"	=> ovwbr($SESSION["orderscc"][$i]["custinfo"]),
			"session_order_amount"		=> $SESSION["orderscc"][$i]["amount"],
			"session_order_famount"		=> formatted_price($SESSION["orderscc"][$i]["amount"])
		));
		$t->parse("order_rows", "order_row", true);
	}
	$t->pparse("out", "page");
}

?>
