<?php
/* users.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");

if (!isset($usertype)) { $usertype = "pf"; }

$qid = new PGM_Sql;

$DOC_TITLE = "Users_Management";
include ("header.php");

switch (nvl($mode)) {
	case "details" :
		print_user_details($username);
		break;

	case "add" :
		print_add_user_form($usertype);
		break;

	case "edit" :
		print_edit_user_form($username);
		break;

	case "del" :
		delete_user($username);
//		print_user_list();
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_username($HTTP_POST_VARS["username"], &$errors, &$errormsg);
		if (username_exists(&$qid, $HTTP_POST_VARS["username"])) {
			$errors->username = true;
			$errormsg = "<li>" . $the_username . " <b>" . ov($HTTP_POST_VARS["username"]) ."</b> " . $already_exists . $errormsg;
		}
/*
		if (email_exists($HTTP_POST_VARS["email"])) {
			$errors->email = true;
			$errormsg .= "<li>" . $the_email_address . " <b>" . ov($HTTP_POST_VARS["email"]) ."</b> " . $already_exists;
		}
*/
		validate_user_form(&$HTTP_POST_VARS, &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_user($HTTP_POST_VARS);
//			print_user_list();
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["newmode"] = "insert";
			$frm["submit_caption"] = "Add_User";
			include ("$CFG->dirroot" . "/form_header.php");
			load_user_form_template($frm, $HTTP_POST_VARS["usertype"], $page_number, $errors);
		}
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
/*
		if ($HTTP_POST_VARS["old_email"] != $HTTP_POST_VARS["email"]
		     && email_exists($HTTP_POST_VARS["email"])) {
			$errors->email = true;
			$errormsg .= "<li>" . $the_email_address . " <b>" . ov($HTTP_POST_VARS["email"]) ."</b> " . $already_exists;
		}
*/
		validate_user_form(&$HTTP_POST_VARS, &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_user($HTTP_POST_VARS);
//			print_user_list();
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["newmode"] = "update";
			$frm["submit_caption"] = "Save_Changes";
			include ("$CFG->dirroot" . "/form_header.php");
			load_user_form_template($frm, $HTTP_POST_VARS["usertype"], $page_number, $errors);
		}
		break;

	case "resetpw" :
		$qid->begin();
		$return = reset_user_password(&$qid, $username);
		$qid->commit();
		if ($return == 0) {
			$t = new Template();
			$t->set_file(array("page" => "templates/" . $SESSION["lang"] . "/user_password_reset.ihtml"));
			$t->set_var("username", ov($username));
			$t->pparse("out", "page");
		} else {
			include ("templates/" . $SESSION["lang"] . "/password_not_reset.ihtml");
		}
		print_user_list();
		break;

	case "import" :
		print_import_users_form();
		break;

	case "update_imp" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_users_form();
		else
			import_users($HTTP_POST_FILES);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_user_list();
		break;
}

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_user_form(&$frm, &$errors, &$errormsg) {

	validate_priv($frm["priv"], &$errors, &$errormsg);
	if ($frm["usertype"] == "pf") {
		validate_firstname($frm["firstname"], &$errors, &$errormsg);
		validate_lastname($frm["lastname"], &$errors, &$errormsg);
		if (!empty($frm["fiscalcode"])) {
			validate_fiscalcode($frm["fiscalcode"], &$errors, &$errormsg);
		}
	} else if ($frm["usertype"] == "az") {
		validate_ragionesociale($frm["firstname"], &$errors, &$errormsg);
		validate_partitaiva($frm["fiscalcode"], &$errors, &$errormsg);
	}
	validate_address($frm["address"], &$errors, &$errormsg);
	validate_number($frm["number"], &$errors, &$errormsg);
	validate_city($frm["city"], &$errors, &$errormsg);
	validate_country($frm["country"], &$errors, &$errormsg);
	validate_zip_code($frm["zip_code"], &$errors, &$errormsg);
	validate_phone($frm["phone"], &$errors, &$errormsg);
	validate_fax($frm["fax"], &$errors, &$errormsg);
	validate_mobilephone($frm["mobilephone"], &$errors, &$errormsg);
	validate_email($frm["email"], &$errors, &$errormsg);
	validate_notes($frm["notes"], &$errors, &$errormsg);
	validate_ournotes($frm["ournotes"], &$errors, &$errormsg);
}

function load_user_form_template($frm, $usertype, $page_number, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/user_form-".$usertype.".ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"page_number"		=> $page_number,
		"frm_newmode"		=> $frm["newmode"],
		"frm_old_email"		=> $frm["old_email"],
		"frm_username"		=> ov($frm["username"]),
		"errors_username"	=> errmsg($errors->username),
		"frm_priv"		=> ov($frm["priv"]),
		"errors_priv"		=> errmsg($errors->priv),
		"frm_firstname"		=> ov($frm["firstname"]),
		"errors_firstname"	=> errmsg($errors->firstname),
		"frm_lastname"		=> ov($frm["lastname"]),
		"errors_lastname"	=> errmsg($errors->lastname),
		"frm_fiscalcode"	=> ov($frm["fiscalcode"]),
		"errors_fiscalcode"	=> errmsg($errors->fiscalcode),
		"frm_address"		=> ov($frm["address"]),
		"errors_address"	=> errmsg($errors->address),
		"frm_number"		=> ov($frm["number"]),
		"errors_number"		=> errmsg($errors->number),
		"frm_city"		=> ov($frm["city"]),
		"errors_city"		=> errmsg($errors->city),
		"frm_country"		=> ov($frm["country"]),
		"errors_country"	=> errmsg($errors->country),
		"frm_zip_code"		=> ov($frm["zip_code"]),
		"errors_zip_code"	=> errmsg($errors->zip_code),
		"frm_phone"		=> ov($frm["phone"]),
		"errors_phone"		=> errmsg($errors->phone),
		"frm_fax"		=> ov($frm["fax"]),
		"errors_fax"		=> errmsg($errors->fax),
		"frm_mobilephone"	=> ov($frm["mobilephone"]),
		"errors_mobilephone"	=> errmsg($errors->mobilephone),
		"frm_email"		=> ov($frm["email"]),
		"errors_email"		=> errmsg($errors->email),
		"frm_authdata"		=> $frm["authdata"] ? "checked" : "" ,
		"frm_acceptadvert"	=> $frm["acceptadvert"] ? "checked" : "" ,
		"frm_notes"		=> ov($frm["notes"]),
		"errors_notes"		=> errmsg($errors->notes),
		"frm_ournotes"		=> ov($frm["ournotes"]),
		"errors_ournotes"	=> errmsg($errors->ournotes),
		"frm_description"	=> ov($frm["description"]),
		"errors_description"	=> errmsg($errors->brand_description),
		"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->set_block("page", "username_notok", "username_notok_blck");
	$t->set_var("username_notok_blck", "");
	$t->set_block("page", "username_ok", "username_ok_blck");
	$t->set_var("username_ok_blck", "");
	if ($frm["username"] == "" || $errors->username)
		$t->parse("username_notok_blck", "username_notok", true);
	else
		$t->parse("username_ok_blck", "username_ok", true);
	$t->pparse("out", "page");
}

function print_user_details($username) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	include ("$CFG->localedir" . $SESSION["lang"] . "/global-names.inc.php");
	global $qid;

	$qid->Query("SELECT * FROM users WHERE username = '$username'");
	$qid->next_record();

	$t = new Template();
	$t->set_file(array("page" => "templates/user_details-" . $qid->f("usertype") . ".ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_username"		=> ov($qid->f("username")),
		"frm_priv"		=> ov($qid->f("priv")),
		"frm_firstname"		=> ov($qid->f("firstname")),
		"frm_lastname"		=> ov($qid->f("lastname")),
		"frm_fiscalcode"	=> ov($qid->f("fiscalcode")),
		"frm_address"		=> ovwbr($qid->f("address")),
		"frm_number"		=> ov($qid->f("number")),
		"frm_city"		=> ov($qid->f("city")),
		"frm_country"		=> ov($qid->f("country")),
		"frm_zip_code"		=> ov($qid->f("zip_code")),
		"frm_phone"		=> ov($qid->f("phone")),
		"frm_fax"		=> ov($qid->f("fax")),
		"frm_mobilephone"	=> ov($qid->f("mobilephone")),
		"frm_email"		=> ov($qid->f("email")),
		"frm_authdata"		=> $qid->f("authdata") ? strtoupper($yes) : "" ,
		"frm_acceptadvert"	=> $frm["acceptadvert"] ? strtoupper($yes) : "" ,
		"frm_notes"		=> ovwbr($qid->f("notes")),
		"frm_ournotes"		=> ovwbr($qid->f("ournotes")),
		"frm_date"		=> $userday[$qid->f("weekday")] . " " . $qid->f("day") . " " . $usermonth[$qid->f("month")] . " " . $qid->f("year")
	));
	$t->pparse("out", "page");
}

function print_add_user_form($usertype) {
/* print a blank user form so we can add a new user */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);

	/* set default values for the reset of the fields */
	$frm["username"] = "";
	$frm["firstname"] = "";
	$frm["lastname"] = "";
	$frm["address"] = "";
	$frm["number"] = "";
	$frm["city"] = "";
	$frm["country"] = "";
	$frm["zip_code"] = "";
	$frm["phone"] = "";
	$frm["fax"] = "";
	$frm["mobilephone"] = "";
	$frm["email"] = "";
	$frm["authdata"] = 0;
	$frm["acceptadvert"] = 1;
	$frm["notes"] = "";

	$frm["newmode"] = "insert";
	$frm["submit_caption"] = "Add_User";

	load_user_form_template($frm, $usertype, $page_number, $errors);
}

function print_edit_user_form($username) {
/* print a user form so we can edit the selected user */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);
	global $qid;

	/* load up the information for the user */
	$qid->Query("SELECT * FROM users WHERE username = '$username'");
	$qid->next_record();
	$frm["username"] = $qid->f("username");
	$frm["password"] = $qid->f("password");
	$frm["usertype"] = $qid->f("usertype");
	$frm["priv"] = $qid->f("priv");
	$frm["firstname"] = $qid->f("firstname");
	$frm["lastname"] = $qid->f("lastname");
	$frm["fiscalcode"] = $qid->f("fiscalcode");
	$frm["address"] = $qid->f("address");
	$frm["number"] = $qid->f("number");
	$frm["city"] = $qid->f("city");
	$frm["country"] = $qid->f("country");
	$frm["zip_code"] = $qid->f("zip_code");
	$frm["phone"] = $qid->f("phone");
	$frm["fax"] = $qid->f("fax");
	$frm["mobilephone"] = $qid->f("mobilephone");
	$frm["email"] = $qid->f("email");
	$frm["authdata"] = $qid->f("authdata");
	$frm["acceptadvert"] = $qid->f("acceptadvert");
	$frm["notes"] = $qid->f("notes");
	$frm["ournotes"] = $qid->f("ournotes");
	$frm["unixtime"] = $qid->f("unixtime");
	$frm["year"] = $qid->f("year");
	$frm["month"] = $qid->f("month");
	$frm["day"] = $qid->f("day");
	$frm["weekday"] = $qid->f("weekday");
	$frm["fromip"] = $qid->f("fromip");

	$frm["old_email"] = $frm["email"];

	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	load_user_form_template($frm, $frm["usertype"], $page_number, $errors);
}

function delete_user($username) {
/* delete the user who's login is $username */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("SELECT priv FROM users WHERE username = '$username'");
	$qid->next_record();
	if ($qid->f("priv") != "admin") {
		$qid->Query("DELETE FROM users WHERE username = '$username'");

		if (empty($SESSION["goback"]["query_string"]))
			$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
		else
			$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

		$t = new Template();
		$t->set_file(array("page" => "templates/user_deleted.ihtml"));
		include ("$CFG->localelangdir" . "/global-common.inc.php");
		include ("$CFG->localelangdir" . "/global-admin.inc.php");
		$t->set_var(array(
			"username"	=> ov($username),
			"backurl"	=> $backurl
		));
		$t->pparse("out", "page");
	} else {
		include ("templates/" . $SESSION["lang"] . "/admin_not_deleted.ihtml");
	}
}

function insert_user($frm) {
/* add a user into the database, we should really have some good validation
 * routines to check for things like bad passwords, etc., but for the purpose
 * of this tutorial it's left to the reader (you) to add them in :) */

	global $CFG, $SESSION;
//	include ($CFG->globalerror);
	global $qid;

//	$date = $myday[date("w")] . date(" j") . "-" . date("n") . "-" . date("Y H:i:s");
	$Dateusec = gettimeofday(); $unixtime = $Dateusec["sec"];
	$year = date("Y"); $month = date("n"); $day = date("j"); $weekday = date("w");
	$fromip = getenv("REMOTE_ADDR");

	$password = generate_password();

	$qid->Query("
		INSERT INTO users (
			 username
			,password
			,usertype
			,priv
			,firstname
			,lastname
			,fiscalcode
			,address
			,number
			,city
			,country
			,zip_code
			,phone
			,fax
			,mobilephone
			,email
			,authdata
			,acceptadvert
			,notes
			,ournotes
			,unixtime
			,year
			,month
			,day
			,weekday
			,fromip
		)
		VALUES (
			 '$frm[username]'
			,'" . md5($password) ."'
			,'$frm[usertype]'
			,'$frm[priv]'
			,'$frm[firstname]'
			,'$frm[lastname]'
			,'$frm[fiscalcode]'
			,'$frm[address]'
			,'$frm[number]'
			,'$frm[city]'
			,'$frm[country]'
			,'$frm[zip_code]'
			,'$frm[phone]'
			,'$frm[fax]'
			,'$frm[mobilephone]'
			,'$frm[email]'
			,'$frm[authdata]'
			,'$frm[acceptadvert]'
			,'$frm[notes]'
			,'$frm[ournotes]'
			,'$unixtime'
			,'$year'
			,'$month'
			,'$day'
			,'$weekday'
			,'$fromip'
		)
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/user_added.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"frm_username"	=> ov($frm[username]),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function update_user($frm) {
/* update the user record in the database */

	global $CFG, $SESSION;
	global $username;
//	include ($CFG->globalerror);
	global $qid;

	$qid->Query("
		UPDATE users SET
			 priv = '$frm[priv]'
			,firstname = '$frm[firstname]'
			,lastname = '$frm[lastname]'
			,fiscalcode = '$frm[fiscalcode]'
			,address = '$frm[address]'
			,number = '$frm[number]'
			,city = '$frm[city]'
			,country = '$frm[country]'
			,zip_code = '$frm[zip_code]'
			,phone = '$frm[phone]'
			,fax = '$frm[fax]'
			,mobilephone = '$frm[mobilephone]'
			,email = '$frm[email]'
			,authdata = '$frm[authdata]'
			,acceptadvert = '$frm[acceptadvert]'
			,notes = '$frm[notes]'
			,ournotes = '$frm[ournotes]'
		WHERE username = '$frm[username]'
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/user_updated.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var(array(
		"username"	=> ov($username),
		"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
}

function print_user_list() {
/* read all the categories from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $yes;
	global $page_number, $datachanged;
//	include ($CFG->globalerror);
	global $qid;

	if (!isset($page_number) || $datachanged) {
		$qid->Query("
			SELECT username, firstname, lastname, phone, email, authdata, acceptadvert
			FROM users
			WHERE username <> 'root'
			ORDER BY username ASC
		");
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$qid->next_record();
			$SESSION["users"][$i]["username"] = $qid->f("username");
			$SESSION["users"][$i]["firstname"] = $qid->f("firstname");
			$SESSION["users"][$i]["lastname"] = $qid->f("lastname");
			$SESSION["users"][$i]["phone"] = $qid->f("phone");
			$SESSION["users"][$i]["email"] = $qid->f("email");
			$SESSION["users"][$i]["authdata"] = $qid->f("authdata");
			$SESSION["users"][$i]["acceptadvert"] = $qid->f("acceptadvert");
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["users_per_page"]) {
		$first = ($page_number-1)*$SESSION["users_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["users_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["users_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["users_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/user_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		include ("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "user_row", "user_rows");
	$t->set_var("user_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
			"page_number"		=> $page_number,
			"session_username"	=> ov($SESSION["users"][$i]["username"]),
			"session_firstname"	=> ov($SESSION["users"][$i]["firstname"]),
			"session_lastname"	=> $SESSION["users"][$i]["lastname"] == "" ? "&nbsp;" : ov($SESSION["users"][$i]["lastname"]),
			"session_phone"		=> ov($SESSION["users"][$i]["phone"]),
			"session_email"		=> ov($SESSION["users"][$i]["email"]),
			"session_authdata"	=> $SESSION["users"][$i]["authdata"] ? strtoupper($yes) : "&nbsp;",
			"session_acceptadvert"	=> $SESSION["users"][$i]["acceptadvert"] ? strtoupper($yes) : "&nbsp;"
		));
		$t->parse("user_rows", "user_row", true);
	}
	$t->pparse("out", "page");
}

function print_import_users_form() {
/* print the import users form so we can add/update users from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function import_users($HTTP_POST_FILES) {
/* Import users from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	/* Let's open a transaction */
	$qid->begin();

	$fcontents = file ($HTTP_POST_FILES['userfile']['tmp_name']);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
//echo "<b>" . $line_num . "</b>:" . $line . "<br>";
		/* dangerous characters quoting */
		for ($i=0; $i<26; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* Let's see if the user already exists ... */
		$qid->Query("SELECT username FROM users WHERE username = '$fldarr[0]'");
		if ($qid->num_rows() == 0) {
			/* ... if it doesn't exist let's create it in the users table ... */
			$qid->Query("
				INSERT INTO users (
					 username
					,password
					,usertype
					,priv
					,firstname
					,lastname
					,fiscalcode
					,address
					,number
					,city
					,country
					,zip_code
					,phone
					,fax
					,mobilephone
					,email
					,authdata
					,acceptadvert
					,notes
					,ournotes
					,unixtime
					,year
					,month
					,day
					,weekday
					,fromip
				)
				VALUES (
					'$fldarr[0]'
					,'" . md5($fldarr[1]) ."'
					,'$fldarr[2]'
					,'$fldarr[3]'
					,'$fldarr[4]'
					,'$fldarr[5]'
					,'$fldarr[6]'
					,'$fldarr[7]'
					,'$fldarr[8]'
					,'$fldarr[9]'
					,'$fldarr[10]'
					,'$fldarr[11]'
					,'$fldarr[12]'
					,'$fldarr[13]'
					,'$fldarr[14]'
					,'$fldarr[15]'
					,'$fldarr[16]'
					,'$fldarr[17]'
					,'$fldarr[18]'
					,'$fldarr[19]'
					,'$fldarr[20]'
					,'$fldarr[21]'
					,'$fldarr[22]'
					,'$fldarr[23]'
					,'$fldarr[24]'
					,'$fldarr[25]'
				)
			");
		} else {
			/* ... otherwise let's update it in the products table ... */
			$qid->Query("
				UPDATE users SET
					usertype = '$fldarr[2]'
					,priv = '$fldarr[3]'
					,firstname = '$fldarr[4]'
					,lastname = '$fldarr[5]'
					,fiscalcode = '$fldarr[6]'
					,address = '$fldarr[7]'
					,number = '$fldarr[8]'
					,city = '$fldarr[9]'
					,country = '$fldarr[10]'
					,zip_code = '$fldarr[11]'
					,phone = '$fldarr[12]'
					,fax = '$fldarr[13]'
					,mobilephone = '$fldarr[14]'
					,email = '$fldarr[15]'
					,authdata = '$fldarr[16]'
					,acceptadvert = '$fldarr[17]'
					,notes = '$fldarr[18]'
					,ournotes = '$fldarr[19]'
					,unixtime = '$fldarr[20]'
					,year = '$fldarr[21]'
					,month = '$fldarr[22]'
					,day = '$fldarr[23]'
					,weekday = '$fldarr[24]'
					,fromip = '$fldarr[25]'
				WHERE username = '$fldarr[0]'
			");
		}
	}

	/* Let's close the transaction */
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?datachanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&datachanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
}

?>
