<?php

/*
 * (c) 2000 Fabio Molinari <fabio.m@mclink.it>
 * (c) 2000, 2001 Marco Pratesi <pratesi@telug.it>
 * (c) 2000 Oleg V. Kalashnikov <oleg@ok.gnu.zp.ua>
 * (c) 2000 Ying Zhang <ying@zippydesign.com>
 */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
global $CFG, $ME;
global $SESSION;
//include ($CFG->globalerror);

$DOC_TITLE = "AdvancedSearch";
include ("$CFG->dirroot" . "/header.php");

/* Form has been submitted, let's go searching. */

if (match_referer() && !isset($from_menu)) {
	if (!isset($page_number)) {
		$page_number = 1;
		if ($product_name_min == ""
		 && $product_name_max == ""
		 && $product_name_in == ""
		 && $brand_id == ""
		 && $description_min == ""
		 && $description_max == ""
		 && $name_in == ""
		 && $price_min == ""
		 && $price_max == ""
		 && $discount_min == ""
		 && $discount_max == ""
		 && $discqty_min == ""
		 && $discqty_max == ""
		 && $weight_min == ""
		 && $weight_max == "") {
			$errormsg->emptyform = true;
		} else {
			$SESSION["product_name_min"] = $product_name_min;
			$SESSION["product_name_max"] = $product_name_max;
			$SESSION["product_name_in"] = $product_name_in;
			$SESSION["brand_id"] = $brand_id;
			$SESSION["prod_concatenation"] = $prod_concatenation;
			$SESSION["prod_case_sensitive"] = $prod_case_sensitive;
			$SESSION["description_min"] = $description_min;
			$SESSION["description_max"] = $description_max;
			$SESSION["name_in"] = $name_in;
			$SESSION["desc_concatenation"] = $desc_concatenation;
			$SESSION["desc_case_sensitive"] = $desc_case_sensitive;
			$SESSION["price_min"] = $price_min;
			$SESSION["price_max"] = $price_max;
			$SESSION["discount_min"] = $discount_min;
			$SESSION["discount_max"] = $discount_max;
			$SESSION["discqty_min"] = $discqty_min;
			$SESSION["discqty_max"] = $discqty_max;
			$SESSION["weight_min"] = $weight_min;
			$SESSION["weight_max"] = $weight_max;
			$errormsg = validate_form($SESSION, $errors);
		}
		if (empty($errormsg)) {
			$qid = new PGM_Sql;
			advanced_find_products(&$qid, &$SESSION);
			$SESSION["numr"] = $qid->num_rows();
			for ($i=0; $i<$SESSION["numr"]; $i++) {
				$qid->next_record();
				$SESSION["searchres"][$i]["id"] = $qid->f("id");
				$SESSION["searchres"][$i]["code"] = $qid->f("code");
				$SESSION["searchres"][$i]["name"] = $qid->f("name");
				$SESSION["searchres"][$i]["lname"] = $qid->f("lname");
				$SESSION["searchres"][$i]["bname"] = $qid->f("bname");
				$SESSION["searchres"][$i]["price"] = $qid->f("price");
				$SESSION["searchres"][$i]["iva"] = $qid->f("iva");
				$SESSION["searchres"][$i]["discount"] = $qid->f("discount");
				$SESSION["searchres"][$i]["discqty"] = $qid->f("discqty");
				$SESSION["searchres"][$i]["weight"] = $qid->f("weight");
				$SESSION["searchres"][$i]["special_level"] = $qid->f("special_level");
				$SESSION["searchres"][$i]["description"] = $qid->f("description");
				$SESSION["searchres"][$i]["thumbwidth"] = $qid->f("thumbwidth");
				$SESSION["searchres"][$i]["thumbheight"] = $qid->f("thumbheight");
			}
		}
	}
	if (empty($errormsg)) {
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		if ($SESSION["numr"] > $SESSION["max_results"]) {
			include ("templates/" . $SESSION["lang"] . "/too_many_results.ihtml");
		} else if ($SESSION["numr"] > $SESSION["products_per_page"]) {
			$first = ($page_number-1)*$SESSION["products_per_page"];
			$last = $SESSION["numr"] < $page_number*$SESSION["products_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["products_per_page"]-1;
			$num_pages = $SESSION["numr"] / $SESSION["products_per_page"];
			if (!($num_pages == (integer) $num_pages)) {
				$num_pages = (integer) $num_pages + 1;
			}
		} else {
			$first = 0;
			$last = $SESSION["numr"] - 1;
		}
		include ("search_results.php");
		include ("$CFG->dirroot" . "/footer.php");
		die;
	}
}

$t = new Template();
$t->set_file(array("page" => "templates/advanced_search_form.ihtml"));
include ("$CFG->localelangdir" . "/global-common.inc.php");
include ("$CFG->localelangdir" . "/global-shopping.inc.php");
$t->set_var("wwwroot", "$CFG->wwwroot");
$t->set_var("productswww", "$CFG->productswww");
$t->set_var("ME", $ME);
$t->set_var("id", $id);
if (empty($errors))
	$t->set_var("there_are_errors", "");
$t->set_var(array(
	"session_product_name_in"	=> ov($SESSION["product_name_in"]),
	"session_prod_concatenation_or"	=> $SESSION["prod_concatenation"] == "AND" ? "" : "checked",
	"session_prod_concatenation_and"=> $SESSION["prod_concatenation"] == "AND" ? "checked" : "",
	"session_prod_case_sensitive"	=> $SESSION["prod_case_sensitive"] ? "checked" : "",
	"session_name_in"		=> ov($SESSION["name_in"]),
	"session_desc_concatenation_or"	=> $SESSION["desc_concatenation"] == "AND" ? "" : "checked",
	"session_desc_concatenation_and"=> $SESSION["desc_concatenation"] == "AND" ? "checked" : "",
	"session_desc_case_sensitive"	=> $SESSION["desc_case_sensitive"] ? "checked" : "",
	"session_price_min"		=> ov($SESSION["price_min"]),
	"errors_price_min"		=> errmsg($errors->price_min),
	"session_price_max"		=> ov($SESSION["price_max"]),
	"errors_price_max"		=> errmsg($errors->price_max),
	"session_discount_min"		=> ov($SESSION["discount_min"]),
	"errors_discount_min"		=> errmsg($errors->discount_min),
	"session_discount_max"		=> ov($SESSION["discount_max"]),
	"errors_discount_max"		=> errmsg($errors->discount_max),
	"session_discqty_min"		=> ov($SESSION["discqty_min"]),
	"errors_discqty_min"		=> errmsg($errors->discqty_min),
	"session_discqty_max"		=> ov($SESSION["discqty_max"]),
	"errors_discqty_max"		=> errmsg($errors->discqty_max)
));
$t->set_block("page", "brand_used", "brand_used_blck");
$t->set_var("brand_used_blck", "");
if ($SESSION["brand_used"]) {
	$t->set_block("brand_used", "brand_row", "brand_rows");
	$t->set_var("brand_rows", "");
	$qid = new PGM_Sql;
	$qid->Query("SELECT id, name FROM brands");
	$SESSION["brands"] = array();
	while ($qid->next_record()) {
		$t->set_var(array(
			"session_brand_id"	=> $qid->f("id"),
			"session_brand_selected"=> ($SESSION["brand_id"] == $qid->f("id")) ? "selected" : "",
			"session_brand_name"	=> $qid->f("name")
		));
		$t->parse("brand_rows", "brand_row", true);
	}
	$t->parse("brand_used_blck", "brand_used", true);
}
$t->set_block("page", "weight_used", "weight_used_blck");
$t->set_var("weight_used_blck", "");
if($SESSION["weight_used"]) {
	$t->set_var(array(
		"session_weight_min"	=> ov($SESSION["weight_min"]),
		"errors_weight_min"	=> errmsg($errors->weight_min),
		"session_weight_max"	=> ov($SESSION["weight_max"]),
		"errors_weight_max"	=> errmsg($errors->weight_max)
	));
	$t->parse("weight_used_blck", "weight_used", true);
}
$t->pparse("out", "page");

include ("$CFG->dirroot" . "/footer.php");


/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors) {
/* validate the form, and return the error messages in a string.  if
 * the string is empty, then there are no errors */

	global $CFG, $SESSION;
//	include ($CFG->globalerror);

	$errors = new Object;
	$errormsg = "";

/*
	if(!empty($frm["product_name_min"])) {
		validate_product_name($frm["product_name_min"], &$errors, &$errormsg);
		if ($errors->product_name) $errors->product_name_min = true;
	}
	if(!empty($frm["product_name_max"])) {
		validate_product_name($frm["product_name_max"], &$errors, &$errormsg);
		if ($errors->product_name) $errors->product_name_max = true;
	}
	if(!empty($frm["description_min"])) {
		validate_product_description($frm["description_min"], &$errors, &$errormsg);
		if ($errors->product_description) $errors->description_min = true;
	}
	if(!empty($frm["description_max"])) {
		validate_product_description($frm["description_max"], &$errors, &$errormsg);
		if ($errors->product_description) $errors->description_max = true;
	}
*/
	if(!empty($frm["price_min"])) {
		validate_price($frm["price_min"], &$errors, &$errormsg);
		if ($errors->price) $errors->price_min = true;
	}
	if(!empty($frm["price_max"])) {
		validate_price($frm["price_max"], &$errors, &$errormsg);
		if ($errors->price) $errors->price_max = true;
	}
	if(!empty($frm["discount_min"])) {
		validate_searched_discount($frm["discount_min"], &$errors, &$errormsg);
		if ($errors->discount) $errors->discount_min = true;
	}
	if(!empty($frm["discount_max"])) {
		validate_searched_discount($frm["discount_max"], &$errors, &$errormsg);
		if ($errors->discount) $errors->discount_max = true;
	}
	if(!empty($frm["discqty_min"])) {
		validate_searched_discqty($frm["discount_min"], &$errors, &$errormsg);
		if ($errors->discqty) $errors->discqty_min = true;
	}
	if(!empty($frm["discqty_max"])) {
		validate_searched_discqty($frm["discount_max"], &$errors, &$errormsg);
		if ($errors->discqty) $errors->discqty_max = true;
	}
	if(!empty($frm["weight_min"])) {
		validate_weight($frm["weight_min"], &$errors, &$errormsg);
		if ($errors->weight) $errors->weight_min = true;
	}
	if(!empty($frm["weight_max"])) {
		validate_weight($frm["weight_max"], &$errors, &$errormsg);
		if ($errors->weight) $errors->weight_max = true;
	}

	return $errormsg;
}

?>
