<?php
/* signup.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
if (!isset($usertype)) { $usertype = "pf"; }

$qid = new PGM_Sql;

/* form has been submitted, try to create the new user account */
if (match_referer() && isset($HTTP_POST_VARS) && !isset($from_menu)) {
	$frm = $HTTP_POST_VARS;
	$errormsg = validate_form($frm, $errors, $usertype);

	if (empty($errormsg)) {
		insert_user($frm, $usertype);

		$DOC_TITLE = "Signup_Successful";
		include ("$CFG->dirroot" . "/header.php");
		$t = new Template();
		$t->set_file(array("page" => "templates/" . $SESSION["lang"] . "/signup_success.ihtml"));
		$t->set_var(array(
			"frm_firstname"	=> ov($frm["firstname"]),
			"frm_username"	=> ov($frm["username"]),
			"frm_password"	=> ov($frm["password"]),
			"wwwroot"	=> $CFG->wwwroot
		));
		$t->pparse("out", "page");
		include ("$CFG->dirroot" . "/footer.php");
		die;
	}
}

$DOC_TITLE = "Signup";
include ("$CFG->dirroot" . "/header.php");
include ("$CFG->dirroot" . "/form_header.php");

if (empty($errormsg)) {	// we are loading the form for the first time
	$frm["acceptadvert"] = 1;
}

$t = new Template();
$t->set_file(array("page" => "templates/signup_form-" . $usertype . ".ihtml"));
include ("$CFG->localelangdir" . "/global-common.inc.php");
include ("$CFG->localelangdir" . "/global-users.inc.php");
$t->set_var("ME", $ME);
$t->set_var("md5dotjs", "$CFG->libwww" . "/md5.js");
$t->set_var("star", return_star());
$t->set_var(array(
	"frm_username"		=> ov($frm["username"]),
	"errors_username"	=> errmsg($errors->username),
	"errors_password"	=> errmsg($errors->password),
	"frm_firstname"		=> ov($frm["firstname"]),
	"errors_firstname"	=> errmsg($errors->firstname),
	"frm_lastname"		=> ov($frm["lastname"]),
	"errors_lastname"	=> errmsg($errors->lastname),
	"frm_address"		=> ov($frm["address"]),
	"errors_address"	=> errmsg($errors->address),
	"frm_number"		=> ov($frm["number"]),
	"errors_number"		=> errmsg($errors->number),
	"frm_city"		=> ov($frm["city"]),
	"errors_city"		=> errmsg($errors->city),
	"frm_country"		=> ov($frm["country"]),
	"errors_country"	=> errmsg($errors->country),
	"frm_zip_code"		=> ov($frm["zip_code"]),
	"errors_zip_code"	=> errmsg($errors->zip_code),
	"frm_phone"		=> ov($frm["phone"]),
	"errors_phone"		=> errmsg($errors->phone),
	"frm_fax"		=> ov($frm["fax"]),
	"errors_fax"		=> errmsg($errors->fax),
	"frm_mobilephone"	=> ov($frm["mobilephone"]),
	"errors_mobilephone"	=> errmsg($errors->mobilephone),
	"frm_email"		=> ov($frm["email"]),
	"errors_email"		=> errmsg($errors->email),
	"frm_authdata"		=> $frm["authdata"] ? "checked" : "",
	"frm_acceptadvert"	=> $frm["acceptadvert"] ? "checked" : "",
	"frm_notes"		=> ov($frm["notes"]),
	"errors_notes"		=> errmsg($errors->notes),
));
$t->set_block("page", "fiscalcode", "fiscalcode_blck");
$t->set_var("fiscalcode_blck", "");
if ($country == "it" || $HTTP_POST_VARS["hiddencountry"] == "it" || $usertype == "az") {
	$t->set_var(array(
		"frm_fiscalcode"	=> ov($frm["fiscalcode"]),
		"errors_fiscalcode"	=> errmsg($errors->fiscalcode)
	));
	$t->parse("fiscalcode_blck", "fiscalcode", true);
}
$t->pparse("out", "page");

include ("$CFG->dirroot" . "/footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors, $usertype) {
/* validate the signup form, and return the error messages in a string.  if
 * the string is empty, then there are no errors */

	global $CFG, $SESSION;
	include ($CFG->globalerror);
	global $qid;

	$errors = new Object;
	$msg = "";

	validate_username($frm["username"], &$errors, &$msg);
	if ($frm["password"] == $frm["passwordconfirm"]) {
		validate_password($frm["password"], &$errors, &$msg);
	} else {
		$errors->password = true;
		$msg .= "<li>" . $passwords_do_not_match;
	}
	if ($usertype == "pf") {
		validate_firstname($frm["firstname"], &$errors, &$msg);
		validate_lastname($frm["lastname"], &$errors, &$msg);
		if ($frm["hiddencountry"] == "it") {
			validate_fiscalcode($frm["fiscalcode"], &$errors, &$msg);
		}
	} else if ($usertype == "az") {
		validate_ragionesociale($frm["firstname"], &$errors, &$msg);
		validate_partitaiva($frm["fiscalcode"], &$errors, &$msg);
	}
	validate_address($frm["address"], &$errors, &$msg);
	validate_number($frm["number"], &$errors, &$msg);
	validate_city($frm["city"], &$errors, &$msg);
	validate_zip_code($frm["zip_code"], &$errors, &$msg);
	validate_phone($frm["phone"], &$errors, &$msg);
	validate_fax($frm["fax"], &$errors, &$msg);
	validate_mobilephone($frm["mobilephone"], &$errors, &$msg);
	validate_email($frm["email"], &$errors, &$msg);
	validate_notes($frm["notes"], &$errors, &$msg);

	if (username_exists(&$qid, $frm["username"])) {
		$errors->username = true;
		$msg = "<li>" . $the_username . " <b>" . ov($frm["username"]) ."</b> " . $already_exists . $msg;

	} /* elseif (email_exists($frm["email"])) {
		$errors->email = true;
		$msg .= "<li>" . $the_email_address . " <b>" . ov($frm["email"]) ."</b> " . $already_exists;
	} */

	return $msg;
}

function insert_user(&$frm, $usertype) {
/* add the new user into the database */

	global $CFG, $SESSION;
	global $qid;

//	$date = $myday[date("w")] . date(" j") . "-" . date("n") . "-" . date("Y H:i:s");
	$Dateusec = gettimeofday(); $unixtime = $Dateusec["sec"];
	$year = date("Y"); $month = date("n"); $day = date("j"); $weekday = date("w");
	$fromip = getenv("REMOTE_ADDR");

	$qid->Query("
		INSERT INTO users (
			 username
			,password
			,usertype
			,firstname
			,lastname
			,fiscalcode
			,address
			,number
			,city
			,country
			,zip_code
			,phone
			,fax
			,mobilephone
			,email
			,authdata
			,acceptadvert
			,notes
			,unixtime
			,year
			,month
			,day
			,weekday
			,fromip
		) VALUES (
			 '$frm[username]'
			,'$frm[password]'
			,'$usertype'
			,'$frm[firstname]'
			,'$frm[lastname]'
			,'$frm[fiscalcode]'
			,'$frm[address]'
			,'$frm[number]'
			,'$frm[city]'
			,'$frm[country]'
			,'$frm[zip_code]'
			,'$frm[phone]'
			,'$frm[fax]'
			,'$frm[mobilephone]'
			,'$frm[email]'
			,'$frm[authdata]'
			,'$frm[acceptadvert]'
			,'$frm[notes]'
			,'$unixtime'
			,'$year'
			,'$month'
			,'$day'
			,'$weekday'
			,'$fromip'
		)
	");
}

?>
