.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE TABLE" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLE \- Creates a new table
.SH SYNOPSIS
.sp
.nf
CREATE [ TEMPORARY | TEMP ] TABLE \fItable_name\fR (
    { \fIcolumn_name\fR \fItype\fR [ \fIcolumn_constraint\fR [ ... ] ]
      | \fItable_constraint\fR }  [, ... ]
    ) [ INHERITS ( \fIinherited_table\fR [, ... ] ) ]

where \fIcolumn_constraint\fR can be:
[ CONSTRAINT \fIconstraint_name\fR ]
{ NOT NULL | NULL | UNIQUE | PRIMARY KEY | DEFAULT \fIvalue\fR | CHECK (\fIcondition\fR) |
  REFERENCES \fItable\fR [ ( \fIcolumn\fR ) ] [ MATCH FULL | MATCH PARTIAL ]
   [ ON DELETE \fIaction\fR ] [ ON UPDATE \fIaction\fR ]
   [ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]
}

and \fItable_constraint\fR can be:
[ CONSTRAINT \fIconstraint_name\fR ]
{ UNIQUE ( \fIcolumn_name\fR [, ... ] ) |
  PRIMARY KEY ( \fIcolumn_name\fR [, ... ] ) |
  CHECK ( \fIcondition\fR ) |
  FOREIGN KEY ( \fIcolumn_name\fR [, ... ] ) REFERENCES \fItable\fR [ ( \fIcolumn\fR [, ... ] ) ]
   [ MATCH FULL | MATCH PARTIAL ] [ ON DELETE \fIaction\fR ] [ ON UPDATE \fIaction\fR ]
   [ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]
}
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created only for this session, and is
automatically dropped on session exit.
Existing permanent tables with the same name are not visible
(in this session) while the temporary table exists.
Any indexes created on a temporary table are automatically
temporary as well.
.TP
\fB\fItable_name\fB\fR
The name of the new table to be created.
.TP
\fB\fIcolumn_name\fB\fR
The name of a column to be created in the new table.
.TP
\fB\fItype\fB\fR
The type of the column. This may include array specifiers.
Refer to the \fIPostgreSQL User's Guide\fR for
further information about data types and arrays.
.TP
\fB\fIinherited_table\fB\fR
The optional INHERITS clause specifies a list of table
names from which this table automatically inherits all fields.
If any inherited field name appears more than once, 
Postgres
reports an error.
Postgres automatically allows the created
table to inherit functions on tables above it in the inheritance
hierarchy.
.TP
\fB\fIconstraint_name\fB\fR
An optional name for a column or table constraint. If not specified,
the system generates a name.
.TP
\fB\fIvalue\fB\fR
A default value for a column.
See the DEFAULT clause for more information.
.TP
\fB\fIcondition\fB\fR
CHECK clauses specify integrity constraints or tests which new or
updated rows must satisfy for an insert or update operation to
succeed. Each constraint must be an expression producing
a boolean result.
A condition appearing within a column definition should reference
that column's value only, while a condition appearing as a table
constraint may reference multiple columns.
.TP
\fB\fItable\fB\fR
The name of an existing table to be referenced by a foreign
key constraint.
.TP
\fB\fIcolumn\fB\fR
The name of a column in an existing table to be referenced by a
foreign key constraint. If not specified, the primary key of
the existing table is assumed.
.TP
\fB\fIaction\fB\fR
A keyword indicating the action to take when a foreign key
constraint is violated.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if table is successfully created.
.TP
\fBERROR\fR
Message returned if table creation failed.
This is usually accompanied by some descriptive text, such as:
ERROR: Relation '\fItable\fR' already exists
, which occurs at runtime if the table specified already exists
in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE\fR will enter a new, initially empty table
into the current database. The table will be "owned" by the user issuing the
command.
.PP
Each \fItype\fR
may be a simple type, a complex type (set) or an array type.
Each attribute may be specified to be non-null and
each may have a default value, specified by the
DEFAULT Clause [\fBcreate_table\fR(l)].
.PP
.sp
.RS
.B "Note:"
Consistent array dimensions within an
attribute are not enforced. This will likely change in a future
release.
.RE
.sp
.PP
\fBCREATE TABLE\fR also automatically creates a data type
that represents the tuple type (structure type) corresponding to one
row of the table. Therefore, tables can't have the same name as any
existing datatype.
.PP
The optional INHERITS
clause specifies a collection of table names from which this table
automatically inherits all fields. If any inherited field name
appears more than once, Postgres reports an error. Postgres automatically
allows the created table to inherit functions on tables above it in
the inheritance hierarchy. Inheritance of functions is done according
to the conventions of the Common Lisp Object System (CLOS).
.PP
A table can have no more than 1600 columns (in practice, the
effective limit is lower because of tuple-length constraints).
A table cannot have the same name as a system catalog table.
.SH "DEFAULT CLAUSE"
.PP
.sp
.nf
DEFAULT \fIvalue\fR
   
.sp
.fi
.PP
The DEFAULT clause assigns a default data value for the column whose
column definition it appears within. The value is any variable-free
expression (note that sub-selects and cross-references to other
columns in the current table are not supported).
The data type of a default value must match the column definition's
data type.
.PP
The DEFAULT expression will be used in any INSERT operation that does
not specify a value for the column. If there is no DEFAULT clause,
then the default is NULL.
.SS "USAGE"
.PP
.sp
.nf
CREATE TABLE distributors (
    name     VARCHAR(40) DEFAULT 'luso films',
    did      INTEGER  DEFAULT NEXTVAL('distributors_serial'),
    modtime  TIMESTAMP DEFAULT now()
);
    
.sp
.fi
The above assigns a literal constant default value for the column
name, and arranges for the default value of column
did to be generated by selecting the next value of a
sequence object. The default value of modtime will
be the time at which the row is inserted.
.PP
It is worth remarking that
.sp
.nf
    modtime  TIMESTAMP DEFAULT 'now'
    
.sp
.fi
would produce a result that is probably not the intended one: the
string 'now' will be coerced to a timestamp value
immediately, and so the default value of modtime will
always be the time of table creation. This difficulty is avoided by
specifying the default value as a function call.
.SH "COLUMN CONSTRAINTS"
.PP
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] {
    NULL | NOT NULL | UNIQUE | PRIMARY KEY | CHECK \fIcondition\fR |
    REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR ) ]
     [ MATCH \fImatchtype\fR ]
     [ ON DELETE \fIaction\fR ] 
     [ ON UPDATE \fIaction\fR ]
     [ [ NOT ] DEFERRABLE ] 
     [ INITIALLY \fIchecktime\fR ] }
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.TP
\fBNULL\fR
The column is allowed to contain NULL values. This is the default.
.TP
\fBNOT NULL\fR
The column is not allowed to contain NULL values.
This is equivalent to the column constraint
CHECK (\fIcolumn\fR NOT NULL).
.TP
\fBUNIQUE\fR
The column must have unique values. In Postgres
this is enforced by automatic creation of a unique index on the column.
.TP
\fBPRIMARY KEY\fR
This column is a primary key, which implies that other tables may rely
on this column as a unique identifier for rows. Both UNIQUE and
NOT NULL are implied by PRIMARY KEY. See PRIMARY KEY for more
information.
.TP
\fB\fIcondition\fB\fR
An arbitrary boolean-valued constraint condition.
.PP
.SS "DESCRIPTION"
.PP
The optional constraint clauses specify constraints or tests which
new or updated rows must satisfy for an insert or update
operation to succeed.
.PP
A constraint is a named rule: an SQL object which helps define
valid sets of values by putting limits on the results of INSERT,
UPDATE or DELETE operations performed on a table. 
.PP
There are two ways to define integrity constraints:
table constraints, covered later, and column constraints, covered here.
.PP
A column constraint is an integrity constraint defined as part of a
column definition, and logically becomes a table constraint as soon
as it is created. The column constraints available are:

PRIMARY KEY

REFERENCES

UNIQUE

CHECK

NOT NULL

.SS "NOT NULL CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIname\fR ] NOT NULL 
   
.sp
.fi
.PP
The NOT NULL constraint specifies a rule that a column may
contain only non-null values. 
This is a column constraint only, and not allowed
as a table constraint.
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: ExecAppend: Fail to add null value in not null attribute "\fIcolumn\fB".\fR
This error occurs at runtime if one tries to insert a null value
into a column which has a NOT NULL constraint.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
.SS "USAGE"
.PP
Define two NOT NULL column constraints on the table
\fBdistributors\fR,
one of which is explicitly given a name:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3) CONSTRAINT no_null NOT NULL,
    name     VARCHAR(40) NOT NULL
);
     
.sp
.fi
.SS "UNIQUE CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] UNIQUE
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: Cannot insert a duplicate key into a unique index.\fR
This error occurs at runtime if one tries to insert a
duplicate value into a column.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The UNIQUE constraint specifies a rule that a group of one or
more distinct columns of a table may contain only unique values.
.PP
The column definitions of the specified columns do not have to
include a NOT NULL constraint to be included in a UNIQUE
constraint. Having more than one null value in a column without a
NOT NULL constraint, does not violate a UNIQUE constraint. (This
deviates from the SQL92 definition, but is a
more sensible convention. See the section on compatibility for more
details.)
.PP
Each UNIQUE column constraint must name a column that is
different from the set of columns named by any other UNIQUE or
PRIMARY KEY constraint defined for the table.
.sp
.RS
.B "Note:"
Postgres automatically creates a unique
index for each UNIQUE constraint, to assure
data integrity. See CREATE INDEX for more information.
.RE
.sp
.SS "USAGE"
.PP
Defines a UNIQUE constraint for the name column:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40) UNIQUE
);
  
.sp
.fi
which is equivalent to the following specified as a table constraint:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40),
    UNIQUE(name)
);
     
.sp
.fi
.SS "THE CHECK CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] CHECK ( \fIcondition\fR )
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.TP
\fB\fIcondition\fB\fR
Any valid conditional expression evaluating to a boolean result.
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: ExecAppend: rejected due to CHECK constraint "\fIconstraint_name\fB".\fR
This error occurs at runtime if one tries to insert an illegal
value into a column subject to a CHECK constraint.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The CHECK constraint specifies a generic restriction on allowed values
within a column. The CHECK constraint is also allowed as a table
constraint.
.PP
CHECK specifies a general boolean expression involving one or more
columns of a table. A new row will be rejected if the boolean
expression evaluates to FALSE when applied to the row's values.
.PP
Currently, CHECK expressions cannot contain sub-selects nor refer
to variables other than fields of the current row.
.PP
The SQL92 standard says that CHECK column constraints may only refer
to the column they apply to; only CHECK table constraints may refer
to multiple columns.
Postgres does not enforce this restriction.
It treats column and table CHECK constraints alike.
.SS "PRIMARY KEY CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] PRIMARY KEY 
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.PP
.SS "OUTPUTS"
.TP
\fBERROR: Cannot insert a duplicate key into a unique index.\fR
This occurs at runtime if one tries to insert a duplicate value into
a column subject to a PRIMARY KEY constraint.
.SS "DESCRIPTION"
.PP
The PRIMARY KEY column constraint specifies that a column of a
table may contain only unique (non-duplicate), non-NULL values. The
definition of the specified column does not have to include an
explicit NOT NULL constraint to be included in a PRIMARY KEY
constraint.
.PP
Only one PRIMARY KEY can be specified for a table, whether as a
column constraint or a table constraint.
.SS "NOTES"
.PP
Postgres automatically creates
a unique index to assure
data integrity (see CREATE INDEX statement).
.PP
The PRIMARY KEY constraint should name a set of columns that is
different from other sets of columns named by any UNIQUE constraint
defined for the same table, since it will result in duplication
of equivalent indexes and unproductive additional runtime overhead.
However, Postgres does not specifically
disallow this.
.SS "REFERENCES CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR ) ] 
    [ MATCH \fImatchtype\fR ]
    [ ON DELETE \fIaction\fR ] 
    [ ON UPDATE \fIaction\fR ]
    [ [ NOT ] DEFERRABLE ] 
    [ INITIALLY \fIchecktime\fR ]
   
.sp
.fi
.PP
The REFERENCES constraint specifies a rule that a column
value is checked against the values of another column.
REFERENCES can also be specified as part of
a FOREIGN KEY table constraint.
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.TP
\fB\fIreftable\fB\fR
The table that contains the data to check against.
.TP
\fB\fIrefcolumn\fB\fR
The column in \fIreftable\fR
to check the data against. If this is not specified, the PRIMARY KEY of the
\fIreftable\fR is used.
.TP
\fBMATCH \fImatchtype\fB\fR
There are three match types: MATCH FULL, MATCH PARTIAL, and a
default match type if none is specified. MATCH FULL will not
allow one column of a multi-column foreign key to be NULL
unless all foreign key columns are NULL. The default MATCH type
allows some foreign key columns to be NULL while other parts
of the foreign key are not NULL. MATCH PARTIAL is currently not
supported.
.TP
\fBON DELETE \fIaction\fB\fR
The action to do when a referenced row in the referenced table is being
deleted. There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Same as NO ACTION.
.TP
\fBCASCADE\fR
Delete any rows referencing the deleted row.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fBON UPDATE \fIaction\fB\fR
The action to do when a referenced column in the referenced
table is being updated to a new value. If the row is updated,
but the referenced column is not changed, no action is done.
There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Same as NO ACTION.
.TP
\fBCASCADE\fR
Update the value of the referencing column to the new value of the
referenced column.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fB[ NOT ] DEFERRABLE\fR
This controls whether the constraint can be deferred to the end
of the transaction. If DEFERRABLE, SET CONSTRAINTS ALL DEFERRED
will cause the foreign key to be checked only at the end of the
transaction. NOT DEFERRABLE is the default.
.TP
\fBINITIALLY \fIchecktime\fB\fR
\fIchecktime\fR has two possible values 
which specify the default time to check the constraint.
.RS
.TP
\fBDEFERRED\fR
Check constraint only at the end of the transaction.
.TP
\fBIMMEDIATE\fR
Check constraint after each statement. This is the default.
.RE
.PP
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: \fIname\fB referential integrity violation - key referenced from\fR
This error occurs at runtime if one tries to insert a value
into a column which does not have a matching column in the
referenced table.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The REFERENCES column constraint specifies that a
column of a table must only contain values which match against
values in a referenced column of a referenced table.
.PP
A value added to this column is matched against the values of the
referenced table and referenced column using the given match type.
In addition, when the referenced column data is changed, actions
are run upon this column's matching data.
.SS "NOTES"
.PP
Currently Postgres only supports MATCH
FULL and a default match type. In addition, the referenced
columns are supposed to be the columns of a UNIQUE constraint in
the referenced table, however Postgres
does not enforce this.
.SH "TABLE CONSTRAINTS"
.PP
.sp
.nf
[ CONSTRAINT name ] { PRIMARY KEY |  UNIQUE } ( \fIcolumn\fR [, ... ] )
[ CONSTRAINT name ] CHECK ( \fIconstraint\fR )
[ CONSTRAINT name ] FOREIGN KEY ( \fIcolumn\fR [, ... ] ) 
                     REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR [, ... ] ) ]
                      [ MATCH \fImatchtype\fR ] 
                      [ ON DELETE \fIaction\fR ] 
                      [ ON UPDATE \fIaction\fR ]
                      [ [ NOT ] DEFERRABLE ] 
                      [ INITIALLY \fIchecktime\fR ]
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.TP
\fB\fIcolumn\fB [, ... ]\fR
The column name(s) for which to define a unique index
and, for PRIMARY KEY, a NOT NULL constraint.
.TP
\fBCHECK ( \fIconstraint\fB )\fR
A boolean expression to be evaluated as the constraint.
.PP
.SS "OUTPUTS"
.PP
The possible outputs for the table constraint clause are the same
as for the corresponding portions of the column constraint clause.
.SS "DESCRIPTION"
.PP
A table constraint is an integrity constraint defined on one or
more columns of a table. The four variations of "Table
Constraint" are:

UNIQUE

CHECK

PRIMARY KEY

FOREIGN KEY

.SS "UNIQUE CONSTRAINT"
.PP
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] UNIQUE ( \fIcolumn\fR [, ... ] )
    
.sp
.fi
.SS "INPUTS"
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.TP
\fB\fIcolumn\fB\fR
A name of a column in a table.
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: Cannot insert a duplicate key into a unique index\fR
This error occurs at runtime if one tries to insert a
duplicate value into a column.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The UNIQUE constraint specifies a rule that a group of one or more
distinct columns of a table may contain only unique values. The
behavior of the UNIQUE table constraint is the same as that for
column constraints, with the additional capability to span multiple
columns.
.PP
See the section on the UNIQUE column constraint for more details.
.SS "USAGE"
.PP
Prevent duplicate rows in the table distributors:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40),
    UNIQUE(did,name)
);
     
.sp
.fi
.SS "PRIMARY KEY CONSTRAINT"
.PP
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] PRIMARY KEY ( \fIcolumn\fR [, ... ] ) 
    
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.TP
\fB\fIcolumn\fB [, ... ]\fR
The names of one or more columns in the table.
.PP
.SS "OUTPUTS"
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: Cannot insert a duplicate key into a unique index.\fR
This occurs at run-time if one tries to insert a duplicate
value into a column subject to a PRIMARY KEY constraint.
.RE
.PP
.SS "DESCRIPTION"
.PP
The PRIMARY KEY constraint specifies a rule that a group of one
or more distinct columns of a table may contain only unique
(nonduplicate), non-null values. The column definitions of
the specified columns do not have to include a NOT NULL
constraint to be included in a PRIMARY KEY constraint.
.PP
The PRIMARY KEY table constraint is similar to that for column constraints,
with the additional capability of encompassing multiple columns.
.PP
Refer to the section on the PRIMARY KEY column constraint for more
information.
.SS "REFERENCES CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] FOREIGN KEY ( \fIcolumn\fR [, ... ] )
    REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR [, ... ] ) ] 
    [ MATCH \fImatchtype\fR ]
    [ ON DELETE \fIaction\fR ] 
    [ ON UPDATE \fIaction\fR ]
    [ [ NOT ] DEFERRABLE ]
    [ INITIALLY \fIchecktime\fR ]
   
.sp
.fi
.PP
The REFERENCES constraint specifies a rule that a column value or set
of column values is
checked against the values in another table.
.SS "INPUTS"
.PP
.TP
\fB\fIconstraint_name\fB\fR
An arbitrary name given to a constraint clause.
.TP
\fB\fIcolumn\fB [, ... ]\fR
The names of one or more columns in the table.
.TP
\fB\fIreftable\fB\fR
The table that contains the data to check against.
.TP
\fB\fIreferenced column\fB [, ... ]\fR
One or more columns in the \fIreftable\fR
to check the data against. If this is not specified, the PRIMARY KEY of the
\fIreftable\fR is used.
.TP
\fBMATCH \fImatchtype\fB\fR
There are three match types: MATCH FULL, MATCH PARTIAL, and a
default match type if none is specified. MATCH FULL will not
allow one column of a multi-column foreign key to be NULL
unless all foreign key columns are NULL. The default MATCH type
allows some foreign key columns to be NULL while other parts
of the foreign key are not NULL. MATCH PARTIAL is currently not
supported.
.TP
\fBON DELETE \fIaction\fB\fR
The action to do when a referenced row in the referenced table is being
deleted. There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Same as NO ACTION.
.TP
\fBCASCADE\fR
Delete any rows referencing the deleted row.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fBON UPDATE \fIaction\fB\fR
The action to do when a referenced column in the referenced
table is being updated to a new value. If the row is updated,
but the referenced column is not changed, no action is done.
There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Disallow update of row being referenced.
.TP
\fBCASCADE\fR
Update the value of the referencing column to the new value
of the referenced column.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fB[ NOT ] DEFERRABLE\fR
This controls whether the constraint can be deferred to the end
of the transaction. If DEFERRABLE, SET CONSTRAINTS ALL DEFERRED
will cause the foreign key to be checked only at the end of the
transaction. NOT DEFERRABLE is the default.
.TP
\fBINITIALLY \fIchecktime\fB\fR
\fIchecktime\fR has two
possible values which specify the default time to check the
constraint.
.RS
.TP
\fBIMMEDIATE\fR
Check constraint after each statement. This is the default.
.TP
\fBDEFERRED\fR
Check constraint only at the end of the transaction.
.RE
.PP
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: \fIname\fB referential integrity violation - key referenced from\fR
This error occurs at runtime if one tries to insert a value
into a column which does not have a matching column in the
referenced table.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The FOREIGN KEY constraint specifies a rule that a group of one
or more distinct columns of a table is related to a group
of distinct columns in the referenced table.
.PP
The FOREIGN KEY table constraint is similar to that for column
constraints, with the additional capability of encompassing
multiple columns.
.PP
Refer to the section on the FOREIGN KEY column constraint for more
information.
.SH "USAGE"
.PP
Create table films and table distributors:
.sp
.nf
CREATE TABLE films (
     code      CHARACTER(5) CONSTRAINT firstkey PRIMARY KEY,
     title     CHARACTER VARYING(40) NOT NULL,
     did       DECIMAL(3) NOT NULL,
     date_prod DATE,
     kind      CHAR(10),
     len       INTERVAL HOUR TO MINUTE
);
   
.sp
.fi
.sp
.nf
CREATE TABLE distributors (
     did      DECIMAL(3) PRIMARY KEY DEFAULT NEXTVAL('serial'),
     name     VARCHAR(40) NOT NULL CHECK (name <> '')
);
   
.sp
.fi
.PP
Create a table with a 2-dimensional array:
.sp
.nf
   CREATE TABLE array (
          vector INT[][]
          );
   
.sp
.fi
.PP
Define a UNIQUE table constraint for the table films.
UNIQUE table constraints can be defined on one or more
columns of the table:
.sp
.nf
CREATE TABLE films (
    code      CHAR(5),
    title     VARCHAR(40),
    did       DECIMAL(3),
    date_prod DATE,
    kind      CHAR(10),
    len       INTERVAL HOUR TO MINUTE,
    CONSTRAINT production UNIQUE(date_prod)
);
   
.sp
.fi
.PP
Define a CHECK column constraint:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3) CHECK (did > 100),
    name     VARCHAR(40)
);
   
.sp
.fi
.PP
Define a CHECK table constraint:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40)
    CONSTRAINT con1 CHECK (did > 100 AND name > '')
);
   
.sp
.fi
.PP
Define a PRIMARY KEY table constraint for the table films.
PRIMARY KEY table constraints can be defined on one or more
columns of the table:
.sp
.nf
CREATE TABLE films (
    code      CHAR(5),
    title     VARCHAR(40),
    did       DECIMAL(3),
    date_prod DATE,
    kind      CHAR(10),
    len       INTERVAL HOUR TO MINUTE,
    CONSTRAINT code_title PRIMARY KEY(code,title)
);
   
.sp
.fi
.PP
Defines a PRIMARY KEY column constraint for table distributors.
PRIMARY KEY column constraints can only be defined on one column
of the table (the following two examples are equivalent):
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     CHAR VARYING(40),
    PRIMARY KEY(did)
); 
   
.sp
.fi
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3) PRIMARY KEY,
    name     VARCHAR(40)
);
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
In addition to the locally visible temporary table, SQL92 also defines a
CREATE GLOBAL TEMPORARY TABLE statement, and optionally an 
ON COMMIT clause:
.sp
.nf
CREATE GLOBAL TEMPORARY TABLE \fItable\fR ( \fIcolumn\fR \fItype\fR [
    DEFAULT \fIvalue\fR ] [ CONSTRAINT \fIcolumn_constraint\fR ] [, ... ] )
    [ CONSTRAINT \fItable_constraint\fR ] [ ON COMMIT { DELETE | PRESERVE } ROWS ] 
   
.sp
.fi
.PP
For temporary tables, the CREATE GLOBAL TEMPORARY TABLE statement
names a new table visible to other clients and defines the table's columns
and constraints. 
.PP
The optional ON COMMIT clause of CREATE TEMPORARY TABLE specifies
whether or not the temporary table should be emptied of rows
whenever COMMIT is executed. If the ON COMMIT clause is omitted, SQL92
specifies that the default is ON COMMIT DELETE ROWS. However,
Postgres' behavior is always like
ON COMMIT PRESERVE ROWS.
.SS "UNIQUE CLAUSE"
.PP
SQL92 specifies some additional capabilities for UNIQUE:
.PP
Table Constraint definition:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] UNIQUE ( \fIcolumn\fR [, ... ] )
    [ { INITIALLY DEFERRED | INITIALLY IMMEDIATE } ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Column Constraint definition:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] UNIQUE
      [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
      [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.SS "NULL CLAUSE"
.PP
The NULL "constraint" (actually a non-constraint) is a
Postgres extension to SQL92 that is
included for symmetry with the NOT NULL clause (and for compatibility
with some other RDBMSes). Since it is the
default for any column, its presence is simply noise.
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] NULL 
     
.sp
.fi
.SS "NOT NULL CLAUSE"
.PP
SQL92 specifies some additional capabilities for NOT NULL:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] NOT NULL 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.SS "CONSTRAINT CLAUSE"
.PP
SQL92 specifies some additional capabilities for constraints,
and also defines assertions and domain constraints.
.sp
.RS
.B "Note:"
Postgres does not yet support 
either domains or assertions.
.RE
.sp
.PP
An assertion is a special type of integrity constraint and shares
the same namespace as other constraints. However, an assertion is
not necessarily dependent on one particular table as
constraints are, so SQL-92 provides the CREATE ASSERTION statement
as an alternate method for defining a constraint:
.sp
.nf
CREATE ASSERTION \fIname\fR CHECK ( \fIcondition\fR )
    
.sp
.fi
.PP
Domain constraints are defined by CREATE DOMAIN or ALTER DOMAIN
statements:
.PP
Domain constraint: 
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] CHECK \fIconstraint\fR 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Table constraint definition:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] { PRIMARY KEY ( \fIcolumn\fR, ... ) | FOREIGN KEY \fIconstraint\fR | UNIQUE \fIconstraint\fR | CHECK \fIconstraint\fR }
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Column constraint definition:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] { NOT NULL | PRIMARY KEY | FOREIGN KEY \fIconstraint\fR | UNIQUE | CHECK \fIconstraint\fR }  
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
A CONSTRAINT definition may contain one deferment attribute
clause and/or one initial constraint mode clause, in any order.
.TP
\fBNOT DEFERRABLE\fR
The constraint must be checked at the end of each statement.
SET CONSTRAINTS ALL DEFERRED will have no effect on this type
of constraint.
.TP
\fBDEFERRABLE\fR
This controls whether the constraint can be deferred to the end
of the transaction. If SET CONSTRAINTS ALL DEFERRED is used or
the constraint is set to INITIALLY DEFERRED, this will cause
the foreign key to be checked only at the end of the
transaction.
.sp
.RS
.B "Note:"
\fBSET CONSTRAINTS\fR changes the foreign key constraint mode
only for the current transaction.
.RE
.sp
.TP
\fBINITIALLY IMMEDIATE\fR
Check constraint after each statement. This is the default.
.TP
\fBINITIALLY DEFERRED\fR
Check constraint only at the end of the transaction.
.PP
.SS "CHECK CLAUSE"
.PP
SQL92 specifies some additional capabilities for CHECK in either
table or column constraints.
.PP
table constraint definition:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] CHECK ( VALUE \fIcondition\fR ) 
      [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
      [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
column constraint definition:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] CHECK ( VALUE \fIcondition\fR ) 
      [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
      [ [ NOT ] DEFERRABLE ]
    
.sp
.fi
.SS "PRIMARY KEY CLAUSE"
.PP
SQL92 specifies some additional capabilities for PRIMARY KEY:
.PP
Table Constraint definition:
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] PRIMARY KEY ( \fIcolumn\fR [, ... ] ) 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Column Constraint definition: 
.sp
.nf
[ CONSTRAINT \fIconstraint_name\fR ] PRIMARY KEY 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.SS "INHERITANCE"
.PP
Multiple inheritance via the INHERITS clause is a
Postgres language extension.
SQL99 (but not SQL92) defines single inheritance using a different
syntax and different semantics. SQL99-style inheritance is not yet
supported by Postgres.
