/*
 * init.c
 *
 * Copyright (c) 2009-2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION
 */

#include "pg_reporter.h"

#include <sys/stat.h>

#include "miscadmin.h"

#ifdef WIN32
#define COPY_COMMAND		"xcopy /S /I \"%s\" \"%s\""
#else
#define COPY_COMMAND		"cp -r \"%s\" \"%s\""
#endif

extern int init_main(const char *dir, const char *argv0);

#ifndef PG_BACKEND_VERSIONSTR
#define PG_BACKEND_VERSIONSTR	PG_VERSIONSTR
#endif

/*
 * initialize httpd-dir.
 */
int
init_main(const char *dir, const char *argv0)
{
	char		cmdbuf[sizeof(COPY_COMMAND) + MAXPGPATH * 2];
	char		backend_exec[MAXPGPATH];
	char		template_dir[MAXPGPATH];
	int			ret;
	struct stat	st;

	/* Won't overwrite existing directories. */
	if (stat(dir, &st) == 0)
		elog(ERROR, "directry \"%s\" already exists", dir);

	ret = find_other_exec(argv0, "postgres", PG_BACKEND_VERSIONSTR, backend_exec);
	if (ret < 0)
	{
		/* try default path, but it might not work on win32. */
		getcwd(backend_exec, MAXPGPATH);
	}

	/* Copy a directory $PGHOME/share/contrib/pg_reporter to the init path. */
	get_share_path(backend_exec, template_dir);
	strlcat(template_dir, "/contrib/pg_reporter", lengthof(template_dir));
	canonicalize_path(template_dir);
	make_native_path(template_dir);

	snprintf(cmdbuf, sizeof(cmdbuf), COPY_COMMAND, template_dir, dir);
	if (system(cmdbuf) != 0)
		elog(ERROR, "init command failed: %s", cmdbuf);

	return 0;
}
