/*-------------------------------------------------------------------------
 *
 * pwritev.c
 *	  Implementation of pwritev(2) for platforms that lack one.
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 *
 * IDENTIFICATION
 *	  src/port/pwritev.c
 *
 *-------------------------------------------------------------------------
 */


#include "postgres.h"

#include <unistd.h>

#include "port/pg_iovec.h"

ssize_t
pwritev(int fd, const struct iovec *iov, int iovcnt, off_t offset)
{
	ssize_t		sum = 0;
	ssize_t		part;

	for (int i = 0; i < iovcnt; ++i)
	{
		part = pwrite(fd, iov[i].iov_base, iov[i].iov_len, offset);
		if (part < 0)
		{
			if (i == 0)
				return -1;
			else
				return sum;
		}
		sum += part;
		offset += part;
		if (part < iov[i].iov_len)
			return sum;
	}
	return sum;
}
