/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgType {
    private final List<PgColumn> columns = new ArrayList<PgColumn>();
    private final List<String> enumValues = new ArrayList<String>();
    private String name;
    private Boolean isEnum = false;

    public PgType(String string) {
        this.name = string;
    }

    public PgColumn getColumn(String string) {
        for (PgColumn pgColumn : this.columns) {
            if (!pgColumn.getName().equals(string)) continue;
            return pgColumn;
        }
        return null;
    }

    public List<PgColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("CREATE TYPE ");
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        if (this.isEnum.booleanValue()) {
            stringBuilder.append(" AS ENUM (");
        } else {
            stringBuilder.append(" AS (");
        }
        stringBuilder.append(System.getProperty("line.separator"));
        boolean bl = true;
        if (this.isEnum.booleanValue()) {
            for (String object : this.enumValues) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                    stringBuilder.append(System.getProperty("line.separator"));
                }
                stringBuilder.append("\t");
                stringBuilder.append(object);
            }
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(")");
        } else if (this.columns.isEmpty()) {
            stringBuilder.append(')');
        } else {
            for (PgColumn pgColumn : this.columns) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                    stringBuilder.append(System.getProperty("line.separator"));
                }
                stringBuilder.append("\t");
                stringBuilder.append(pgColumn.getFullDefinition(false));
            }
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(")");
        }
        stringBuilder.append(';');
        for (PgColumn pgColumn : this.getColumnsWithStatistics()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("ALTER TABLE ONLY ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" ALTER COLUMN ");
            stringBuilder.append(PgDiffUtils.getQuotedName(pgColumn.getName()));
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public String getDropSQL() {
        return "DROP TYPE " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addColumn(PgColumn pgColumn) {
        this.columns.add(pgColumn);
    }

    public boolean containsColumn(String string) {
        for (PgColumn pgColumn : this.columns) {
            if (!pgColumn.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private List<PgColumn> getColumnsWithStatistics() {
        ArrayList<PgColumn> arrayList = new ArrayList<PgColumn>();
        for (PgColumn pgColumn : this.columns) {
            if (pgColumn.getStatistics() == null) continue;
            arrayList.add(pgColumn);
        }
        return arrayList;
    }

    public void setIsEnum(boolean bl) {
        this.isEnum = bl;
    }

    public boolean getIsEnum() {
        return this.isEnum;
    }

    public void addEnumValue(String string) {
        this.enumValues.add(string);
    }
}

