####################################################################################################################################
# Error Definition Data
####################################################################################################################################
package pgBackRestBuild::Error::Data;

use strict;
use warnings FATAL => qw(all);
use Carp qw(confess);

use Exporter qw(import);
    our @EXPORT = qw();
use Storable qw(dclone);

####################################################################################################################################
# Error min and max values
####################################################################################################################################
use constant ERRDEF_MIN                                             => 25;
    push @EXPORT, qw(ERRDEF_MIN);
use constant ERRDEF_MAX                                             => 125;
    push @EXPORT, qw(ERRDEF_MAX);

####################################################################################################################################
# Error definition data
####################################################################################################################################
my $rhErrorDefine;

####################################################################################################################################
# Load error definition from YAML
####################################################################################################################################
sub errorDefineLoad
{
    my $strErrorYaml = shift;

    require YAML::Any;
    YAML::Any->import(qw(Load));

    $rhErrorDefine = Load($strErrorYaml);
}

push @EXPORT, qw(errorDefineLoad);

####################################################################################################################################
# Get error definition
####################################################################################################################################
sub errorDefine
{
    return dclone($rhErrorDefine);
}

push @EXPORT, qw(errorDefine);

1;
