/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashMap;
import org.jsoup.SerializationException;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.Parser;

public class Entities {
    private static final int empty = -1;
    private static final String emptyName = "";
    static final int codepointRadix = 36;
    private static final HashMap<String, String> multipoints = new HashMap();
    private static final char[] codeDelims = new char[]{',', ';'};

    private Entities() {
    }

    public static boolean isNamedEntity(String name) {
        return EscapeMode.extended.codepointForName(name) != -1;
    }

    public static boolean isBaseNamedEntity(String name) {
        return EscapeMode.base.codepointForName(name) != -1;
    }

    public static Character getCharacterByName(String name) {
        return Character.valueOf((char)EscapeMode.extended.codepointForName(name));
    }

    public static String getByName(String name) {
        String val = multipoints.get(name);
        if (val != null) {
            return val;
        }
        int codepoint = EscapeMode.extended.codepointForName(name);
        if (codepoint != -1) {
            return new String(new int[]{codepoint}, 0, 1);
        }
        return emptyName;
    }

    public static int codepointsForName(String name, int[] codepoints) {
        String val = multipoints.get(name);
        if (val != null) {
            codepoints[0] = val.codePointAt(0);
            codepoints[1] = val.codePointAt(1);
            return 2;
        }
        int codepoint = EscapeMode.extended.codepointForName(name);
        if (codepoint != -1) {
            codepoints[0] = codepoint;
            return 1;
        }
        return 0;
    }

    static String escape(String string, Document.OutputSettings out) {
        StringBuilder accum = new StringBuilder(string.length() * 2);
        try {
            Entities.escape(accum, string, out, false, false, false);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return accum.toString();
    }

    static void escape(Appendable accum, String string, Document.OutputSettings out, boolean inAttribute, boolean normaliseWhite, boolean stripLeadingWhite) throws IOException {
        int codePoint;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        EscapeMode escapeMode = out.escapeMode();
        CharsetEncoder encoder = out.encoder();
        CoreCharset coreCharset = CoreCharset.byName(encoder.charset().name());
        int length = string.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(offset);
            if (normaliseWhite) {
                if (StringUtil.isWhitespace(codePoint)) {
                    if (stripLeadingWhite && !reachedNonWhite || lastWasWhite) continue;
                    accum.append(' ');
                    lastWasWhite = true;
                    continue;
                }
                lastWasWhite = false;
                reachedNonWhite = true;
            }
            if (codePoint < 65536) {
                char c = (char)codePoint;
                switch (c) {
                    case '&': {
                        accum.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            accum.append("&nbsp;");
                            break;
                        }
                        accum.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!inAttribute || escapeMode == EscapeMode.xhtml) {
                            accum.append("&lt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '>': {
                        if (!inAttribute) {
                            accum.append("&gt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '\"': {
                        if (inAttribute) {
                            accum.append("&quot;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    default: {
                        if (Entities.canEncode(coreCharset, c, encoder)) {
                            accum.append(c);
                            break;
                        }
                        Entities.appendEncoded(accum, escapeMode, codePoint);
                        break;
                    }
                }
                continue;
            }
            String c = new String(Character.toChars(codePoint));
            if (encoder.canEncode(c)) {
                accum.append(c);
                continue;
            }
            Entities.appendEncoded(accum, escapeMode, codePoint);
        }
    }

    private static void appendEncoded(Appendable accum, EscapeMode escapeMode, int codePoint) throws IOException {
        String name = escapeMode.nameForCodepoint(codePoint);
        if (name != emptyName) {
            accum.append('&').append(name).append(';');
        } else {
            accum.append("&#x").append(Integer.toHexString(codePoint)).append(';');
        }
    }

    static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    static String unescape(String string, boolean strict) {
        return Parser.unescapeEntities(string, strict);
    }

    private static boolean canEncode(CoreCharset charset, char c, CharsetEncoder fallback) {
        switch (charset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return true;
            }
        }
        return fallback.canEncode(c);
    }

    private static void load(EscapeMode e, String file, int size) {
        EscapeMode.access$202(e, new String[size]);
        EscapeMode.access$302(e, new int[size]);
        EscapeMode.access$402(e, new int[size]);
        EscapeMode.access$502(e, new String[size]);
        InputStream stream = Entities.class.getResourceAsStream(file);
        if (stream == null) {
            throw new IllegalStateException("Could not read resource " + file + ". Make sure you copy resources for " + Entities.class.getCanonicalName());
        }
        int i = 0;
        try {
            ByteBuffer bytes = DataUtil.readToByteBuffer(stream, 0);
            String contents = Charset.forName("ascii").decode(bytes).toString();
            CharacterReader reader = new CharacterReader(contents);
            while (!reader.isEmpty()) {
                int cp2;
                String name = reader.consumeTo('=');
                reader.advance();
                int cp1 = Integer.parseInt(reader.consumeToAny(codeDelims), 36);
                char codeDelim = reader.current();
                reader.advance();
                if (codeDelim == ',') {
                    cp2 = Integer.parseInt(reader.consumeTo(';'), 36);
                    reader.advance();
                } else {
                    cp2 = -1;
                }
                String indexS = reader.consumeTo('\n');
                if (indexS.charAt(indexS.length() - 1) == '\r') {
                    indexS = indexS.substring(0, indexS.length() - 1);
                }
                int index = Integer.parseInt(indexS, 36);
                reader.advance();
                ((EscapeMode)e).nameKeys[i] = name;
                ((EscapeMode)e).codeVals[i] = cp1;
                ((EscapeMode)e).codeKeys[index] = cp1;
                ((EscapeMode)e).nameVals[index] = name;
                if (cp2 != -1) {
                    multipoints.put(name, new String(new int[]{cp1, cp2}, 0, 2));
                }
                ++i;
            }
        }
        catch (IOException err) {
            throw new IllegalStateException("Error reading resource " + file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CoreCharset {
        ascii,
        utf,
        fallback;


        private static CoreCharset byName(String name) {
            if (name.equals("US-ASCII")) {
                return ascii;
            }
            if (name.startsWith("UTF-")) {
                return utf;
            }
            return fallback;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscapeMode {
        xhtml("entities-xhtml.properties", 4),
        base("entities-base.properties", 106),
        extended("entities-full.properties", 2125);

        private String[] nameKeys;
        private int[] codeVals;
        private int[] codeKeys;
        private String[] nameVals;

        private EscapeMode(String file, int size) {
            Entities.load(this, file, size);
        }

        int codepointForName(String name) {
            int index = Arrays.binarySearch(this.nameKeys, name);
            return index >= 0 ? this.codeVals[index] : -1;
        }

        String nameForCodepoint(int codepoint) {
            int index = Arrays.binarySearch(this.codeKeys, codepoint);
            if (index >= 0) {
                return index < this.nameVals.length - 1 && this.codeKeys[index + 1] == codepoint ? this.nameVals[index + 1] : this.nameVals[index];
            }
            return Entities.emptyName;
        }

        private int size() {
            return this.nameKeys.length;
        }

        static /* synthetic */ String[] access$202(EscapeMode x0, String[] x1) {
            x0.nameKeys = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(EscapeMode x0, int[] x1) {
            x0.codeVals = x1;
            return x1;
        }

        static /* synthetic */ int[] access$402(EscapeMode x0, int[] x1) {
            x0.codeKeys = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(EscapeMode x0, String[] x1) {
            x0.nameVals = x1;
            return x1;
        }
    }
}

